/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.server;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandBroadcast
extends CommandBase {
    @Override
    public String getName() {
        return "say";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 1;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.say.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length <= 0 || p_execute_3_[0].length() <= 0) {
            throw new WrongUsageException("commands.say.usage", new Object[0]);
        }
        ITextComponent lvt_4_1_ = CommandBroadcast.getChatComponentFromNthArg(p_execute_2_, p_execute_3_, 0, true);
        p_execute_1_.getPlayerList().sendMessage(new TextComponentTranslation("chat.type.announcement", p_execute_2_.getDisplayName(), lvt_4_1_));
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length >= 1) {
            return CommandBroadcast.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
        }
        return Collections.emptyList();
    }
}

