/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.server;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandListBans
extends CommandBase {
    @Override
    public String getName() {
        return "banlist";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 3;
    }

    @Override
    public boolean checkPermission(MinecraftServer p_checkPermission_1_, ICommandSender p_checkPermission_2_) {
        return (p_checkPermission_1_.getPlayerList().getBannedIPs().isLanServer() || p_checkPermission_1_.getPlayerList().getBannedPlayers().isLanServer()) && super.checkPermission(p_checkPermission_1_, p_checkPermission_2_);
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.banlist.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length >= 1 && "ips".equalsIgnoreCase(p_execute_3_[0])) {
            p_execute_2_.sendMessage(new TextComponentTranslation("commands.banlist.ips", p_execute_1_.getPlayerList().getBannedIPs().getKeys().length));
            p_execute_2_.sendMessage(new TextComponentString(CommandListBans.joinNiceString(p_execute_1_.getPlayerList().getBannedIPs().getKeys())));
        } else {
            p_execute_2_.sendMessage(new TextComponentTranslation("commands.banlist.players", p_execute_1_.getPlayerList().getBannedPlayers().getKeys().length));
            p_execute_2_.sendMessage(new TextComponentString(CommandListBans.joinNiceString(p_execute_1_.getPlayerList().getBannedPlayers().getKeys())));
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandListBans.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "players", "ips");
        }
        return Collections.emptyList();
    }
}

