/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.server;

import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class CommandMessage
extends CommandBase {
    @Override
    public List<String> getAliases() {
        return Arrays.asList("w", "msg");
    }

    @Override
    public String getName() {
        return "tell";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 0;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.message.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length < 2) {
            throw new WrongUsageException("commands.message.usage", new Object[0]);
        }
        EntityPlayerMP lvt_4_1_ = CommandMessage.getPlayer(p_execute_1_, p_execute_2_, p_execute_3_[0]);
        if (lvt_4_1_ == p_execute_2_) {
            throw new PlayerNotFoundException("commands.message.sameTarget");
        }
        ITextComponent lvt_5_1_ = CommandMessage.getChatComponentFromNthArg(p_execute_2_, p_execute_3_, 1, !(p_execute_2_ instanceof EntityPlayer));
        TextComponentTranslation lvt_6_1_ = new TextComponentTranslation("commands.message.display.incoming", p_execute_2_.getDisplayName(), lvt_5_1_.createCopy());
        TextComponentTranslation lvt_7_1_ = new TextComponentTranslation("commands.message.display.outgoing", lvt_4_1_.getDisplayName(), lvt_5_1_.createCopy());
        lvt_6_1_.getStyle().setColor(TextFormatting.GRAY).setItalic(true);
        lvt_7_1_.getStyle().setColor(TextFormatting.GRAY).setItalic(true);
        ((Entity)lvt_4_1_).sendMessage(lvt_6_1_);
        p_execute_2_.sendMessage(lvt_7_1_);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        return CommandMessage.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
    }

    @Override
    public boolean isUsernameIndex(String[] p_isUsernameIndex_1_, int p_isUsernameIndex_2_) {
        return p_isUsernameIndex_2_ == 0;
    }
}

