/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.server;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandOp
extends CommandBase {
    @Override
    public String getName() {
        return "op";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 3;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.op.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length != 1 || p_execute_3_[0].length() <= 0) {
            throw new WrongUsageException("commands.op.usage", new Object[0]);
        }
        GameProfile lvt_4_1_ = p_execute_1_.getPlayerProfileCache().getGameProfileForUsername(p_execute_3_[0]);
        if (lvt_4_1_ == null) {
            throw new CommandException("commands.op.failed", p_execute_3_[0]);
        }
        p_execute_1_.getPlayerList().addOp(lvt_4_1_);
        CommandOp.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.op.success", p_execute_3_[0]);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            String lvt_5_1_ = p_getTabCompletions_3_[p_getTabCompletions_3_.length - 1];
            ArrayList lvt_6_1_ = Lists.newArrayList();
            for (GameProfile lvt_10_1_ : p_getTabCompletions_1_.getOnlinePlayerProfiles()) {
                if (p_getTabCompletions_1_.getPlayerList().canSendCommands(lvt_10_1_) || !CommandOp.doesStringStartWith(lvt_5_1_, lvt_10_1_.getName())) continue;
                lvt_6_1_.add(lvt_10_1_.getName());
            }
            return lvt_6_1_;
        }
        return Collections.emptyList();
    }
}

