/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.server;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.command.server.CommandBanIp;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandPardonIp
extends CommandBase {
    @Override
    public String getName() {
        return "pardon-ip";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 3;
    }

    @Override
    public boolean checkPermission(MinecraftServer p_checkPermission_1_, ICommandSender p_checkPermission_2_) {
        return p_checkPermission_1_.getPlayerList().getBannedIPs().isLanServer() && super.checkPermission(p_checkPermission_1_, p_checkPermission_2_);
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.unbanip.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length != 1 || p_execute_3_[0].length() <= 1) {
            throw new WrongUsageException("commands.unbanip.usage", new Object[0]);
        }
        Matcher lvt_4_1_ = CommandBanIp.IP_PATTERN.matcher(p_execute_3_[0]);
        if (!lvt_4_1_.matches()) {
            throw new SyntaxErrorException("commands.unbanip.invalid", new Object[0]);
        }
        p_execute_1_.getPlayerList().getBannedIPs().removeEntry(p_execute_3_[0]);
        CommandPardonIp.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.unbanip.success", p_execute_3_[0]);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandPardonIp.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getPlayerList().getBannedIPs().getKeys());
        }
        return Collections.emptyList();
    }
}

