/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.server;

import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandPardonPlayer
extends CommandBase {
    @Override
    public String getName() {
        return "pardon";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 3;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.unban.usage";
    }

    @Override
    public boolean checkPermission(MinecraftServer p_checkPermission_1_, ICommandSender p_checkPermission_2_) {
        return p_checkPermission_1_.getPlayerList().getBannedPlayers().isLanServer() && super.checkPermission(p_checkPermission_1_, p_checkPermission_2_);
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length != 1 || p_execute_3_[0].length() <= 0) {
            throw new WrongUsageException("commands.unban.usage", new Object[0]);
        }
        GameProfile lvt_4_1_ = p_execute_1_.getPlayerList().getBannedPlayers().getBannedProfile(p_execute_3_[0]);
        if (lvt_4_1_ == null) {
            throw new CommandException("commands.unban.failed", p_execute_3_[0]);
        }
        p_execute_1_.getPlayerList().getBannedPlayers().removeEntry(lvt_4_1_);
        CommandPardonPlayer.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.unban.success", p_execute_3_[0]);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandPardonPlayer.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getPlayerList().getBannedPlayers().getKeys());
        }
        return Collections.emptyList();
    }
}

