/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.server;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.WorldServer;

public class CommandSaveAll
extends CommandBase {
    @Override
    public String getName() {
        return "save-all";
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.save.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        p_execute_2_.sendMessage(new TextComponentTranslation("commands.save.start", new Object[0]));
        if (p_execute_1_.getPlayerList() != null) {
            p_execute_1_.getPlayerList().saveAllPlayerData();
        }
        try {
            for (int lvt_4_1_ = 0; lvt_4_1_ < p_execute_1_.worlds.length; ++lvt_4_1_) {
                if (p_execute_1_.worlds[lvt_4_1_] == null) continue;
                WorldServer lvt_5_1_ = p_execute_1_.worlds[lvt_4_1_];
                boolean lvt_6_1_ = lvt_5_1_.disableLevelSaving;
                lvt_5_1_.disableLevelSaving = false;
                lvt_5_1_.saveAllChunks(true, null);
                lvt_5_1_.disableLevelSaving = lvt_6_1_;
            }
            if (p_execute_3_.length > 0 && "flush".equals(p_execute_3_[0])) {
                p_execute_2_.sendMessage(new TextComponentTranslation("commands.save.flushStart", new Object[0]));
                for (int lvt_4_2_ = 0; lvt_4_2_ < p_execute_1_.worlds.length; ++lvt_4_2_) {
                    if (p_execute_1_.worlds[lvt_4_2_] == null) continue;
                    WorldServer lvt_5_2_ = p_execute_1_.worlds[lvt_4_2_];
                    boolean lvt_6_2_ = lvt_5_2_.disableLevelSaving;
                    lvt_5_2_.disableLevelSaving = false;
                    lvt_5_2_.saveChunkData();
                    lvt_5_2_.disableLevelSaving = lvt_6_2_;
                }
                p_execute_2_.sendMessage(new TextComponentTranslation("commands.save.flushEnd", new Object[0]));
            }
        }
        catch (MinecraftException lvt_4_3_) {
            CommandSaveAll.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.save.failed", lvt_4_3_.getMessage());
            return;
        }
        CommandSaveAll.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.save.success", new Object[0]);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandSaveAll.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "flush");
        }
        return Collections.emptyList();
    }
}

