/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.EntitySelector;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class CommandScoreboard
extends CommandBase {
    @Override
    public String getName() {
        return "scoreboard";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.scoreboard.usage";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (this.handleUserWildcards(p_execute_1_, p_execute_2_, p_execute_3_)) {
            return;
        }
        if (p_execute_3_.length < 1) {
            throw new WrongUsageException("commands.scoreboard.usage", new Object[0]);
        }
        if ("objectives".equalsIgnoreCase(p_execute_3_[0])) {
            if (p_execute_3_.length == 1) {
                throw new WrongUsageException("commands.scoreboard.objectives.usage", new Object[0]);
            }
            if ("list".equalsIgnoreCase(p_execute_3_[1])) {
                this.listObjectives(p_execute_2_, p_execute_1_);
                return;
            } else if ("add".equalsIgnoreCase(p_execute_3_[1])) {
                if (p_execute_3_.length < 4) throw new WrongUsageException("commands.scoreboard.objectives.add.usage", new Object[0]);
                this.addObjective(p_execute_2_, p_execute_3_, 2, p_execute_1_);
                return;
            } else if ("remove".equalsIgnoreCase(p_execute_3_[1])) {
                if (p_execute_3_.length != 3) throw new WrongUsageException("commands.scoreboard.objectives.remove.usage", new Object[0]);
                this.removeObjective(p_execute_2_, p_execute_3_[2], p_execute_1_);
                return;
            } else {
                if (!"setdisplay".equalsIgnoreCase(p_execute_3_[1])) throw new WrongUsageException("commands.scoreboard.objectives.usage", new Object[0]);
                if (p_execute_3_.length != 3 && p_execute_3_.length != 4) throw new WrongUsageException("commands.scoreboard.objectives.setdisplay.usage", new Object[0]);
                this.setDisplayObjective(p_execute_2_, p_execute_3_, 2, p_execute_1_);
            }
            return;
        } else if ("players".equalsIgnoreCase(p_execute_3_[0])) {
            if (p_execute_3_.length == 1) {
                throw new WrongUsageException("commands.scoreboard.players.usage", new Object[0]);
            }
            if ("list".equalsIgnoreCase(p_execute_3_[1])) {
                if (p_execute_3_.length > 3) throw new WrongUsageException("commands.scoreboard.players.list.usage", new Object[0]);
                this.listPlayers(p_execute_2_, p_execute_3_, 2, p_execute_1_);
                return;
            } else if ("add".equalsIgnoreCase(p_execute_3_[1])) {
                if (p_execute_3_.length < 5) throw new WrongUsageException("commands.scoreboard.players.add.usage", new Object[0]);
                this.addPlayerScore(p_execute_2_, p_execute_3_, 2, p_execute_1_);
                return;
            } else if ("remove".equalsIgnoreCase(p_execute_3_[1])) {
                if (p_execute_3_.length < 5) throw new WrongUsageException("commands.scoreboard.players.remove.usage", new Object[0]);
                this.addPlayerScore(p_execute_2_, p_execute_3_, 2, p_execute_1_);
                return;
            } else if ("set".equalsIgnoreCase(p_execute_3_[1])) {
                if (p_execute_3_.length < 5) throw new WrongUsageException("commands.scoreboard.players.set.usage", new Object[0]);
                this.addPlayerScore(p_execute_2_, p_execute_3_, 2, p_execute_1_);
                return;
            } else if ("reset".equalsIgnoreCase(p_execute_3_[1])) {
                if (p_execute_3_.length != 3 && p_execute_3_.length != 4) throw new WrongUsageException("commands.scoreboard.players.reset.usage", new Object[0]);
                this.resetPlayerScore(p_execute_2_, p_execute_3_, 2, p_execute_1_);
                return;
            } else if ("enable".equalsIgnoreCase(p_execute_3_[1])) {
                if (p_execute_3_.length != 4) throw new WrongUsageException("commands.scoreboard.players.enable.usage", new Object[0]);
                this.enablePlayerTrigger(p_execute_2_, p_execute_3_, 2, p_execute_1_);
                return;
            } else if ("test".equalsIgnoreCase(p_execute_3_[1])) {
                if (p_execute_3_.length != 5 && p_execute_3_.length != 6) throw new WrongUsageException("commands.scoreboard.players.test.usage", new Object[0]);
                this.testPlayerScore(p_execute_2_, p_execute_3_, 2, p_execute_1_);
                return;
            } else if ("operation".equalsIgnoreCase(p_execute_3_[1])) {
                if (p_execute_3_.length != 7) throw new WrongUsageException("commands.scoreboard.players.operation.usage", new Object[0]);
                this.applyPlayerOperation(p_execute_2_, p_execute_3_, 2, p_execute_1_);
                return;
            } else {
                if (!"tag".equalsIgnoreCase(p_execute_3_[1])) throw new WrongUsageException("commands.scoreboard.players.usage", new Object[0]);
                if (p_execute_3_.length < 4) throw new WrongUsageException("commands.scoreboard.players.tag.usage", new Object[0]);
                this.applyPlayerTag(p_execute_1_, p_execute_2_, p_execute_3_, 2);
            }
            return;
        } else {
            if (!"teams".equalsIgnoreCase(p_execute_3_[0])) throw new WrongUsageException("commands.scoreboard.usage", new Object[0]);
            if (p_execute_3_.length == 1) {
                throw new WrongUsageException("commands.scoreboard.teams.usage", new Object[0]);
            }
            if ("list".equalsIgnoreCase(p_execute_3_[1])) {
                if (p_execute_3_.length > 3) throw new WrongUsageException("commands.scoreboard.teams.list.usage", new Object[0]);
                this.listTeams(p_execute_2_, p_execute_3_, 2, p_execute_1_);
                return;
            } else if ("add".equalsIgnoreCase(p_execute_3_[1])) {
                if (p_execute_3_.length < 3) throw new WrongUsageException("commands.scoreboard.teams.add.usage", new Object[0]);
                this.addTeam(p_execute_2_, p_execute_3_, 2, p_execute_1_);
                return;
            } else if ("remove".equalsIgnoreCase(p_execute_3_[1])) {
                if (p_execute_3_.length != 3) throw new WrongUsageException("commands.scoreboard.teams.remove.usage", new Object[0]);
                this.removeTeam(p_execute_2_, p_execute_3_, 2, p_execute_1_);
                return;
            } else if ("empty".equalsIgnoreCase(p_execute_3_[1])) {
                if (p_execute_3_.length != 3) throw new WrongUsageException("commands.scoreboard.teams.empty.usage", new Object[0]);
                this.emptyTeam(p_execute_2_, p_execute_3_, 2, p_execute_1_);
                return;
            } else if ("join".equalsIgnoreCase(p_execute_3_[1])) {
                if (p_execute_3_.length < 4 && (p_execute_3_.length != 3 || !(p_execute_2_ instanceof EntityPlayer))) throw new WrongUsageException("commands.scoreboard.teams.join.usage", new Object[0]);
                this.joinTeam(p_execute_2_, p_execute_3_, 2, p_execute_1_);
                return;
            } else if ("leave".equalsIgnoreCase(p_execute_3_[1])) {
                if (p_execute_3_.length < 3 && !(p_execute_2_ instanceof EntityPlayer)) throw new WrongUsageException("commands.scoreboard.teams.leave.usage", new Object[0]);
                this.leaveTeam(p_execute_2_, p_execute_3_, 2, p_execute_1_);
                return;
            } else {
                if (!"option".equalsIgnoreCase(p_execute_3_[1])) throw new WrongUsageException("commands.scoreboard.teams.usage", new Object[0]);
                if (p_execute_3_.length != 4 && p_execute_3_.length != 5) throw new WrongUsageException("commands.scoreboard.teams.option.usage", new Object[0]);
                this.setTeamOption(p_execute_2_, p_execute_3_, 2, p_execute_1_);
            }
        }
    }

    private boolean handleUserWildcards(MinecraftServer p_handleUserWildcards_1_, ICommandSender p_handleUserWildcards_2_, String[] p_handleUserWildcards_3_) throws CommandException {
        int lvt_4_1_ = -1;
        for (int lvt_5_1_ = 0; lvt_5_1_ < p_handleUserWildcards_3_.length; ++lvt_5_1_) {
            if (!this.isUsernameIndex(p_handleUserWildcards_3_, lvt_5_1_) || !"*".equals(p_handleUserWildcards_3_[lvt_5_1_])) continue;
            if (lvt_4_1_ < 0) {
                lvt_4_1_ = lvt_5_1_;
                continue;
            }
            throw new CommandException("commands.scoreboard.noMultiWildcard", new Object[0]);
        }
        if (lvt_4_1_ < 0) {
            return false;
        }
        ArrayList lvt_5_2_ = Lists.newArrayList(this.getScoreboard(p_handleUserWildcards_1_).getObjectiveNames());
        String lvt_6_1_ = p_handleUserWildcards_3_[lvt_4_1_];
        ArrayList lvt_7_1_ = Lists.newArrayList();
        Iterator iterator = lvt_5_2_.iterator();
        while (iterator.hasNext()) {
            String lvt_9_1_;
            p_handleUserWildcards_3_[lvt_4_1_] = lvt_9_1_ = (String)iterator.next();
            try {
                this.execute(p_handleUserWildcards_1_, p_handleUserWildcards_2_, p_handleUserWildcards_3_);
                lvt_7_1_.add(lvt_9_1_);
            }
            catch (CommandException lvt_10_1_) {
                TextComponentTranslation lvt_11_1_ = new TextComponentTranslation(lvt_10_1_.getMessage(), lvt_10_1_.getErrorObjects());
                lvt_11_1_.getStyle().setColor(TextFormatting.RED);
                p_handleUserWildcards_2_.sendMessage(lvt_11_1_);
            }
        }
        p_handleUserWildcards_3_[lvt_4_1_] = lvt_6_1_;
        p_handleUserWildcards_2_.setCommandStat(CommandResultStats.Type.AFFECTED_ENTITIES, lvt_7_1_.size());
        if (lvt_7_1_.isEmpty()) {
            throw new WrongUsageException("commands.scoreboard.allMatchesFailed", new Object[0]);
        }
        return true;
    }

    protected Scoreboard getScoreboard(MinecraftServer p_getScoreboard_1_) {
        return p_getScoreboard_1_.worldServerForDimension(0).getScoreboard();
    }

    protected ScoreObjective convertToObjective(String p_convertToObjective_1_, boolean p_convertToObjective_2_, MinecraftServer p_convertToObjective_3_) throws CommandException {
        Scoreboard lvt_4_1_ = this.getScoreboard(p_convertToObjective_3_);
        ScoreObjective lvt_5_1_ = lvt_4_1_.getObjective(p_convertToObjective_1_);
        if (lvt_5_1_ == null) {
            throw new CommandException("commands.scoreboard.objectiveNotFound", p_convertToObjective_1_);
        }
        if (p_convertToObjective_2_ && lvt_5_1_.getCriteria().isReadOnly()) {
            throw new CommandException("commands.scoreboard.objectiveReadOnly", p_convertToObjective_1_);
        }
        return lvt_5_1_;
    }

    protected ScorePlayerTeam convertToTeam(String p_convertToTeam_1_, MinecraftServer p_convertToTeam_2_) throws CommandException {
        Scoreboard lvt_3_1_ = this.getScoreboard(p_convertToTeam_2_);
        ScorePlayerTeam lvt_4_1_ = lvt_3_1_.getTeam(p_convertToTeam_1_);
        if (lvt_4_1_ == null) {
            throw new CommandException("commands.scoreboard.teamNotFound", p_convertToTeam_1_);
        }
        return lvt_4_1_;
    }

    protected void addObjective(ICommandSender p_addObjective_1_, String[] p_addObjective_2_, int p_addObjective_3_, MinecraftServer p_addObjective_4_) throws CommandException {
        String lvt_5_1_ = p_addObjective_2_[p_addObjective_3_++];
        String lvt_6_1_ = p_addObjective_2_[p_addObjective_3_++];
        Scoreboard lvt_7_1_ = this.getScoreboard(p_addObjective_4_);
        IScoreCriteria lvt_8_1_ = IScoreCriteria.INSTANCES.get(lvt_6_1_);
        if (lvt_8_1_ == null) {
            throw new WrongUsageException("commands.scoreboard.objectives.add.wrongType", lvt_6_1_);
        }
        if (lvt_7_1_.getObjective(lvt_5_1_) != null) {
            throw new CommandException("commands.scoreboard.objectives.add.alreadyExists", lvt_5_1_);
        }
        if (lvt_5_1_.length() > 16) {
            throw new SyntaxErrorException("commands.scoreboard.objectives.add.tooLong", lvt_5_1_, 16);
        }
        if (lvt_5_1_.isEmpty()) {
            throw new WrongUsageException("commands.scoreboard.objectives.add.usage", new Object[0]);
        }
        if (p_addObjective_2_.length > p_addObjective_3_) {
            String lvt_9_1_ = CommandScoreboard.getChatComponentFromNthArg(p_addObjective_1_, p_addObjective_2_, p_addObjective_3_).getUnformattedText();
            if (lvt_9_1_.length() > 32) {
                throw new SyntaxErrorException("commands.scoreboard.objectives.add.displayTooLong", lvt_9_1_, 32);
            }
            if (lvt_9_1_.isEmpty()) {
                lvt_7_1_.addScoreObjective(lvt_5_1_, lvt_8_1_);
            } else {
                lvt_7_1_.addScoreObjective(lvt_5_1_, lvt_8_1_).setDisplayName(lvt_9_1_);
            }
        } else {
            lvt_7_1_.addScoreObjective(lvt_5_1_, lvt_8_1_);
        }
        CommandScoreboard.notifyCommandListener(p_addObjective_1_, (ICommand)this, "commands.scoreboard.objectives.add.success", lvt_5_1_);
    }

    protected void addTeam(ICommandSender p_addTeam_1_, String[] p_addTeam_2_, int p_addTeam_3_, MinecraftServer p_addTeam_4_) throws CommandException {
        String lvt_5_1_ = p_addTeam_2_[p_addTeam_3_++];
        Scoreboard lvt_6_1_ = this.getScoreboard(p_addTeam_4_);
        if (lvt_6_1_.getTeam(lvt_5_1_) != null) {
            throw new CommandException("commands.scoreboard.teams.add.alreadyExists", lvt_5_1_);
        }
        if (lvt_5_1_.length() > 16) {
            throw new SyntaxErrorException("commands.scoreboard.teams.add.tooLong", lvt_5_1_, 16);
        }
        if (lvt_5_1_.isEmpty()) {
            throw new WrongUsageException("commands.scoreboard.teams.add.usage", new Object[0]);
        }
        if (p_addTeam_2_.length > p_addTeam_3_) {
            String lvt_7_1_ = CommandScoreboard.getChatComponentFromNthArg(p_addTeam_1_, p_addTeam_2_, p_addTeam_3_).getUnformattedText();
            if (lvt_7_1_.length() > 32) {
                throw new SyntaxErrorException("commands.scoreboard.teams.add.displayTooLong", lvt_7_1_, 32);
            }
            if (lvt_7_1_.isEmpty()) {
                lvt_6_1_.createTeam(lvt_5_1_);
            } else {
                lvt_6_1_.createTeam(lvt_5_1_).setTeamName(lvt_7_1_);
            }
        } else {
            lvt_6_1_.createTeam(lvt_5_1_);
        }
        CommandScoreboard.notifyCommandListener(p_addTeam_1_, (ICommand)this, "commands.scoreboard.teams.add.success", lvt_5_1_);
    }

    protected void setTeamOption(ICommandSender p_setTeamOption_1_, String[] p_setTeamOption_2_, int p_setTeamOption_3_, MinecraftServer p_setTeamOption_4_) throws CommandException {
        String lvt_6_1_;
        ScorePlayerTeam lvt_5_1_;
        if ((lvt_5_1_ = this.convertToTeam(p_setTeamOption_2_[p_setTeamOption_3_++], p_setTeamOption_4_)) == null) {
            return;
        }
        if (!("color".equalsIgnoreCase(lvt_6_1_ = p_setTeamOption_2_[p_setTeamOption_3_++].toLowerCase(Locale.ROOT)) || "friendlyfire".equalsIgnoreCase(lvt_6_1_) || "seeFriendlyInvisibles".equalsIgnoreCase(lvt_6_1_) || "nametagVisibility".equalsIgnoreCase(lvt_6_1_) || "deathMessageVisibility".equalsIgnoreCase(lvt_6_1_) || "collisionRule".equalsIgnoreCase(lvt_6_1_))) {
            throw new WrongUsageException("commands.scoreboard.teams.option.usage", new Object[0]);
        }
        if (p_setTeamOption_2_.length == 4) {
            if ("color".equalsIgnoreCase(lvt_6_1_)) {
                throw new WrongUsageException("commands.scoreboard.teams.option.noValue", lvt_6_1_, CommandScoreboard.joinNiceStringFromCollection(TextFormatting.getValidValues(true, false)));
            }
            if ("friendlyfire".equalsIgnoreCase(lvt_6_1_) || "seeFriendlyInvisibles".equalsIgnoreCase(lvt_6_1_)) {
                throw new WrongUsageException("commands.scoreboard.teams.option.noValue", lvt_6_1_, CommandScoreboard.joinNiceStringFromCollection(Arrays.asList("true", "false")));
            }
            if ("nametagVisibility".equalsIgnoreCase(lvt_6_1_) || "deathMessageVisibility".equalsIgnoreCase(lvt_6_1_)) {
                throw new WrongUsageException("commands.scoreboard.teams.option.noValue", lvt_6_1_, CommandScoreboard.joinNiceString(Team.EnumVisible.getNames()));
            }
            if ("collisionRule".equalsIgnoreCase(lvt_6_1_)) {
                throw new WrongUsageException("commands.scoreboard.teams.option.noValue", lvt_6_1_, CommandScoreboard.joinNiceString(Team.CollisionRule.getNames()));
            }
            throw new WrongUsageException("commands.scoreboard.teams.option.usage", new Object[0]);
        }
        String lvt_7_1_ = p_setTeamOption_2_[p_setTeamOption_3_];
        if ("color".equalsIgnoreCase(lvt_6_1_)) {
            TextFormatting lvt_8_1_ = TextFormatting.getValueByName(lvt_7_1_);
            if (lvt_8_1_ == null || lvt_8_1_.isFancyStyling()) {
                throw new WrongUsageException("commands.scoreboard.teams.option.noValue", lvt_6_1_, CommandScoreboard.joinNiceStringFromCollection(TextFormatting.getValidValues(true, false)));
            }
            lvt_5_1_.setChatFormat(lvt_8_1_);
            lvt_5_1_.setNamePrefix(lvt_8_1_.toString());
            lvt_5_1_.setNameSuffix(TextFormatting.RESET.toString());
        } else if ("friendlyfire".equalsIgnoreCase(lvt_6_1_)) {
            if (!"true".equalsIgnoreCase(lvt_7_1_) && !"false".equalsIgnoreCase(lvt_7_1_)) {
                throw new WrongUsageException("commands.scoreboard.teams.option.noValue", lvt_6_1_, CommandScoreboard.joinNiceStringFromCollection(Arrays.asList("true", "false")));
            }
            lvt_5_1_.setAllowFriendlyFire("true".equalsIgnoreCase(lvt_7_1_));
        } else if ("seeFriendlyInvisibles".equalsIgnoreCase(lvt_6_1_)) {
            if (!"true".equalsIgnoreCase(lvt_7_1_) && !"false".equalsIgnoreCase(lvt_7_1_)) {
                throw new WrongUsageException("commands.scoreboard.teams.option.noValue", lvt_6_1_, CommandScoreboard.joinNiceStringFromCollection(Arrays.asList("true", "false")));
            }
            lvt_5_1_.setSeeFriendlyInvisiblesEnabled("true".equalsIgnoreCase(lvt_7_1_));
        } else if ("nametagVisibility".equalsIgnoreCase(lvt_6_1_)) {
            Team.EnumVisible lvt_8_2_ = Team.EnumVisible.getByName(lvt_7_1_);
            if (lvt_8_2_ == null) {
                throw new WrongUsageException("commands.scoreboard.teams.option.noValue", lvt_6_1_, CommandScoreboard.joinNiceString(Team.EnumVisible.getNames()));
            }
            lvt_5_1_.setNameTagVisibility(lvt_8_2_);
        } else if ("deathMessageVisibility".equalsIgnoreCase(lvt_6_1_)) {
            Team.EnumVisible lvt_8_3_ = Team.EnumVisible.getByName(lvt_7_1_);
            if (lvt_8_3_ == null) {
                throw new WrongUsageException("commands.scoreboard.teams.option.noValue", lvt_6_1_, CommandScoreboard.joinNiceString(Team.EnumVisible.getNames()));
            }
            lvt_5_1_.setDeathMessageVisibility(lvt_8_3_);
        } else if ("collisionRule".equalsIgnoreCase(lvt_6_1_)) {
            Team.CollisionRule lvt_8_4_ = Team.CollisionRule.getByName(lvt_7_1_);
            if (lvt_8_4_ == null) {
                throw new WrongUsageException("commands.scoreboard.teams.option.noValue", lvt_6_1_, CommandScoreboard.joinNiceString(Team.CollisionRule.getNames()));
            }
            lvt_5_1_.setCollisionRule(lvt_8_4_);
        }
        CommandScoreboard.notifyCommandListener(p_setTeamOption_1_, (ICommand)this, "commands.scoreboard.teams.option.success", lvt_6_1_, lvt_5_1_.getRegisteredName(), lvt_7_1_);
    }

    protected void removeTeam(ICommandSender p_removeTeam_1_, String[] p_removeTeam_2_, int p_removeTeam_3_, MinecraftServer p_removeTeam_4_) throws CommandException {
        Scoreboard lvt_5_1_ = this.getScoreboard(p_removeTeam_4_);
        ScorePlayerTeam lvt_6_1_ = this.convertToTeam(p_removeTeam_2_[p_removeTeam_3_], p_removeTeam_4_);
        if (lvt_6_1_ == null) {
            return;
        }
        lvt_5_1_.removeTeam(lvt_6_1_);
        CommandScoreboard.notifyCommandListener(p_removeTeam_1_, (ICommand)this, "commands.scoreboard.teams.remove.success", lvt_6_1_.getRegisteredName());
    }

    protected void listTeams(ICommandSender p_listTeams_1_, String[] p_listTeams_2_, int p_listTeams_3_, MinecraftServer p_listTeams_4_) throws CommandException {
        Scoreboard lvt_5_1_ = this.getScoreboard(p_listTeams_4_);
        if (p_listTeams_2_.length > p_listTeams_3_) {
            ScorePlayerTeam lvt_6_1_ = this.convertToTeam(p_listTeams_2_[p_listTeams_3_], p_listTeams_4_);
            if (lvt_6_1_ == null) {
                return;
            }
            Collection<String> lvt_7_1_ = lvt_6_1_.getMembershipCollection();
            p_listTeams_1_.setCommandStat(CommandResultStats.Type.QUERY_RESULT, lvt_7_1_.size());
            if (lvt_7_1_.isEmpty()) {
                throw new CommandException("commands.scoreboard.teams.list.player.empty", lvt_6_1_.getRegisteredName());
            }
            TextComponentTranslation lvt_8_1_ = new TextComponentTranslation("commands.scoreboard.teams.list.player.count", lvt_7_1_.size(), lvt_6_1_.getRegisteredName());
            lvt_8_1_.getStyle().setColor(TextFormatting.DARK_GREEN);
            p_listTeams_1_.sendMessage(lvt_8_1_);
            p_listTeams_1_.sendMessage(new TextComponentString(CommandScoreboard.joinNiceString(lvt_7_1_.toArray())));
        } else {
            Collection<ScorePlayerTeam> lvt_6_2_ = lvt_5_1_.getTeams();
            p_listTeams_1_.setCommandStat(CommandResultStats.Type.QUERY_RESULT, lvt_6_2_.size());
            if (lvt_6_2_.isEmpty()) {
                throw new CommandException("commands.scoreboard.teams.list.empty", new Object[0]);
            }
            TextComponentTranslation lvt_7_2_ = new TextComponentTranslation("commands.scoreboard.teams.list.count", lvt_6_2_.size());
            lvt_7_2_.getStyle().setColor(TextFormatting.DARK_GREEN);
            p_listTeams_1_.sendMessage(lvt_7_2_);
            for (ScorePlayerTeam lvt_9_1_ : lvt_6_2_) {
                p_listTeams_1_.sendMessage(new TextComponentTranslation("commands.scoreboard.teams.list.entry", lvt_9_1_.getRegisteredName(), lvt_9_1_.getTeamName(), lvt_9_1_.getMembershipCollection().size()));
            }
        }
    }

    protected void joinTeam(ICommandSender p_joinTeam_1_, String[] p_joinTeam_2_, int p_joinTeam_3_, MinecraftServer p_joinTeam_4_) throws CommandException {
        Scoreboard lvt_5_1_ = this.getScoreboard(p_joinTeam_4_);
        String lvt_6_1_ = p_joinTeam_2_[p_joinTeam_3_++];
        HashSet lvt_7_1_ = Sets.newHashSet();
        HashSet lvt_8_1_ = Sets.newHashSet();
        if (p_joinTeam_1_ instanceof EntityPlayer && p_joinTeam_3_ == p_joinTeam_2_.length) {
            String lvt_9_1_ = CommandScoreboard.getCommandSenderAsPlayer(p_joinTeam_1_).getName();
            if (lvt_5_1_.addPlayerToTeam(lvt_9_1_, lvt_6_1_)) {
                lvt_7_1_.add(lvt_9_1_);
            } else {
                lvt_8_1_.add(lvt_9_1_);
            }
        } else {
            while (p_joinTeam_3_ < p_joinTeam_2_.length) {
                String lvt_9_2_;
                if (EntitySelector.isSelector(lvt_9_2_ = p_joinTeam_2_[p_joinTeam_3_++])) {
                    List<Entity> lvt_10_1_ = CommandScoreboard.getEntityList(p_joinTeam_4_, p_joinTeam_1_, lvt_9_2_);
                    for (Entity lvt_12_1_ : lvt_10_1_) {
                        String lvt_13_1_ = CommandScoreboard.getEntityName(p_joinTeam_4_, p_joinTeam_1_, lvt_12_1_.getCachedUniqueIdString());
                        if (lvt_5_1_.addPlayerToTeam(lvt_13_1_, lvt_6_1_)) {
                            lvt_7_1_.add(lvt_13_1_);
                            continue;
                        }
                        lvt_8_1_.add(lvt_13_1_);
                    }
                    continue;
                }
                String lvt_10_2_ = CommandScoreboard.getEntityName(p_joinTeam_4_, p_joinTeam_1_, lvt_9_2_);
                if (lvt_5_1_.addPlayerToTeam(lvt_10_2_, lvt_6_1_)) {
                    lvt_7_1_.add(lvt_10_2_);
                    continue;
                }
                lvt_8_1_.add(lvt_10_2_);
            }
        }
        if (!lvt_7_1_.isEmpty()) {
            p_joinTeam_1_.setCommandStat(CommandResultStats.Type.AFFECTED_ENTITIES, lvt_7_1_.size());
            CommandScoreboard.notifyCommandListener(p_joinTeam_1_, (ICommand)this, "commands.scoreboard.teams.join.success", lvt_7_1_.size(), lvt_6_1_, CommandScoreboard.joinNiceString(lvt_7_1_.toArray(new String[lvt_7_1_.size()])));
        }
        if (!lvt_8_1_.isEmpty()) {
            throw new CommandException("commands.scoreboard.teams.join.failure", lvt_8_1_.size(), lvt_6_1_, CommandScoreboard.joinNiceString(lvt_8_1_.toArray(new String[lvt_8_1_.size()])));
        }
    }

    protected void leaveTeam(ICommandSender p_leaveTeam_1_, String[] p_leaveTeam_2_, int p_leaveTeam_3_, MinecraftServer p_leaveTeam_4_) throws CommandException {
        Scoreboard lvt_5_1_ = this.getScoreboard(p_leaveTeam_4_);
        HashSet lvt_6_1_ = Sets.newHashSet();
        HashSet lvt_7_1_ = Sets.newHashSet();
        if (p_leaveTeam_1_ instanceof EntityPlayer && p_leaveTeam_3_ == p_leaveTeam_2_.length) {
            String lvt_8_1_ = CommandScoreboard.getCommandSenderAsPlayer(p_leaveTeam_1_).getName();
            if (lvt_5_1_.removePlayerFromTeams(lvt_8_1_)) {
                lvt_6_1_.add(lvt_8_1_);
            } else {
                lvt_7_1_.add(lvt_8_1_);
            }
        } else {
            while (p_leaveTeam_3_ < p_leaveTeam_2_.length) {
                String lvt_8_2_;
                if (EntitySelector.isSelector(lvt_8_2_ = p_leaveTeam_2_[p_leaveTeam_3_++])) {
                    List<Entity> lvt_9_1_ = CommandScoreboard.getEntityList(p_leaveTeam_4_, p_leaveTeam_1_, lvt_8_2_);
                    for (Entity lvt_11_1_ : lvt_9_1_) {
                        String lvt_12_1_ = CommandScoreboard.getEntityName(p_leaveTeam_4_, p_leaveTeam_1_, lvt_11_1_.getCachedUniqueIdString());
                        if (lvt_5_1_.removePlayerFromTeams(lvt_12_1_)) {
                            lvt_6_1_.add(lvt_12_1_);
                            continue;
                        }
                        lvt_7_1_.add(lvt_12_1_);
                    }
                    continue;
                }
                String lvt_9_2_ = CommandScoreboard.getEntityName(p_leaveTeam_4_, p_leaveTeam_1_, lvt_8_2_);
                if (lvt_5_1_.removePlayerFromTeams(lvt_9_2_)) {
                    lvt_6_1_.add(lvt_9_2_);
                    continue;
                }
                lvt_7_1_.add(lvt_9_2_);
            }
        }
        if (!lvt_6_1_.isEmpty()) {
            p_leaveTeam_1_.setCommandStat(CommandResultStats.Type.AFFECTED_ENTITIES, lvt_6_1_.size());
            CommandScoreboard.notifyCommandListener(p_leaveTeam_1_, (ICommand)this, "commands.scoreboard.teams.leave.success", lvt_6_1_.size(), CommandScoreboard.joinNiceString(lvt_6_1_.toArray(new String[lvt_6_1_.size()])));
        }
        if (!lvt_7_1_.isEmpty()) {
            throw new CommandException("commands.scoreboard.teams.leave.failure", lvt_7_1_.size(), CommandScoreboard.joinNiceString(lvt_7_1_.toArray(new String[lvt_7_1_.size()])));
        }
    }

    protected void emptyTeam(ICommandSender p_emptyTeam_1_, String[] p_emptyTeam_2_, int p_emptyTeam_3_, MinecraftServer p_emptyTeam_4_) throws CommandException {
        Scoreboard lvt_5_1_ = this.getScoreboard(p_emptyTeam_4_);
        ScorePlayerTeam lvt_6_1_ = this.convertToTeam(p_emptyTeam_2_[p_emptyTeam_3_], p_emptyTeam_4_);
        if (lvt_6_1_ == null) {
            return;
        }
        ArrayList lvt_7_1_ = Lists.newArrayList(lvt_6_1_.getMembershipCollection());
        p_emptyTeam_1_.setCommandStat(CommandResultStats.Type.AFFECTED_ENTITIES, lvt_7_1_.size());
        if (lvt_7_1_.isEmpty()) {
            throw new CommandException("commands.scoreboard.teams.empty.alreadyEmpty", lvt_6_1_.getRegisteredName());
        }
        for (String lvt_9_1_ : lvt_7_1_) {
            lvt_5_1_.removePlayerFromTeam(lvt_9_1_, lvt_6_1_);
        }
        CommandScoreboard.notifyCommandListener(p_emptyTeam_1_, (ICommand)this, "commands.scoreboard.teams.empty.success", lvt_7_1_.size(), lvt_6_1_.getRegisteredName());
    }

    protected void removeObjective(ICommandSender p_removeObjective_1_, String p_removeObjective_2_, MinecraftServer p_removeObjective_3_) throws CommandException {
        Scoreboard lvt_4_1_ = this.getScoreboard(p_removeObjective_3_);
        ScoreObjective lvt_5_1_ = this.convertToObjective(p_removeObjective_2_, false, p_removeObjective_3_);
        lvt_4_1_.removeObjective(lvt_5_1_);
        CommandScoreboard.notifyCommandListener(p_removeObjective_1_, (ICommand)this, "commands.scoreboard.objectives.remove.success", p_removeObjective_2_);
    }

    protected void listObjectives(ICommandSender p_listObjectives_1_, MinecraftServer p_listObjectives_2_) throws CommandException {
        Scoreboard lvt_3_1_ = this.getScoreboard(p_listObjectives_2_);
        Collection<ScoreObjective> lvt_4_1_ = lvt_3_1_.getScoreObjectives();
        if (lvt_4_1_.isEmpty()) {
            throw new CommandException("commands.scoreboard.objectives.list.empty", new Object[0]);
        }
        TextComponentTranslation lvt_5_1_ = new TextComponentTranslation("commands.scoreboard.objectives.list.count", lvt_4_1_.size());
        lvt_5_1_.getStyle().setColor(TextFormatting.DARK_GREEN);
        p_listObjectives_1_.sendMessage(lvt_5_1_);
        for (ScoreObjective lvt_7_1_ : lvt_4_1_) {
            p_listObjectives_1_.sendMessage(new TextComponentTranslation("commands.scoreboard.objectives.list.entry", lvt_7_1_.getName(), lvt_7_1_.getDisplayName(), lvt_7_1_.getCriteria().getName()));
        }
    }

    protected void setDisplayObjective(ICommandSender p_setDisplayObjective_1_, String[] p_setDisplayObjective_2_, int p_setDisplayObjective_3_, MinecraftServer p_setDisplayObjective_4_) throws CommandException {
        Scoreboard lvt_5_1_ = this.getScoreboard(p_setDisplayObjective_4_);
        String lvt_6_1_ = p_setDisplayObjective_2_[p_setDisplayObjective_3_++];
        int lvt_7_1_ = Scoreboard.getObjectiveDisplaySlotNumber(lvt_6_1_);
        ScoreObjective lvt_8_1_ = null;
        if (p_setDisplayObjective_2_.length == 4) {
            lvt_8_1_ = this.convertToObjective(p_setDisplayObjective_2_[p_setDisplayObjective_3_], false, p_setDisplayObjective_4_);
        }
        if (lvt_7_1_ < 0) {
            throw new CommandException("commands.scoreboard.objectives.setdisplay.invalidSlot", lvt_6_1_);
        }
        lvt_5_1_.setObjectiveInDisplaySlot(lvt_7_1_, lvt_8_1_);
        if (lvt_8_1_ != null) {
            CommandScoreboard.notifyCommandListener(p_setDisplayObjective_1_, (ICommand)this, "commands.scoreboard.objectives.setdisplay.successSet", Scoreboard.getObjectiveDisplaySlot(lvt_7_1_), lvt_8_1_.getName());
        } else {
            CommandScoreboard.notifyCommandListener(p_setDisplayObjective_1_, (ICommand)this, "commands.scoreboard.objectives.setdisplay.successCleared", Scoreboard.getObjectiveDisplaySlot(lvt_7_1_));
        }
    }

    protected void listPlayers(ICommandSender p_listPlayers_1_, String[] p_listPlayers_2_, int p_listPlayers_3_, MinecraftServer p_listPlayers_4_) throws CommandException {
        Scoreboard lvt_5_1_ = this.getScoreboard(p_listPlayers_4_);
        if (p_listPlayers_2_.length > p_listPlayers_3_) {
            String lvt_6_1_ = CommandScoreboard.getEntityName(p_listPlayers_4_, p_listPlayers_1_, p_listPlayers_2_[p_listPlayers_3_]);
            Map<ScoreObjective, Score> lvt_7_1_ = lvt_5_1_.getObjectivesForEntity(lvt_6_1_);
            p_listPlayers_1_.setCommandStat(CommandResultStats.Type.QUERY_RESULT, lvt_7_1_.size());
            if (lvt_7_1_.isEmpty()) {
                throw new CommandException("commands.scoreboard.players.list.player.empty", lvt_6_1_);
            }
            TextComponentTranslation lvt_8_1_ = new TextComponentTranslation("commands.scoreboard.players.list.player.count", lvt_7_1_.size(), lvt_6_1_);
            lvt_8_1_.getStyle().setColor(TextFormatting.DARK_GREEN);
            p_listPlayers_1_.sendMessage(lvt_8_1_);
            for (Score lvt_10_1_ : lvt_7_1_.values()) {
                p_listPlayers_1_.sendMessage(new TextComponentTranslation("commands.scoreboard.players.list.player.entry", lvt_10_1_.getScorePoints(), lvt_10_1_.getObjective().getDisplayName(), lvt_10_1_.getObjective().getName()));
            }
        } else {
            Collection<String> lvt_6_2_ = lvt_5_1_.getObjectiveNames();
            p_listPlayers_1_.setCommandStat(CommandResultStats.Type.QUERY_RESULT, lvt_6_2_.size());
            if (lvt_6_2_.isEmpty()) {
                throw new CommandException("commands.scoreboard.players.list.empty", new Object[0]);
            }
            TextComponentTranslation lvt_7_2_ = new TextComponentTranslation("commands.scoreboard.players.list.count", lvt_6_2_.size());
            lvt_7_2_.getStyle().setColor(TextFormatting.DARK_GREEN);
            p_listPlayers_1_.sendMessage(lvt_7_2_);
            p_listPlayers_1_.sendMessage(new TextComponentString(CommandScoreboard.joinNiceString(lvt_6_2_.toArray())));
        }
    }

    protected void addPlayerScore(ICommandSender p_addPlayerScore_1_, String[] p_addPlayerScore_2_, int p_addPlayerScore_3_, MinecraftServer p_addPlayerScore_4_) throws CommandException {
        int lvt_9_1_;
        String lvt_7_1_;
        String lvt_5_1_ = p_addPlayerScore_2_[p_addPlayerScore_3_ - 1];
        int lvt_6_1_ = p_addPlayerScore_3_;
        if ((lvt_7_1_ = CommandScoreboard.getEntityName(p_addPlayerScore_4_, p_addPlayerScore_1_, p_addPlayerScore_2_[p_addPlayerScore_3_++])).length() > 40) {
            throw new SyntaxErrorException("commands.scoreboard.players.name.tooLong", lvt_7_1_, 40);
        }
        ScoreObjective lvt_8_1_ = this.convertToObjective(p_addPlayerScore_2_[p_addPlayerScore_3_++], true, p_addPlayerScore_4_);
        int n = lvt_9_1_ = "set".equalsIgnoreCase(lvt_5_1_) ? CommandScoreboard.parseInt(p_addPlayerScore_2_[p_addPlayerScore_3_++]) : CommandScoreboard.parseInt(p_addPlayerScore_2_[p_addPlayerScore_3_++], 0);
        if (p_addPlayerScore_2_.length > p_addPlayerScore_3_) {
            Entity lvt_10_1_ = CommandScoreboard.getEntity(p_addPlayerScore_4_, p_addPlayerScore_1_, p_addPlayerScore_2_[lvt_6_1_]);
            try {
                NBTTagCompound lvt_11_1_ = JsonToNBT.getTagFromJson(CommandScoreboard.buildString(p_addPlayerScore_2_, p_addPlayerScore_3_));
                NBTTagCompound lvt_12_1_ = CommandScoreboard.entityToNBT(lvt_10_1_);
                if (!NBTUtil.areNBTEquals(lvt_11_1_, lvt_12_1_, true)) {
                    throw new CommandException("commands.scoreboard.players.set.tagMismatch", lvt_7_1_);
                }
            }
            catch (NBTException lvt_11_2_) {
                throw new CommandException("commands.scoreboard.players.set.tagError", lvt_11_2_.getMessage());
            }
        }
        Scoreboard lvt_10_2_ = this.getScoreboard(p_addPlayerScore_4_);
        Score lvt_11_3_ = lvt_10_2_.getOrCreateScore(lvt_7_1_, lvt_8_1_);
        if ("set".equalsIgnoreCase(lvt_5_1_)) {
            lvt_11_3_.setScorePoints(lvt_9_1_);
        } else if ("add".equalsIgnoreCase(lvt_5_1_)) {
            lvt_11_3_.increaseScore(lvt_9_1_);
        } else {
            lvt_11_3_.decreaseScore(lvt_9_1_);
        }
        CommandScoreboard.notifyCommandListener(p_addPlayerScore_1_, (ICommand)this, "commands.scoreboard.players.set.success", lvt_8_1_.getName(), lvt_7_1_, lvt_11_3_.getScorePoints());
    }

    protected void resetPlayerScore(ICommandSender p_resetPlayerScore_1_, String[] p_resetPlayerScore_2_, int p_resetPlayerScore_3_, MinecraftServer p_resetPlayerScore_4_) throws CommandException {
        Scoreboard lvt_5_1_ = this.getScoreboard(p_resetPlayerScore_4_);
        String lvt_6_1_ = CommandScoreboard.getEntityName(p_resetPlayerScore_4_, p_resetPlayerScore_1_, p_resetPlayerScore_2_[p_resetPlayerScore_3_++]);
        if (p_resetPlayerScore_2_.length > p_resetPlayerScore_3_) {
            ScoreObjective lvt_7_1_ = this.convertToObjective(p_resetPlayerScore_2_[p_resetPlayerScore_3_++], false, p_resetPlayerScore_4_);
            lvt_5_1_.removeObjectiveFromEntity(lvt_6_1_, lvt_7_1_);
            CommandScoreboard.notifyCommandListener(p_resetPlayerScore_1_, (ICommand)this, "commands.scoreboard.players.resetscore.success", lvt_7_1_.getName(), lvt_6_1_);
        } else {
            lvt_5_1_.removeObjectiveFromEntity(lvt_6_1_, null);
            CommandScoreboard.notifyCommandListener(p_resetPlayerScore_1_, (ICommand)this, "commands.scoreboard.players.reset.success", lvt_6_1_);
        }
    }

    protected void enablePlayerTrigger(ICommandSender p_enablePlayerTrigger_1_, String[] p_enablePlayerTrigger_2_, int p_enablePlayerTrigger_3_, MinecraftServer p_enablePlayerTrigger_4_) throws CommandException {
        String lvt_6_1_;
        Scoreboard lvt_5_1_ = this.getScoreboard(p_enablePlayerTrigger_4_);
        if ((lvt_6_1_ = CommandScoreboard.getPlayerName(p_enablePlayerTrigger_4_, p_enablePlayerTrigger_1_, p_enablePlayerTrigger_2_[p_enablePlayerTrigger_3_++])).length() > 40) {
            throw new SyntaxErrorException("commands.scoreboard.players.name.tooLong", lvt_6_1_, 40);
        }
        ScoreObjective lvt_7_1_ = this.convertToObjective(p_enablePlayerTrigger_2_[p_enablePlayerTrigger_3_], false, p_enablePlayerTrigger_4_);
        if (lvt_7_1_.getCriteria() != IScoreCriteria.TRIGGER) {
            throw new CommandException("commands.scoreboard.players.enable.noTrigger", lvt_7_1_.getName());
        }
        Score lvt_8_1_ = lvt_5_1_.getOrCreateScore(lvt_6_1_, lvt_7_1_);
        lvt_8_1_.setLocked(false);
        CommandScoreboard.notifyCommandListener(p_enablePlayerTrigger_1_, (ICommand)this, "commands.scoreboard.players.enable.success", lvt_7_1_.getName(), lvt_6_1_);
    }

    protected void testPlayerScore(ICommandSender p_testPlayerScore_1_, String[] p_testPlayerScore_2_, int p_testPlayerScore_3_, MinecraftServer p_testPlayerScore_4_) throws CommandException {
        ScoreObjective lvt_7_1_;
        String lvt_6_1_;
        Scoreboard lvt_5_1_ = this.getScoreboard(p_testPlayerScore_4_);
        if ((lvt_6_1_ = CommandScoreboard.getEntityName(p_testPlayerScore_4_, p_testPlayerScore_1_, p_testPlayerScore_2_[p_testPlayerScore_3_++])).length() > 40) {
            throw new SyntaxErrorException("commands.scoreboard.players.name.tooLong", lvt_6_1_, 40);
        }
        if (!lvt_5_1_.entityHasObjective(lvt_6_1_, lvt_7_1_ = this.convertToObjective(p_testPlayerScore_2_[p_testPlayerScore_3_++], false, p_testPlayerScore_4_))) {
            throw new CommandException("commands.scoreboard.players.test.notFound", lvt_7_1_.getName(), lvt_6_1_);
        }
        int lvt_8_1_ = p_testPlayerScore_2_[p_testPlayerScore_3_].equals("*") ? Integer.MIN_VALUE : CommandScoreboard.parseInt(p_testPlayerScore_2_[p_testPlayerScore_3_]);
        int lvt_9_1_ = ++p_testPlayerScore_3_ >= p_testPlayerScore_2_.length || p_testPlayerScore_2_[p_testPlayerScore_3_].equals("*") ? Integer.MAX_VALUE : CommandScoreboard.parseInt(p_testPlayerScore_2_[p_testPlayerScore_3_], lvt_8_1_);
        Score lvt_10_1_ = lvt_5_1_.getOrCreateScore(lvt_6_1_, lvt_7_1_);
        if (lvt_10_1_.getScorePoints() < lvt_8_1_ || lvt_10_1_.getScorePoints() > lvt_9_1_) {
            throw new CommandException("commands.scoreboard.players.test.failed", lvt_10_1_.getScorePoints(), lvt_8_1_, lvt_9_1_);
        }
        CommandScoreboard.notifyCommandListener(p_testPlayerScore_1_, (ICommand)this, "commands.scoreboard.players.test.success", lvt_10_1_.getScorePoints(), lvt_8_1_, lvt_9_1_);
    }

    protected void applyPlayerOperation(ICommandSender p_applyPlayerOperation_1_, String[] p_applyPlayerOperation_2_, int p_applyPlayerOperation_3_, MinecraftServer p_applyPlayerOperation_4_) throws CommandException {
        Scoreboard lvt_5_1_ = this.getScoreboard(p_applyPlayerOperation_4_);
        String lvt_6_1_ = CommandScoreboard.getEntityName(p_applyPlayerOperation_4_, p_applyPlayerOperation_1_, p_applyPlayerOperation_2_[p_applyPlayerOperation_3_++]);
        ScoreObjective lvt_7_1_ = this.convertToObjective(p_applyPlayerOperation_2_[p_applyPlayerOperation_3_++], true, p_applyPlayerOperation_4_);
        String lvt_8_1_ = p_applyPlayerOperation_2_[p_applyPlayerOperation_3_++];
        String lvt_9_1_ = CommandScoreboard.getEntityName(p_applyPlayerOperation_4_, p_applyPlayerOperation_1_, p_applyPlayerOperation_2_[p_applyPlayerOperation_3_++]);
        ScoreObjective lvt_10_1_ = this.convertToObjective(p_applyPlayerOperation_2_[p_applyPlayerOperation_3_], false, p_applyPlayerOperation_4_);
        if (lvt_6_1_.length() > 40) {
            throw new SyntaxErrorException("commands.scoreboard.players.name.tooLong", lvt_6_1_, 40);
        }
        if (lvt_9_1_.length() > 40) {
            throw new SyntaxErrorException("commands.scoreboard.players.name.tooLong", lvt_9_1_, 40);
        }
        Score lvt_11_1_ = lvt_5_1_.getOrCreateScore(lvt_6_1_, lvt_7_1_);
        if (!lvt_5_1_.entityHasObjective(lvt_9_1_, lvt_10_1_)) {
            throw new CommandException("commands.scoreboard.players.operation.notFound", lvt_10_1_.getName(), lvt_9_1_);
        }
        Score lvt_12_1_ = lvt_5_1_.getOrCreateScore(lvt_9_1_, lvt_10_1_);
        if ("+=".equals(lvt_8_1_)) {
            lvt_11_1_.setScorePoints(lvt_11_1_.getScorePoints() + lvt_12_1_.getScorePoints());
        } else if ("-=".equals(lvt_8_1_)) {
            lvt_11_1_.setScorePoints(lvt_11_1_.getScorePoints() - lvt_12_1_.getScorePoints());
        } else if ("*=".equals(lvt_8_1_)) {
            lvt_11_1_.setScorePoints(lvt_11_1_.getScorePoints() * lvt_12_1_.getScorePoints());
        } else if ("/=".equals(lvt_8_1_)) {
            if (lvt_12_1_.getScorePoints() != 0) {
                lvt_11_1_.setScorePoints(lvt_11_1_.getScorePoints() / lvt_12_1_.getScorePoints());
            }
        } else if ("%=".equals(lvt_8_1_)) {
            if (lvt_12_1_.getScorePoints() != 0) {
                lvt_11_1_.setScorePoints(lvt_11_1_.getScorePoints() % lvt_12_1_.getScorePoints());
            }
        } else if ("=".equals(lvt_8_1_)) {
            lvt_11_1_.setScorePoints(lvt_12_1_.getScorePoints());
        } else if ("<".equals(lvt_8_1_)) {
            lvt_11_1_.setScorePoints(Math.min(lvt_11_1_.getScorePoints(), lvt_12_1_.getScorePoints()));
        } else if (">".equals(lvt_8_1_)) {
            lvt_11_1_.setScorePoints(Math.max(lvt_11_1_.getScorePoints(), lvt_12_1_.getScorePoints()));
        } else if ("><".equals(lvt_8_1_)) {
            int lvt_13_1_ = lvt_11_1_.getScorePoints();
            lvt_11_1_.setScorePoints(lvt_12_1_.getScorePoints());
            lvt_12_1_.setScorePoints(lvt_13_1_);
        } else {
            throw new CommandException("commands.scoreboard.players.operation.invalidOperation", lvt_8_1_);
        }
        CommandScoreboard.notifyCommandListener(p_applyPlayerOperation_1_, (ICommand)this, "commands.scoreboard.players.operation.success", new Object[0]);
    }

    protected void applyPlayerTag(MinecraftServer p_applyPlayerTag_1_, ICommandSender p_applyPlayerTag_2_, String[] p_applyPlayerTag_3_, int p_applyPlayerTag_4_) throws CommandException {
        String lvt_5_1_ = CommandScoreboard.getEntityName(p_applyPlayerTag_1_, p_applyPlayerTag_2_, p_applyPlayerTag_3_[p_applyPlayerTag_4_]);
        Entity lvt_6_1_ = CommandScoreboard.getEntity(p_applyPlayerTag_1_, p_applyPlayerTag_2_, p_applyPlayerTag_3_[p_applyPlayerTag_4_++]);
        String lvt_7_1_ = p_applyPlayerTag_3_[p_applyPlayerTag_4_++];
        Set<String> lvt_8_1_ = lvt_6_1_.getTags();
        if ("list".equals(lvt_7_1_)) {
            if (!lvt_8_1_.isEmpty()) {
                TextComponentTranslation lvt_9_1_ = new TextComponentTranslation("commands.scoreboard.players.tag.list", lvt_5_1_);
                lvt_9_1_.getStyle().setColor(TextFormatting.DARK_GREEN);
                p_applyPlayerTag_2_.sendMessage(lvt_9_1_);
                p_applyPlayerTag_2_.sendMessage(new TextComponentString(CommandScoreboard.joinNiceString(lvt_8_1_.toArray())));
            }
            p_applyPlayerTag_2_.setCommandStat(CommandResultStats.Type.QUERY_RESULT, lvt_8_1_.size());
            return;
        }
        if (p_applyPlayerTag_3_.length < 5) {
            throw new WrongUsageException("commands.scoreboard.players.tag.usage", new Object[0]);
        }
        String lvt_9_2_ = p_applyPlayerTag_3_[p_applyPlayerTag_4_++];
        if (p_applyPlayerTag_3_.length > p_applyPlayerTag_4_) {
            try {
                NBTTagCompound lvt_10_1_ = JsonToNBT.getTagFromJson(CommandScoreboard.buildString(p_applyPlayerTag_3_, p_applyPlayerTag_4_));
                NBTTagCompound lvt_11_1_ = CommandScoreboard.entityToNBT(lvt_6_1_);
                if (!NBTUtil.areNBTEquals(lvt_10_1_, lvt_11_1_, true)) {
                    throw new CommandException("commands.scoreboard.players.tag.tagMismatch", lvt_5_1_);
                }
            }
            catch (NBTException lvt_10_2_) {
                throw new CommandException("commands.scoreboard.players.tag.tagError", lvt_10_2_.getMessage());
            }
        }
        if ("add".equals(lvt_7_1_)) {
            if (!lvt_6_1_.addTag(lvt_9_2_)) {
                throw new CommandException("commands.scoreboard.players.tag.tooMany", 1024);
            }
            CommandScoreboard.notifyCommandListener(p_applyPlayerTag_2_, (ICommand)this, "commands.scoreboard.players.tag.success.add", lvt_9_2_);
        } else if ("remove".equals(lvt_7_1_)) {
            if (!lvt_6_1_.removeTag(lvt_9_2_)) {
                throw new CommandException("commands.scoreboard.players.tag.notFound", lvt_9_2_);
            }
            CommandScoreboard.notifyCommandListener(p_applyPlayerTag_2_, (ICommand)this, "commands.scoreboard.players.tag.success.remove", lvt_9_2_);
        } else {
            throw new WrongUsageException("commands.scoreboard.players.tag.usage", new Object[0]);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "objectives", "players", "teams");
        }
        if ("objectives".equalsIgnoreCase(p_getTabCompletions_3_[0])) {
            if (p_getTabCompletions_3_.length == 2) {
                return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "list", "add", "remove", "setdisplay");
            }
            if ("add".equalsIgnoreCase(p_getTabCompletions_3_[1])) {
                if (p_getTabCompletions_3_.length == 4) {
                    Set<String> lvt_5_1_ = IScoreCriteria.INSTANCES.keySet();
                    return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, lvt_5_1_);
                }
            } else if ("remove".equalsIgnoreCase(p_getTabCompletions_3_[1])) {
                if (p_getTabCompletions_3_.length == 3) {
                    return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, this.getObjectiveNames(false, p_getTabCompletions_1_));
                }
            } else if ("setdisplay".equalsIgnoreCase(p_getTabCompletions_3_[1])) {
                if (p_getTabCompletions_3_.length == 3) {
                    return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, Scoreboard.getDisplaySlotStrings());
                }
                if (p_getTabCompletions_3_.length == 4) {
                    return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, this.getObjectiveNames(false, p_getTabCompletions_1_));
                }
            }
        } else if ("players".equalsIgnoreCase(p_getTabCompletions_3_[0])) {
            if (p_getTabCompletions_3_.length == 2) {
                return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "set", "add", "remove", "reset", "list", "enable", "test", "operation", "tag");
            }
            if ("set".equalsIgnoreCase(p_getTabCompletions_3_[1]) || "add".equalsIgnoreCase(p_getTabCompletions_3_[1]) || "remove".equalsIgnoreCase(p_getTabCompletions_3_[1]) || "reset".equalsIgnoreCase(p_getTabCompletions_3_[1])) {
                if (p_getTabCompletions_3_.length == 3) {
                    return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
                }
                if (p_getTabCompletions_3_.length == 4) {
                    return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, this.getObjectiveNames(true, p_getTabCompletions_1_));
                }
            } else if ("enable".equalsIgnoreCase(p_getTabCompletions_3_[1])) {
                if (p_getTabCompletions_3_.length == 3) {
                    return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
                }
                if (p_getTabCompletions_3_.length == 4) {
                    return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, this.getTriggerNames(p_getTabCompletions_1_));
                }
            } else if ("list".equalsIgnoreCase(p_getTabCompletions_3_[1]) || "test".equalsIgnoreCase(p_getTabCompletions_3_[1])) {
                if (p_getTabCompletions_3_.length == 3) {
                    return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, this.getScoreboard(p_getTabCompletions_1_).getObjectiveNames());
                }
                if (p_getTabCompletions_3_.length == 4 && "test".equalsIgnoreCase(p_getTabCompletions_3_[1])) {
                    return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, this.getObjectiveNames(false, p_getTabCompletions_1_));
                }
            } else if ("operation".equalsIgnoreCase(p_getTabCompletions_3_[1])) {
                if (p_getTabCompletions_3_.length == 3) {
                    return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, this.getScoreboard(p_getTabCompletions_1_).getObjectiveNames());
                }
                if (p_getTabCompletions_3_.length == 4) {
                    return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, this.getObjectiveNames(true, p_getTabCompletions_1_));
                }
                if (p_getTabCompletions_3_.length == 5) {
                    return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "+=", "-=", "*=", "/=", "%=", "=", "<", ">", "><");
                }
                if (p_getTabCompletions_3_.length == 6) {
                    return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
                }
                if (p_getTabCompletions_3_.length == 7) {
                    return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, this.getObjectiveNames(false, p_getTabCompletions_1_));
                }
            } else if ("tag".equalsIgnoreCase(p_getTabCompletions_3_[1])) {
                if (p_getTabCompletions_3_.length == 3) {
                    return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, this.getScoreboard(p_getTabCompletions_1_).getObjectiveNames());
                }
                if (p_getTabCompletions_3_.length == 4) {
                    return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "add", "remove", "list");
                }
            }
        } else if ("teams".equalsIgnoreCase(p_getTabCompletions_3_[0])) {
            if (p_getTabCompletions_3_.length == 2) {
                return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "add", "remove", "join", "leave", "empty", "list", "option");
            }
            if ("join".equalsIgnoreCase(p_getTabCompletions_3_[1])) {
                if (p_getTabCompletions_3_.length == 3) {
                    return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, this.getScoreboard(p_getTabCompletions_1_).getTeamNames());
                }
                if (p_getTabCompletions_3_.length >= 4) {
                    return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
                }
            } else {
                if ("leave".equalsIgnoreCase(p_getTabCompletions_3_[1])) {
                    return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
                }
                if ("empty".equalsIgnoreCase(p_getTabCompletions_3_[1]) || "list".equalsIgnoreCase(p_getTabCompletions_3_[1]) || "remove".equalsIgnoreCase(p_getTabCompletions_3_[1])) {
                    if (p_getTabCompletions_3_.length == 3) {
                        return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, this.getScoreboard(p_getTabCompletions_1_).getTeamNames());
                    }
                } else if ("option".equalsIgnoreCase(p_getTabCompletions_3_[1])) {
                    if (p_getTabCompletions_3_.length == 3) {
                        return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, this.getScoreboard(p_getTabCompletions_1_).getTeamNames());
                    }
                    if (p_getTabCompletions_3_.length == 4) {
                        return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "color", "friendlyfire", "seeFriendlyInvisibles", "nametagVisibility", "deathMessageVisibility", "collisionRule");
                    }
                    if (p_getTabCompletions_3_.length == 5) {
                        if ("color".equalsIgnoreCase(p_getTabCompletions_3_[3])) {
                            return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, TextFormatting.getValidValues(true, false));
                        }
                        if ("nametagVisibility".equalsIgnoreCase(p_getTabCompletions_3_[3]) || "deathMessageVisibility".equalsIgnoreCase(p_getTabCompletions_3_[3])) {
                            return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, Team.EnumVisible.getNames());
                        }
                        if ("collisionRule".equalsIgnoreCase(p_getTabCompletions_3_[3])) {
                            return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, Team.CollisionRule.getNames());
                        }
                        if ("friendlyfire".equalsIgnoreCase(p_getTabCompletions_3_[3]) || "seeFriendlyInvisibles".equalsIgnoreCase(p_getTabCompletions_3_[3])) {
                            return CommandScoreboard.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "true", "false");
                        }
                    }
                }
            }
        }
        return Collections.emptyList();
    }

    protected List<String> getObjectiveNames(boolean p_getObjectiveNames_1_, MinecraftServer p_getObjectiveNames_2_) {
        Collection<ScoreObjective> lvt_3_1_ = this.getScoreboard(p_getObjectiveNames_2_).getScoreObjectives();
        ArrayList lvt_4_1_ = Lists.newArrayList();
        for (ScoreObjective lvt_6_1_ : lvt_3_1_) {
            if (p_getObjectiveNames_1_ && lvt_6_1_.getCriteria().isReadOnly()) continue;
            lvt_4_1_.add(lvt_6_1_.getName());
        }
        return lvt_4_1_;
    }

    protected List<String> getTriggerNames(MinecraftServer p_getTriggerNames_1_) {
        Collection<ScoreObjective> lvt_2_1_ = this.getScoreboard(p_getTriggerNames_1_).getScoreObjectives();
        ArrayList lvt_3_1_ = Lists.newArrayList();
        for (ScoreObjective lvt_5_1_ : lvt_2_1_) {
            if (lvt_5_1_.getCriteria() != IScoreCriteria.TRIGGER) continue;
            lvt_3_1_.add(lvt_5_1_.getName());
        }
        return lvt_3_1_;
    }

    @Override
    public boolean isUsernameIndex(String[] p_isUsernameIndex_1_, int p_isUsernameIndex_2_) {
        if ("players".equalsIgnoreCase(p_isUsernameIndex_1_[0])) {
            if (p_isUsernameIndex_1_.length > 1 && "operation".equalsIgnoreCase(p_isUsernameIndex_1_[1])) {
                return p_isUsernameIndex_2_ == 2 || p_isUsernameIndex_2_ == 5;
            }
            return p_isUsernameIndex_2_ == 2;
        }
        if ("teams".equalsIgnoreCase(p_isUsernameIndex_1_[0])) {
            return p_isUsernameIndex_2_ == 2;
        }
        return false;
    }
}

