/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.server;

import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CommandSetBlock
extends CommandBase {
    @Override
    public String getName() {
        return "setblock";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.setblock.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        TileEntity tileentity;
        TileEntity tileentity1;
        if (p_execute_3_.length < 4) {
            throw new WrongUsageException("commands.setblock.usage", new Object[0]);
        }
        p_execute_2_.setCommandStat(CommandResultStats.Type.AFFECTED_BLOCKS, 0);
        BlockPos blockpos = CommandSetBlock.parseBlockPos(p_execute_2_, p_execute_3_, 0, false);
        Block block = CommandBase.getBlockByText(p_execute_2_, p_execute_3_[3]);
        IBlockState iblockstate = p_execute_3_.length >= 5 ? CommandSetBlock.convertArgToBlockState(block, p_execute_3_[4]) : block.getDefaultState();
        World world = p_execute_2_.getEntityWorld();
        if (!world.isBlockLoaded(blockpos)) {
            throw new CommandException("commands.setblock.outOfWorld", new Object[0]);
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        boolean flag = false;
        if (p_execute_3_.length >= 7 && block.hasTileEntity(iblockstate)) {
            String s = CommandSetBlock.getChatComponentFromNthArg(p_execute_2_, p_execute_3_, 6).getUnformattedText();
            try {
                nbttagcompound = JsonToNBT.getTagFromJson(s);
                flag = true;
            }
            catch (NBTException nbtexception) {
                throw new CommandException("commands.setblock.tagError", nbtexception.getMessage());
            }
        }
        if (p_execute_3_.length >= 6) {
            if ("destroy".equals(p_execute_3_[5])) {
                world.destroyBlock(blockpos, true);
                if (block == Blocks.AIR) {
                    CommandSetBlock.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.setblock.success", new Object[0]);
                    return;
                }
            } else if ("keep".equals(p_execute_3_[5]) && !world.isAirBlock(blockpos)) {
                throw new CommandException("commands.setblock.noChange", new Object[0]);
            }
        }
        if ((tileentity1 = world.getTileEntity(blockpos)) != null) {
            if (tileentity1 instanceof IInventory) {
                ((IInventory)((Object)tileentity1)).clear();
            }
            world.setBlockState(blockpos, Blocks.AIR.getDefaultState(), block == Blocks.AIR ? 2 : 4);
        }
        if (!world.setBlockState(blockpos, iblockstate, 2)) {
            throw new CommandException("commands.setblock.noChange", new Object[0]);
        }
        if (flag && (tileentity = world.getTileEntity(blockpos)) != null) {
            nbttagcompound.setInteger("x", blockpos.getX());
            nbttagcompound.setInteger("y", blockpos.getY());
            nbttagcompound.setInteger("z", blockpos.getZ());
            tileentity.readFromNBT(nbttagcompound);
        }
        world.notifyNeighborsRespectDebug(blockpos, iblockstate.getBlock(), false);
        p_execute_2_.setCommandStat(CommandResultStats.Type.AFFECTED_BLOCKS, 1);
        CommandSetBlock.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.setblock.success", new Object[0]);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        return p_getTabCompletions_3_.length > 0 && p_getTabCompletions_3_.length <= 3 ? CommandSetBlock.getTabCompletionCoordinate(p_getTabCompletions_3_, 0, p_getTabCompletions_4_) : (p_getTabCompletions_3_.length == 4 ? CommandSetBlock.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, Block.REGISTRY.getKeys()) : (p_getTabCompletions_3_.length == 6 ? CommandSetBlock.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "replace", "destroy", "keep") : Collections.emptyList()));
    }
}

