/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.server;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;

public class CommandSummon
extends CommandBase {
    @Override
    public String getName() {
        return "summon";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.summon.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        World lvt_13_1_;
        if (p_execute_3_.length < 1) {
            throw new WrongUsageException("commands.summon.usage", new Object[0]);
        }
        String lvt_4_1_ = p_execute_3_[0];
        BlockPos lvt_5_1_ = p_execute_2_.getPosition();
        Vec3d lvt_6_1_ = p_execute_2_.getPositionVector();
        double lvt_7_1_ = lvt_6_1_.xCoord;
        double lvt_9_1_ = lvt_6_1_.yCoord;
        double lvt_11_1_ = lvt_6_1_.zCoord;
        if (p_execute_3_.length >= 4) {
            lvt_7_1_ = CommandSummon.parseDouble(lvt_7_1_, p_execute_3_[1], true);
            lvt_9_1_ = CommandSummon.parseDouble(lvt_9_1_, p_execute_3_[2], false);
            lvt_11_1_ = CommandSummon.parseDouble(lvt_11_1_, p_execute_3_[3], true);
            lvt_5_1_ = new BlockPos(lvt_7_1_, lvt_9_1_, lvt_11_1_);
        }
        if (!(lvt_13_1_ = p_execute_2_.getEntityWorld()).isBlockLoaded(lvt_5_1_)) {
            throw new CommandException("commands.summon.outOfWorld", new Object[0]);
        }
        if (EntityList.LIGHTNING_BOLT.equals(new ResourceLocation(lvt_4_1_))) {
            lvt_13_1_.addWeatherEffect(new EntityLightningBolt(lvt_13_1_, lvt_7_1_, lvt_9_1_, lvt_11_1_, false));
            CommandSummon.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.summon.success", new Object[0]);
            return;
        }
        NBTTagCompound lvt_14_1_ = new NBTTagCompound();
        boolean lvt_15_1_ = false;
        if (p_execute_3_.length >= 5) {
            ITextComponent lvt_16_1_ = CommandSummon.getChatComponentFromNthArg(p_execute_2_, p_execute_3_, 4);
            try {
                lvt_14_1_ = JsonToNBT.getTagFromJson(lvt_16_1_.getUnformattedText());
                lvt_15_1_ = true;
            }
            catch (NBTException lvt_17_1_) {
                throw new CommandException("commands.summon.tagError", lvt_17_1_.getMessage());
            }
        }
        lvt_14_1_.setString("id", lvt_4_1_);
        Entity lvt_16_2_ = AnvilChunkLoader.readWorldEntityPos(lvt_14_1_, lvt_13_1_, lvt_7_1_, lvt_9_1_, lvt_11_1_, true);
        if (lvt_16_2_ == null) {
            throw new CommandException("commands.summon.failed", new Object[0]);
        }
        lvt_16_2_.setLocationAndAngles(lvt_7_1_, lvt_9_1_, lvt_11_1_, lvt_16_2_.rotationYaw, lvt_16_2_.rotationPitch);
        if (!lvt_15_1_ && lvt_16_2_ instanceof EntityLiving) {
            ((EntityLiving)lvt_16_2_).onInitialSpawn(lvt_13_1_.getDifficultyForLocation(new BlockPos(lvt_16_2_)), null);
        }
        CommandSummon.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.summon.success", new Object[0]);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandSummon.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, EntityList.getEntityNameList());
        }
        if (p_getTabCompletions_3_.length > 1 && p_getTabCompletions_3_.length <= 4) {
            return CommandSummon.getTabCompletionCoordinate(p_getTabCompletions_3_, 1, p_getTabCompletions_4_);
        }
        return Collections.emptyList();
    }
}

