/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.server;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.play.server.SPacketPlayerPosLook;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class CommandTeleport
extends CommandBase {
    @Override
    public String getName() {
        return "teleport";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.teleport.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length < 4) {
            throw new WrongUsageException("commands.teleport.usage", new Object[0]);
        }
        Entity lvt_4_1_ = CommandTeleport.getEntity(p_execute_1_, p_execute_2_, p_execute_3_[0]);
        if (lvt_4_1_.world == null) {
            return;
        }
        int lvt_5_1_ = 4096;
        Vec3d lvt_6_1_ = p_execute_2_.getPositionVector();
        int lvt_7_1_ = 1;
        CommandBase.CoordinateArg lvt_8_1_ = CommandTeleport.parseCoordinate(lvt_6_1_.xCoord, p_execute_3_[lvt_7_1_++], true);
        CommandBase.CoordinateArg lvt_9_1_ = CommandTeleport.parseCoordinate(lvt_6_1_.yCoord, p_execute_3_[lvt_7_1_++], -4096, 4096, false);
        CommandBase.CoordinateArg lvt_10_1_ = CommandTeleport.parseCoordinate(lvt_6_1_.zCoord, p_execute_3_[lvt_7_1_++], true);
        Entity lvt_11_1_ = p_execute_2_.getCommandSenderEntity() == null ? lvt_4_1_ : p_execute_2_.getCommandSenderEntity();
        CommandBase.CoordinateArg lvt_12_1_ = CommandTeleport.parseCoordinate(p_execute_3_.length > lvt_7_1_ ? (double)lvt_11_1_.rotationYaw : (double)lvt_4_1_.rotationYaw, p_execute_3_.length > lvt_7_1_ ? p_execute_3_[lvt_7_1_] : "~", false);
        CommandBase.CoordinateArg lvt_13_1_ = CommandTeleport.parseCoordinate(p_execute_3_.length > ++lvt_7_1_ ? (double)lvt_11_1_.rotationPitch : (double)lvt_4_1_.rotationPitch, p_execute_3_.length > lvt_7_1_ ? p_execute_3_[lvt_7_1_] : "~", false);
        CommandTeleport.doTeleport(lvt_4_1_, lvt_8_1_, lvt_9_1_, lvt_10_1_, lvt_12_1_, lvt_13_1_);
        CommandTeleport.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.teleport.success.coordinates", lvt_4_1_.getName(), lvt_8_1_.getResult(), lvt_9_1_.getResult(), lvt_10_1_.getResult());
    }

    private static void doTeleport(Entity p_doTeleport_0_, CommandBase.CoordinateArg p_doTeleport_1_, CommandBase.CoordinateArg p_doTeleport_2_, CommandBase.CoordinateArg p_doTeleport_3_, CommandBase.CoordinateArg p_doTeleport_4_, CommandBase.CoordinateArg p_doTeleport_5_) {
        if (p_doTeleport_0_ instanceof EntityPlayerMP) {
            EnumSet<SPacketPlayerPosLook.EnumFlags> lvt_6_1_ = EnumSet.noneOf(SPacketPlayerPosLook.EnumFlags.class);
            float lvt_7_1_ = (float)p_doTeleport_4_.getAmount();
            if (p_doTeleport_4_.isRelative()) {
                lvt_6_1_.add(SPacketPlayerPosLook.EnumFlags.Y_ROT);
            } else {
                lvt_7_1_ = MathHelper.wrapDegrees(lvt_7_1_);
            }
            float lvt_8_1_ = (float)p_doTeleport_5_.getAmount();
            if (p_doTeleport_5_.isRelative()) {
                lvt_6_1_.add(SPacketPlayerPosLook.EnumFlags.X_ROT);
            } else {
                lvt_8_1_ = MathHelper.wrapDegrees(lvt_8_1_);
            }
            p_doTeleport_0_.dismountRidingEntity();
            ((EntityPlayerMP)p_doTeleport_0_).connection.setPlayerLocation(p_doTeleport_1_.getResult(), p_doTeleport_2_.getResult(), p_doTeleport_3_.getResult(), lvt_7_1_, lvt_8_1_, lvt_6_1_);
            p_doTeleport_0_.setRotationYawHead(lvt_7_1_);
        } else {
            float lvt_6_2_ = (float)MathHelper.wrapDegrees(p_doTeleport_4_.getResult());
            float lvt_7_2_ = (float)MathHelper.wrapDegrees(p_doTeleport_5_.getResult());
            lvt_7_2_ = MathHelper.clamp(lvt_7_2_, -90.0f, 90.0f);
            p_doTeleport_0_.setLocationAndAngles(p_doTeleport_1_.getResult(), p_doTeleport_2_.getResult(), p_doTeleport_3_.getResult(), lvt_6_2_, lvt_7_2_);
            p_doTeleport_0_.setRotationYawHead(lvt_6_2_);
        }
        if (!(p_doTeleport_0_ instanceof EntityLivingBase) || !((EntityLivingBase)p_doTeleport_0_).isElytraFlying()) {
            p_doTeleport_0_.motionY = 0.0;
            p_doTeleport_0_.onGround = true;
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandTeleport.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getOnlinePlayerNames());
        }
        if (p_getTabCompletions_3_.length > 1 && p_getTabCompletions_3_.length <= 4) {
            return CommandTeleport.getTabCompletionCoordinate(p_getTabCompletions_3_, 1, p_getTabCompletions_4_);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(String[] p_isUsernameIndex_1_, int p_isUsernameIndex_2_) {
        return p_isUsernameIndex_2_ == 0;
    }
}

