/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.server;

import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CommandTestForBlock
extends CommandBase {
    @Override
    public String getName() {
        return "testforblock";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.testforblock.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        IBlockState lvt_9_2_;
        Block lvt_10_2_;
        if (p_execute_3_.length < 4) {
            throw new WrongUsageException("commands.testforblock.usage", new Object[0]);
        }
        p_execute_2_.setCommandStat(CommandResultStats.Type.AFFECTED_BLOCKS, 0);
        BlockPos lvt_4_1_ = CommandTestForBlock.parseBlockPos(p_execute_2_, p_execute_3_, 0, false);
        Block lvt_5_1_ = CommandTestForBlock.getBlockByText(p_execute_2_, p_execute_3_[3]);
        if (lvt_5_1_ == null) {
            throw new NumberInvalidException("commands.setblock.notFound", p_execute_3_[3]);
        }
        World lvt_6_1_ = p_execute_2_.getEntityWorld();
        if (!lvt_6_1_.isBlockLoaded(lvt_4_1_)) {
            throw new CommandException("commands.testforblock.outOfWorld", new Object[0]);
        }
        NBTTagCompound lvt_7_1_ = new NBTTagCompound();
        boolean lvt_8_1_ = false;
        if (p_execute_3_.length >= 6 && lvt_5_1_.hasTileEntity()) {
            String lvt_9_1_ = CommandTestForBlock.getChatComponentFromNthArg(p_execute_2_, p_execute_3_, 5).getUnformattedText();
            try {
                lvt_7_1_ = JsonToNBT.getTagFromJson(lvt_9_1_);
                lvt_8_1_ = true;
            }
            catch (NBTException lvt_10_1_) {
                throw new CommandException("commands.setblock.tagError", lvt_10_1_.getMessage());
            }
        }
        if ((lvt_10_2_ = (lvt_9_2_ = lvt_6_1_.getBlockState(lvt_4_1_)).getBlock()) != lvt_5_1_) {
            throw new CommandException("commands.testforblock.failed.tile", lvt_4_1_.getX(), lvt_4_1_.getY(), lvt_4_1_.getZ(), lvt_10_2_.getLocalizedName(), lvt_5_1_.getLocalizedName());
        }
        if (p_execute_3_.length >= 5 && !CommandBase.convertArgToBlockStatePredicate(lvt_5_1_, p_execute_3_[4]).apply((Object)lvt_9_2_)) {
            try {
                int lvt_11_1_ = lvt_9_2_.getBlock().getMetaFromState(lvt_9_2_);
                throw new CommandException("commands.testforblock.failed.data", lvt_4_1_.getX(), lvt_4_1_.getY(), lvt_4_1_.getZ(), lvt_11_1_, Integer.parseInt(p_execute_3_[4]));
            }
            catch (NumberFormatException lvt_11_2_) {
                throw new CommandException("commands.testforblock.failed.data", lvt_4_1_.getX(), lvt_4_1_.getY(), lvt_4_1_.getZ(), lvt_9_2_.toString(), p_execute_3_[4]);
            }
        }
        if (lvt_8_1_) {
            TileEntity lvt_11_3_ = lvt_6_1_.getTileEntity(lvt_4_1_);
            if (lvt_11_3_ == null) {
                throw new CommandException("commands.testforblock.failed.tileEntity", lvt_4_1_.getX(), lvt_4_1_.getY(), lvt_4_1_.getZ());
            }
            NBTTagCompound lvt_12_1_ = lvt_11_3_.writeToNBT(new NBTTagCompound());
            if (!NBTUtil.areNBTEquals(lvt_7_1_, lvt_12_1_, true)) {
                throw new CommandException("commands.testforblock.failed.nbt", lvt_4_1_.getX(), lvt_4_1_.getY(), lvt_4_1_.getZ());
            }
        }
        p_execute_2_.setCommandStat(CommandResultStats.Type.AFFECTED_BLOCKS, 1);
        CommandTestForBlock.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.testforblock.success", lvt_4_1_.getX(), lvt_4_1_.getY(), lvt_4_1_.getZ());
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length > 0 && p_getTabCompletions_3_.length <= 3) {
            return CommandTestForBlock.getTabCompletionCoordinate(p_getTabCompletions_3_, 0, p_getTabCompletions_4_);
        }
        if (p_getTabCompletions_3_.length == 4) {
            return CommandTestForBlock.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, Block.REGISTRY.getKeys());
        }
        return Collections.emptyList();
    }
}

