/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.server;

import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandWhitelist
extends CommandBase {
    @Override
    public String getName() {
        return "whitelist";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 3;
    }

    @Override
    public String getUsage(ICommandSender p_getUsage_1_) {
        return "commands.whitelist.usage";
    }

    @Override
    public void execute(MinecraftServer p_execute_1_, ICommandSender p_execute_2_, String[] p_execute_3_) throws CommandException {
        if (p_execute_3_.length < 1) {
            throw new WrongUsageException("commands.whitelist.usage", new Object[0]);
        }
        if ("on".equals(p_execute_3_[0])) {
            p_execute_1_.getPlayerList().setWhiteListEnabled(true);
            CommandWhitelist.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.whitelist.enabled", new Object[0]);
        } else if ("off".equals(p_execute_3_[0])) {
            p_execute_1_.getPlayerList().setWhiteListEnabled(false);
            CommandWhitelist.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.whitelist.disabled", new Object[0]);
        } else if ("list".equals(p_execute_3_[0])) {
            p_execute_2_.sendMessage(new TextComponentTranslation("commands.whitelist.list", p_execute_1_.getPlayerList().getWhitelistedPlayerNames().length, p_execute_1_.getPlayerList().getAvailablePlayerDat().length));
            Object[] lvt_4_1_ = p_execute_1_.getPlayerList().getWhitelistedPlayerNames();
            p_execute_2_.sendMessage(new TextComponentString(CommandWhitelist.joinNiceString(lvt_4_1_)));
        } else if ("add".equals(p_execute_3_[0])) {
            if (p_execute_3_.length < 2) {
                throw new WrongUsageException("commands.whitelist.add.usage", new Object[0]);
            }
            GameProfile lvt_4_2_ = p_execute_1_.getPlayerProfileCache().getGameProfileForUsername(p_execute_3_[1]);
            if (lvt_4_2_ == null) {
                throw new CommandException("commands.whitelist.add.failed", p_execute_3_[1]);
            }
            p_execute_1_.getPlayerList().addWhitelistedPlayer(lvt_4_2_);
            CommandWhitelist.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.whitelist.add.success", p_execute_3_[1]);
        } else if ("remove".equals(p_execute_3_[0])) {
            if (p_execute_3_.length < 2) {
                throw new WrongUsageException("commands.whitelist.remove.usage", new Object[0]);
            }
            GameProfile lvt_4_3_ = p_execute_1_.getPlayerList().getWhitelistedPlayers().getByName(p_execute_3_[1]);
            if (lvt_4_3_ == null) {
                throw new CommandException("commands.whitelist.remove.failed", p_execute_3_[1]);
            }
            p_execute_1_.getPlayerList().removePlayerFromWhitelist(lvt_4_3_);
            CommandWhitelist.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.whitelist.remove.success", p_execute_3_[1]);
        } else if ("reload".equals(p_execute_3_[0])) {
            p_execute_1_.getPlayerList().reloadWhitelist();
            CommandWhitelist.notifyCommandListener(p_execute_2_, (ICommand)this, "commands.whitelist.reloaded", new Object[0]);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer p_getTabCompletions_1_, ICommandSender p_getTabCompletions_2_, String[] p_getTabCompletions_3_, BlockPos p_getTabCompletions_4_) {
        if (p_getTabCompletions_3_.length == 1) {
            return CommandWhitelist.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, "on", "off", "list", "add", "remove", "reload");
        }
        if (p_getTabCompletions_3_.length == 2) {
            if ("remove".equals(p_getTabCompletions_3_[0])) {
                return CommandWhitelist.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getPlayerList().getWhitelistedPlayerNames());
            }
            if ("add".equals(p_getTabCompletions_3_[0])) {
                return CommandWhitelist.getListOfStringsMatchingLastWord(p_getTabCompletions_3_, p_getTabCompletions_1_.getPlayerProfileCache().getUsernames());
            }
        }
        return Collections.emptyList();
    }
}

