/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.crash;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CrashReportCategory {
    private final CrashReport crashReport;
    private final String name;
    private final List<Entry> children = Lists.newArrayList();
    private StackTraceElement[] stackTrace = new StackTraceElement[0];

    public CrashReportCategory(CrashReport p_i1353_1_, String p_i1353_2_) {
        this.crashReport = p_i1353_1_;
        this.name = p_i1353_2_;
    }

    @SideOnly(value=Side.CLIENT)
    public static String getCoordinateInfo(double p_getCoordinateInfo_0_, double p_getCoordinateInfo_2_, double p_getCoordinateInfo_4_) {
        return String.format("%.2f,%.2f,%.2f - %s", p_getCoordinateInfo_0_, p_getCoordinateInfo_2_, p_getCoordinateInfo_4_, CrashReportCategory.getCoordinateInfo(new BlockPos(p_getCoordinateInfo_0_, p_getCoordinateInfo_2_, p_getCoordinateInfo_4_)));
    }

    public static String getCoordinateInfo(BlockPos p_getCoordinateInfo_0_) {
        return CrashReportCategory.getCoordinateInfo(p_getCoordinateInfo_0_.getX(), p_getCoordinateInfo_0_.getY(), p_getCoordinateInfo_0_.getZ());
    }

    public static String getCoordinateInfo(int p_getCoordinateInfo_0_, int p_getCoordinateInfo_1_, int p_getCoordinateInfo_2_) {
        StringBuilder stringbuilder = new StringBuilder();
        try {
            stringbuilder.append(String.format("World: (%d,%d,%d)", p_getCoordinateInfo_0_, p_getCoordinateInfo_1_, p_getCoordinateInfo_2_));
        }
        catch (Throwable var16) {
            stringbuilder.append("(Error finding world loc)");
        }
        stringbuilder.append(", ");
        try {
            int i = p_getCoordinateInfo_0_ >> 4;
            int j = p_getCoordinateInfo_2_ >> 4;
            int k = p_getCoordinateInfo_0_ & 0xF;
            int l = p_getCoordinateInfo_1_ >> 4;
            int i1 = p_getCoordinateInfo_2_ & 0xF;
            int j1 = i << 4;
            int k1 = j << 4;
            int l1 = (i + 1 << 4) - 1;
            int i2 = (j + 1 << 4) - 1;
            stringbuilder.append(String.format("Chunk: (at %d,%d,%d in %d,%d; contains blocks %d,0,%d to %d,255,%d)", k, l, i1, i, j, j1, k1, l1, i2));
        }
        catch (Throwable var15) {
            stringbuilder.append("(Error finding chunk loc)");
        }
        stringbuilder.append(", ");
        try {
            int k2 = p_getCoordinateInfo_0_ >> 9;
            int l2 = p_getCoordinateInfo_2_ >> 9;
            int i3 = k2 << 5;
            int j3 = l2 << 5;
            int k3 = (k2 + 1 << 5) - 1;
            int l3 = (l2 + 1 << 5) - 1;
            int i4 = k2 << 9;
            int j4 = l2 << 9;
            int k4 = (k2 + 1 << 9) - 1;
            int j2 = (l2 + 1 << 9) - 1;
            stringbuilder.append(String.format("Region: (%d,%d; contains chunks %d,%d to %d,%d, blocks %d,0,%d to %d,255,%d)", k2, l2, i3, j3, k3, l3, i4, j4, k4, j2));
        }
        catch (Throwable var14) {
            stringbuilder.append("(Error finding world loc)");
        }
        return stringbuilder.toString();
    }

    public void setDetail(String p_setDetail_1_, ICrashReportDetail<String> p_setDetail_2_) {
        try {
            this.addCrashSection(p_setDetail_1_, p_setDetail_2_.call());
        }
        catch (Throwable throwable) {
            this.addCrashSectionThrowable(p_setDetail_1_, throwable);
        }
    }

    public void addCrashSection(String p_addCrashSection_1_, Object p_addCrashSection_2_) {
        this.children.add(new Entry(p_addCrashSection_1_, p_addCrashSection_2_));
    }

    public void addCrashSectionThrowable(String p_addCrashSectionThrowable_1_, Throwable p_addCrashSectionThrowable_2_) {
        this.addCrashSection(p_addCrashSectionThrowable_1_, p_addCrashSectionThrowable_2_);
    }

    public int getPrunedStackTrace(int p_getPrunedStackTrace_1_) {
        StackTraceElement[] astacktraceelement = Thread.currentThread().getStackTrace();
        if (astacktraceelement.length <= 0) {
            return 0;
        }
        int len = astacktraceelement.length - 3 - p_getPrunedStackTrace_1_;
        if (len <= 0) {
            len = astacktraceelement.length;
        }
        this.stackTrace = new StackTraceElement[len];
        System.arraycopy(astacktraceelement, astacktraceelement.length - len, this.stackTrace, 0, this.stackTrace.length);
        return this.stackTrace.length;
    }

    public boolean firstTwoElementsOfStackTraceMatch(StackTraceElement p_firstTwoElementsOfStackTraceMatch_1_, StackTraceElement p_firstTwoElementsOfStackTraceMatch_2_) {
        if (this.stackTrace.length != 0 && p_firstTwoElementsOfStackTraceMatch_1_ != null) {
            StackTraceElement stacktraceelement = this.stackTrace[0];
            if (stacktraceelement.isNativeMethod() == p_firstTwoElementsOfStackTraceMatch_1_.isNativeMethod() && stacktraceelement.getClassName().equals(p_firstTwoElementsOfStackTraceMatch_1_.getClassName()) && stacktraceelement.getFileName().equals(p_firstTwoElementsOfStackTraceMatch_1_.getFileName()) && stacktraceelement.getMethodName().equals(p_firstTwoElementsOfStackTraceMatch_1_.getMethodName())) {
                if (p_firstTwoElementsOfStackTraceMatch_2_ != null != this.stackTrace.length > 1) {
                    return false;
                }
                if (p_firstTwoElementsOfStackTraceMatch_2_ != null && !this.stackTrace[1].equals(p_firstTwoElementsOfStackTraceMatch_2_)) {
                    return false;
                }
                this.stackTrace[0] = p_firstTwoElementsOfStackTraceMatch_1_;
                return true;
            }
            return false;
        }
        return false;
    }

    public void trimStackTraceEntriesFromBottom(int p_trimStackTraceEntriesFromBottom_1_) {
        StackTraceElement[] astacktraceelement = new StackTraceElement[this.stackTrace.length - p_trimStackTraceEntriesFromBottom_1_];
        System.arraycopy(this.stackTrace, 0, astacktraceelement, 0, astacktraceelement.length);
        this.stackTrace = astacktraceelement;
    }

    public void appendToStringBuilder(StringBuilder p_appendToStringBuilder_1_) {
        p_appendToStringBuilder_1_.append("-- ").append(this.name).append(" --\n");
        p_appendToStringBuilder_1_.append("Details:");
        for (Entry crashreportcategory$entry : this.children) {
            p_appendToStringBuilder_1_.append("\n\t");
            p_appendToStringBuilder_1_.append(crashreportcategory$entry.getKey());
            p_appendToStringBuilder_1_.append(": ");
            p_appendToStringBuilder_1_.append(crashreportcategory$entry.getValue());
        }
        if (this.stackTrace != null && this.stackTrace.length > 0) {
            p_appendToStringBuilder_1_.append("\nStacktrace:");
            for (StackTraceElement stacktraceelement : this.stackTrace) {
                p_appendToStringBuilder_1_.append("\n\tat ");
                p_appendToStringBuilder_1_.append(stacktraceelement);
            }
        }
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public static void addBlockInfo(CrashReportCategory p_addBlockInfo_0_, final BlockPos p_addBlockInfo_1_, final Block p_addBlockInfo_2_, final int p_addBlockInfo_3_) {
        final int i = Block.getIdFromBlock(p_addBlockInfo_2_);
        p_addBlockInfo_0_.setDetail("Block type", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                try {
                    return String.format("ID #%d (%s // %s)", i, p_addBlockInfo_2_.getUnlocalizedName(), p_addBlockInfo_2_.getClass().getCanonicalName());
                }
                catch (Throwable var2) {
                    return "ID #" + i;
                }
            }
        });
        p_addBlockInfo_0_.setDetail("Block data value", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                if (p_addBlockInfo_3_ < 0) {
                    return "Unknown? (Got " + p_addBlockInfo_3_ + ")";
                }
                String s = String.format("%4s", Integer.toBinaryString(p_addBlockInfo_3_)).replace(" ", "0");
                return String.format("%1$d / 0x%1$X / 0b%2$s", p_addBlockInfo_3_, s);
            }
        });
        p_addBlockInfo_0_.setDetail("Block location", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                return CrashReportCategory.getCoordinateInfo(p_addBlockInfo_1_);
            }
        });
    }

    public static void addBlockInfo(CrashReportCategory p_addBlockInfo_0_, final BlockPos p_addBlockInfo_1_, final IBlockState p_addBlockInfo_2_) {
        p_addBlockInfo_0_.setDetail("Block", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                return p_addBlockInfo_2_.toString();
            }
        });
        p_addBlockInfo_0_.setDetail("Block location", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                return CrashReportCategory.getCoordinateInfo(p_addBlockInfo_1_);
            }
        });
    }

    static class Entry {
        private final String key;
        private final String value;

        public Entry(String p_i1352_1_, Object p_i1352_2_) {
            this.key = p_i1352_1_;
            if (p_i1352_2_ == null) {
                this.value = "~~NULL~~";
            } else if (p_i1352_2_ instanceof Throwable) {
                Throwable throwable = (Throwable)p_i1352_2_;
                this.value = "~~ERROR~~ " + throwable.getClass().getSimpleName() + ": " + throwable.getMessage();
            } else {
                this.value = p_i1352_2_.toString();
            }
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

