/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.creativetab;

import java.util.List;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class CreativeTabs {
    public static CreativeTabs[] CREATIVE_TAB_ARRAY = new CreativeTabs[12];
    public static final CreativeTabs BUILDING_BLOCKS = new CreativeTabs(0, "buildingBlocks"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack getTabIconItem() {
            return new ItemStack(Item.getItemFromBlock(Blocks.BRICK_BLOCK));
        }
    };
    public static final CreativeTabs DECORATIONS = new CreativeTabs(1, "decorations"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack getTabIconItem() {
            return new ItemStack(Item.getItemFromBlock(Blocks.DOUBLE_PLANT), 1, BlockDoublePlant.EnumPlantType.PAEONIA.getMeta());
        }
    };
    public static final CreativeTabs REDSTONE = new CreativeTabs(2, "redstone"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack getTabIconItem() {
            return new ItemStack(Items.REDSTONE);
        }
    };
    public static final CreativeTabs TRANSPORTATION = new CreativeTabs(3, "transportation"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack getTabIconItem() {
            return new ItemStack(Item.getItemFromBlock(Blocks.GOLDEN_RAIL));
        }
    };
    public static final CreativeTabs MISC = new CreativeTabs(4, "misc"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack getTabIconItem() {
            return new ItemStack(Items.LAVA_BUCKET);
        }
    };
    public static final CreativeTabs SEARCH = new CreativeTabs(5, "search"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack getTabIconItem() {
            return new ItemStack(Items.COMPASS);
        }
    }.setBackgroundImageName("item_search.png");
    public static final CreativeTabs FOOD = new CreativeTabs(6, "food"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack getTabIconItem() {
            return new ItemStack(Items.APPLE);
        }
    };
    public static final CreativeTabs TOOLS = new CreativeTabs(7, "tools"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack getTabIconItem() {
            return new ItemStack(Items.IRON_AXE);
        }
    }.setRelevantEnchantmentTypes(EnumEnchantmentType.ALL, EnumEnchantmentType.DIGGER, EnumEnchantmentType.FISHING_ROD, EnumEnchantmentType.BREAKABLE);
    public static final CreativeTabs COMBAT = new CreativeTabs(8, "combat"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack getTabIconItem() {
            return new ItemStack(Items.GOLDEN_SWORD);
        }
    }.setRelevantEnchantmentTypes(EnumEnchantmentType.ALL, EnumEnchantmentType.ARMOR, EnumEnchantmentType.ARMOR_FEET, EnumEnchantmentType.ARMOR_HEAD, EnumEnchantmentType.ARMOR_LEGS, EnumEnchantmentType.ARMOR_CHEST, EnumEnchantmentType.BOW, EnumEnchantmentType.WEAPON, EnumEnchantmentType.WEARABLE, EnumEnchantmentType.BREAKABLE);
    public static final CreativeTabs BREWING = new CreativeTabs(9, "brewing"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack getTabIconItem() {
            return PotionUtils.addPotionToItemStack(new ItemStack(Items.POTIONITEM), PotionTypes.WATER);
        }
    };
    public static final CreativeTabs MATERIALS = new CreativeTabs(10, "materials"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack getTabIconItem() {
            return new ItemStack(Items.STICK);
        }
    };
    public static final CreativeTabs INVENTORY = new CreativeTabs(11, "inventory"){

        @Override
        @SideOnly(value=Side.CLIENT)
        public ItemStack getTabIconItem() {
            return new ItemStack(Item.getItemFromBlock(Blocks.CHEST));
        }
    }.setBackgroundImageName("inventory.png").setNoScrollbar().setNoTitle();
    private final int tabIndex;
    private final String tabLabel;
    private String theTexture = "items.png";
    private boolean hasScrollbar = true;
    private boolean drawTitle = true;
    private EnumEnchantmentType[] enchantmentTypes;
    private ItemStack iconItemStack;

    public CreativeTabs(String p_i5_1_) {
        this(CreativeTabs.getNextID(), p_i5_1_);
    }

    public CreativeTabs(int p_i1853_1_, String p_i1853_2_) {
        if (p_i1853_1_ >= CREATIVE_TAB_ARRAY.length) {
            CreativeTabs[] tmp = new CreativeTabs[p_i1853_1_ + 1];
            for (int x = 0; x < CREATIVE_TAB_ARRAY.length; ++x) {
                tmp[x] = CREATIVE_TAB_ARRAY[x];
            }
            CREATIVE_TAB_ARRAY = tmp;
        }
        this.tabIndex = p_i1853_1_;
        this.tabLabel = p_i1853_2_;
        this.iconItemStack = ItemStack.EMPTY;
        CreativeTabs.CREATIVE_TAB_ARRAY[p_i1853_1_] = this;
    }

    @SideOnly(value=Side.CLIENT)
    public int getTabIndex() {
        return this.tabIndex;
    }

    public CreativeTabs setBackgroundImageName(String p_setBackgroundImageName_1_) {
        this.theTexture = p_setBackgroundImageName_1_;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public String getTabLabel() {
        return this.tabLabel;
    }

    @SideOnly(value=Side.CLIENT)
    public String getTranslatedTabLabel() {
        return "itemGroup." + this.getTabLabel();
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getIconItemStack() {
        if (this.iconItemStack.isEmpty()) {
            this.iconItemStack = this.getTabIconItem();
        }
        return this.iconItemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract ItemStack getTabIconItem();

    @SideOnly(value=Side.CLIENT)
    public String getBackgroundImageName() {
        return this.theTexture;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean drawInForegroundOfTab() {
        return this.drawTitle;
    }

    public CreativeTabs setNoTitle() {
        this.drawTitle = false;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldHidePlayerInventory() {
        return this.hasScrollbar;
    }

    public CreativeTabs setNoScrollbar() {
        this.hasScrollbar = false;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public int getTabColumn() {
        if (this.tabIndex > 11) {
            return (this.tabIndex - 12) % 10 % 5;
        }
        return this.tabIndex % 6;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isTabInFirstRow() {
        if (this.tabIndex > 11) {
            return (this.tabIndex - 12) % 10 < 5;
        }
        return this.tabIndex < 6;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumEnchantmentType[] getRelevantEnchantmentTypes() {
        return this.enchantmentTypes;
    }

    public CreativeTabs setRelevantEnchantmentTypes(EnumEnchantmentType ... p_setRelevantEnchantmentTypes_1_) {
        this.enchantmentTypes = p_setRelevantEnchantmentTypes_1_;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasRelevantEnchantmentType(EnumEnchantmentType p_hasRelevantEnchantmentType_1_) {
        if (this.enchantmentTypes == null) {
            return false;
        }
        for (EnumEnchantmentType enumenchantmenttype : this.enchantmentTypes) {
            if (enumenchantmenttype != p_hasRelevantEnchantmentType_1_) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void displayAllRelevantItems(NonNullList<ItemStack> p_displayAllRelevantItems_1_) {
        for (Item item : Item.REGISTRY) {
            if (item == null) continue;
            for (CreativeTabs tab : item.getCreativeTabs()) {
                if (tab != this) continue;
                item.getSubItems(item, this, p_displayAllRelevantItems_1_);
            }
        }
        if (this.getRelevantEnchantmentTypes() != null) {
            this.addEnchantmentBooksToList(p_displayAllRelevantItems_1_, this.getRelevantEnchantmentTypes());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addEnchantmentBooksToList(List<ItemStack> p_addEnchantmentBooksToList_1_, EnumEnchantmentType ... p_addEnchantmentBooksToList_2_) {
        for (Enchantment enchantment : Enchantment.REGISTRY) {
            if (enchantment == null || enchantment.type == null) continue;
            boolean flag = false;
            for (int i = 0; i < p_addEnchantmentBooksToList_2_.length && !flag; ++i) {
                if (enchantment.type != p_addEnchantmentBooksToList_2_[i]) continue;
                flag = true;
            }
            if (!flag) continue;
            p_addEnchantmentBooksToList_1_.add(Items.ENCHANTED_BOOK.getEnchantedItemStack(new EnchantmentData(enchantment, enchantment.getMaxLevel())));
        }
    }

    public int getTabPage() {
        if (this.tabIndex > 11) {
            return (this.tabIndex - 12) / 10 + 1;
        }
        return 0;
    }

    public static int getNextID() {
        return CREATIVE_TAB_ARRAY.length;
    }

    public boolean hasSearchBar() {
        return this.tabIndex == CreativeTabs.SEARCH.tabIndex;
    }

    public int getSearchbarWidth() {
        return 89;
    }
}

