/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.dispenser;

import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class BehaviorDefaultDispenseItem
implements IBehaviorDispenseItem {
    @Override
    public final ItemStack dispense(IBlockSource p_dispense_1_, ItemStack p_dispense_2_) {
        ItemStack lvt_3_1_ = this.dispenseStack(p_dispense_1_, p_dispense_2_);
        this.playDispenseSound(p_dispense_1_);
        this.spawnDispenseParticles(p_dispense_1_, p_dispense_1_.getBlockState().getValue(BlockDispenser.FACING));
        return lvt_3_1_;
    }

    protected ItemStack dispenseStack(IBlockSource p_dispenseStack_1_, ItemStack p_dispenseStack_2_) {
        EnumFacing lvt_3_1_ = p_dispenseStack_1_.getBlockState().getValue(BlockDispenser.FACING);
        IPosition lvt_4_1_ = BlockDispenser.getDispensePosition(p_dispenseStack_1_);
        ItemStack lvt_5_1_ = p_dispenseStack_2_.splitStack(1);
        BehaviorDefaultDispenseItem.doDispense(p_dispenseStack_1_.getWorld(), lvt_5_1_, 6, lvt_3_1_, lvt_4_1_);
        return p_dispenseStack_2_;
    }

    public static void doDispense(World p_doDispense_0_, ItemStack p_doDispense_1_, int p_doDispense_2_, EnumFacing p_doDispense_3_, IPosition p_doDispense_4_) {
        double lvt_5_1_ = p_doDispense_4_.getX();
        double lvt_7_1_ = p_doDispense_4_.getY();
        double lvt_9_1_ = p_doDispense_4_.getZ();
        lvt_7_1_ = p_doDispense_3_.getAxis() == EnumFacing.Axis.Y ? (lvt_7_1_ -= 0.125) : (lvt_7_1_ -= 0.15625);
        EntityItem lvt_11_1_ = new EntityItem(p_doDispense_0_, lvt_5_1_, lvt_7_1_, lvt_9_1_, p_doDispense_1_);
        double lvt_12_1_ = p_doDispense_0_.rand.nextDouble() * 0.1 + 0.2;
        lvt_11_1_.motionX = (double)p_doDispense_3_.getFrontOffsetX() * lvt_12_1_;
        lvt_11_1_.motionY = 0.2f;
        lvt_11_1_.motionZ = (double)p_doDispense_3_.getFrontOffsetZ() * lvt_12_1_;
        lvt_11_1_.motionX += p_doDispense_0_.rand.nextGaussian() * (double)0.0075f * (double)p_doDispense_2_;
        lvt_11_1_.motionY += p_doDispense_0_.rand.nextGaussian() * (double)0.0075f * (double)p_doDispense_2_;
        lvt_11_1_.motionZ += p_doDispense_0_.rand.nextGaussian() * (double)0.0075f * (double)p_doDispense_2_;
        p_doDispense_0_.spawnEntity(lvt_11_1_);
    }

    protected void playDispenseSound(IBlockSource p_playDispenseSound_1_) {
        p_playDispenseSound_1_.getWorld().playEvent(1000, p_playDispenseSound_1_.getBlockPos(), 0);
    }

    protected void spawnDispenseParticles(IBlockSource p_spawnDispenseParticles_1_, EnumFacing p_spawnDispenseParticles_2_) {
        p_spawnDispenseParticles_1_.getWorld().playEvent(2000, p_spawnDispenseParticles_1_.getBlockPos(), this.getWorldEventDataFrom(p_spawnDispenseParticles_2_));
    }

    private int getWorldEventDataFrom(EnumFacing p_getWorldEventDataFrom_1_) {
        return p_getWorldEventDataFrom_1_.getFrontOffsetX() + 1 + (p_getWorldEventDataFrom_1_.getFrontOffsetZ() + 1) * 3;
    }
}

