/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.enchantment;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentArrowDamage;
import net.minecraft.enchantment.EnchantmentArrowFire;
import net.minecraft.enchantment.EnchantmentArrowInfinite;
import net.minecraft.enchantment.EnchantmentArrowKnockback;
import net.minecraft.enchantment.EnchantmentBindingCurse;
import net.minecraft.enchantment.EnchantmentDamage;
import net.minecraft.enchantment.EnchantmentDigging;
import net.minecraft.enchantment.EnchantmentDurability;
import net.minecraft.enchantment.EnchantmentFireAspect;
import net.minecraft.enchantment.EnchantmentFishingSpeed;
import net.minecraft.enchantment.EnchantmentFrostWalker;
import net.minecraft.enchantment.EnchantmentKnockback;
import net.minecraft.enchantment.EnchantmentLootBonus;
import net.minecraft.enchantment.EnchantmentMending;
import net.minecraft.enchantment.EnchantmentOxygen;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.enchantment.EnchantmentSweepingEdge;
import net.minecraft.enchantment.EnchantmentThorns;
import net.minecraft.enchantment.EnchantmentUntouching;
import net.minecraft.enchantment.EnchantmentVanishingCurse;
import net.minecraft.enchantment.EnchantmentWaterWalker;
import net.minecraft.enchantment.EnchantmentWaterWorker;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public abstract class Enchantment
extends IForgeRegistryEntry.Impl<Enchantment> {
    public static final RegistryNamespaced<ResourceLocation, Enchantment> REGISTRY = GameData.getEnchantmentRegistry();
    private final EntityEquipmentSlot[] applicableEquipmentTypes;
    private final Rarity rarity;
    public EnumEnchantmentType type;
    protected String name;

    @Nullable
    public static Enchantment getEnchantmentByID(int p_getEnchantmentByID_0_) {
        return REGISTRY.getObjectById(p_getEnchantmentByID_0_);
    }

    public static int getEnchantmentID(Enchantment p_getEnchantmentID_0_) {
        return REGISTRY.getIDForObject(p_getEnchantmentID_0_);
    }

    @Nullable
    public static Enchantment getEnchantmentByLocation(String p_getEnchantmentByLocation_0_) {
        return REGISTRY.getObject(new ResourceLocation(p_getEnchantmentByLocation_0_));
    }

    protected Enchantment(Rarity p_i46731_1_, EnumEnchantmentType p_i46731_2_, EntityEquipmentSlot[] p_i46731_3_) {
        this.rarity = p_i46731_1_;
        this.type = p_i46731_2_;
        this.applicableEquipmentTypes = p_i46731_3_;
    }

    public List<ItemStack> getEntityEquipment(EntityLivingBase p_getEntityEquipment_1_) {
        ArrayList list = Lists.newArrayList();
        for (EntityEquipmentSlot entityequipmentslot : this.applicableEquipmentTypes) {
            ItemStack itemstack = p_getEntityEquipment_1_.getItemStackFromSlot(entityequipmentslot);
            if (itemstack.isEmpty()) continue;
            list.add(itemstack);
        }
        return list;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public int getMinLevel() {
        return 1;
    }

    public int getMaxLevel() {
        return 1;
    }

    public int getMinEnchantability(int p_getMinEnchantability_1_) {
        return 1 + p_getMinEnchantability_1_ * 10;
    }

    public int getMaxEnchantability(int p_getMaxEnchantability_1_) {
        return this.getMinEnchantability(p_getMaxEnchantability_1_) + 5;
    }

    public int calcModifierDamage(int p_calcModifierDamage_1_, DamageSource p_calcModifierDamage_2_) {
        return 0;
    }

    public float calcDamageByCreature(int p_calcDamageByCreature_1_, EnumCreatureAttribute p_calcDamageByCreature_2_) {
        return 0.0f;
    }

    public final boolean func_191560_c(Enchantment p_191560_1_) {
        return this.canApplyTogether(p_191560_1_) && p_191560_1_.canApplyTogether(this);
    }

    protected boolean canApplyTogether(Enchantment p_canApplyTogether_1_) {
        return this != p_canApplyTogether_1_;
    }

    public Enchantment setName(String p_setName_1_) {
        this.name = p_setName_1_;
        return this;
    }

    public String getName() {
        return "enchantment." + this.name;
    }

    public String getTranslatedName(int p_getTranslatedName_1_) {
        String s = I18n.translateToLocal(this.getName());
        if (this.isCurse()) {
            s = (Object)((Object)TextFormatting.RED) + s;
        }
        return p_getTranslatedName_1_ == 1 && this.getMaxLevel() == 1 ? s : s + " " + I18n.translateToLocal("enchantment.level." + p_getTranslatedName_1_);
    }

    public boolean canApply(ItemStack p_canApply_1_) {
        return this.canApplyAtEnchantingTable(p_canApply_1_);
    }

    public void onEntityDamaged(EntityLivingBase p_onEntityDamaged_1_, Entity p_onEntityDamaged_2_, int p_onEntityDamaged_3_) {
    }

    public void onUserHurt(EntityLivingBase p_onUserHurt_1_, Entity p_onUserHurt_2_, int p_onUserHurt_3_) {
    }

    public boolean isTreasureEnchantment() {
        return false;
    }

    public boolean isCurse() {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack p_canApplyAtEnchantingTable_1_) {
        return p_canApplyAtEnchantingTable_1_.getItem().canApplyAtEnchantingTable(p_canApplyAtEnchantingTable_1_, this);
    }

    public boolean isAllowedOnBooks() {
        return true;
    }

    public static void registerEnchantments() {
        EntityEquipmentSlot[] aentityequipmentslot = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
        REGISTRY.register(0, new ResourceLocation("protection"), new EnchantmentProtection(Rarity.COMMON, EnchantmentProtection.Type.ALL, aentityequipmentslot));
        REGISTRY.register(1, new ResourceLocation("fire_protection"), new EnchantmentProtection(Rarity.UNCOMMON, EnchantmentProtection.Type.FIRE, aentityequipmentslot));
        REGISTRY.register(2, new ResourceLocation("feather_falling"), new EnchantmentProtection(Rarity.UNCOMMON, EnchantmentProtection.Type.FALL, aentityequipmentslot));
        REGISTRY.register(3, new ResourceLocation("blast_protection"), new EnchantmentProtection(Rarity.RARE, EnchantmentProtection.Type.EXPLOSION, aentityequipmentslot));
        REGISTRY.register(4, new ResourceLocation("projectile_protection"), new EnchantmentProtection(Rarity.UNCOMMON, EnchantmentProtection.Type.PROJECTILE, aentityequipmentslot));
        REGISTRY.register(5, new ResourceLocation("respiration"), new EnchantmentOxygen(Rarity.RARE, aentityequipmentslot));
        REGISTRY.register(6, new ResourceLocation("aqua_affinity"), new EnchantmentWaterWorker(Rarity.RARE, aentityequipmentslot));
        REGISTRY.register(7, new ResourceLocation("thorns"), new EnchantmentThorns(Rarity.VERY_RARE, aentityequipmentslot));
        REGISTRY.register(8, new ResourceLocation("depth_strider"), new EnchantmentWaterWalker(Rarity.RARE, aentityequipmentslot));
        REGISTRY.register(9, new ResourceLocation("frost_walker"), new EnchantmentFrostWalker(Rarity.RARE, EntityEquipmentSlot.FEET));
        REGISTRY.register(10, new ResourceLocation("binding_curse"), new EnchantmentBindingCurse(Rarity.VERY_RARE, aentityequipmentslot));
        REGISTRY.register(16, new ResourceLocation("sharpness"), new EnchantmentDamage(Rarity.COMMON, 0, EntityEquipmentSlot.MAINHAND));
        REGISTRY.register(17, new ResourceLocation("smite"), new EnchantmentDamage(Rarity.UNCOMMON, 1, EntityEquipmentSlot.MAINHAND));
        REGISTRY.register(18, new ResourceLocation("bane_of_arthropods"), new EnchantmentDamage(Rarity.UNCOMMON, 2, EntityEquipmentSlot.MAINHAND));
        REGISTRY.register(19, new ResourceLocation("knockback"), new EnchantmentKnockback(Rarity.UNCOMMON, EntityEquipmentSlot.MAINHAND));
        REGISTRY.register(20, new ResourceLocation("fire_aspect"), new EnchantmentFireAspect(Rarity.RARE, EntityEquipmentSlot.MAINHAND));
        REGISTRY.register(21, new ResourceLocation("looting"), new EnchantmentLootBonus(Rarity.RARE, EnumEnchantmentType.WEAPON, EntityEquipmentSlot.MAINHAND));
        REGISTRY.register(22, new ResourceLocation("sweeping"), new EnchantmentSweepingEdge(Rarity.RARE, EntityEquipmentSlot.MAINHAND));
        REGISTRY.register(32, new ResourceLocation("efficiency"), new EnchantmentDigging(Rarity.COMMON, EntityEquipmentSlot.MAINHAND));
        REGISTRY.register(33, new ResourceLocation("silk_touch"), new EnchantmentUntouching(Rarity.VERY_RARE, EntityEquipmentSlot.MAINHAND));
        REGISTRY.register(34, new ResourceLocation("unbreaking"), new EnchantmentDurability(Rarity.UNCOMMON, EntityEquipmentSlot.MAINHAND));
        REGISTRY.register(35, new ResourceLocation("fortune"), new EnchantmentLootBonus(Rarity.RARE, EnumEnchantmentType.DIGGER, EntityEquipmentSlot.MAINHAND));
        REGISTRY.register(48, new ResourceLocation("power"), new EnchantmentArrowDamage(Rarity.COMMON, EntityEquipmentSlot.MAINHAND));
        REGISTRY.register(49, new ResourceLocation("punch"), new EnchantmentArrowKnockback(Rarity.RARE, EntityEquipmentSlot.MAINHAND));
        REGISTRY.register(50, new ResourceLocation("flame"), new EnchantmentArrowFire(Rarity.RARE, EntityEquipmentSlot.MAINHAND));
        REGISTRY.register(51, new ResourceLocation("infinity"), new EnchantmentArrowInfinite(Rarity.VERY_RARE, EntityEquipmentSlot.MAINHAND));
        REGISTRY.register(61, new ResourceLocation("luck_of_the_sea"), new EnchantmentLootBonus(Rarity.RARE, EnumEnchantmentType.FISHING_ROD, EntityEquipmentSlot.MAINHAND));
        REGISTRY.register(62, new ResourceLocation("lure"), new EnchantmentFishingSpeed(Rarity.RARE, EnumEnchantmentType.FISHING_ROD, EntityEquipmentSlot.MAINHAND));
        REGISTRY.register(70, new ResourceLocation("mending"), new EnchantmentMending(Rarity.RARE, EntityEquipmentSlot.values()));
        REGISTRY.register(71, new ResourceLocation("vanishing_curse"), new EnchantmentVanishingCurse(Rarity.VERY_RARE, EntityEquipmentSlot.values()));
    }

    public static enum Rarity {
        COMMON(10),
        UNCOMMON(5),
        RARE(2),
        VERY_RARE(1);

        private final int weight;

        private Rarity(int p_i47026_3_) {
            this.weight = p_i47026_3_;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

