/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.enchantment;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;

public class EnchantmentDamage
extends Enchantment {
    private static final String[] PROTECTION_NAME = new String[]{"all", "undead", "arthropods"};
    private static final int[] BASE_ENCHANTABILITY = new int[]{1, 5, 5};
    private static final int[] LEVEL_ENCHANTABILITY = new int[]{11, 8, 8};
    private static final int[] THRESHOLD_ENCHANTABILITY = new int[]{20, 20, 20};
    public final int damageType;

    public EnchantmentDamage(Enchantment.Rarity p_i46734_1_, int p_i46734_2_, EntityEquipmentSlot ... p_i46734_3_) {
        super(p_i46734_1_, EnumEnchantmentType.WEAPON, p_i46734_3_);
        this.damageType = p_i46734_2_;
    }

    @Override
    public int getMinEnchantability(int p_getMinEnchantability_1_) {
        return BASE_ENCHANTABILITY[this.damageType] + (p_getMinEnchantability_1_ - 1) * LEVEL_ENCHANTABILITY[this.damageType];
    }

    @Override
    public int getMaxEnchantability(int p_getMaxEnchantability_1_) {
        return this.getMinEnchantability(p_getMaxEnchantability_1_) + THRESHOLD_ENCHANTABILITY[this.damageType];
    }

    @Override
    public int getMaxLevel() {
        return 5;
    }

    @Override
    public float calcDamageByCreature(int p_calcDamageByCreature_1_, EnumCreatureAttribute p_calcDamageByCreature_2_) {
        if (this.damageType == 0) {
            return 1.0f + (float)Math.max(0, p_calcDamageByCreature_1_ - 1) * 0.5f;
        }
        if (this.damageType == 1 && p_calcDamageByCreature_2_ == EnumCreatureAttribute.UNDEAD) {
            return (float)p_calcDamageByCreature_1_ * 2.5f;
        }
        if (this.damageType == 2 && p_calcDamageByCreature_2_ == EnumCreatureAttribute.ARTHROPOD) {
            return (float)p_calcDamageByCreature_1_ * 2.5f;
        }
        return 0.0f;
    }

    @Override
    public String getName() {
        return "enchantment.damage." + PROTECTION_NAME[this.damageType];
    }

    @Override
    public boolean canApplyTogether(Enchantment p_canApplyTogether_1_) {
        return !(p_canApplyTogether_1_ instanceof EnchantmentDamage);
    }

    @Override
    public boolean canApply(ItemStack p_canApply_1_) {
        if (p_canApply_1_.getItem() instanceof ItemAxe) {
            return true;
        }
        return super.canApply(p_canApply_1_);
    }

    @Override
    public void onEntityDamaged(EntityLivingBase p_onEntityDamaged_1_, Entity p_onEntityDamaged_2_, int p_onEntityDamaged_3_) {
        if (p_onEntityDamaged_2_ instanceof EntityLivingBase) {
            EntityLivingBase lvt_4_1_ = (EntityLivingBase)p_onEntityDamaged_2_;
            if (this.damageType == 2 && lvt_4_1_.getCreatureAttribute() == EnumCreatureAttribute.ARTHROPOD) {
                int lvt_5_1_ = 20 + p_onEntityDamaged_1_.getRNG().nextInt(10 * p_onEntityDamaged_3_);
                lvt_4_1_.addPotionEffect(new PotionEffect(MobEffects.SLOWNESS, lvt_5_1_, 3));
            }
        }
    }
}

