/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.enchantment;

import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EnchantmentFrostWalker
extends Enchantment {
    public EnchantmentFrostWalker(Enchantment.Rarity p_i46728_1_, EntityEquipmentSlot ... p_i46728_2_) {
        super(p_i46728_1_, EnumEnchantmentType.ARMOR_FEET, p_i46728_2_);
        this.setName("frostWalker");
    }

    @Override
    public int getMinEnchantability(int p_getMinEnchantability_1_) {
        return p_getMinEnchantability_1_ * 10;
    }

    @Override
    public int getMaxEnchantability(int p_getMaxEnchantability_1_) {
        return this.getMinEnchantability(p_getMaxEnchantability_1_) + 15;
    }

    @Override
    public boolean isTreasureEnchantment() {
        return true;
    }

    @Override
    public int getMaxLevel() {
        return 2;
    }

    public static void freezeNearby(EntityLivingBase p_freezeNearby_0_, World p_freezeNearby_1_, BlockPos p_freezeNearby_2_, int p_freezeNearby_3_) {
        if (!p_freezeNearby_0_.onGround) {
            return;
        }
        float lvt_4_1_ = Math.min(16, 2 + p_freezeNearby_3_);
        BlockPos.MutableBlockPos lvt_5_1_ = new BlockPos.MutableBlockPos(0, 0, 0);
        for (BlockPos.MutableBlockPos lvt_7_1_ : BlockPos.getAllInBoxMutable(p_freezeNearby_2_.add(-lvt_4_1_, -1.0, -lvt_4_1_), p_freezeNearby_2_.add(lvt_4_1_, -1.0, lvt_4_1_))) {
            IBlockState lvt_9_1_;
            if (!(lvt_7_1_.distanceSqToCenter(p_freezeNearby_0_.posX, p_freezeNearby_0_.posY, p_freezeNearby_0_.posZ) <= (double)(lvt_4_1_ * lvt_4_1_))) continue;
            lvt_5_1_.setPos(lvt_7_1_.getX(), lvt_7_1_.getY() + 1, lvt_7_1_.getZ());
            IBlockState lvt_8_1_ = p_freezeNearby_1_.getBlockState(lvt_5_1_);
            if (lvt_8_1_.getMaterial() != Material.AIR || (lvt_9_1_ = p_freezeNearby_1_.getBlockState(lvt_7_1_)).getMaterial() != Material.WATER || lvt_9_1_.getValue(BlockLiquid.LEVEL) != 0 || !p_freezeNearby_1_.mayPlace(Blocks.FROSTED_ICE, lvt_7_1_, false, EnumFacing.DOWN, null)) continue;
            p_freezeNearby_1_.setBlockState(lvt_7_1_, Blocks.FROSTED_ICE.getDefaultState());
            p_freezeNearby_1_.scheduleUpdate(lvt_7_1_.toImmutable(), Blocks.FROSTED_ICE, MathHelper.getInt(p_freezeNearby_0_.getRNG(), 60, 120));
        }
    }

    @Override
    public boolean canApplyTogether(Enchantment p_canApplyTogether_1_) {
        return super.canApplyTogether(p_canApplyTogether_1_) && p_canApplyTogether_1_ != Enchantments.DEPTH_STRIDER;
    }
}

