/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.enchantment;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentSweepingEdge;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Util;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.MathHelper;

public class EnchantmentHelper {
    private static final Random RANDOM = new Random();
    private static final ModifierDamage ENCHANTMENT_MODIFIER_DAMAGE = new ModifierDamage();
    private static final ModifierLiving ENCHANTMENT_MODIFIER_LIVING = new ModifierLiving();
    private static final HurtIterator ENCHANTMENT_ITERATOR_HURT = new HurtIterator();
    private static final DamageIterator ENCHANTMENT_ITERATOR_DAMAGE = new DamageIterator();

    public static int getEnchantmentLevel(Enchantment p_getEnchantmentLevel_0_, ItemStack p_getEnchantmentLevel_1_) {
        if (p_getEnchantmentLevel_1_.isEmpty()) {
            return 0;
        }
        NBTTagList nbttaglist = p_getEnchantmentLevel_1_.getEnchantmentTagList();
        if (nbttaglist == null) {
            return 0;
        }
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            Enchantment enchantment = Enchantment.getEnchantmentByID(nbttaglist.getCompoundTagAt(i).getShort("id"));
            short j = nbttaglist.getCompoundTagAt(i).getShort("lvl");
            if (enchantment != p_getEnchantmentLevel_0_) continue;
            return j;
        }
        return 0;
    }

    public static Map<Enchantment, Integer> getEnchantments(ItemStack p_getEnchantments_0_) {
        NBTTagList nbttaglist;
        LinkedHashMap map = Maps.newLinkedHashMap();
        NBTTagList nBTTagList = nbttaglist = p_getEnchantments_0_.getItem() == Items.ENCHANTED_BOOK ? Items.ENCHANTED_BOOK.getEnchantments(p_getEnchantments_0_) : p_getEnchantments_0_.getEnchantmentTagList();
        if (nbttaglist != null) {
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                Enchantment enchantment = Enchantment.getEnchantmentByID(nbttaglist.getCompoundTagAt(i).getShort("id"));
                short j = nbttaglist.getCompoundTagAt(i).getShort("lvl");
                map.put(enchantment, Integer.valueOf(j));
            }
        }
        return map;
    }

    public static void setEnchantments(Map<Enchantment, Integer> p_setEnchantments_0_, ItemStack p_setEnchantments_1_) {
        NBTTagList nbttaglist = new NBTTagList();
        for (Map.Entry<Enchantment, Integer> entry : p_setEnchantments_0_.entrySet()) {
            Enchantment enchantment = entry.getKey();
            if (enchantment == null) continue;
            int i = entry.getValue();
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.setShort("id", (short)Enchantment.getEnchantmentID(enchantment));
            nbttagcompound.setShort("lvl", (short)i);
            nbttaglist.appendTag(nbttagcompound);
            if (p_setEnchantments_1_.getItem() != Items.ENCHANTED_BOOK) continue;
            Items.ENCHANTED_BOOK.addEnchantment(p_setEnchantments_1_, new EnchantmentData(enchantment, i));
        }
        if (nbttaglist.hasNoTags()) {
            if (p_setEnchantments_1_.hasTagCompound()) {
                p_setEnchantments_1_.getTagCompound().removeTag("ench");
            }
        } else if (p_setEnchantments_1_.getItem() != Items.ENCHANTED_BOOK) {
            p_setEnchantments_1_.setTagInfo("ench", nbttaglist);
        }
    }

    private static void applyEnchantmentModifier(IModifier p_applyEnchantmentModifier_0_, ItemStack p_applyEnchantmentModifier_1_) {
        NBTTagList nbttaglist;
        if (!p_applyEnchantmentModifier_1_.isEmpty() && (nbttaglist = p_applyEnchantmentModifier_1_.getEnchantmentTagList()) != null) {
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                short j = nbttaglist.getCompoundTagAt(i).getShort("id");
                short k = nbttaglist.getCompoundTagAt(i).getShort("lvl");
                if (Enchantment.getEnchantmentByID(j) == null) continue;
                p_applyEnchantmentModifier_0_.calculateModifier(Enchantment.getEnchantmentByID(j), k);
            }
        }
    }

    private static void applyEnchantmentModifierArray(IModifier p_applyEnchantmentModifierArray_0_, Iterable<ItemStack> p_applyEnchantmentModifierArray_1_) {
        for (ItemStack itemstack : p_applyEnchantmentModifierArray_1_) {
            EnchantmentHelper.applyEnchantmentModifier(p_applyEnchantmentModifierArray_0_, itemstack);
        }
    }

    public static int getEnchantmentModifierDamage(Iterable<ItemStack> p_getEnchantmentModifierDamage_0_, DamageSource p_getEnchantmentModifierDamage_1_) {
        EnchantmentHelper.ENCHANTMENT_MODIFIER_DAMAGE.damageModifier = 0;
        EnchantmentHelper.ENCHANTMENT_MODIFIER_DAMAGE.source = p_getEnchantmentModifierDamage_1_;
        EnchantmentHelper.applyEnchantmentModifierArray(ENCHANTMENT_MODIFIER_DAMAGE, p_getEnchantmentModifierDamage_0_);
        return EnchantmentHelper.ENCHANTMENT_MODIFIER_DAMAGE.damageModifier;
    }

    public static float getModifierForCreature(ItemStack p_getModifierForCreature_0_, EnumCreatureAttribute p_getModifierForCreature_1_) {
        EnchantmentHelper.ENCHANTMENT_MODIFIER_LIVING.livingModifier = 0.0f;
        EnchantmentHelper.ENCHANTMENT_MODIFIER_LIVING.entityLiving = p_getModifierForCreature_1_;
        EnchantmentHelper.applyEnchantmentModifier(ENCHANTMENT_MODIFIER_LIVING, p_getModifierForCreature_0_);
        return EnchantmentHelper.ENCHANTMENT_MODIFIER_LIVING.livingModifier;
    }

    public static float func_191527_a(EntityLivingBase p_191527_0_) {
        int i = EnchantmentHelper.getMaxEnchantmentLevel(Enchantments.field_191530_r, p_191527_0_);
        return i > 0 ? EnchantmentSweepingEdge.func_191526_e(i) : 0.0f;
    }

    public static void applyThornEnchantments(EntityLivingBase p_applyThornEnchantments_0_, Entity p_applyThornEnchantments_1_) {
        EnchantmentHelper.ENCHANTMENT_ITERATOR_HURT.attacker = p_applyThornEnchantments_1_;
        EnchantmentHelper.ENCHANTMENT_ITERATOR_HURT.user = p_applyThornEnchantments_0_;
        if (p_applyThornEnchantments_0_ != null) {
            EnchantmentHelper.applyEnchantmentModifierArray(ENCHANTMENT_ITERATOR_HURT, p_applyThornEnchantments_0_.getEquipmentAndArmor());
        }
        if (p_applyThornEnchantments_1_ instanceof EntityPlayer) {
            EnchantmentHelper.applyEnchantmentModifier(ENCHANTMENT_ITERATOR_HURT, p_applyThornEnchantments_0_.getHeldItemMainhand());
        }
    }

    public static void applyArthropodEnchantments(EntityLivingBase p_applyArthropodEnchantments_0_, Entity p_applyArthropodEnchantments_1_) {
        EnchantmentHelper.ENCHANTMENT_ITERATOR_DAMAGE.user = p_applyArthropodEnchantments_0_;
        EnchantmentHelper.ENCHANTMENT_ITERATOR_DAMAGE.target = p_applyArthropodEnchantments_1_;
        if (p_applyArthropodEnchantments_0_ != null) {
            EnchantmentHelper.applyEnchantmentModifierArray(ENCHANTMENT_ITERATOR_DAMAGE, p_applyArthropodEnchantments_0_.getEquipmentAndArmor());
        }
        if (p_applyArthropodEnchantments_0_ instanceof EntityPlayer) {
            EnchantmentHelper.applyEnchantmentModifier(ENCHANTMENT_ITERATOR_DAMAGE, p_applyArthropodEnchantments_0_.getHeldItemMainhand());
        }
    }

    public static int getMaxEnchantmentLevel(Enchantment p_getMaxEnchantmentLevel_0_, EntityLivingBase p_getMaxEnchantmentLevel_1_) {
        List<ItemStack> iterable = p_getMaxEnchantmentLevel_0_.getEntityEquipment(p_getMaxEnchantmentLevel_1_);
        if (iterable == null) {
            return 0;
        }
        int i = 0;
        for (ItemStack itemstack : iterable) {
            int j = EnchantmentHelper.getEnchantmentLevel(p_getMaxEnchantmentLevel_0_, itemstack);
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    public static int getKnockbackModifier(EntityLivingBase p_getKnockbackModifier_0_) {
        return EnchantmentHelper.getMaxEnchantmentLevel(Enchantments.KNOCKBACK, p_getKnockbackModifier_0_);
    }

    public static int getFireAspectModifier(EntityLivingBase p_getFireAspectModifier_0_) {
        return EnchantmentHelper.getMaxEnchantmentLevel(Enchantments.FIRE_ASPECT, p_getFireAspectModifier_0_);
    }

    public static int getRespirationModifier(EntityLivingBase p_getRespirationModifier_0_) {
        return EnchantmentHelper.getMaxEnchantmentLevel(Enchantments.RESPIRATION, p_getRespirationModifier_0_);
    }

    public static int getDepthStriderModifier(EntityLivingBase p_getDepthStriderModifier_0_) {
        return EnchantmentHelper.getMaxEnchantmentLevel(Enchantments.DEPTH_STRIDER, p_getDepthStriderModifier_0_);
    }

    public static int getEfficiencyModifier(EntityLivingBase p_getEfficiencyModifier_0_) {
        return EnchantmentHelper.getMaxEnchantmentLevel(Enchantments.EFFICIENCY, p_getEfficiencyModifier_0_);
    }

    public static int func_191529_b(ItemStack p_191529_0_) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.LUCK_OF_THE_SEA, p_191529_0_);
    }

    public static int func_191528_c(ItemStack p_191528_0_) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.LURE, p_191528_0_);
    }

    public static int getLootingModifier(EntityLivingBase p_getLootingModifier_0_) {
        return EnchantmentHelper.getMaxEnchantmentLevel(Enchantments.LOOTING, p_getLootingModifier_0_);
    }

    public static boolean getAquaAffinityModifier(EntityLivingBase p_getAquaAffinityModifier_0_) {
        return EnchantmentHelper.getMaxEnchantmentLevel(Enchantments.AQUA_AFFINITY, p_getAquaAffinityModifier_0_) > 0;
    }

    public static boolean hasFrostWalkerEnchantment(EntityLivingBase p_hasFrostWalkerEnchantment_0_) {
        return EnchantmentHelper.getMaxEnchantmentLevel(Enchantments.FROST_WALKER, p_hasFrostWalkerEnchantment_0_) > 0;
    }

    public static boolean hasBindingCurse(ItemStack p_hasBindingCurse_0_) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.BINDING_CURSE, p_hasBindingCurse_0_) > 0;
    }

    public static boolean hasVanishingCurse(ItemStack p_hasVanishingCurse_0_) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.VANISHING_CURSE, p_hasVanishingCurse_0_) > 0;
    }

    public static ItemStack getEnchantedItem(Enchantment p_getEnchantedItem_0_, EntityLivingBase p_getEnchantedItem_1_) {
        List<ItemStack> list = p_getEnchantedItem_0_.getEntityEquipment(p_getEnchantedItem_1_);
        if (list.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ArrayList list1 = Lists.newArrayList();
        for (ItemStack itemstack : list) {
            if (itemstack.isEmpty() || EnchantmentHelper.getEnchantmentLevel(p_getEnchantedItem_0_, itemstack) <= 0) continue;
            list1.add(itemstack);
        }
        return list1.isEmpty() ? ItemStack.EMPTY : (ItemStack)list1.get(p_getEnchantedItem_1_.getRNG().nextInt(list1.size()));
    }

    public static int calcItemStackEnchantability(Random p_calcItemStackEnchantability_0_, int p_calcItemStackEnchantability_1_, int p_calcItemStackEnchantability_2_, ItemStack p_calcItemStackEnchantability_3_) {
        Item item = p_calcItemStackEnchantability_3_.getItem();
        int i = item.getItemEnchantability(p_calcItemStackEnchantability_3_);
        if (i <= 0) {
            return 0;
        }
        if (p_calcItemStackEnchantability_2_ > 15) {
            p_calcItemStackEnchantability_2_ = 15;
        }
        int j = p_calcItemStackEnchantability_0_.nextInt(8) + 1 + (p_calcItemStackEnchantability_2_ >> 1) + p_calcItemStackEnchantability_0_.nextInt(p_calcItemStackEnchantability_2_ + 1);
        return p_calcItemStackEnchantability_1_ == 0 ? Math.max(j / 3, 1) : (p_calcItemStackEnchantability_1_ == 1 ? j * 2 / 3 + 1 : Math.max(j, p_calcItemStackEnchantability_2_ * 2));
    }

    public static ItemStack addRandomEnchantment(Random p_addRandomEnchantment_0_, ItemStack p_addRandomEnchantment_1_, int p_addRandomEnchantment_2_, boolean p_addRandomEnchantment_3_) {
        boolean flag;
        List<EnchantmentData> list = EnchantmentHelper.buildEnchantmentList(p_addRandomEnchantment_0_, p_addRandomEnchantment_1_, p_addRandomEnchantment_2_, p_addRandomEnchantment_3_);
        boolean bl = flag = p_addRandomEnchantment_1_.getItem() == Items.BOOK;
        if (flag) {
            p_addRandomEnchantment_1_ = new ItemStack(Items.ENCHANTED_BOOK);
        }
        for (EnchantmentData enchantmentdata : list) {
            if (flag) {
                Items.ENCHANTED_BOOK.addEnchantment(p_addRandomEnchantment_1_, enchantmentdata);
                continue;
            }
            p_addRandomEnchantment_1_.addEnchantment(enchantmentdata.enchantmentobj, enchantmentdata.enchantmentLevel);
        }
        return p_addRandomEnchantment_1_;
    }

    public static List<EnchantmentData> buildEnchantmentList(Random p_buildEnchantmentList_0_, ItemStack p_buildEnchantmentList_1_, int p_buildEnchantmentList_2_, boolean p_buildEnchantmentList_3_) {
        ArrayList list = Lists.newArrayList();
        Item item = p_buildEnchantmentList_1_.getItem();
        int i = item.getItemEnchantability(p_buildEnchantmentList_1_);
        if (i <= 0) {
            return list;
        }
        p_buildEnchantmentList_2_ = p_buildEnchantmentList_2_ + 1 + p_buildEnchantmentList_0_.nextInt(i / 4 + 1) + p_buildEnchantmentList_0_.nextInt(i / 4 + 1);
        float f = (p_buildEnchantmentList_0_.nextFloat() + p_buildEnchantmentList_0_.nextFloat() - 1.0f) * 0.15f;
        List<EnchantmentData> list1 = EnchantmentHelper.getEnchantmentDatas(p_buildEnchantmentList_2_ = MathHelper.clamp(Math.round((float)p_buildEnchantmentList_2_ + (float)p_buildEnchantmentList_2_ * f), 1, Integer.MAX_VALUE), p_buildEnchantmentList_1_, p_buildEnchantmentList_3_);
        if (!list1.isEmpty()) {
            list.add(WeightedRandom.getRandomItem(p_buildEnchantmentList_0_, list1));
            while (p_buildEnchantmentList_0_.nextInt(50) <= p_buildEnchantmentList_2_) {
                EnchantmentHelper.removeIncompatible(list1, (EnchantmentData)Util.getLastElement(list));
                if (list1.isEmpty()) break;
                list.add(WeightedRandom.getRandomItem(p_buildEnchantmentList_0_, list1));
                p_buildEnchantmentList_2_ /= 2;
            }
        }
        return list;
    }

    public static void removeIncompatible(List<EnchantmentData> p_removeIncompatible_0_, EnchantmentData p_removeIncompatible_1_) {
        Iterator<EnchantmentData> iterator = p_removeIncompatible_0_.iterator();
        while (iterator.hasNext()) {
            if (p_removeIncompatible_1_.enchantmentobj.func_191560_c(iterator.next().enchantmentobj)) continue;
            iterator.remove();
        }
    }

    public static List<EnchantmentData> getEnchantmentDatas(int p_getEnchantmentDatas_0_, ItemStack p_getEnchantmentDatas_1_, boolean p_getEnchantmentDatas_2_) {
        ArrayList list = Lists.newArrayList();
        Item item = p_getEnchantmentDatas_1_.getItem();
        boolean flag = p_getEnchantmentDatas_1_.getItem() == Items.BOOK;
        block0: for (Enchantment enchantment : Enchantment.REGISTRY) {
            if (enchantment.isTreasureEnchantment() && !p_getEnchantmentDatas_2_ || !enchantment.canApplyAtEnchantingTable(p_getEnchantmentDatas_1_) && (!flag || !enchantment.isAllowedOnBooks())) continue;
            for (int i = enchantment.getMaxLevel(); i > enchantment.getMinLevel() - 1; --i) {
                if (p_getEnchantmentDatas_0_ < enchantment.getMinEnchantability(i) || p_getEnchantmentDatas_0_ > enchantment.getMaxEnchantability(i)) continue;
                list.add(new EnchantmentData(enchantment, i));
                continue block0;
            }
        }
        return list;
    }

    static final class ModifierLiving
    implements IModifier {
        public float livingModifier;
        public EnumCreatureAttribute entityLiving;

        private ModifierLiving() {
        }

        @Override
        public void calculateModifier(Enchantment p_calculateModifier_1_, int p_calculateModifier_2_) {
            this.livingModifier += p_calculateModifier_1_.calcDamageByCreature(p_calculateModifier_2_, this.entityLiving);
        }
    }

    static final class ModifierDamage
    implements IModifier {
        public int damageModifier;
        public DamageSource source;

        private ModifierDamage() {
        }

        @Override
        public void calculateModifier(Enchantment p_calculateModifier_1_, int p_calculateModifier_2_) {
            this.damageModifier += p_calculateModifier_1_.calcModifierDamage(p_calculateModifier_2_, this.source);
        }
    }

    static interface IModifier {
        public void calculateModifier(Enchantment var1, int var2);
    }

    static final class HurtIterator
    implements IModifier {
        public EntityLivingBase user;
        public Entity attacker;

        private HurtIterator() {
        }

        @Override
        public void calculateModifier(Enchantment p_calculateModifier_1_, int p_calculateModifier_2_) {
            p_calculateModifier_1_.onUserHurt(this.user, this.attacker, p_calculateModifier_2_);
        }
    }

    static final class DamageIterator
    implements IModifier {
        public EntityLivingBase user;
        public Entity target;

        private DamageIterator() {
        }

        @Override
        public void calculateModifier(Enchantment p_calculateModifier_1_, int p_calculateModifier_2_) {
            p_calculateModifier_1_.onEntityDamaged(this.user, this.target, p_calculateModifier_2_);
        }
    }
}

