/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.enchantment;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;

public class EnchantmentProtection
extends Enchantment {
    public final Type protectionType;

    public EnchantmentProtection(Enchantment.Rarity p_i46723_1_, Type p_i46723_2_, EntityEquipmentSlot ... p_i46723_3_) {
        super(p_i46723_1_, EnumEnchantmentType.ARMOR, p_i46723_3_);
        this.protectionType = p_i46723_2_;
        if (p_i46723_2_ == Type.FALL) {
            this.type = EnumEnchantmentType.ARMOR_FEET;
        }
    }

    @Override
    public int getMinEnchantability(int p_getMinEnchantability_1_) {
        return this.protectionType.getMinimalEnchantability() + (p_getMinEnchantability_1_ - 1) * this.protectionType.getEnchantIncreasePerLevel();
    }

    @Override
    public int getMaxEnchantability(int p_getMaxEnchantability_1_) {
        return this.getMinEnchantability(p_getMaxEnchantability_1_) + this.protectionType.getEnchantIncreasePerLevel();
    }

    @Override
    public int getMaxLevel() {
        return 4;
    }

    @Override
    public int calcModifierDamage(int p_calcModifierDamage_1_, DamageSource p_calcModifierDamage_2_) {
        if (p_calcModifierDamage_2_.canHarmInCreative()) {
            return 0;
        }
        if (this.protectionType == Type.ALL) {
            return p_calcModifierDamage_1_;
        }
        if (this.protectionType == Type.FIRE && p_calcModifierDamage_2_.isFireDamage()) {
            return p_calcModifierDamage_1_ * 2;
        }
        if (this.protectionType == Type.FALL && p_calcModifierDamage_2_ == DamageSource.FALL) {
            return p_calcModifierDamage_1_ * 3;
        }
        if (this.protectionType == Type.EXPLOSION && p_calcModifierDamage_2_.isExplosion()) {
            return p_calcModifierDamage_1_ * 2;
        }
        if (this.protectionType == Type.PROJECTILE && p_calcModifierDamage_2_.isProjectile()) {
            return p_calcModifierDamage_1_ * 2;
        }
        return 0;
    }

    @Override
    public String getName() {
        return "enchantment.protect." + this.protectionType.getTypeName();
    }

    @Override
    public boolean canApplyTogether(Enchantment p_canApplyTogether_1_) {
        if (p_canApplyTogether_1_ instanceof EnchantmentProtection) {
            EnchantmentProtection lvt_2_1_ = (EnchantmentProtection)p_canApplyTogether_1_;
            if (this.protectionType == lvt_2_1_.protectionType) {
                return false;
            }
            return this.protectionType == Type.FALL || lvt_2_1_.protectionType == Type.FALL;
        }
        return super.canApplyTogether(p_canApplyTogether_1_);
    }

    public static int getFireTimeForEntity(EntityLivingBase p_getFireTimeForEntity_0_, int p_getFireTimeForEntity_1_) {
        int lvt_2_1_ = EnchantmentHelper.getMaxEnchantmentLevel(Enchantments.FIRE_PROTECTION, p_getFireTimeForEntity_0_);
        if (lvt_2_1_ > 0) {
            p_getFireTimeForEntity_1_ -= MathHelper.floor((float)p_getFireTimeForEntity_1_ * ((float)lvt_2_1_ * 0.15f));
        }
        return p_getFireTimeForEntity_1_;
    }

    public static double getBlastDamageReduction(EntityLivingBase p_getBlastDamageReduction_0_, double p_getBlastDamageReduction_1_) {
        int lvt_3_1_ = EnchantmentHelper.getMaxEnchantmentLevel(Enchantments.BLAST_PROTECTION, p_getBlastDamageReduction_0_);
        if (lvt_3_1_ > 0) {
            p_getBlastDamageReduction_1_ -= (double)MathHelper.floor(p_getBlastDamageReduction_1_ * (double)((float)lvt_3_1_ * 0.15f));
        }
        return p_getBlastDamageReduction_1_;
    }

    public static enum Type {
        ALL("all", 1, 11, 20),
        FIRE("fire", 10, 8, 12),
        FALL("fall", 5, 6, 10),
        EXPLOSION("explosion", 5, 8, 12),
        PROJECTILE("projectile", 3, 6, 15);

        private final String typeName;
        private final int minEnchantability;
        private final int levelCost;
        private final int levelCostSpan;

        private Type(String p_i47051_3_, int p_i47051_4_, int p_i47051_5_, int p_i47051_6_) {
            this.typeName = p_i47051_3_;
            this.minEnchantability = p_i47051_4_;
            this.levelCost = p_i47051_5_;
            this.levelCostSpan = p_i47051_6_;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public int getMinimalEnchantability() {
            return this.minEnchantability;
        }

        public int getEnchantIncreasePerLevel() {
            return this.levelCost;
        }
    }
}

