/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.enchantment;

import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;

public class EnchantmentThorns
extends Enchantment {
    public EnchantmentThorns(Enchantment.Rarity p_i46722_1_, EntityEquipmentSlot ... p_i46722_2_) {
        super(p_i46722_1_, EnumEnchantmentType.ARMOR_CHEST, p_i46722_2_);
        this.setName("thorns");
    }

    @Override
    public int getMinEnchantability(int p_getMinEnchantability_1_) {
        return 10 + 20 * (p_getMinEnchantability_1_ - 1);
    }

    @Override
    public int getMaxEnchantability(int p_getMaxEnchantability_1_) {
        return super.getMinEnchantability(p_getMaxEnchantability_1_) + 50;
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public boolean canApply(ItemStack p_canApply_1_) {
        return p_canApply_1_.getItem() instanceof ItemArmor ? true : super.canApply(p_canApply_1_);
    }

    @Override
    public void onUserHurt(EntityLivingBase p_onUserHurt_1_, Entity p_onUserHurt_2_, int p_onUserHurt_3_) {
        Random random = p_onUserHurt_1_.getRNG();
        ItemStack itemstack = EnchantmentHelper.getEnchantedItem(Enchantments.THORNS, p_onUserHurt_1_);
        if (EnchantmentThorns.shouldHit(p_onUserHurt_3_, random)) {
            if (p_onUserHurt_2_ != null) {
                p_onUserHurt_2_.attackEntityFrom(DamageSource.causeThornsDamage(p_onUserHurt_1_), EnchantmentThorns.getDamage(p_onUserHurt_3_, random));
            }
            if (!itemstack.isEmpty()) {
                this.damageArmor(itemstack, 3, p_onUserHurt_1_);
            }
        } else if (!itemstack.isEmpty()) {
            this.damageArmor(itemstack, 1, p_onUserHurt_1_);
        }
    }

    public static boolean shouldHit(int p_shouldHit_0_, Random p_shouldHit_1_) {
        return p_shouldHit_0_ <= 0 ? false : p_shouldHit_1_.nextFloat() < 0.15f * (float)p_shouldHit_0_;
    }

    public static int getDamage(int p_getDamage_0_, Random p_getDamage_1_) {
        return p_getDamage_0_ > 10 ? p_getDamage_0_ - 10 : 1 + p_getDamage_1_.nextInt(4);
    }

    private void damageArmor(ItemStack p_damageArmor_1_, int p_damageArmor_2_, EntityLivingBase p_damageArmor_3_) {
        int slot = -1;
        int x = 0;
        for (ItemStack i : p_damageArmor_3_.getArmorInventoryList()) {
            if (i == p_damageArmor_1_) {
                slot = x;
                break;
            }
            ++x;
        }
        if (slot == -1 || !(p_damageArmor_1_.getItem() instanceof ISpecialArmor)) {
            p_damageArmor_1_.damageItem(1, p_damageArmor_3_);
            return;
        }
        ISpecialArmor armor = (ISpecialArmor)((Object)p_damageArmor_1_.getItem());
        armor.damageArmor(p_damageArmor_3_, p_damageArmor_1_, DamageSource.causeThornsDamage(p_damageArmor_3_), p_damageArmor_2_, slot);
    }
}

