/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.enchantment;

import com.google.common.base.Predicate;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;

public enum EnumEnchantmentType {
    ALL{

        @Override
        public boolean canEnchantItem(Item p_canEnchantItem_1_) {
            for (EnumEnchantmentType enumenchantmenttype : EnumEnchantmentType.values()) {
                if (enumenchantmenttype == ALL || !enumenchantmenttype.canEnchantItem(p_canEnchantItem_1_)) continue;
                return true;
            }
            return false;
        }
    }
    ,
    ARMOR{

        @Override
        public boolean canEnchantItem(Item p_canEnchantItem_1_) {
            return p_canEnchantItem_1_ instanceof ItemArmor;
        }
    }
    ,
    ARMOR_FEET{

        @Override
        public boolean canEnchantItem(Item p_canEnchantItem_1_) {
            return p_canEnchantItem_1_ instanceof ItemArmor && ((ItemArmor)p_canEnchantItem_1_).armorType == EntityEquipmentSlot.FEET;
        }
    }
    ,
    ARMOR_LEGS{

        @Override
        public boolean canEnchantItem(Item p_canEnchantItem_1_) {
            return p_canEnchantItem_1_ instanceof ItemArmor && ((ItemArmor)p_canEnchantItem_1_).armorType == EntityEquipmentSlot.LEGS;
        }
    }
    ,
    ARMOR_CHEST{

        @Override
        public boolean canEnchantItem(Item p_canEnchantItem_1_) {
            return p_canEnchantItem_1_ instanceof ItemArmor && ((ItemArmor)p_canEnchantItem_1_).armorType == EntityEquipmentSlot.CHEST;
        }
    }
    ,
    ARMOR_HEAD{

        @Override
        public boolean canEnchantItem(Item p_canEnchantItem_1_) {
            return p_canEnchantItem_1_ instanceof ItemArmor && ((ItemArmor)p_canEnchantItem_1_).armorType == EntityEquipmentSlot.HEAD;
        }
    }
    ,
    WEAPON{

        @Override
        public boolean canEnchantItem(Item p_canEnchantItem_1_) {
            return p_canEnchantItem_1_ instanceof ItemSword;
        }
    }
    ,
    DIGGER{

        @Override
        public boolean canEnchantItem(Item p_canEnchantItem_1_) {
            return p_canEnchantItem_1_ instanceof ItemTool;
        }
    }
    ,
    FISHING_ROD{

        @Override
        public boolean canEnchantItem(Item p_canEnchantItem_1_) {
            return p_canEnchantItem_1_ instanceof ItemFishingRod;
        }
    }
    ,
    BREAKABLE{

        @Override
        public boolean canEnchantItem(Item p_canEnchantItem_1_) {
            return p_canEnchantItem_1_.isDamageable();
        }
    }
    ,
    BOW{

        @Override
        public boolean canEnchantItem(Item p_canEnchantItem_1_) {
            return p_canEnchantItem_1_ instanceof ItemBow;
        }
    }
    ,
    WEARABLE{

        @Override
        public boolean canEnchantItem(Item p_canEnchantItem_1_) {
            boolean flag = p_canEnchantItem_1_ instanceof ItemBlock && ((ItemBlock)p_canEnchantItem_1_).getBlock() instanceof BlockPumpkin;
            return p_canEnchantItem_1_ instanceof ItemArmor || p_canEnchantItem_1_ instanceof ItemElytra || p_canEnchantItem_1_ instanceof ItemSkull || flag;
        }
    };

    private Predicate<Item> delegate = null;

    private EnumEnchantmentType() {
    }

    private EnumEnchantmentType(Predicate<Item> p_i7_3_) {
        this.delegate = p_i7_3_;
    }

    public boolean canEnchantItem(Item p_canEnchantItem_1_) {
        return this.delegate == null ? false : this.delegate.apply((Object)p_canEnchantItem_1_);
    }
}

