/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockWall;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommandSender;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.EntityLeashKnot;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataFixer;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.Explosion;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Entity
implements ICommandSender,
ICapabilitySerializable<NBTTagCompound> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<ItemStack> EMPTY_EQUIPMENT = Collections.emptyList();
    private static final AxisAlignedBB ZERO_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static double renderDistanceWeight = 1.0;
    private static int nextEntityID;
    private int entityId;
    public boolean preventEntitySpawning;
    private final List<Entity> riddenByEntities;
    protected int rideCooldown;
    private Entity ridingEntity;
    public boolean forceSpawn;
    public World world;
    public double prevPosX;
    public double prevPosY;
    public double prevPosZ;
    public double posX;
    public double posY;
    public double posZ;
    public double motionX;
    public double motionY;
    public double motionZ;
    public float rotationYaw;
    public float rotationPitch;
    public float prevRotationYaw;
    public float prevRotationPitch;
    private AxisAlignedBB boundingBox;
    public boolean onGround;
    public boolean isCollidedHorizontally;
    public boolean isCollidedVertically;
    public boolean isCollided;
    public boolean velocityChanged;
    protected boolean isInWeb;
    private boolean isOutsideBorder;
    public boolean isDead;
    public float width = 0.6f;
    public float height = 1.8f;
    public float prevDistanceWalkedModified;
    public float distanceWalkedModified;
    public float distanceWalkedOnStepModified;
    public float fallDistance;
    private int nextStepDistance = 1;
    public double lastTickPosX;
    public double lastTickPosY;
    public double lastTickPosZ;
    public float stepHeight;
    public boolean noClip;
    public float entityCollisionReduction;
    protected Random rand;
    public int ticksExisted;
    private int fire;
    protected boolean inWater;
    public int hurtResistantTime;
    protected boolean firstUpdate = true;
    protected boolean isImmuneToFire;
    protected EntityDataManager dataManager;
    protected static final DataParameter<Byte> FLAGS;
    private static final DataParameter<Integer> AIR;
    private static final DataParameter<String> CUSTOM_NAME;
    private static final DataParameter<Boolean> CUSTOM_NAME_VISIBLE;
    private static final DataParameter<Boolean> SILENT;
    private static final DataParameter<Boolean> NO_GRAVITY;
    public boolean addedToChunk;
    public int chunkCoordX;
    public int chunkCoordY;
    public int chunkCoordZ;
    @SideOnly(value=Side.CLIENT)
    public long serverPosX;
    @SideOnly(value=Side.CLIENT)
    public long serverPosY;
    @SideOnly(value=Side.CLIENT)
    public long serverPosZ;
    public boolean ignoreFrustumCheck;
    public boolean isAirBorne;
    public int timeUntilPortal;
    protected boolean inPortal;
    protected int portalCounter;
    public int dimension;
    protected BlockPos lastPortalPos;
    protected Vec3d lastPortalVec;
    protected EnumFacing teleportDirection;
    private boolean invulnerable;
    protected UUID entityUniqueID;
    protected String cachedUniqueIdString;
    private final CommandResultStats cmdResultStats;
    protected boolean glowing;
    private final Set<String> tags;
    private boolean isPositionDirty;
    private double[] field_191505_aI;
    private long field_191506_aJ;
    private NBTTagCompound customEntityData;
    public boolean captureDrops = false;
    public ArrayList<EntityItem> capturedDrops = new ArrayList();
    private CapabilityDispatcher capabilities;

    public Entity(World p_i1582_1_) {
        this.entityId = nextEntityID++;
        this.riddenByEntities = Lists.newArrayList();
        this.boundingBox = ZERO_AABB;
        this.rand = new Random();
        this.fire = -this.getFireImmuneTicks();
        this.entityUniqueID = MathHelper.getRandomUUID(this.rand);
        this.cachedUniqueIdString = this.entityUniqueID.toString();
        this.cmdResultStats = new CommandResultStats();
        this.tags = Sets.newHashSet();
        this.field_191505_aI = new double[]{0.0, 0.0, 0.0};
        this.world = p_i1582_1_;
        this.setPosition(0.0, 0.0, 0.0);
        if (p_i1582_1_ != null) {
            this.dimension = p_i1582_1_.provider.getDimension();
        }
        this.dataManager = new EntityDataManager(this);
        this.dataManager.register(FLAGS, (byte)0);
        this.dataManager.register(AIR, 300);
        this.dataManager.register(CUSTOM_NAME_VISIBLE, false);
        this.dataManager.register(CUSTOM_NAME, "");
        this.dataManager.register(SILENT, false);
        this.dataManager.register(NO_GRAVITY, false);
        this.entityInit();
        MinecraftForge.EVENT_BUS.post(new EntityEvent.EntityConstructing(this));
        this.capabilities = ForgeEventFactory.gatherCapabilities(this);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public void setEntityId(int p_setEntityId_1_) {
        this.entityId = p_setEntityId_1_;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public boolean addTag(String p_addTag_1_) {
        if (this.tags.size() >= 1024) {
            return false;
        }
        this.tags.add(p_addTag_1_);
        return true;
    }

    public boolean removeTag(String p_removeTag_1_) {
        return this.tags.remove(p_removeTag_1_);
    }

    public void onKillCommand() {
        this.setDead();
    }

    protected abstract void entityInit();

    public EntityDataManager getDataManager() {
        return this.dataManager;
    }

    public boolean equals(Object p_equals_1_) {
        return p_equals_1_ instanceof Entity ? ((Entity)p_equals_1_).entityId == this.entityId : false;
    }

    public int hashCode() {
        return this.entityId;
    }

    @SideOnly(value=Side.CLIENT)
    protected void preparePlayerToSpawn() {
        if (this.world != null) {
            while (this.posY > 0.0 && this.posY < 256.0) {
                this.setPosition(this.posX, this.posY, this.posZ);
                if (this.world.getCollisionBoxes(this, this.getEntityBoundingBox()).isEmpty()) break;
                this.posY += 1.0;
            }
            this.motionX = 0.0;
            this.motionY = 0.0;
            this.motionZ = 0.0;
            this.rotationPitch = 0.0f;
        }
    }

    public void setDead() {
        this.isDead = true;
    }

    public void setDropItemsWhenDead(boolean p_setDropItemsWhenDead_1_) {
    }

    protected void setSize(float p_setSize_1_, float p_setSize_2_) {
        if (p_setSize_1_ != this.width || p_setSize_2_ != this.height) {
            float f = this.width;
            this.width = p_setSize_1_;
            this.height = p_setSize_2_;
            if (this.width < f) {
                double d0 = (double)p_setSize_1_ / 2.0;
                this.setEntityBoundingBox(new AxisAlignedBB(this.posX - d0, this.posY, this.posZ - d0, this.posX + d0, this.posY + (double)this.height, this.posZ + d0));
                return;
            }
            AxisAlignedBB axisalignedbb = this.getEntityBoundingBox();
            this.setEntityBoundingBox(new AxisAlignedBB(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ, axisalignedbb.minX + (double)this.width, axisalignedbb.minY + (double)this.height, axisalignedbb.minZ + (double)this.width));
            if (this.width > f && !this.firstUpdate && !this.world.isRemote) {
                this.move(MoverType.SELF, f - this.width, 0.0, f - this.width);
            }
        }
    }

    protected void setRotation(float p_setRotation_1_, float p_setRotation_2_) {
        this.rotationYaw = p_setRotation_1_ % 360.0f;
        this.rotationPitch = p_setRotation_2_ % 360.0f;
    }

    public void setPosition(double p_setPosition_1_, double p_setPosition_3_, double p_setPosition_5_) {
        this.posX = p_setPosition_1_;
        this.posY = p_setPosition_3_;
        this.posZ = p_setPosition_5_;
        float f = this.width / 2.0f;
        float f1 = this.height;
        this.setEntityBoundingBox(new AxisAlignedBB(p_setPosition_1_ - (double)f, p_setPosition_3_, p_setPosition_5_ - (double)f, p_setPosition_1_ + (double)f, p_setPosition_3_ + (double)f1, p_setPosition_5_ + (double)f));
    }

    @SideOnly(value=Side.CLIENT)
    public void turn(float p_turn_1_, float p_turn_2_) {
        float f = this.rotationPitch;
        float f1 = this.rotationYaw;
        this.rotationYaw = (float)((double)this.rotationYaw + (double)p_turn_1_ * 0.15);
        this.rotationPitch = (float)((double)this.rotationPitch - (double)p_turn_2_ * 0.15);
        this.rotationPitch = MathHelper.clamp(this.rotationPitch, -90.0f, 90.0f);
        this.prevRotationPitch += this.rotationPitch - f;
        this.prevRotationYaw += this.rotationYaw - f1;
        if (this.ridingEntity != null) {
            this.ridingEntity.applyOrientationToEntity(this);
        }
    }

    public void onUpdate() {
        if (!this.world.isRemote) {
            this.setFlag(6, this.isGlowing());
        }
        this.onEntityUpdate();
    }

    public void onEntityUpdate() {
        this.world.theProfiler.startSection("entityBaseTick");
        if (this.isRiding() && this.getRidingEntity().isDead) {
            this.dismountRidingEntity();
        }
        if (this.rideCooldown > 0) {
            --this.rideCooldown;
        }
        this.prevDistanceWalkedModified = this.distanceWalkedModified;
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.prevRotationPitch = this.rotationPitch;
        this.prevRotationYaw = this.rotationYaw;
        if (!this.world.isRemote && this.world instanceof WorldServer) {
            this.world.theProfiler.startSection("portal");
            if (this.inPortal) {
                MinecraftServer minecraftserver = this.world.getMinecraftServer();
                if (minecraftserver.getAllowNether()) {
                    int i;
                    if (!this.isRiding() && this.portalCounter++ >= (i = this.getMaxInPortalTime())) {
                        this.portalCounter = i;
                        this.timeUntilPortal = this.getPortalCooldown();
                        int j = this.world.provider.getDimensionType().getId() == -1 ? 0 : -1;
                        this.changeDimension(j);
                    }
                    this.inPortal = false;
                }
            } else {
                if (this.portalCounter > 0) {
                    this.portalCounter -= 4;
                }
                if (this.portalCounter < 0) {
                    this.portalCounter = 0;
                }
            }
            this.decrementTimeUntilPortal();
            this.world.theProfiler.endSection();
        }
        this.spawnRunningParticles();
        this.handleWaterMovement();
        if (this.world.isRemote) {
            this.extinguish();
        } else if (this.fire > 0) {
            if (this.isImmuneToFire) {
                this.fire -= 4;
                if (this.fire < 0) {
                    this.extinguish();
                }
            } else {
                if (this.fire % 20 == 0) {
                    this.attackEntityFrom(DamageSource.ON_FIRE, 1.0f);
                }
                --this.fire;
            }
        }
        if (this.isInLava()) {
            this.setOnFireFromLava();
            this.fallDistance *= 0.5f;
        }
        if (this.posY < -64.0) {
            this.kill();
        }
        if (!this.world.isRemote) {
            this.setFlag(0, this.fire > 0);
        }
        this.firstUpdate = false;
        this.world.theProfiler.endSection();
    }

    protected void decrementTimeUntilPortal() {
        if (this.timeUntilPortal > 0) {
            --this.timeUntilPortal;
        }
    }

    public int getMaxInPortalTime() {
        return 1;
    }

    protected void setOnFireFromLava() {
        if (!this.isImmuneToFire) {
            this.attackEntityFrom(DamageSource.LAVA, 4.0f);
            this.setFire(15);
        }
    }

    public void setFire(int p_setFire_1_) {
        int i = p_setFire_1_ * 20;
        if (this instanceof EntityLivingBase) {
            i = EnchantmentProtection.getFireTimeForEntity((EntityLivingBase)this, i);
        }
        if (this.fire < i) {
            this.fire = i;
        }
    }

    public void extinguish() {
        this.fire = 0;
    }

    protected void kill() {
        this.setDead();
    }

    public boolean isOffsetPositionInLiquid(double p_isOffsetPositionInLiquid_1_, double p_isOffsetPositionInLiquid_3_, double p_isOffsetPositionInLiquid_5_) {
        AxisAlignedBB axisalignedbb = this.getEntityBoundingBox().offset(p_isOffsetPositionInLiquid_1_, p_isOffsetPositionInLiquid_3_, p_isOffsetPositionInLiquid_5_);
        return this.isLiquidPresentInAABB(axisalignedbb);
    }

    private boolean isLiquidPresentInAABB(AxisAlignedBB p_isLiquidPresentInAABB_1_) {
        return this.world.getCollisionBoxes(this, p_isLiquidPresentInAABB_1_).isEmpty() && !this.world.containsAnyLiquid(p_isLiquidPresentInAABB_1_);
    }

    public void move(MoverType p_move_1_, double p_move_2_, double p_move_4_, double p_move_6_) {
        if (this.noClip) {
            this.setEntityBoundingBox(this.getEntityBoundingBox().offset(p_move_2_, p_move_4_, p_move_6_));
            this.resetPositionToBB();
        } else {
            BlockPos blockpos1;
            IBlockState iblockstate1;
            Block block1;
            boolean flag;
            if (p_move_1_ == MoverType.PISTON) {
                long i = this.world.getTotalWorldTime();
                if (i != this.field_191506_aJ) {
                    Arrays.fill(this.field_191505_aI, 0.0);
                    this.field_191506_aJ = i;
                }
                if (p_move_2_ != 0.0) {
                    int j = EnumFacing.Axis.X.ordinal();
                    double d0 = MathHelper.clamp(p_move_2_ + this.field_191505_aI[j], -0.51, 0.51);
                    p_move_2_ = d0 - this.field_191505_aI[j];
                    this.field_191505_aI[j] = d0;
                    if (Math.abs(p_move_2_) <= (double)1.0E-5f) {
                        return;
                    }
                } else if (p_move_4_ != 0.0) {
                    int l4 = EnumFacing.Axis.Y.ordinal();
                    double d12 = MathHelper.clamp(p_move_4_ + this.field_191505_aI[l4], -0.51, 0.51);
                    p_move_4_ = d12 - this.field_191505_aI[l4];
                    this.field_191505_aI[l4] = d12;
                    if (Math.abs(p_move_4_) <= (double)1.0E-5f) {
                        return;
                    }
                } else {
                    if (p_move_6_ == 0.0) {
                        return;
                    }
                    int i5 = EnumFacing.Axis.Z.ordinal();
                    double d13 = MathHelper.clamp(p_move_6_ + this.field_191505_aI[i5], -0.51, 0.51);
                    p_move_6_ = d13 - this.field_191505_aI[i5];
                    this.field_191505_aI[i5] = d13;
                    if (Math.abs(p_move_6_) <= (double)1.0E-5f) {
                        return;
                    }
                }
            }
            this.world.theProfiler.startSection("move");
            double d10 = this.posX;
            double d11 = this.posY;
            double d1 = this.posZ;
            if (this.isInWeb) {
                this.isInWeb = false;
                p_move_2_ *= 0.25;
                p_move_4_ *= (double)0.05f;
                p_move_6_ *= 0.25;
                this.motionX = 0.0;
                this.motionY = 0.0;
                this.motionZ = 0.0;
            }
            double d2 = p_move_2_;
            double d3 = p_move_4_;
            double d4 = p_move_6_;
            if ((p_move_1_ == MoverType.SELF || p_move_1_ == MoverType.PLAYER) && this.onGround && this.isSneaking() && this instanceof EntityPlayer) {
                double d5 = 0.05;
                while (p_move_2_ != 0.0 && this.world.getCollisionBoxes(this, this.getEntityBoundingBox().offset(p_move_2_, -this.stepHeight, 0.0)).isEmpty()) {
                    p_move_2_ = p_move_2_ < 0.05 && p_move_2_ >= -0.05 ? 0.0 : (p_move_2_ > 0.0 ? (p_move_2_ -= 0.05) : (p_move_2_ += 0.05));
                    d2 = p_move_2_;
                }
                while (p_move_6_ != 0.0 && this.world.getCollisionBoxes(this, this.getEntityBoundingBox().offset(0.0, -this.stepHeight, p_move_6_)).isEmpty()) {
                    p_move_6_ = p_move_6_ < 0.05 && p_move_6_ >= -0.05 ? 0.0 : (p_move_6_ > 0.0 ? (p_move_6_ -= 0.05) : (p_move_6_ += 0.05));
                    d4 = p_move_6_;
                }
                while (p_move_2_ != 0.0 && p_move_6_ != 0.0 && this.world.getCollisionBoxes(this, this.getEntityBoundingBox().offset(p_move_2_, -this.stepHeight, p_move_6_)).isEmpty()) {
                    p_move_2_ = p_move_2_ < 0.05 && p_move_2_ >= -0.05 ? 0.0 : (p_move_2_ > 0.0 ? (p_move_2_ -= 0.05) : (p_move_2_ += 0.05));
                    d2 = p_move_2_;
                    p_move_6_ = p_move_6_ < 0.05 && p_move_6_ >= -0.05 ? 0.0 : (p_move_6_ > 0.0 ? (p_move_6_ -= 0.05) : (p_move_6_ += 0.05));
                    d4 = p_move_6_;
                }
            }
            List<AxisAlignedBB> list1 = this.world.getCollisionBoxes(this, this.getEntityBoundingBox().addCoord(p_move_2_, p_move_4_, p_move_6_));
            AxisAlignedBB axisalignedbb = this.getEntityBoundingBox();
            if (p_move_4_ != 0.0) {
                int l = list1.size();
                for (int k = 0; k < l; ++k) {
                    p_move_4_ = list1.get(k).calculateYOffset(this.getEntityBoundingBox(), p_move_4_);
                }
                this.setEntityBoundingBox(this.getEntityBoundingBox().offset(0.0, p_move_4_, 0.0));
            }
            if (p_move_2_ != 0.0) {
                int l5 = list1.size();
                for (int j5 = 0; j5 < l5; ++j5) {
                    p_move_2_ = list1.get(j5).calculateXOffset(this.getEntityBoundingBox(), p_move_2_);
                }
                if (p_move_2_ != 0.0) {
                    this.setEntityBoundingBox(this.getEntityBoundingBox().offset(p_move_2_, 0.0, 0.0));
                }
            }
            if (p_move_6_ != 0.0) {
                int i6 = list1.size();
                for (int k5 = 0; k5 < i6; ++k5) {
                    p_move_6_ = list1.get(k5).calculateZOffset(this.getEntityBoundingBox(), p_move_6_);
                }
                if (p_move_6_ != 0.0) {
                    this.setEntityBoundingBox(this.getEntityBoundingBox().offset(0.0, 0.0, p_move_6_));
                }
            }
            boolean bl = flag = this.onGround || d3 != p_move_4_ && d3 < 0.0;
            if (this.stepHeight > 0.0f && flag && (d2 != p_move_2_ || d4 != p_move_6_)) {
                double d14 = p_move_2_;
                double d6 = p_move_4_;
                double d7 = p_move_6_;
                AxisAlignedBB axisalignedbb1 = this.getEntityBoundingBox();
                this.setEntityBoundingBox(axisalignedbb);
                p_move_4_ = this.stepHeight;
                List<AxisAlignedBB> list = this.world.getCollisionBoxes(this, this.getEntityBoundingBox().addCoord(d2, p_move_4_, d4));
                AxisAlignedBB axisalignedbb2 = this.getEntityBoundingBox();
                AxisAlignedBB axisalignedbb3 = axisalignedbb2.addCoord(d2, 0.0, d4);
                double d8 = p_move_4_;
                int k1 = list.size();
                for (int j1 = 0; j1 < k1; ++j1) {
                    d8 = list.get(j1).calculateYOffset(axisalignedbb3, d8);
                }
                axisalignedbb2 = axisalignedbb2.offset(0.0, d8, 0.0);
                double d18 = d2;
                int i2 = list.size();
                for (int l1 = 0; l1 < i2; ++l1) {
                    d18 = list.get(l1).calculateXOffset(axisalignedbb2, d18);
                }
                axisalignedbb2 = axisalignedbb2.offset(d18, 0.0, 0.0);
                double d19 = d4;
                int k2 = list.size();
                for (int j2 = 0; j2 < k2; ++j2) {
                    d19 = list.get(j2).calculateZOffset(axisalignedbb2, d19);
                }
                axisalignedbb2 = axisalignedbb2.offset(0.0, 0.0, d19);
                AxisAlignedBB axisalignedbb4 = this.getEntityBoundingBox();
                double d20 = p_move_4_;
                int i3 = list.size();
                for (int l2 = 0; l2 < i3; ++l2) {
                    d20 = list.get(l2).calculateYOffset(axisalignedbb4, d20);
                }
                axisalignedbb4 = axisalignedbb4.offset(0.0, d20, 0.0);
                double d21 = d2;
                int k3 = list.size();
                for (int j3 = 0; j3 < k3; ++j3) {
                    d21 = list.get(j3).calculateXOffset(axisalignedbb4, d21);
                }
                axisalignedbb4 = axisalignedbb4.offset(d21, 0.0, 0.0);
                double d22 = d4;
                int i4 = list.size();
                for (int l3 = 0; l3 < i4; ++l3) {
                    d22 = list.get(l3).calculateZOffset(axisalignedbb4, d22);
                }
                axisalignedbb4 = axisalignedbb4.offset(0.0, 0.0, d22);
                double d23 = d18 * d18 + d19 * d19;
                double d9 = d21 * d21 + d22 * d22;
                if (d23 > d9) {
                    p_move_2_ = d18;
                    p_move_6_ = d19;
                    p_move_4_ = -d8;
                    this.setEntityBoundingBox(axisalignedbb2);
                } else {
                    p_move_2_ = d21;
                    p_move_6_ = d22;
                    p_move_4_ = -d20;
                    this.setEntityBoundingBox(axisalignedbb4);
                }
                int k4 = list.size();
                for (int j4 = 0; j4 < k4; ++j4) {
                    p_move_4_ = list.get(j4).calculateYOffset(this.getEntityBoundingBox(), p_move_4_);
                }
                this.setEntityBoundingBox(this.getEntityBoundingBox().offset(0.0, p_move_4_, 0.0));
                if (d14 * d14 + d7 * d7 >= p_move_2_ * p_move_2_ + p_move_6_ * p_move_6_) {
                    p_move_2_ = d14;
                    p_move_4_ = d6;
                    p_move_6_ = d7;
                    this.setEntityBoundingBox(axisalignedbb1);
                }
            }
            this.world.theProfiler.endSection();
            this.world.theProfiler.startSection("rest");
            this.resetPositionToBB();
            this.isCollidedHorizontally = d2 != p_move_2_ || d4 != p_move_6_;
            this.isCollidedVertically = d3 != p_move_4_;
            this.onGround = this.isCollidedVertically && d3 < 0.0;
            this.isCollided = this.isCollidedHorizontally || this.isCollidedVertically;
            int j6 = MathHelper.floor(this.posX);
            int i1 = MathHelper.floor(this.posY - (double)0.2f);
            int k6 = MathHelper.floor(this.posZ);
            BlockPos blockpos = new BlockPos(j6, i1, k6);
            IBlockState iblockstate = this.world.getBlockState(blockpos);
            if (iblockstate.getMaterial() == Material.AIR && ((block1 = (iblockstate1 = this.world.getBlockState(blockpos1 = blockpos.down())).getBlock()) instanceof BlockFence || block1 instanceof BlockWall || block1 instanceof BlockFenceGate)) {
                iblockstate = iblockstate1;
                blockpos = blockpos1;
            }
            this.updateFallState(p_move_4_, this.onGround, iblockstate, blockpos);
            if (d2 != p_move_2_) {
                this.motionX = 0.0;
            }
            if (d4 != p_move_6_) {
                this.motionZ = 0.0;
            }
            Block block = iblockstate.getBlock();
            if (d3 != p_move_4_) {
                block.onLanded(this.world, this);
            }
            if (!(!this.canTriggerWalking() || this.onGround && this.isSneaking() && this instanceof EntityPlayer || this.isRiding())) {
                double d15 = this.posX - d10;
                double d16 = this.posY - d11;
                double d17 = this.posZ - d1;
                if (block != Blocks.LADDER) {
                    d16 = 0.0;
                }
                if (block != null && this.onGround) {
                    block.onEntityWalk(this.world, blockpos, this);
                }
                this.distanceWalkedModified = (float)((double)this.distanceWalkedModified + (double)MathHelper.sqrt(d15 * d15 + d17 * d17) * 0.6);
                this.distanceWalkedOnStepModified = (float)((double)this.distanceWalkedOnStepModified + (double)MathHelper.sqrt(d15 * d15 + d16 * d16 + d17 * d17) * 0.6);
                if (this.distanceWalkedOnStepModified > (float)this.nextStepDistance && iblockstate.getMaterial() != Material.AIR) {
                    this.nextStepDistance = (int)this.distanceWalkedOnStepModified + 1;
                    if (this.isInWater()) {
                        Entity entity = this.isBeingRidden() && this.getControllingPassenger() != null ? this.getControllingPassenger() : this;
                        float f = entity == this ? 0.35f : 0.4f;
                        float f1 = MathHelper.sqrt(entity.motionX * entity.motionX * (double)0.2f + entity.motionY * entity.motionY + entity.motionZ * entity.motionZ * (double)0.2f) * f;
                        if (f1 > 1.0f) {
                            f1 = 1.0f;
                        }
                        this.playSound(this.getSwimSound(), f1, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
                    } else {
                        this.playStepSound(blockpos, block);
                    }
                }
            }
            try {
                this.doBlockCollisions();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Checking entity block collision");
                CrashReportCategory crashreportcategory = crashreport.makeCategory("Entity being checked for collision");
                this.addEntityCrashInfo(crashreportcategory);
                throw new ReportedException(crashreport);
            }
            boolean flag1 = this.isWet();
            if (this.world.isFlammableWithin(this.getEntityBoundingBox().contract(0.001))) {
                this.dealFireDamage(1);
                if (!flag1) {
                    ++this.fire;
                    if (this.fire == 0) {
                        this.setFire(8);
                    }
                }
            } else if (this.fire <= 0) {
                this.fire = -this.getFireImmuneTicks();
            }
            if (flag1 && this.isBurning()) {
                this.playSound(SoundEvents.ENTITY_GENERIC_EXTINGUISH_FIRE, 0.7f, 1.6f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
                this.fire = -this.getFireImmuneTicks();
            }
            this.world.theProfiler.endSection();
        }
    }

    public void resetPositionToBB() {
        AxisAlignedBB axisalignedbb = this.getEntityBoundingBox();
        this.posX = (axisalignedbb.minX + axisalignedbb.maxX) / 2.0;
        this.posY = axisalignedbb.minY;
        this.posZ = (axisalignedbb.minZ + axisalignedbb.maxZ) / 2.0;
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.ENTITY_GENERIC_SWIM;
    }

    protected SoundEvent getSplashSound() {
        return SoundEvents.ENTITY_GENERIC_SPLASH;
    }

    protected void doBlockCollisions() {
        AxisAlignedBB axisalignedbb = this.getEntityBoundingBox();
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.retain(axisalignedbb.minX + 0.001, axisalignedbb.minY + 0.001, axisalignedbb.minZ + 0.001);
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos1 = BlockPos.PooledMutableBlockPos.retain(axisalignedbb.maxX - 0.001, axisalignedbb.maxY - 0.001, axisalignedbb.maxZ - 0.001);
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos2 = BlockPos.PooledMutableBlockPos.retain();
        if (this.world.isAreaLoaded((BlockPos)blockpos$pooledmutableblockpos, blockpos$pooledmutableblockpos1)) {
            for (int i = blockpos$pooledmutableblockpos.getX(); i <= blockpos$pooledmutableblockpos1.getX(); ++i) {
                for (int j = blockpos$pooledmutableblockpos.getY(); j <= blockpos$pooledmutableblockpos1.getY(); ++j) {
                    for (int k = blockpos$pooledmutableblockpos.getZ(); k <= blockpos$pooledmutableblockpos1.getZ(); ++k) {
                        blockpos$pooledmutableblockpos2.setPos(i, j, k);
                        IBlockState iblockstate = this.world.getBlockState(blockpos$pooledmutableblockpos2);
                        try {
                            iblockstate.getBlock().onEntityCollidedWithBlock(this.world, blockpos$pooledmutableblockpos2, iblockstate, this);
                            continue;
                        }
                        catch (Throwable throwable) {
                            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Colliding entity with block");
                            CrashReportCategory crashreportcategory = crashreport.makeCategory("Block being collided with");
                            CrashReportCategory.addBlockInfo(crashreportcategory, blockpos$pooledmutableblockpos2, iblockstate);
                            throw new ReportedException(crashreport);
                        }
                    }
                }
            }
        }
        blockpos$pooledmutableblockpos.release();
        blockpos$pooledmutableblockpos1.release();
        blockpos$pooledmutableblockpos2.release();
    }

    protected void playStepSound(BlockPos p_playStepSound_1_, Block p_playStepSound_2_) {
        SoundType soundtype = p_playStepSound_2_.getSoundType(this.world.getBlockState(p_playStepSound_1_), this.world, p_playStepSound_1_, this);
        if (this.world.getBlockState(p_playStepSound_1_.up()).getBlock() == Blocks.SNOW_LAYER) {
            soundtype = Blocks.SNOW_LAYER.getSoundType();
            this.playSound(soundtype.getStepSound(), soundtype.getVolume() * 0.15f, soundtype.getPitch());
        } else if (!p_playStepSound_2_.getDefaultState().getMaterial().isLiquid()) {
            this.playSound(soundtype.getStepSound(), soundtype.getVolume() * 0.15f, soundtype.getPitch());
        }
    }

    public void playSound(SoundEvent p_playSound_1_, float p_playSound_2_, float p_playSound_3_) {
        if (!this.isSilent()) {
            this.world.playSound(null, this.posX, this.posY, this.posZ, p_playSound_1_, this.getSoundCategory(), p_playSound_2_, p_playSound_3_);
        }
    }

    public boolean isSilent() {
        return this.dataManager.get(SILENT);
    }

    public void setSilent(boolean p_setSilent_1_) {
        this.dataManager.set(SILENT, p_setSilent_1_);
    }

    public boolean hasNoGravity() {
        return this.dataManager.get(NO_GRAVITY);
    }

    public void setNoGravity(boolean p_setNoGravity_1_) {
        this.dataManager.set(NO_GRAVITY, p_setNoGravity_1_);
    }

    protected boolean canTriggerWalking() {
        return true;
    }

    protected void updateFallState(double p_updateFallState_1_, boolean p_updateFallState_3_, IBlockState p_updateFallState_4_, BlockPos p_updateFallState_5_) {
        if (p_updateFallState_3_) {
            if (this.fallDistance > 0.0f) {
                p_updateFallState_4_.getBlock().onFallenUpon(this.world, p_updateFallState_5_, this, this.fallDistance);
            }
            this.fallDistance = 0.0f;
        } else if (p_updateFallState_1_ < 0.0) {
            this.fallDistance = (float)((double)this.fallDistance - p_updateFallState_1_);
        }
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox() {
        return null;
    }

    protected void dealFireDamage(int p_dealFireDamage_1_) {
        if (!this.isImmuneToFire) {
            this.attackEntityFrom(DamageSource.IN_FIRE, p_dealFireDamage_1_);
        }
    }

    public final boolean isImmuneToFire() {
        return this.isImmuneToFire;
    }

    public void fall(float p_fall_1_, float p_fall_2_) {
        if (this.isBeingRidden()) {
            for (Entity entity : this.getPassengers()) {
                entity.fall(p_fall_1_, p_fall_2_);
            }
        }
    }

    public boolean isWet() {
        if (this.inWater) {
            return true;
        }
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.retain(this.posX, this.posY, this.posZ);
        if (!this.world.isRainingAt(blockpos$pooledmutableblockpos) && !this.world.isRainingAt(blockpos$pooledmutableblockpos.setPos(this.posX, this.posY + (double)this.height, this.posZ))) {
            blockpos$pooledmutableblockpos.release();
            return false;
        }
        blockpos$pooledmutableblockpos.release();
        return true;
    }

    public boolean isInWater() {
        return this.inWater;
    }

    public boolean handleWaterMovement() {
        if (this.getRidingEntity() instanceof EntityBoat) {
            this.inWater = false;
        } else if (this.world.handleMaterialAcceleration(this.getEntityBoundingBox().expand(0.0, -0.4f, 0.0).contract(0.001), Material.WATER, this)) {
            if (!this.inWater && !this.firstUpdate) {
                this.resetHeight();
            }
            this.fallDistance = 0.0f;
            this.inWater = true;
            this.extinguish();
        } else {
            this.inWater = false;
        }
        return this.inWater;
    }

    protected void resetHeight() {
        Entity entity = this.isBeingRidden() && this.getControllingPassenger() != null ? this.getControllingPassenger() : this;
        float f = entity == this ? 0.2f : 0.9f;
        float f1 = MathHelper.sqrt(entity.motionX * entity.motionX * (double)0.2f + entity.motionY * entity.motionY + entity.motionZ * entity.motionZ * (double)0.2f) * f;
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        this.playSound(this.getSplashSound(), f1, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
        float f2 = MathHelper.floor(this.getEntityBoundingBox().minY);
        int i = 0;
        while ((float)i < 1.0f + this.width * 20.0f) {
            float f3 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
            float f4 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
            this.world.spawnParticle(EnumParticleTypes.WATER_BUBBLE, this.posX + (double)f3, (double)(f2 + 1.0f), this.posZ + (double)f4, this.motionX, this.motionY - (double)(this.rand.nextFloat() * 0.2f), this.motionZ, new int[0]);
            ++i;
        }
        int j = 0;
        while ((float)j < 1.0f + this.width * 20.0f) {
            float f5 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
            float f6 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
            this.world.spawnParticle(EnumParticleTypes.WATER_SPLASH, this.posX + (double)f5, (double)(f2 + 1.0f), this.posZ + (double)f6, this.motionX, this.motionY, this.motionZ, new int[0]);
            ++j;
        }
    }

    public void spawnRunningParticles() {
        if (this.isSprinting() && !this.isInWater()) {
            this.createRunningParticles();
        }
    }

    protected void createRunningParticles() {
        int k;
        int j;
        int i = MathHelper.floor(this.posX);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.floor(this.posY - (double)0.2f), k = MathHelper.floor(this.posZ));
        IBlockState iblockstate = this.world.getBlockState(blockpos);
        if (iblockstate.getRenderType() != EnumBlockRenderType.INVISIBLE) {
            this.world.spawnParticle(EnumParticleTypes.BLOCK_CRACK, this.posX + ((double)this.rand.nextFloat() - 0.5) * (double)this.width, this.getEntityBoundingBox().minY + 0.1, this.posZ + ((double)this.rand.nextFloat() - 0.5) * (double)this.width, -this.motionX * 4.0, 1.5, -this.motionZ * 4.0, Block.getStateId(iblockstate));
        }
    }

    public boolean isInsideOfMaterial(Material p_isInsideOfMaterial_1_) {
        if (this.getRidingEntity() instanceof EntityBoat) {
            return false;
        }
        double d0 = this.posY + (double)this.getEyeHeight();
        BlockPos blockpos = new BlockPos(this.posX, d0, this.posZ);
        IBlockState iblockstate = this.world.getBlockState(blockpos);
        Boolean result = iblockstate.getBlock().isEntityInsideMaterial(this.world, blockpos, iblockstate, this, d0, p_isInsideOfMaterial_1_, true);
        if (result != null) {
            return result;
        }
        if (iblockstate.getMaterial() == p_isInsideOfMaterial_1_) {
            return ForgeHooks.isInsideOfMaterial(p_isInsideOfMaterial_1_, this, blockpos);
        }
        return false;
    }

    public boolean isInLava() {
        return this.world.isMaterialInBB(this.getEntityBoundingBox().expand(-0.1f, -0.4f, -0.1f), Material.LAVA);
    }

    public void moveRelative(float p_moveRelative_1_, float p_moveRelative_2_, float p_moveRelative_3_) {
        float f = p_moveRelative_1_ * p_moveRelative_1_ + p_moveRelative_2_ * p_moveRelative_2_;
        if (f >= 1.0E-4f) {
            if ((f = MathHelper.sqrt(f)) < 1.0f) {
                f = 1.0f;
            }
            f = p_moveRelative_3_ / f;
            float f1 = MathHelper.sin(this.rotationYaw * ((float)Math.PI / 180));
            float f2 = MathHelper.cos(this.rotationYaw * ((float)Math.PI / 180));
            this.motionX += (double)((p_moveRelative_1_ *= f) * f2 - (p_moveRelative_2_ *= f) * f1);
            this.motionZ += (double)(p_moveRelative_2_ * f2 + p_moveRelative_1_ * f1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender(float p_getBrightnessForRender_1_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(MathHelper.floor(this.posX), 0, MathHelper.floor(this.posZ));
        if (this.world.isBlockLoaded(blockpos$mutableblockpos)) {
            blockpos$mutableblockpos.setY(MathHelper.floor(this.posY + (double)this.getEyeHeight()));
            return this.world.getCombinedLight(blockpos$mutableblockpos, 0);
        }
        return 0;
    }

    public float getBrightness(float p_getBrightness_1_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(MathHelper.floor(this.posX), 0, MathHelper.floor(this.posZ));
        if (this.world.isBlockLoaded(blockpos$mutableblockpos)) {
            blockpos$mutableblockpos.setY(MathHelper.floor(this.posY + (double)this.getEyeHeight()));
            return this.world.getLightBrightness(blockpos$mutableblockpos);
        }
        return 0.0f;
    }

    public void setWorld(World p_setWorld_1_) {
        this.world = p_setWorld_1_;
    }

    public void setPositionAndRotation(double p_setPositionAndRotation_1_, double p_setPositionAndRotation_3_, double p_setPositionAndRotation_5_, float p_setPositionAndRotation_7_, float p_setPositionAndRotation_8_) {
        this.posX = MathHelper.clamp(p_setPositionAndRotation_1_, -3.0E7, 3.0E7);
        this.posY = p_setPositionAndRotation_3_;
        this.posZ = MathHelper.clamp(p_setPositionAndRotation_5_, -3.0E7, 3.0E7);
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        p_setPositionAndRotation_8_ = MathHelper.clamp(p_setPositionAndRotation_8_, -90.0f, 90.0f);
        this.rotationYaw = p_setPositionAndRotation_7_;
        this.rotationPitch = p_setPositionAndRotation_8_;
        this.prevRotationYaw = this.rotationYaw;
        this.prevRotationPitch = this.rotationPitch;
        double d0 = this.prevRotationYaw - p_setPositionAndRotation_7_;
        if (d0 < -180.0) {
            this.prevRotationYaw += 360.0f;
        }
        if (d0 >= 180.0) {
            this.prevRotationYaw -= 360.0f;
        }
        this.setPosition(this.posX, this.posY, this.posZ);
        this.setRotation(p_setPositionAndRotation_7_, p_setPositionAndRotation_8_);
    }

    public void moveToBlockPosAndAngles(BlockPos p_moveToBlockPosAndAngles_1_, float p_moveToBlockPosAndAngles_2_, float p_moveToBlockPosAndAngles_3_) {
        this.setLocationAndAngles((double)p_moveToBlockPosAndAngles_1_.getX() + 0.5, p_moveToBlockPosAndAngles_1_.getY(), (double)p_moveToBlockPosAndAngles_1_.getZ() + 0.5, p_moveToBlockPosAndAngles_2_, p_moveToBlockPosAndAngles_3_);
    }

    public void setLocationAndAngles(double p_setLocationAndAngles_1_, double p_setLocationAndAngles_3_, double p_setLocationAndAngles_5_, float p_setLocationAndAngles_7_, float p_setLocationAndAngles_8_) {
        this.posX = p_setLocationAndAngles_1_;
        this.posY = p_setLocationAndAngles_3_;
        this.posZ = p_setLocationAndAngles_5_;
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.lastTickPosX = this.posX;
        this.lastTickPosY = this.posY;
        this.lastTickPosZ = this.posZ;
        this.rotationYaw = p_setLocationAndAngles_7_;
        this.rotationPitch = p_setLocationAndAngles_8_;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    public float getDistanceToEntity(Entity p_getDistanceToEntity_1_) {
        float f = (float)(this.posX - p_getDistanceToEntity_1_.posX);
        float f1 = (float)(this.posY - p_getDistanceToEntity_1_.posY);
        float f2 = (float)(this.posZ - p_getDistanceToEntity_1_.posZ);
        return MathHelper.sqrt(f * f + f1 * f1 + f2 * f2);
    }

    public double getDistanceSq(double p_getDistanceSq_1_, double p_getDistanceSq_3_, double p_getDistanceSq_5_) {
        double d0 = this.posX - p_getDistanceSq_1_;
        double d1 = this.posY - p_getDistanceSq_3_;
        double d2 = this.posZ - p_getDistanceSq_5_;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public double getDistanceSq(BlockPos p_getDistanceSq_1_) {
        return p_getDistanceSq_1_.distanceSq(this.posX, this.posY, this.posZ);
    }

    public double getDistanceSqToCenter(BlockPos p_getDistanceSqToCenter_1_) {
        return p_getDistanceSqToCenter_1_.distanceSqToCenter(this.posX, this.posY, this.posZ);
    }

    public double getDistance(double p_getDistance_1_, double p_getDistance_3_, double p_getDistance_5_) {
        double d0 = this.posX - p_getDistance_1_;
        double d1 = this.posY - p_getDistance_3_;
        double d2 = this.posZ - p_getDistance_5_;
        return MathHelper.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
    }

    public double getDistanceSqToEntity(Entity p_getDistanceSqToEntity_1_) {
        double d0 = this.posX - p_getDistanceSqToEntity_1_.posX;
        double d1 = this.posY - p_getDistanceSqToEntity_1_.posY;
        double d2 = this.posZ - p_getDistanceSqToEntity_1_.posZ;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void onCollideWithPlayer(EntityPlayer p_onCollideWithPlayer_1_) {
    }

    public void applyEntityCollision(Entity p_applyEntityCollision_1_) {
        double d1;
        double d0;
        double d2;
        if (!this.isRidingSameEntity(p_applyEntityCollision_1_) && !p_applyEntityCollision_1_.noClip && !this.noClip && (d2 = MathHelper.absMax(d0 = p_applyEntityCollision_1_.posX - this.posX, d1 = p_applyEntityCollision_1_.posZ - this.posZ)) >= (double)0.01f) {
            d2 = MathHelper.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            d0 *= (double)(1.0f - this.entityCollisionReduction);
            d1 *= (double)(1.0f - this.entityCollisionReduction);
            if (!this.isBeingRidden()) {
                this.addVelocity(-d0, 0.0, -d1);
            }
            if (!p_applyEntityCollision_1_.isBeingRidden()) {
                p_applyEntityCollision_1_.addVelocity(d0, 0.0, d1);
            }
        }
    }

    public void addVelocity(double p_addVelocity_1_, double p_addVelocity_3_, double p_addVelocity_5_) {
        this.motionX += p_addVelocity_1_;
        this.motionY += p_addVelocity_3_;
        this.motionZ += p_addVelocity_5_;
        this.isAirBorne = true;
    }

    protected void setBeenAttacked() {
        this.velocityChanged = true;
    }

    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        if (this.isEntityInvulnerable(p_attackEntityFrom_1_)) {
            return false;
        }
        this.setBeenAttacked();
        return false;
    }

    public Vec3d getLook(float p_getLook_1_) {
        if (p_getLook_1_ == 1.0f) {
            return this.getVectorForRotation(this.rotationPitch, this.rotationYaw);
        }
        float f = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * p_getLook_1_;
        float f1 = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * p_getLook_1_;
        return this.getVectorForRotation(f, f1);
    }

    protected final Vec3d getVectorForRotation(float p_getVectorForRotation_1_, float p_getVectorForRotation_2_) {
        float f = MathHelper.cos(-p_getVectorForRotation_2_ * ((float)Math.PI / 180) - (float)Math.PI);
        float f1 = MathHelper.sin(-p_getVectorForRotation_2_ * ((float)Math.PI / 180) - (float)Math.PI);
        float f2 = -MathHelper.cos(-p_getVectorForRotation_1_ * ((float)Math.PI / 180));
        float f3 = MathHelper.sin(-p_getVectorForRotation_1_ * ((float)Math.PI / 180));
        return new Vec3d(f1 * f2, f3, f * f2);
    }

    public Vec3d getPositionEyes(float p_getPositionEyes_1_) {
        if (p_getPositionEyes_1_ == 1.0f) {
            return new Vec3d(this.posX, this.posY + (double)this.getEyeHeight(), this.posZ);
        }
        double d0 = this.prevPosX + (this.posX - this.prevPosX) * (double)p_getPositionEyes_1_;
        double d1 = this.prevPosY + (this.posY - this.prevPosY) * (double)p_getPositionEyes_1_ + (double)this.getEyeHeight();
        double d2 = this.prevPosZ + (this.posZ - this.prevPosZ) * (double)p_getPositionEyes_1_;
        return new Vec3d(d0, d1, d2);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public RayTraceResult rayTrace(double p_rayTrace_1_, float p_rayTrace_3_) {
        Vec3d vec3d = this.getPositionEyes(p_rayTrace_3_);
        Vec3d vec3d1 = this.getLook(p_rayTrace_3_);
        Vec3d vec3d2 = vec3d.addVector(vec3d1.xCoord * p_rayTrace_1_, vec3d1.yCoord * p_rayTrace_1_, vec3d1.zCoord * p_rayTrace_1_);
        return this.world.rayTraceBlocks(vec3d, vec3d2, false, false, true);
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean canBePushed() {
        return false;
    }

    public void addToPlayerScore(Entity p_addToPlayerScore_1_, int p_addToPlayerScore_2_) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRender3d(double p_isInRangeToRender3d_1_, double p_isInRangeToRender3d_3_, double p_isInRangeToRender3d_5_) {
        double d0 = this.posX - p_isInRangeToRender3d_1_;
        double d1 = this.posY - p_isInRangeToRender3d_3_;
        double d2 = this.posZ - p_isInRangeToRender3d_5_;
        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
        return this.isInRangeToRenderDist(d3);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double p_isInRangeToRenderDist_1_) {
        double d0 = this.getEntityBoundingBox().getAverageEdgeLength();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return p_isInRangeToRenderDist_1_ < (d0 = d0 * 64.0 * renderDistanceWeight) * d0;
    }

    public boolean writeToNBTAtomically(NBTTagCompound p_writeToNBTAtomically_1_) {
        String s = this.getEntityString();
        if (!this.isDead && s != null) {
            p_writeToNBTAtomically_1_.setString("id", s);
            this.writeToNBT(p_writeToNBTAtomically_1_);
            return true;
        }
        return false;
    }

    public boolean writeToNBTOptional(NBTTagCompound p_writeToNBTOptional_1_) {
        String s = this.getEntityString();
        if (!this.isDead && s != null && !this.isRiding()) {
            p_writeToNBTOptional_1_.setString("id", s);
            this.writeToNBT(p_writeToNBTOptional_1_);
            return true;
        }
        return false;
    }

    public static void registerFixes(DataFixer p_registerFixes_0_) {
        p_registerFixes_0_.registerWalker(FixTypes.ENTITY, new IDataWalker(){

            @Override
            public NBTTagCompound process(IDataFixer p_process_1_, NBTTagCompound p_process_2_, int p_process_3_) {
                if (p_process_2_.hasKey("Passengers", 9)) {
                    NBTTagList nbttaglist = p_process_2_.getTagList("Passengers", 10);
                    for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                        nbttaglist.set(i, p_process_1_.process(FixTypes.ENTITY, nbttaglist.getCompoundTagAt(i), p_process_3_));
                    }
                }
                return p_process_2_;
            }
        });
    }

    public NBTTagCompound writeToNBT(NBTTagCompound p_writeToNBT_1_) {
        try {
            p_writeToNBT_1_.setTag("Pos", this.newDoubleNBTList(this.posX, this.posY, this.posZ));
            p_writeToNBT_1_.setTag("Motion", this.newDoubleNBTList(this.motionX, this.motionY, this.motionZ));
            p_writeToNBT_1_.setTag("Rotation", this.newFloatNBTList(this.rotationYaw, this.rotationPitch));
            p_writeToNBT_1_.setFloat("FallDistance", this.fallDistance);
            p_writeToNBT_1_.setShort("Fire", (short)this.fire);
            p_writeToNBT_1_.setShort("Air", (short)this.getAir());
            p_writeToNBT_1_.setBoolean("OnGround", this.onGround);
            p_writeToNBT_1_.setInteger("Dimension", this.dimension);
            p_writeToNBT_1_.setBoolean("Invulnerable", this.invulnerable);
            p_writeToNBT_1_.setInteger("PortalCooldown", this.timeUntilPortal);
            p_writeToNBT_1_.setUniqueId("UUID", this.getUniqueID());
            if (this.hasCustomName()) {
                p_writeToNBT_1_.setString("CustomName", this.getCustomNameTag());
            }
            if (this.getAlwaysRenderNameTag()) {
                p_writeToNBT_1_.setBoolean("CustomNameVisible", this.getAlwaysRenderNameTag());
            }
            this.cmdResultStats.writeStatsToNBT(p_writeToNBT_1_);
            if (this.isSilent()) {
                p_writeToNBT_1_.setBoolean("Silent", this.isSilent());
            }
            if (this.hasNoGravity()) {
                p_writeToNBT_1_.setBoolean("NoGravity", this.hasNoGravity());
            }
            if (this.glowing) {
                p_writeToNBT_1_.setBoolean("Glowing", this.glowing);
            }
            if (this.tags.size() > 0) {
                NBTTagList nbttaglist = new NBTTagList();
                for (String s : this.tags) {
                    nbttaglist.appendTag(new NBTTagString(s));
                }
                p_writeToNBT_1_.setTag("Tags", nbttaglist);
            }
            if (this.customEntityData != null) {
                p_writeToNBT_1_.setTag("ForgeData", this.customEntityData);
            }
            if (this.capabilities != null) {
                p_writeToNBT_1_.setTag("ForgeCaps", this.capabilities.serializeNBT());
            }
            this.writeEntityToNBT(p_writeToNBT_1_);
            if (this.isBeingRidden()) {
                NBTTagList nbttaglist1 = new NBTTagList();
                for (Entity entity : this.getPassengers()) {
                    NBTTagCompound nbttagcompound;
                    if (!entity.writeToNBTAtomically(nbttagcompound = new NBTTagCompound())) continue;
                    nbttaglist1.appendTag(nbttagcompound);
                }
                if (!nbttaglist1.hasNoTags()) {
                    p_writeToNBT_1_.setTag("Passengers", nbttaglist1);
                }
            }
            return p_writeToNBT_1_;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Saving entity NBT");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Entity being saved");
            this.addEntityCrashInfo(crashreportcategory);
            throw new ReportedException(crashreport);
        }
    }

    public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
        try {
            NBTTagList nbttaglist = p_readFromNBT_1_.getTagList("Pos", 6);
            NBTTagList nbttaglist2 = p_readFromNBT_1_.getTagList("Motion", 6);
            NBTTagList nbttaglist3 = p_readFromNBT_1_.getTagList("Rotation", 5);
            this.motionX = nbttaglist2.getDoubleAt(0);
            this.motionY = nbttaglist2.getDoubleAt(1);
            this.motionZ = nbttaglist2.getDoubleAt(2);
            if (Math.abs(this.motionX) > 10.0) {
                this.motionX = 0.0;
            }
            if (Math.abs(this.motionY) > 10.0) {
                this.motionY = 0.0;
            }
            if (Math.abs(this.motionZ) > 10.0) {
                this.motionZ = 0.0;
            }
            this.posX = nbttaglist.getDoubleAt(0);
            this.posY = nbttaglist.getDoubleAt(1);
            this.posZ = nbttaglist.getDoubleAt(2);
            this.lastTickPosX = this.posX;
            this.lastTickPosY = this.posY;
            this.lastTickPosZ = this.posZ;
            this.prevPosX = this.posX;
            this.prevPosY = this.posY;
            this.prevPosZ = this.posZ;
            this.rotationYaw = nbttaglist3.getFloatAt(0);
            this.rotationPitch = nbttaglist3.getFloatAt(1);
            this.prevRotationYaw = this.rotationYaw;
            this.prevRotationPitch = this.rotationPitch;
            this.setRotationYawHead(this.rotationYaw);
            this.setRenderYawOffset(this.rotationYaw);
            this.fallDistance = p_readFromNBT_1_.getFloat("FallDistance");
            this.fire = p_readFromNBT_1_.getShort("Fire");
            this.setAir(p_readFromNBT_1_.getShort("Air"));
            this.onGround = p_readFromNBT_1_.getBoolean("OnGround");
            if (p_readFromNBT_1_.hasKey("Dimension")) {
                this.dimension = p_readFromNBT_1_.getInteger("Dimension");
            }
            this.invulnerable = p_readFromNBT_1_.getBoolean("Invulnerable");
            this.timeUntilPortal = p_readFromNBT_1_.getInteger("PortalCooldown");
            if (p_readFromNBT_1_.hasUniqueId("UUID")) {
                this.entityUniqueID = p_readFromNBT_1_.getUniqueId("UUID");
                this.cachedUniqueIdString = this.entityUniqueID.toString();
            }
            this.setPosition(this.posX, this.posY, this.posZ);
            this.setRotation(this.rotationYaw, this.rotationPitch);
            if (p_readFromNBT_1_.hasKey("CustomName", 8)) {
                this.setCustomNameTag(p_readFromNBT_1_.getString("CustomName"));
            }
            this.setAlwaysRenderNameTag(p_readFromNBT_1_.getBoolean("CustomNameVisible"));
            this.cmdResultStats.readStatsFromNBT(p_readFromNBT_1_);
            this.setSilent(p_readFromNBT_1_.getBoolean("Silent"));
            this.setNoGravity(p_readFromNBT_1_.getBoolean("NoGravity"));
            this.setGlowing(p_readFromNBT_1_.getBoolean("Glowing"));
            if (p_readFromNBT_1_.hasKey("ForgeData")) {
                this.customEntityData = p_readFromNBT_1_.getCompoundTag("ForgeData");
            }
            if (this.capabilities != null && p_readFromNBT_1_.hasKey("ForgeCaps")) {
                this.capabilities.deserializeNBT(p_readFromNBT_1_.getCompoundTag("ForgeCaps"));
            }
            if (p_readFromNBT_1_.hasKey("Tags", 9)) {
                this.tags.clear();
                NBTTagList nbttaglist1 = p_readFromNBT_1_.getTagList("Tags", 8);
                int i = Math.min(nbttaglist1.tagCount(), 1024);
                for (int j = 0; j < i; ++j) {
                    this.tags.add(nbttaglist1.getStringTagAt(j));
                }
            }
            this.readEntityFromNBT(p_readFromNBT_1_);
            if (this.shouldSetPosAfterLoading()) {
                this.setPosition(this.posX, this.posY, this.posZ);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Loading entity NBT");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Entity being loaded");
            this.addEntityCrashInfo(crashreportcategory);
            throw new ReportedException(crashreport);
        }
    }

    protected boolean shouldSetPosAfterLoading() {
        return true;
    }

    @Nullable
    protected final String getEntityString() {
        ResourceLocation resourcelocation = EntityList.getKey(this);
        return resourcelocation == null ? null : resourcelocation.toString();
    }

    protected abstract void readEntityFromNBT(NBTTagCompound var1);

    protected abstract void writeEntityToNBT(NBTTagCompound var1);

    protected NBTTagList newDoubleNBTList(double ... p_newDoubleNBTList_1_) {
        NBTTagList nbttaglist = new NBTTagList();
        for (double d0 : p_newDoubleNBTList_1_) {
            nbttaglist.appendTag(new NBTTagDouble(d0));
        }
        return nbttaglist;
    }

    protected NBTTagList newFloatNBTList(float ... p_newFloatNBTList_1_) {
        NBTTagList nbttaglist = new NBTTagList();
        for (float f : p_newFloatNBTList_1_) {
            nbttaglist.appendTag(new NBTTagFloat(f));
        }
        return nbttaglist;
    }

    @Nullable
    public EntityItem dropItem(Item p_dropItem_1_, int p_dropItem_2_) {
        return this.dropItemWithOffset(p_dropItem_1_, p_dropItem_2_, 0.0f);
    }

    @Nullable
    public EntityItem dropItemWithOffset(Item p_dropItemWithOffset_1_, int p_dropItemWithOffset_2_, float p_dropItemWithOffset_3_) {
        return this.entityDropItem(new ItemStack(p_dropItemWithOffset_1_, p_dropItemWithOffset_2_, 0), p_dropItemWithOffset_3_);
    }

    @Nullable
    public EntityItem entityDropItem(ItemStack p_entityDropItem_1_, float p_entityDropItem_2_) {
        if (p_entityDropItem_1_.isEmpty()) {
            return null;
        }
        EntityItem entityitem = new EntityItem(this.world, this.posX, this.posY + (double)p_entityDropItem_2_, this.posZ, p_entityDropItem_1_);
        entityitem.setDefaultPickupDelay();
        if (this.captureDrops) {
            this.capturedDrops.add(entityitem);
        } else {
            this.world.spawnEntity(entityitem);
        }
        return entityitem;
    }

    public boolean isEntityAlive() {
        return !this.isDead;
    }

    public boolean isEntityInsideOpaqueBlock() {
        if (this.noClip) {
            return false;
        }
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.retain();
        for (int i = 0; i < 8; ++i) {
            int j = MathHelper.floor(this.posY + (double)(((float)((i >> 0) % 2) - 0.5f) * 0.1f) + (double)this.getEyeHeight());
            int k = MathHelper.floor(this.posX + (double)(((float)((i >> 1) % 2) - 0.5f) * this.width * 0.8f));
            int l = MathHelper.floor(this.posZ + (double)(((float)((i >> 2) % 2) - 0.5f) * this.width * 0.8f));
            if (blockpos$pooledmutableblockpos.getX() == k && blockpos$pooledmutableblockpos.getY() == j && blockpos$pooledmutableblockpos.getZ() == l) continue;
            blockpos$pooledmutableblockpos.setPos(k, j, l);
            if (!this.world.getBlockState(blockpos$pooledmutableblockpos).causesSuffocation()) continue;
            blockpos$pooledmutableblockpos.release();
            return true;
        }
        blockpos$pooledmutableblockpos.release();
        return false;
    }

    public boolean processInitialInteract(EntityPlayer p_processInitialInteract_1_, EnumHand p_processInitialInteract_2_) {
        return false;
    }

    @Nullable
    public AxisAlignedBB getCollisionBox(Entity p_getCollisionBox_1_) {
        return null;
    }

    public void updateRidden() {
        Entity entity = this.getRidingEntity();
        if (this.isRiding() && entity.isDead) {
            this.dismountRidingEntity();
        } else {
            this.motionX = 0.0;
            this.motionY = 0.0;
            this.motionZ = 0.0;
            this.onUpdate();
            if (this.isRiding()) {
                entity.updatePassenger(this);
            }
        }
    }

    public void updatePassenger(Entity p_updatePassenger_1_) {
        if (this.isPassenger(p_updatePassenger_1_)) {
            p_updatePassenger_1_.setPosition(this.posX, this.posY + this.getMountedYOffset() + p_updatePassenger_1_.getYOffset(), this.posZ);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void applyOrientationToEntity(Entity p_applyOrientationToEntity_1_) {
    }

    public double getYOffset() {
        return 0.0;
    }

    public double getMountedYOffset() {
        return (double)this.height * 0.75;
    }

    public boolean startRiding(Entity p_startRiding_1_) {
        return this.startRiding(p_startRiding_1_, false);
    }

    public boolean startRiding(Entity p_startRiding_1_, boolean p_startRiding_2_) {
        Entity entity = p_startRiding_1_;
        while (entity.ridingEntity != null) {
            if (entity.ridingEntity == this) {
                return false;
            }
            entity = entity.ridingEntity;
        }
        if (!ForgeEventFactory.canMountEntity(this, p_startRiding_1_, true)) {
            return false;
        }
        if (p_startRiding_2_ || this.canBeRidden(p_startRiding_1_) && p_startRiding_1_.canFitPassenger(this)) {
            if (this.isRiding()) {
                this.dismountRidingEntity();
            }
            this.ridingEntity = p_startRiding_1_;
            this.ridingEntity.addPassenger(this);
            return true;
        }
        return false;
    }

    protected boolean canBeRidden(Entity p_canBeRidden_1_) {
        return this.rideCooldown <= 0;
    }

    public void removePassengers() {
        for (int i = this.riddenByEntities.size() - 1; i >= 0; --i) {
            this.riddenByEntities.get(i).dismountRidingEntity();
        }
    }

    public void dismountRidingEntity() {
        if (this.ridingEntity != null) {
            Entity entity = this.ridingEntity;
            if (!ForgeEventFactory.canMountEntity(this, entity, false)) {
                return;
            }
            this.ridingEntity = null;
            entity.removePassenger(this);
        }
    }

    protected void addPassenger(Entity p_addPassenger_1_) {
        if (p_addPassenger_1_.getRidingEntity() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (!this.world.isRemote && p_addPassenger_1_ instanceof EntityPlayer && !(this.getControllingPassenger() instanceof EntityPlayer)) {
            this.riddenByEntities.add(0, p_addPassenger_1_);
        } else {
            this.riddenByEntities.add(p_addPassenger_1_);
        }
    }

    protected void removePassenger(Entity p_removePassenger_1_) {
        if (p_removePassenger_1_.getRidingEntity() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        this.riddenByEntities.remove(p_removePassenger_1_);
        p_removePassenger_1_.rideCooldown = 60;
    }

    protected boolean canFitPassenger(Entity p_canFitPassenger_1_) {
        return this.getPassengers().size() < 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotationDirect(double p_setPositionAndRotationDirect_1_, double p_setPositionAndRotationDirect_3_, double p_setPositionAndRotationDirect_5_, float p_setPositionAndRotationDirect_7_, float p_setPositionAndRotationDirect_8_, int p_setPositionAndRotationDirect_9_, boolean p_setPositionAndRotationDirect_10_) {
        this.setPosition(p_setPositionAndRotationDirect_1_, p_setPositionAndRotationDirect_3_, p_setPositionAndRotationDirect_5_);
        this.setRotation(p_setPositionAndRotationDirect_7_, p_setPositionAndRotationDirect_8_);
    }

    public float getCollisionBorderSize() {
        return 0.0f;
    }

    public Vec3d getLookVec() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec2f getPitchYaw() {
        Vec2f vec2f = new Vec2f(this.rotationPitch, this.rotationYaw);
        return vec2f;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getForward() {
        return Vec3d.fromPitchYawVector(this.getPitchYaw());
    }

    public void setPortal(BlockPos p_setPortal_1_) {
        if (this.timeUntilPortal > 0) {
            this.timeUntilPortal = this.getPortalCooldown();
        } else {
            if (!this.world.isRemote && !p_setPortal_1_.equals(this.lastPortalPos)) {
                this.lastPortalPos = new BlockPos(p_setPortal_1_);
                BlockPattern.PatternHelper blockpattern$patternhelper = Blocks.PORTAL.createPatternHelper(this.world, this.lastPortalPos);
                double d0 = blockpattern$patternhelper.getForwards().getAxis() == EnumFacing.Axis.X ? (double)blockpattern$patternhelper.getFrontTopLeft().getZ() : (double)blockpattern$patternhelper.getFrontTopLeft().getX();
                double d1 = blockpattern$patternhelper.getForwards().getAxis() == EnumFacing.Axis.X ? this.posZ : this.posX;
                d1 = Math.abs(MathHelper.pct(d1 - (double)(blockpattern$patternhelper.getForwards().rotateY().getAxisDirection() == EnumFacing.AxisDirection.NEGATIVE ? 1 : 0), d0, d0 - (double)blockpattern$patternhelper.getWidth()));
                double d2 = MathHelper.pct(this.posY - 1.0, blockpattern$patternhelper.getFrontTopLeft().getY(), blockpattern$patternhelper.getFrontTopLeft().getY() - blockpattern$patternhelper.getHeight());
                this.lastPortalVec = new Vec3d(d1, d2, 0.0);
                this.teleportDirection = blockpattern$patternhelper.getForwards();
            }
            this.inPortal = true;
        }
    }

    public int getPortalCooldown() {
        return 300;
    }

    @SideOnly(value=Side.CLIENT)
    public void setVelocity(double p_setVelocity_1_, double p_setVelocity_3_, double p_setVelocity_5_) {
        this.motionX = p_setVelocity_1_;
        this.motionY = p_setVelocity_3_;
        this.motionZ = p_setVelocity_5_;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte p_handleStatusUpdate_1_) {
    }

    @SideOnly(value=Side.CLIENT)
    public void performHurtAnimation() {
    }

    public Iterable<ItemStack> getHeldEquipment() {
        return EMPTY_EQUIPMENT;
    }

    public Iterable<ItemStack> getArmorInventoryList() {
        return EMPTY_EQUIPMENT;
    }

    public Iterable<ItemStack> getEquipmentAndArmor() {
        return Iterables.concat(this.getHeldEquipment(), this.getArmorInventoryList());
    }

    public void setItemStackToSlot(EntityEquipmentSlot p_setItemStackToSlot_1_, ItemStack p_setItemStackToSlot_2_) {
    }

    public boolean isBurning() {
        boolean flag = this.world != null && this.world.isRemote;
        return !this.isImmuneToFire && (this.fire > 0 || flag && this.getFlag(0));
    }

    public boolean isRiding() {
        return this.getRidingEntity() != null;
    }

    public boolean isBeingRidden() {
        return !this.getPassengers().isEmpty();
    }

    public boolean isSneaking() {
        return this.getFlag(1);
    }

    public void setSneaking(boolean p_setSneaking_1_) {
        this.setFlag(1, p_setSneaking_1_);
    }

    public boolean isSprinting() {
        return this.getFlag(3);
    }

    public void setSprinting(boolean p_setSprinting_1_) {
        this.setFlag(3, p_setSprinting_1_);
    }

    public boolean isGlowing() {
        return this.glowing || this.world.isRemote && this.getFlag(6);
    }

    public void setGlowing(boolean p_setGlowing_1_) {
        this.glowing = p_setGlowing_1_;
        if (!this.world.isRemote) {
            this.setFlag(6, this.glowing);
        }
    }

    public boolean isInvisible() {
        return this.getFlag(5);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInvisibleToPlayer(EntityPlayer p_isInvisibleToPlayer_1_) {
        if (p_isInvisibleToPlayer_1_.isSpectator()) {
            return false;
        }
        Team team = this.getTeam();
        return team != null && p_isInvisibleToPlayer_1_ != null && p_isInvisibleToPlayer_1_.getTeam() == team && team.getSeeFriendlyInvisiblesEnabled() ? false : this.isInvisible();
    }

    @Nullable
    public Team getTeam() {
        return this.world.getScoreboard().getPlayersTeam(this.getCachedUniqueIdString());
    }

    public boolean isOnSameTeam(Entity p_isOnSameTeam_1_) {
        return this.isOnScoreboardTeam(p_isOnSameTeam_1_.getTeam());
    }

    public boolean isOnScoreboardTeam(Team p_isOnScoreboardTeam_1_) {
        return this.getTeam() != null ? this.getTeam().isSameTeam(p_isOnScoreboardTeam_1_) : false;
    }

    public void setInvisible(boolean p_setInvisible_1_) {
        this.setFlag(5, p_setInvisible_1_);
    }

    protected boolean getFlag(int p_getFlag_1_) {
        return (this.dataManager.get(FLAGS) & 1 << p_getFlag_1_) != 0;
    }

    protected void setFlag(int p_setFlag_1_, boolean p_setFlag_2_) {
        byte b0 = this.dataManager.get(FLAGS);
        if (p_setFlag_2_) {
            this.dataManager.set(FLAGS, (byte)(b0 | 1 << p_setFlag_1_));
        } else {
            this.dataManager.set(FLAGS, (byte)(b0 & ~(1 << p_setFlag_1_)));
        }
    }

    public int getAir() {
        return this.dataManager.get(AIR);
    }

    public void setAir(int p_setAir_1_) {
        this.dataManager.set(AIR, p_setAir_1_);
    }

    public void onStruckByLightning(EntityLightningBolt p_onStruckByLightning_1_) {
        this.attackEntityFrom(DamageSource.LIGHTNING_BOLT, 5.0f);
        ++this.fire;
        if (this.fire == 0) {
            this.setFire(8);
        }
    }

    public void onKillEntity(EntityLivingBase p_onKillEntity_1_) {
    }

    protected boolean pushOutOfBlocks(double p_pushOutOfBlocks_1_, double p_pushOutOfBlocks_3_, double p_pushOutOfBlocks_5_) {
        BlockPos blockpos = new BlockPos(p_pushOutOfBlocks_1_, p_pushOutOfBlocks_3_, p_pushOutOfBlocks_5_);
        double d0 = p_pushOutOfBlocks_1_ - (double)blockpos.getX();
        double d1 = p_pushOutOfBlocks_3_ - (double)blockpos.getY();
        double d2 = p_pushOutOfBlocks_5_ - (double)blockpos.getZ();
        if (!this.world.collidesWithAnyBlock(this.getEntityBoundingBox())) {
            return false;
        }
        EnumFacing enumfacing = EnumFacing.UP;
        double d3 = Double.MAX_VALUE;
        if (!this.world.isBlockFullCube(blockpos.west()) && d0 < d3) {
            d3 = d0;
            enumfacing = EnumFacing.WEST;
        }
        if (!this.world.isBlockFullCube(blockpos.east()) && 1.0 - d0 < d3) {
            d3 = 1.0 - d0;
            enumfacing = EnumFacing.EAST;
        }
        if (!this.world.isBlockFullCube(blockpos.north()) && d2 < d3) {
            d3 = d2;
            enumfacing = EnumFacing.NORTH;
        }
        if (!this.world.isBlockFullCube(blockpos.south()) && 1.0 - d2 < d3) {
            d3 = 1.0 - d2;
            enumfacing = EnumFacing.SOUTH;
        }
        if (!this.world.isBlockFullCube(blockpos.up()) && 1.0 - d1 < d3) {
            d3 = 1.0 - d1;
            enumfacing = EnumFacing.UP;
        }
        float f = this.rand.nextFloat() * 0.2f + 0.1f;
        float f1 = enumfacing.getAxisDirection().getOffset();
        if (enumfacing.getAxis() == EnumFacing.Axis.X) {
            this.motionX = f1 * f;
            this.motionY *= 0.75;
            this.motionZ *= 0.75;
        } else if (enumfacing.getAxis() == EnumFacing.Axis.Y) {
            this.motionX *= 0.75;
            this.motionY = f1 * f;
            this.motionZ *= 0.75;
        } else if (enumfacing.getAxis() == EnumFacing.Axis.Z) {
            this.motionX *= 0.75;
            this.motionY *= 0.75;
            this.motionZ = f1 * f;
        }
        return true;
    }

    public void setInWeb() {
        this.isInWeb = true;
        this.fallDistance = 0.0f;
    }

    @Override
    public String getName() {
        if (this.hasCustomName()) {
            return this.getCustomNameTag();
        }
        String s = EntityList.getEntityString(this);
        if (s == null) {
            s = "generic";
        }
        return I18n.translateToLocal("entity." + s + ".name");
    }

    @Nullable
    public Entity[] getParts() {
        return null;
    }

    public boolean isEntityEqual(Entity p_isEntityEqual_1_) {
        return this == p_isEntityEqual_1_;
    }

    public float getRotationYawHead() {
        return 0.0f;
    }

    public void setRotationYawHead(float p_setRotationYawHead_1_) {
    }

    public void setRenderYawOffset(float p_setRenderYawOffset_1_) {
    }

    public boolean canBeAttackedWithItem() {
        return true;
    }

    public boolean hitByEntity(Entity p_hitByEntity_1_) {
        return false;
    }

    public String toString() {
        return String.format("%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f]", this.getClass().getSimpleName(), this.getName(), this.entityId, this.world == null ? "~NULL~" : this.world.getWorldInfo().getWorldName(), this.posX, this.posY, this.posZ);
    }

    public boolean isEntityInvulnerable(DamageSource p_isEntityInvulnerable_1_) {
        return this.invulnerable && p_isEntityInvulnerable_1_ != DamageSource.OUT_OF_WORLD && !p_isEntityInvulnerable_1_.isCreativePlayer();
    }

    public boolean getIsInvulnerable() {
        return this.invulnerable;
    }

    public void setEntityInvulnerable(boolean p_setEntityInvulnerable_1_) {
        this.invulnerable = p_setEntityInvulnerable_1_;
    }

    public void copyLocationAndAnglesFrom(Entity p_copyLocationAndAnglesFrom_1_) {
        this.setLocationAndAngles(p_copyLocationAndAnglesFrom_1_.posX, p_copyLocationAndAnglesFrom_1_.posY, p_copyLocationAndAnglesFrom_1_.posZ, p_copyLocationAndAnglesFrom_1_.rotationYaw, p_copyLocationAndAnglesFrom_1_.rotationPitch);
    }

    private void copyDataFromOld(Entity p_copyDataFromOld_1_) {
        NBTTagCompound nbttagcompound = p_copyDataFromOld_1_.writeToNBT(new NBTTagCompound());
        nbttagcompound.removeTag("Dimension");
        this.readFromNBT(nbttagcompound);
        this.timeUntilPortal = p_copyDataFromOld_1_.timeUntilPortal;
        this.lastPortalPos = p_copyDataFromOld_1_.lastPortalPos;
        this.lastPortalVec = p_copyDataFromOld_1_.lastPortalVec;
        this.teleportDirection = p_copyDataFromOld_1_.teleportDirection;
    }

    @Nullable
    public Entity changeDimension(int p_changeDimension_1_) {
        if (!this.world.isRemote && !this.isDead) {
            BlockPos blockpos;
            if (!ForgeHooks.onTravelToDimension(this, p_changeDimension_1_)) {
                return null;
            }
            this.world.theProfiler.startSection("changeDimension");
            MinecraftServer minecraftserver = this.getServer();
            int i = this.dimension;
            WorldServer worldserver = minecraftserver.worldServerForDimension(i);
            WorldServer worldserver1 = minecraftserver.worldServerForDimension(p_changeDimension_1_);
            this.dimension = p_changeDimension_1_;
            if (i == 1 && p_changeDimension_1_ == 1) {
                worldserver1 = minecraftserver.worldServerForDimension(0);
                this.dimension = 0;
            }
            this.world.removeEntity(this);
            this.isDead = false;
            this.world.theProfiler.startSection("reposition");
            if (p_changeDimension_1_ == 1) {
                blockpos = worldserver1.getSpawnCoordinate();
            } else {
                double d0 = this.posX;
                double d1 = this.posZ;
                double d2 = 8.0;
                if (p_changeDimension_1_ == -1) {
                    d0 = MathHelper.clamp(d0 / 8.0, worldserver1.getWorldBorder().minX() + 16.0, worldserver1.getWorldBorder().maxX() - 16.0);
                    d1 = MathHelper.clamp(d1 / 8.0, worldserver1.getWorldBorder().minZ() + 16.0, worldserver1.getWorldBorder().maxZ() - 16.0);
                } else if (p_changeDimension_1_ == 0) {
                    d0 = MathHelper.clamp(d0 * 8.0, worldserver1.getWorldBorder().minX() + 16.0, worldserver1.getWorldBorder().maxX() - 16.0);
                    d1 = MathHelper.clamp(d1 * 8.0, worldserver1.getWorldBorder().minZ() + 16.0, worldserver1.getWorldBorder().maxZ() - 16.0);
                }
                d0 = MathHelper.clamp((int)d0, -29999872, 29999872);
                d1 = MathHelper.clamp((int)d1, -29999872, 29999872);
                float f = this.rotationYaw;
                this.setLocationAndAngles(d0, this.posY, d1, 90.0f, 0.0f);
                Teleporter teleporter = worldserver1.getDefaultTeleporter();
                teleporter.placeInExistingPortal(this, f);
                blockpos = new BlockPos(this);
            }
            worldserver.updateEntityWithOptionalForce(this, false);
            this.world.theProfiler.endStartSection("reloading");
            Entity entity = EntityList.newEntity(this.getClass(), worldserver1);
            if (entity != null) {
                entity.copyDataFromOld(this);
                if (i == 1 && p_changeDimension_1_ == 1) {
                    BlockPos blockpos1 = worldserver1.getTopSolidOrLiquidBlock(worldserver1.getSpawnPoint());
                    entity.moveToBlockPosAndAngles(blockpos1, entity.rotationYaw, entity.rotationPitch);
                } else {
                    entity.moveToBlockPosAndAngles(blockpos, entity.rotationYaw, entity.rotationPitch);
                }
                boolean flag = entity.forceSpawn;
                entity.forceSpawn = true;
                worldserver1.spawnEntity(entity);
                entity.forceSpawn = flag;
                worldserver1.updateEntityWithOptionalForce(entity, false);
            }
            this.isDead = true;
            this.world.theProfiler.endSection();
            worldserver.resetUpdateEntityTick();
            worldserver1.resetUpdateEntityTick();
            this.world.theProfiler.endSection();
            return entity;
        }
        return null;
    }

    public boolean isNonBoss() {
        return true;
    }

    public float getExplosionResistance(Explosion p_getExplosionResistance_1_, World p_getExplosionResistance_2_, BlockPos p_getExplosionResistance_3_, IBlockState p_getExplosionResistance_4_) {
        return p_getExplosionResistance_4_.getBlock().getExplosionResistance(p_getExplosionResistance_2_, p_getExplosionResistance_3_, this, p_getExplosionResistance_1_);
    }

    public boolean verifyExplosion(Explosion p_verifyExplosion_1_, World p_verifyExplosion_2_, BlockPos p_verifyExplosion_3_, IBlockState p_verifyExplosion_4_, float p_verifyExplosion_5_) {
        return true;
    }

    public int getMaxFallHeight() {
        return 3;
    }

    public Vec3d getLastPortalVec() {
        return this.lastPortalVec;
    }

    public EnumFacing getTeleportDirection() {
        return this.teleportDirection;
    }

    public boolean doesEntityNotTriggerPressurePlate() {
        return false;
    }

    public void addEntityCrashInfo(CrashReportCategory p_addEntityCrashInfo_1_) {
        p_addEntityCrashInfo_1_.setDetail("Entity Type", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                return EntityList.getKey(Entity.this) + " (" + Entity.this.getClass().getCanonicalName() + ")";
            }
        });
        p_addEntityCrashInfo_1_.addCrashSection("Entity ID", this.entityId);
        p_addEntityCrashInfo_1_.setDetail("Entity Name", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                return Entity.this.getName();
            }
        });
        p_addEntityCrashInfo_1_.addCrashSection("Entity's Exact location", String.format("%.2f, %.2f, %.2f", this.posX, this.posY, this.posZ));
        p_addEntityCrashInfo_1_.addCrashSection("Entity's Block location", CrashReportCategory.getCoordinateInfo(MathHelper.floor(this.posX), MathHelper.floor(this.posY), MathHelper.floor(this.posZ)));
        p_addEntityCrashInfo_1_.addCrashSection("Entity's Momentum", String.format("%.2f, %.2f, %.2f", this.motionX, this.motionY, this.motionZ));
        p_addEntityCrashInfo_1_.setDetail("Entity's Passengers", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                return Entity.this.getPassengers().toString();
            }
        });
        p_addEntityCrashInfo_1_.setDetail("Entity's Vehicle", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                return Entity.this.getRidingEntity().toString();
            }
        });
    }

    public void setUniqueId(UUID p_setUniqueId_1_) {
        this.entityUniqueID = p_setUniqueId_1_;
        this.cachedUniqueIdString = this.entityUniqueID.toString();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderOnFire() {
        return this.isBurning();
    }

    public UUID getUniqueID() {
        return this.entityUniqueID;
    }

    public String getCachedUniqueIdString() {
        return this.cachedUniqueIdString;
    }

    public boolean isPushedByWater() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static double getRenderDistanceWeight() {
        return renderDistanceWeight;
    }

    @SideOnly(value=Side.CLIENT)
    public static void setRenderDistanceWeight(double p_setRenderDistanceWeight_0_) {
        renderDistanceWeight = p_setRenderDistanceWeight_0_;
    }

    @Override
    public ITextComponent getDisplayName() {
        TextComponentString textcomponentstring = new TextComponentString(ScorePlayerTeam.formatPlayerName(this.getTeam(), this.getName()));
        textcomponentstring.getStyle().setHoverEvent(this.getHoverEvent());
        textcomponentstring.getStyle().setInsertion(this.getCachedUniqueIdString());
        return textcomponentstring;
    }

    public void setCustomNameTag(String p_setCustomNameTag_1_) {
        this.dataManager.set(CUSTOM_NAME, p_setCustomNameTag_1_);
    }

    public String getCustomNameTag() {
        return this.dataManager.get(CUSTOM_NAME);
    }

    public boolean hasCustomName() {
        return !this.dataManager.get(CUSTOM_NAME).isEmpty();
    }

    public void setAlwaysRenderNameTag(boolean p_setAlwaysRenderNameTag_1_) {
        this.dataManager.set(CUSTOM_NAME_VISIBLE, p_setAlwaysRenderNameTag_1_);
    }

    public boolean getAlwaysRenderNameTag() {
        return this.dataManager.get(CUSTOM_NAME_VISIBLE);
    }

    public void setPositionAndUpdate(double p_setPositionAndUpdate_1_, double p_setPositionAndUpdate_3_, double p_setPositionAndUpdate_5_) {
        this.isPositionDirty = true;
        this.setLocationAndAngles(p_setPositionAndUpdate_1_, p_setPositionAndUpdate_3_, p_setPositionAndUpdate_5_, this.rotationYaw, this.rotationPitch);
        this.world.updateEntityWithOptionalForce(this, false);
    }

    public void notifyDataManagerChange(DataParameter<?> p_notifyDataManagerChange_1_) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getAlwaysRenderNameTagForRender() {
        return this.getAlwaysRenderNameTag();
    }

    public EnumFacing getHorizontalFacing() {
        return EnumFacing.getHorizontal(MathHelper.floor((double)(this.rotationYaw * 4.0f / 360.0f) + 0.5) & 3);
    }

    public EnumFacing getAdjustedHorizontalFacing() {
        return this.getHorizontalFacing();
    }

    protected HoverEvent getHoverEvent() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        ResourceLocation resourcelocation = EntityList.getKey(this);
        nbttagcompound.setString("id", this.getCachedUniqueIdString());
        if (resourcelocation != null) {
            nbttagcompound.setString("type", resourcelocation.toString());
        }
        nbttagcompound.setString("name", this.getName());
        return new HoverEvent(HoverEvent.Action.SHOW_ENTITY, new TextComponentString(nbttagcompound.toString()));
    }

    public boolean isSpectatedByPlayer(EntityPlayerMP p_isSpectatedByPlayer_1_) {
        return true;
    }

    public AxisAlignedBB getEntityBoundingBox() {
        return this.boundingBox;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return this.getEntityBoundingBox();
    }

    public void setEntityBoundingBox(AxisAlignedBB p_setEntityBoundingBox_1_) {
        this.boundingBox = p_setEntityBoundingBox_1_;
    }

    public float getEyeHeight() {
        return this.height * 0.85f;
    }

    public boolean isOutsideBorder() {
        return this.isOutsideBorder;
    }

    public void setOutsideBorder(boolean p_setOutsideBorder_1_) {
        this.isOutsideBorder = p_setOutsideBorder_1_;
    }

    public boolean replaceItemInInventory(int p_replaceItemInInventory_1_, ItemStack p_replaceItemInInventory_2_) {
        return false;
    }

    @Override
    public void sendMessage(ITextComponent p_sendMessage_1_) {
    }

    @Override
    public boolean canUseCommand(int p_canUseCommand_1_, String p_canUseCommand_2_) {
        return true;
    }

    @Override
    public BlockPos getPosition() {
        return new BlockPos(this.posX, this.posY + 0.5, this.posZ);
    }

    @Override
    public Vec3d getPositionVector() {
        return new Vec3d(this.posX, this.posY, this.posZ);
    }

    @Override
    public World getEntityWorld() {
        return this.world;
    }

    @Override
    public Entity getCommandSenderEntity() {
        return this;
    }

    @Override
    public boolean sendCommandFeedback() {
        return false;
    }

    @Override
    public void setCommandStat(CommandResultStats.Type p_setCommandStat_1_, int p_setCommandStat_2_) {
        if (this.world != null && !this.world.isRemote) {
            this.cmdResultStats.setCommandStatForSender(this.world.getMinecraftServer(), this, p_setCommandStat_1_, p_setCommandStat_2_);
        }
    }

    @Override
    @Nullable
    public MinecraftServer getServer() {
        return this.world.getMinecraftServer();
    }

    public CommandResultStats getCommandStats() {
        return this.cmdResultStats;
    }

    public void setCommandStats(Entity p_setCommandStats_1_) {
        this.cmdResultStats.addAllStats(p_setCommandStats_1_.getCommandStats());
    }

    public EnumActionResult applyPlayerInteraction(EntityPlayer p_applyPlayerInteraction_1_, Vec3d p_applyPlayerInteraction_2_, EnumHand p_applyPlayerInteraction_3_) {
        return EnumActionResult.PASS;
    }

    public boolean isImmuneToExplosions() {
        return false;
    }

    protected void applyEnchantments(EntityLivingBase p_applyEnchantments_1_, Entity p_applyEnchantments_2_) {
        if (p_applyEnchantments_2_ instanceof EntityLivingBase) {
            EnchantmentHelper.applyThornEnchantments((EntityLivingBase)p_applyEnchantments_2_, p_applyEnchantments_1_);
        }
        EnchantmentHelper.applyArthropodEnchantments(p_applyEnchantments_1_, p_applyEnchantments_2_);
    }

    public NBTTagCompound getEntityData() {
        if (this.customEntityData == null) {
            this.customEntityData = new NBTTagCompound();
        }
        return this.customEntityData;
    }

    public boolean shouldRiderSit() {
        return true;
    }

    public ItemStack getPickedResult(RayTraceResult p_getPickedResult_1_) {
        if (this instanceof EntityPainting) {
            return new ItemStack(Items.PAINTING);
        }
        if (this instanceof EntityLeashKnot) {
            return new ItemStack(Items.LEAD);
        }
        if (this instanceof EntityItemFrame) {
            ItemStack held = ((EntityItemFrame)this).getDisplayedItem();
            if (held.isEmpty()) {
                return new ItemStack(Items.ITEM_FRAME);
            }
            return held.copy();
        }
        if (this instanceof EntityMinecart) {
            return ((EntityMinecart)this).getCartItem();
        }
        if (this instanceof EntityBoat) {
            return new ItemStack(((EntityBoat)this).getItemBoat());
        }
        if (this instanceof EntityArmorStand) {
            return new ItemStack(Items.ARMOR_STAND);
        }
        if (this instanceof EntityEnderCrystal) {
            return new ItemStack(Items.END_CRYSTAL);
        }
        ResourceLocation name = EntityList.getKey(this);
        if (name != null && EntityList.ENTITY_EGGS.containsKey(name)) {
            ItemStack stack = new ItemStack(Items.SPAWN_EGG);
            ItemMonsterPlacer.applyEntityIdToItemStack(stack, name);
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public UUID getPersistentID() {
        return this.entityUniqueID;
    }

    public final void resetEntityId() {
        this.entityId = nextEntityID++;
    }

    public boolean shouldRenderInPass(int p_shouldRenderInPass_1_) {
        return p_shouldRenderInPass_1_ == 0;
    }

    public boolean isCreatureType(EnumCreatureType p_isCreatureType_1_, boolean p_isCreatureType_2_) {
        if (p_isCreatureType_2_ && this instanceof EntityLiving && ((EntityLiving)this).isNoDespawnRequired()) {
            return false;
        }
        return p_isCreatureType_1_.getCreatureClass().isAssignableFrom(this.getClass());
    }

    public boolean canRiderInteract() {
        return false;
    }

    public boolean shouldDismountInWater(Entity p_shouldDismountInWater_1_) {
        return this instanceof EntityLivingBase;
    }

    @Override
    public boolean hasCapability(Capability<?> p_hasCapability_1_, EnumFacing p_hasCapability_2_) {
        if (this.getCapability(p_hasCapability_1_, p_hasCapability_2_) != null) {
            return true;
        }
        return this.capabilities == null ? false : this.capabilities.hasCapability(p_hasCapability_1_, p_hasCapability_2_);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> p_getCapability_1_, EnumFacing p_getCapability_2_) {
        return this.capabilities == null ? null : (T)this.capabilities.getCapability(p_getCapability_1_, p_getCapability_2_);
    }

    @Override
    public void deserializeNBT(NBTTagCompound p_deserializeNBT_1_) {
        this.readFromNBT(p_deserializeNBT_1_);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound ret = new NBTTagCompound();
        ret.setString("id", this.getEntityString());
        return this.writeToNBT(ret);
    }

    public boolean canTrample(World p_canTrample_1_, Block p_canTrample_2_, BlockPos p_canTrample_3_, float p_canTrample_4_) {
        return p_canTrample_1_.rand.nextFloat() < p_canTrample_4_ - 0.5f && this instanceof EntityLivingBase && (this instanceof EntityPlayer || p_canTrample_1_.getGameRules().getBoolean("mobGriefing")) && this.width * this.width * this.height > 0.512f;
    }

    public void addTrackingPlayer(EntityPlayerMP p_addTrackingPlayer_1_) {
    }

    public void removeTrackingPlayer(EntityPlayerMP p_removeTrackingPlayer_1_) {
    }

    public float getRotatedYaw(Rotation p_getRotatedYaw_1_) {
        float f = MathHelper.wrapDegrees(this.rotationYaw);
        switch (p_getRotatedYaw_1_) {
            case CLOCKWISE_180: {
                return f + 180.0f;
            }
            case COUNTERCLOCKWISE_90: {
                return f + 270.0f;
            }
            case CLOCKWISE_90: {
                return f + 90.0f;
            }
        }
        return f;
    }

    public float getMirroredYaw(Mirror p_getMirroredYaw_1_) {
        float f = MathHelper.wrapDegrees(this.rotationYaw);
        switch (p_getMirroredYaw_1_) {
            case LEFT_RIGHT: {
                return -f;
            }
            case FRONT_BACK: {
                return 180.0f - f;
            }
        }
        return f;
    }

    public boolean ignoreItemEntityData() {
        return false;
    }

    public boolean setPositionNonDirty() {
        boolean flag = this.isPositionDirty;
        this.isPositionDirty = false;
        return flag;
    }

    @Nullable
    public Entity getControllingPassenger() {
        return null;
    }

    public List<Entity> getPassengers() {
        return this.riddenByEntities.isEmpty() ? Collections.emptyList() : Lists.newArrayList(this.riddenByEntities);
    }

    public boolean isPassenger(Entity p_isPassenger_1_) {
        for (Entity entity : this.getPassengers()) {
            if (!entity.equals(p_isPassenger_1_)) continue;
            return true;
        }
        return false;
    }

    public Collection<Entity> getRecursivePassengers() {
        HashSet set = Sets.newHashSet();
        this.getRecursivePassengersByType(Entity.class, set);
        return set;
    }

    public <T extends Entity> Collection<T> getRecursivePassengersByType(Class<T> p_getRecursivePassengersByType_1_) {
        HashSet set = Sets.newHashSet();
        this.getRecursivePassengersByType(p_getRecursivePassengersByType_1_, set);
        return set;
    }

    private <T extends Entity> void getRecursivePassengersByType(Class<T> p_getRecursivePassengersByType_1_, Set<T> p_getRecursivePassengersByType_2_) {
        for (Entity entity : this.getPassengers()) {
            if (p_getRecursivePassengersByType_1_.isAssignableFrom(entity.getClass())) {
                p_getRecursivePassengersByType_2_.add(entity);
            }
            entity.getRecursivePassengersByType(p_getRecursivePassengersByType_1_, p_getRecursivePassengersByType_2_);
        }
    }

    public Entity getLowestRidingEntity() {
        Entity entity = this;
        while (entity.isRiding()) {
            entity = entity.getRidingEntity();
        }
        return entity;
    }

    public boolean isRidingSameEntity(Entity p_isRidingSameEntity_1_) {
        return this.getLowestRidingEntity() == p_isRidingSameEntity_1_.getLowestRidingEntity();
    }

    public boolean isRidingOrBeingRiddenBy(Entity p_isRidingOrBeingRiddenBy_1_) {
        for (Entity entity : this.getPassengers()) {
            if (entity.equals(p_isRidingOrBeingRiddenBy_1_)) {
                return true;
            }
            if (!entity.isRidingOrBeingRiddenBy(p_isRidingOrBeingRiddenBy_1_)) continue;
            return true;
        }
        return false;
    }

    public boolean canPassengerSteer() {
        Entity entity = this.getControllingPassenger();
        return entity instanceof EntityPlayer ? ((EntityPlayer)entity).isUser() : !this.world.isRemote;
    }

    @Nullable
    public Entity getRidingEntity() {
        return this.ridingEntity;
    }

    public EnumPushReaction getPushReaction() {
        return EnumPushReaction.NORMAL;
    }

    public SoundCategory getSoundCategory() {
        return SoundCategory.NEUTRAL;
    }

    protected int getFireImmuneTicks() {
        return 1;
    }

    static {
        FLAGS = EntityDataManager.createKey(Entity.class, DataSerializers.BYTE);
        AIR = EntityDataManager.createKey(Entity.class, DataSerializers.VARINT);
        CUSTOM_NAME = EntityDataManager.createKey(Entity.class, DataSerializers.STRING);
        CUSTOM_NAME_VISIBLE = EntityDataManager.createKey(Entity.class, DataSerializers.BOOLEAN);
        SILENT = EntityDataManager.createKey(Entity.class, DataSerializers.BOOLEAN);
        NO_GRAVITY = EntityDataManager.createKey(Entity.class, DataSerializers.BOOLEAN);
    }
}

