/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public abstract class EntityAgeable
extends EntityCreature {
    private static final DataParameter<Boolean> BABY = EntityDataManager.createKey(EntityAgeable.class, DataSerializers.BOOLEAN);
    protected int growingAge;
    protected int forcedAge;
    protected int forcedAgeTimer;
    private float ageWidth = -1.0f;
    private float ageHeight;

    public EntityAgeable(World p_i1578_1_) {
        super(p_i1578_1_);
    }

    @Nullable
    public abstract EntityAgeable createChild(EntityAgeable var1);

    @Override
    public boolean processInteract(EntityPlayer p_processInteract_1_, EnumHand p_processInteract_2_) {
        ItemStack itemstack = p_processInteract_1_.getHeldItem(p_processInteract_2_);
        if (itemstack.getItem() == Items.SPAWN_EGG) {
            EntityAgeable entityageable;
            Class<? extends Entity> oclass;
            if (!this.world.isRemote && (oclass = EntityList.getClass(ItemMonsterPlacer.getNamedIdFrom(itemstack))) != null && this.getClass() == oclass && (entityageable = this.createChild(this)) != null) {
                entityageable.setGrowingAge(-24000);
                entityageable.setLocationAndAngles(this.posX, this.posY, this.posZ, 0.0f, 0.0f);
                this.world.spawnEntity(entityageable);
                if (itemstack.hasDisplayName()) {
                    entityageable.setCustomNameTag(itemstack.getDisplayName());
                }
                if (!p_processInteract_1_.capabilities.isCreativeMode) {
                    itemstack.shrink(1);
                }
            }
            return true;
        }
        return false;
    }

    protected boolean holdingSpawnEggOfClass(ItemStack p_holdingSpawnEggOfClass_1_, Class<? extends Entity> p_holdingSpawnEggOfClass_2_) {
        if (p_holdingSpawnEggOfClass_1_.getItem() != Items.SPAWN_EGG) {
            return false;
        }
        Class<? extends Entity> oclass = EntityList.getClass(ItemMonsterPlacer.getNamedIdFrom(p_holdingSpawnEggOfClass_1_));
        return oclass != null && p_holdingSpawnEggOfClass_2_ == oclass;
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(BABY, false);
    }

    public int getGrowingAge() {
        return this.world.isRemote ? (this.dataManager.get(BABY).booleanValue() ? -1 : 1) : this.growingAge;
    }

    public void ageUp(int p_ageUp_1_, boolean p_ageUp_2_) {
        int i;
        int j = i = this.getGrowingAge();
        if ((i += p_ageUp_1_ * 20) > 0) {
            i = 0;
            if (j < 0) {
                this.onGrowingAdult();
            }
        }
        int k = i - j;
        this.setGrowingAge(i);
        if (p_ageUp_2_) {
            this.forcedAge += k;
            if (this.forcedAgeTimer == 0) {
                this.forcedAgeTimer = 40;
            }
        }
        if (this.getGrowingAge() == 0) {
            this.setGrowingAge(this.forcedAge);
        }
    }

    public void addGrowth(int p_addGrowth_1_) {
        this.ageUp(p_addGrowth_1_, false);
    }

    public void setGrowingAge(int p_setGrowingAge_1_) {
        this.dataManager.set(BABY, p_setGrowingAge_1_ < 0);
        this.growingAge = p_setGrowingAge_1_;
        this.setScaleForAge(this.isChild());
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setInteger("Age", this.getGrowingAge());
        p_writeEntityToNBT_1_.setInteger("ForcedAge", this.forcedAge);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        this.setGrowingAge(p_readEntityFromNBT_1_.getInteger("Age"));
        this.forcedAge = p_readEntityFromNBT_1_.getInteger("ForcedAge");
    }

    @Override
    public void notifyDataManagerChange(DataParameter<?> p_notifyDataManagerChange_1_) {
        if (BABY.equals(p_notifyDataManagerChange_1_)) {
            this.setScaleForAge(this.isChild());
        }
        super.notifyDataManagerChange(p_notifyDataManagerChange_1_);
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.world.isRemote) {
            if (this.forcedAgeTimer > 0) {
                if (this.forcedAgeTimer % 4 == 0) {
                    this.world.spawnParticle(EnumParticleTypes.VILLAGER_HAPPY, this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + 0.5 + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, 0.0, 0.0, 0.0, new int[0]);
                }
                --this.forcedAgeTimer;
            }
        } else {
            int i = this.getGrowingAge();
            if (i < 0) {
                this.setGrowingAge(++i);
                if (i == 0) {
                    this.onGrowingAdult();
                }
            } else if (i > 0) {
                this.setGrowingAge(--i);
            }
        }
    }

    protected void onGrowingAdult() {
    }

    @Override
    public boolean isChild() {
        return this.getGrowingAge() < 0;
    }

    public void setScaleForAge(boolean p_setScaleForAge_1_) {
        this.setScale(p_setScaleForAge_1_ ? 0.5f : 1.0f);
    }

    @Override
    protected final void setSize(float p_setSize_1_, float p_setSize_2_) {
        boolean flag = this.ageWidth > 0.0f;
        this.ageWidth = p_setSize_1_;
        this.ageHeight = p_setSize_2_;
        if (!flag) {
            this.setScale(1.0f);
        }
    }

    protected final void setScale(float p_setScale_1_) {
        super.setSize(this.ageWidth * p_setScale_1_, this.ageHeight * p_setScale_1_);
    }
}

