/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.PotionTypes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityAreaEffectCloud
extends Entity {
    private static final DataParameter<Float> RADIUS = EntityDataManager.createKey(EntityAreaEffectCloud.class, DataSerializers.FLOAT);
    private static final DataParameter<Integer> COLOR = EntityDataManager.createKey(EntityAreaEffectCloud.class, DataSerializers.VARINT);
    private static final DataParameter<Boolean> IGNORE_RADIUS = EntityDataManager.createKey(EntityAreaEffectCloud.class, DataSerializers.BOOLEAN);
    private static final DataParameter<Integer> PARTICLE = EntityDataManager.createKey(EntityAreaEffectCloud.class, DataSerializers.VARINT);
    private static final DataParameter<Integer> PARTICLE_PARAM_1 = EntityDataManager.createKey(EntityAreaEffectCloud.class, DataSerializers.VARINT);
    private static final DataParameter<Integer> PARTICLE_PARAM_2 = EntityDataManager.createKey(EntityAreaEffectCloud.class, DataSerializers.VARINT);
    private PotionType potion = PotionTypes.EMPTY;
    private final List<PotionEffect> effects = Lists.newArrayList();
    private final Map<Entity, Integer> reapplicationDelayMap = Maps.newHashMap();
    private int duration = 600;
    private int waitTime = 20;
    private int reapplicationDelay = 20;
    private boolean colorSet;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusPerTick;
    private EntityLivingBase owner;
    private UUID ownerUniqueId;

    public EntityAreaEffectCloud(World p_i46809_1_) {
        super(p_i46809_1_);
        this.noClip = true;
        this.isImmuneToFire = true;
        this.setRadius(3.0f);
    }

    public EntityAreaEffectCloud(World p_i46810_1_, double p_i46810_2_, double p_i46810_4_, double p_i46810_6_) {
        this(p_i46810_1_);
        this.setPosition(p_i46810_2_, p_i46810_4_, p_i46810_6_);
    }

    @Override
    protected void entityInit() {
        this.getDataManager().register(COLOR, 0);
        this.getDataManager().register(RADIUS, Float.valueOf(0.5f));
        this.getDataManager().register(IGNORE_RADIUS, false);
        this.getDataManager().register(PARTICLE, EnumParticleTypes.SPELL_MOB.getParticleID());
        this.getDataManager().register(PARTICLE_PARAM_1, 0);
        this.getDataManager().register(PARTICLE_PARAM_2, 0);
    }

    public void setRadius(float p_setRadius_1_) {
        double lvt_2_1_ = this.posX;
        double lvt_4_1_ = this.posY;
        double lvt_6_1_ = this.posZ;
        this.setSize(p_setRadius_1_ * 2.0f, 0.5f);
        this.setPosition(lvt_2_1_, lvt_4_1_, lvt_6_1_);
        if (!this.world.isRemote) {
            this.getDataManager().set(RADIUS, Float.valueOf(p_setRadius_1_));
        }
    }

    public float getRadius() {
        return this.getDataManager().get(RADIUS).floatValue();
    }

    public void setPotion(PotionType p_setPotion_1_) {
        this.potion = p_setPotion_1_;
        if (!this.colorSet) {
            this.updateFixedColor();
        }
    }

    private void updateFixedColor() {
        if (this.potion == PotionTypes.EMPTY && this.effects.isEmpty()) {
            this.getDataManager().set(COLOR, 0);
        } else {
            this.getDataManager().set(COLOR, PotionUtils.getPotionColorFromEffectList(PotionUtils.mergeEffects(this.potion, this.effects)));
        }
    }

    public void addEffect(PotionEffect p_addEffect_1_) {
        this.effects.add(p_addEffect_1_);
        if (!this.colorSet) {
            this.updateFixedColor();
        }
    }

    public int getColor() {
        return this.getDataManager().get(COLOR);
    }

    public void setColor(int p_setColor_1_) {
        this.colorSet = true;
        this.getDataManager().set(COLOR, p_setColor_1_);
    }

    public EnumParticleTypes getParticle() {
        return EnumParticleTypes.getParticleFromId(this.getDataManager().get(PARTICLE));
    }

    public void setParticle(EnumParticleTypes p_setParticle_1_) {
        this.getDataManager().set(PARTICLE, p_setParticle_1_.getParticleID());
    }

    public int getParticleParam1() {
        return this.getDataManager().get(PARTICLE_PARAM_1);
    }

    public void setParticleParam1(int p_setParticleParam1_1_) {
        this.getDataManager().set(PARTICLE_PARAM_1, p_setParticleParam1_1_);
    }

    public int getParticleParam2() {
        return this.getDataManager().get(PARTICLE_PARAM_2);
    }

    public void setParticleParam2(int p_setParticleParam2_1_) {
        this.getDataManager().set(PARTICLE_PARAM_2, p_setParticleParam2_1_);
    }

    protected void setIgnoreRadius(boolean p_setIgnoreRadius_1_) {
        this.getDataManager().set(IGNORE_RADIUS, p_setIgnoreRadius_1_);
    }

    public boolean shouldIgnoreRadius() {
        return this.getDataManager().get(IGNORE_RADIUS);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int p_setDuration_1_) {
        this.duration = p_setDuration_1_;
    }

    @Override
    public void onUpdate() {
        block25: {
            boolean lvt_3_2_;
            float lvt_2_1_;
            boolean lvt_1_1_;
            block23: {
                int[] lvt_4_1_;
                EnumParticleTypes lvt_3_1_;
                block24: {
                    super.onUpdate();
                    lvt_1_1_ = this.shouldIgnoreRadius();
                    lvt_2_1_ = this.getRadius();
                    if (!this.world.isRemote) break block23;
                    lvt_3_1_ = this.getParticle();
                    lvt_4_1_ = new int[lvt_3_1_.getArgumentCount()];
                    if (lvt_4_1_.length > 0) {
                        lvt_4_1_[0] = this.getParticleParam1();
                    }
                    if (lvt_4_1_.length > 1) {
                        lvt_4_1_[1] = this.getParticleParam2();
                    }
                    if (!lvt_1_1_) break block24;
                    if (!this.rand.nextBoolean()) break block25;
                    for (int lvt_5_1_ = 0; lvt_5_1_ < 2; ++lvt_5_1_) {
                        float lvt_6_1_ = this.rand.nextFloat() * ((float)Math.PI * 2);
                        float lvt_7_1_ = MathHelper.sqrt(this.rand.nextFloat()) * 0.2f;
                        float lvt_8_1_ = MathHelper.cos(lvt_6_1_) * lvt_7_1_;
                        float lvt_9_1_ = MathHelper.sin(lvt_6_1_) * lvt_7_1_;
                        if (lvt_3_1_ == EnumParticleTypes.SPELL_MOB) {
                            int lvt_10_1_ = this.rand.nextBoolean() ? 0xFFFFFF : this.getColor();
                            int lvt_11_1_ = lvt_10_1_ >> 16 & 0xFF;
                            int lvt_12_1_ = lvt_10_1_ >> 8 & 0xFF;
                            int lvt_13_1_ = lvt_10_1_ & 0xFF;
                            this.world.spawnAlwaysVisibleParticle(EnumParticleTypes.SPELL_MOB.getParticleID(), this.posX + (double)lvt_8_1_, this.posY, this.posZ + (double)lvt_9_1_, (float)lvt_11_1_ / 255.0f, (float)lvt_12_1_ / 255.0f, (float)lvt_13_1_ / 255.0f, new int[0]);
                            continue;
                        }
                        this.world.spawnAlwaysVisibleParticle(lvt_3_1_.getParticleID(), this.posX + (double)lvt_8_1_, this.posY, this.posZ + (double)lvt_9_1_, 0.0, 0.0, 0.0, lvt_4_1_);
                    }
                    break block25;
                }
                float lvt_5_2_ = (float)Math.PI * lvt_2_1_ * lvt_2_1_;
                int lvt_6_2_ = 0;
                while ((float)lvt_6_2_ < lvt_5_2_) {
                    float lvt_7_2_ = this.rand.nextFloat() * ((float)Math.PI * 2);
                    float lvt_8_2_ = MathHelper.sqrt(this.rand.nextFloat()) * lvt_2_1_;
                    float lvt_9_2_ = MathHelper.cos(lvt_7_2_) * lvt_8_2_;
                    float lvt_10_2_ = MathHelper.sin(lvt_7_2_) * lvt_8_2_;
                    if (lvt_3_1_ == EnumParticleTypes.SPELL_MOB) {
                        int lvt_11_2_ = this.getColor();
                        int lvt_12_2_ = lvt_11_2_ >> 16 & 0xFF;
                        int lvt_13_2_ = lvt_11_2_ >> 8 & 0xFF;
                        int lvt_14_1_ = lvt_11_2_ & 0xFF;
                        this.world.spawnAlwaysVisibleParticle(EnumParticleTypes.SPELL_MOB.getParticleID(), this.posX + (double)lvt_9_2_, this.posY, this.posZ + (double)lvt_10_2_, (float)lvt_12_2_ / 255.0f, (float)lvt_13_2_ / 255.0f, (float)lvt_14_1_ / 255.0f, new int[0]);
                    } else {
                        this.world.spawnAlwaysVisibleParticle(lvt_3_1_.getParticleID(), this.posX + (double)lvt_9_2_, this.posY, this.posZ + (double)lvt_10_2_, (0.5 - this.rand.nextDouble()) * 0.15, 0.01f, (0.5 - this.rand.nextDouble()) * 0.15, lvt_4_1_);
                    }
                    ++lvt_6_2_;
                }
                break block25;
            }
            if (this.ticksExisted >= this.waitTime + this.duration) {
                this.setDead();
                return;
            }
            boolean bl = lvt_3_2_ = this.ticksExisted < this.waitTime;
            if (lvt_1_1_ != lvt_3_2_) {
                this.setIgnoreRadius(lvt_3_2_);
            }
            if (lvt_3_2_) {
                return;
            }
            if (this.radiusPerTick != 0.0f) {
                if ((lvt_2_1_ += this.radiusPerTick) < 0.5f) {
                    this.setDead();
                    return;
                }
                this.setRadius(lvt_2_1_);
            }
            if (this.ticksExisted % 5 == 0) {
                Iterator<Map.Entry<Entity, Integer>> lvt_4_2_ = this.reapplicationDelayMap.entrySet().iterator();
                while (lvt_4_2_.hasNext()) {
                    Map.Entry<Entity, Integer> lvt_5_3_ = lvt_4_2_.next();
                    if (this.ticksExisted < lvt_5_3_.getValue()) continue;
                    lvt_4_2_.remove();
                }
                ArrayList lvt_4_3_ = Lists.newArrayList();
                for (PotionEffect lvt_6_3_ : this.potion.getEffects()) {
                    lvt_4_3_.add(new PotionEffect(lvt_6_3_.getPotion(), lvt_6_3_.getDuration() / 4, lvt_6_3_.getAmplifier(), lvt_6_3_.getIsAmbient(), lvt_6_3_.doesShowParticles()));
                }
                lvt_4_3_.addAll(this.effects);
                if (lvt_4_3_.isEmpty()) {
                    this.reapplicationDelayMap.clear();
                } else {
                    List<EntityLivingBase> lvt_5_4_ = this.world.getEntitiesWithinAABB(EntityLivingBase.class, this.getEntityBoundingBox());
                    if (!lvt_5_4_.isEmpty()) {
                        for (EntityLivingBase lvt_7_3_ : lvt_5_4_) {
                            double lvt_10_3_;
                            double lvt_8_3_;
                            double lvt_12_3_;
                            if (this.reapplicationDelayMap.containsKey(lvt_7_3_) || !lvt_7_3_.canBeHitWithPotion() || !((lvt_12_3_ = (lvt_8_3_ = lvt_7_3_.posX - this.posX) * lvt_8_3_ + (lvt_10_3_ = lvt_7_3_.posZ - this.posZ) * lvt_10_3_) <= (double)(lvt_2_1_ * lvt_2_1_))) continue;
                            this.reapplicationDelayMap.put(lvt_7_3_, this.ticksExisted + this.reapplicationDelay);
                            for (PotionEffect lvt_15_1_ : lvt_4_3_) {
                                if (lvt_15_1_.getPotion().isInstant()) {
                                    lvt_15_1_.getPotion().affectEntity(this, this.getOwner(), lvt_7_3_, lvt_15_1_.getAmplifier(), 0.5);
                                    continue;
                                }
                                lvt_7_3_.addPotionEffect(new PotionEffect(lvt_15_1_));
                            }
                            if (this.radiusOnUse != 0.0f) {
                                if ((lvt_2_1_ += this.radiusOnUse) < 0.5f) {
                                    this.setDead();
                                    return;
                                }
                                this.setRadius(lvt_2_1_);
                            }
                            if (this.durationOnUse == 0) continue;
                            this.duration += this.durationOnUse;
                            if (this.duration > 0) continue;
                            this.setDead();
                            return;
                        }
                    }
                }
            }
        }
    }

    public void setRadiusOnUse(float p_setRadiusOnUse_1_) {
        this.radiusOnUse = p_setRadiusOnUse_1_;
    }

    public void setRadiusPerTick(float p_setRadiusPerTick_1_) {
        this.radiusPerTick = p_setRadiusPerTick_1_;
    }

    public void setWaitTime(int p_setWaitTime_1_) {
        this.waitTime = p_setWaitTime_1_;
    }

    public void setOwner(EntityLivingBase p_setOwner_1_) {
        this.owner = p_setOwner_1_;
        this.ownerUniqueId = p_setOwner_1_ == null ? null : p_setOwner_1_.getUniqueID();
    }

    @Nullable
    public EntityLivingBase getOwner() {
        Entity lvt_1_1_;
        if (this.owner == null && this.ownerUniqueId != null && this.world instanceof WorldServer && (lvt_1_1_ = ((WorldServer)this.world).getEntityFromUuid(this.ownerUniqueId)) instanceof EntityLivingBase) {
            this.owner = (EntityLivingBase)lvt_1_1_;
        }
        return this.owner;
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        EnumParticleTypes lvt_2_1_;
        this.ticksExisted = p_readEntityFromNBT_1_.getInteger("Age");
        this.duration = p_readEntityFromNBT_1_.getInteger("Duration");
        this.waitTime = p_readEntityFromNBT_1_.getInteger("WaitTime");
        this.reapplicationDelay = p_readEntityFromNBT_1_.getInteger("ReapplicationDelay");
        this.durationOnUse = p_readEntityFromNBT_1_.getInteger("DurationOnUse");
        this.radiusOnUse = p_readEntityFromNBT_1_.getFloat("RadiusOnUse");
        this.radiusPerTick = p_readEntityFromNBT_1_.getFloat("RadiusPerTick");
        this.setRadius(p_readEntityFromNBT_1_.getFloat("Radius"));
        this.ownerUniqueId = p_readEntityFromNBT_1_.getUniqueId("OwnerUUID");
        if (p_readEntityFromNBT_1_.hasKey("Particle", 8) && (lvt_2_1_ = EnumParticleTypes.getByName(p_readEntityFromNBT_1_.getString("Particle"))) != null) {
            this.setParticle(lvt_2_1_);
            this.setParticleParam1(p_readEntityFromNBT_1_.getInteger("ParticleParam1"));
            this.setParticleParam2(p_readEntityFromNBT_1_.getInteger("ParticleParam2"));
        }
        if (p_readEntityFromNBT_1_.hasKey("Color", 99)) {
            this.setColor(p_readEntityFromNBT_1_.getInteger("Color"));
        }
        if (p_readEntityFromNBT_1_.hasKey("Potion", 8)) {
            this.setPotion(PotionUtils.getPotionTypeFromNBT(p_readEntityFromNBT_1_));
        }
        if (p_readEntityFromNBT_1_.hasKey("Effects", 9)) {
            NBTTagList lvt_2_2_ = p_readEntityFromNBT_1_.getTagList("Effects", 10);
            this.effects.clear();
            for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_2_2_.tagCount(); ++lvt_3_1_) {
                PotionEffect lvt_4_1_ = PotionEffect.readCustomPotionEffectFromNBT(lvt_2_2_.getCompoundTagAt(lvt_3_1_));
                if (lvt_4_1_ == null) continue;
                this.addEffect(lvt_4_1_);
            }
        }
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        p_writeEntityToNBT_1_.setInteger("Age", this.ticksExisted);
        p_writeEntityToNBT_1_.setInteger("Duration", this.duration);
        p_writeEntityToNBT_1_.setInteger("WaitTime", this.waitTime);
        p_writeEntityToNBT_1_.setInteger("ReapplicationDelay", this.reapplicationDelay);
        p_writeEntityToNBT_1_.setInteger("DurationOnUse", this.durationOnUse);
        p_writeEntityToNBT_1_.setFloat("RadiusOnUse", this.radiusOnUse);
        p_writeEntityToNBT_1_.setFloat("RadiusPerTick", this.radiusPerTick);
        p_writeEntityToNBT_1_.setFloat("Radius", this.getRadius());
        p_writeEntityToNBT_1_.setString("Particle", this.getParticle().getParticleName());
        p_writeEntityToNBT_1_.setInteger("ParticleParam1", this.getParticleParam1());
        p_writeEntityToNBT_1_.setInteger("ParticleParam2", this.getParticleParam2());
        if (this.ownerUniqueId != null) {
            p_writeEntityToNBT_1_.setUniqueId("OwnerUUID", this.ownerUniqueId);
        }
        if (this.colorSet) {
            p_writeEntityToNBT_1_.setInteger("Color", this.getColor());
        }
        if (this.potion != PotionTypes.EMPTY && this.potion != null) {
            p_writeEntityToNBT_1_.setString("Potion", PotionType.REGISTRY.getNameForObject(this.potion).toString());
        }
        if (!this.effects.isEmpty()) {
            NBTTagList lvt_2_1_ = new NBTTagList();
            for (PotionEffect lvt_4_1_ : this.effects) {
                lvt_2_1_.appendTag(lvt_4_1_.writeCustomPotionEffectToNBT(new NBTTagCompound()));
            }
            p_writeEntityToNBT_1_.setTag("Effects", lvt_2_1_);
        }
    }

    @Override
    public void notifyDataManagerChange(DataParameter<?> p_notifyDataManagerChange_1_) {
        if (RADIUS.equals(p_notifyDataManagerChange_1_)) {
            this.setRadius(this.getRadius());
        }
        super.notifyDataManagerChange(p_notifyDataManagerChange_1_);
    }

    @Override
    public EnumPushReaction getPushReaction() {
        return EnumPushReaction.IGNORE;
    }
}

