/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.MathHelper;

public class EntityBodyHelper {
    private final EntityLivingBase theLiving;
    private int rotationTickCounter;
    private float prevRenderYawHead;

    public EntityBodyHelper(EntityLivingBase p_i1611_1_) {
        this.theLiving = p_i1611_1_;
    }

    public void updateRenderAngles() {
        double lvt_1_1_ = this.theLiving.posX - this.theLiving.prevPosX;
        double lvt_3_1_ = this.theLiving.posZ - this.theLiving.prevPosZ;
        if (lvt_1_1_ * lvt_1_1_ + lvt_3_1_ * lvt_3_1_ > 2.500000277905201E-7) {
            this.theLiving.renderYawOffset = this.theLiving.rotationYaw;
            this.prevRenderYawHead = this.theLiving.rotationYawHead = this.computeAngleWithBound(this.theLiving.renderYawOffset, this.theLiving.rotationYawHead, 75.0f);
            this.rotationTickCounter = 0;
            return;
        }
        if (this.theLiving.getPassengers().isEmpty() || !(this.theLiving.getPassengers().get(0) instanceof EntityLiving)) {
            float lvt_5_1_ = 75.0f;
            if (Math.abs(this.theLiving.rotationYawHead - this.prevRenderYawHead) > 15.0f) {
                this.rotationTickCounter = 0;
                this.prevRenderYawHead = this.theLiving.rotationYawHead;
            } else {
                ++this.rotationTickCounter;
                int lvt_6_1_ = 10;
                if (this.rotationTickCounter > 10) {
                    lvt_5_1_ = Math.max(1.0f - (float)(this.rotationTickCounter - 10) / 10.0f, 0.0f) * 75.0f;
                }
            }
            this.theLiving.renderYawOffset = this.computeAngleWithBound(this.theLiving.rotationYawHead, this.theLiving.renderYawOffset, lvt_5_1_);
        }
    }

    private float computeAngleWithBound(float p_computeAngleWithBound_1_, float p_computeAngleWithBound_2_, float p_computeAngleWithBound_3_) {
        float lvt_4_1_ = MathHelper.wrapDegrees(p_computeAngleWithBound_1_ - p_computeAngleWithBound_2_);
        if (lvt_4_1_ < -p_computeAngleWithBound_3_) {
            lvt_4_1_ = -p_computeAngleWithBound_3_;
        }
        if (lvt_4_1_ >= p_computeAngleWithBound_3_) {
            lvt_4_1_ = p_computeAngleWithBound_3_;
        }
        return p_computeAngleWithBound_1_ - lvt_4_1_;
    }
}

