/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class EntityCreature
extends EntityLiving {
    public static final UUID FLEEING_SPEED_MODIFIER_UUID = UUID.fromString("E199AD21-BA8A-4C53-8D13-6182D5C69D3A");
    public static final AttributeModifier FLEEING_SPEED_MODIFIER = new AttributeModifier(FLEEING_SPEED_MODIFIER_UUID, "Fleeing speed bonus", 2.0, 2).setSaved(false);
    private BlockPos homePosition = BlockPos.ORIGIN;
    private float maximumHomeDistance = -1.0f;
    private float restoreWaterCost = PathNodeType.WATER.getPriority();

    public EntityCreature(World p_i1602_1_) {
        super(p_i1602_1_);
    }

    public float getBlockPathWeight(BlockPos p_getBlockPathWeight_1_) {
        return 0.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getCanSpawnHere() {
        if (!super.getCanSpawnHere()) return false;
        BlockPos blockPos = new BlockPos(this.posX, this.getEntityBoundingBox().minY, this.posZ);
        if (!(this.getBlockPathWeight(blockPos) >= 0.0f)) return false;
        return true;
    }

    public boolean hasPath() {
        return !this.navigator.noPath();
    }

    public boolean isWithinHomeDistanceCurrentPosition() {
        return this.isWithinHomeDistanceFromPosition(new BlockPos(this));
    }

    public boolean isWithinHomeDistanceFromPosition(BlockPos p_isWithinHomeDistanceFromPosition_1_) {
        if (this.maximumHomeDistance == -1.0f) {
            return true;
        }
        return this.homePosition.distanceSq(p_isWithinHomeDistanceFromPosition_1_) < (double)(this.maximumHomeDistance * this.maximumHomeDistance);
    }

    public void setHomePosAndDistance(BlockPos p_setHomePosAndDistance_1_, int p_setHomePosAndDistance_2_) {
        this.homePosition = p_setHomePosAndDistance_1_;
        this.maximumHomeDistance = p_setHomePosAndDistance_2_;
    }

    public BlockPos getHomePosition() {
        return this.homePosition;
    }

    public float getMaximumHomeDistance() {
        return this.maximumHomeDistance;
    }

    public void detachHome() {
        this.maximumHomeDistance = -1.0f;
    }

    public boolean hasHome() {
        return this.maximumHomeDistance != -1.0f;
    }

    @Override
    protected void updateLeashedState() {
        super.updateLeashedState();
        if (this.getLeashed() && this.getLeashedToEntity() != null && this.getLeashedToEntity().world == this.world) {
            Entity lvt_1_1_ = this.getLeashedToEntity();
            this.setHomePosAndDistance(new BlockPos((int)lvt_1_1_.posX, (int)lvt_1_1_.posY, (int)lvt_1_1_.posZ), 5);
            float lvt_2_1_ = this.getDistanceToEntity(lvt_1_1_);
            if (this instanceof EntityTameable && ((EntityTameable)this).isSitting()) {
                if (lvt_2_1_ > 10.0f) {
                    this.clearLeashed(true, true);
                }
                return;
            }
            this.onLeashDistance(lvt_2_1_);
            if (lvt_2_1_ > 10.0f) {
                this.clearLeashed(true, true);
                this.tasks.disableControlFlag(1);
            } else if (lvt_2_1_ > 6.0f) {
                double lvt_3_1_ = (lvt_1_1_.posX - this.posX) / (double)lvt_2_1_;
                double lvt_5_1_ = (lvt_1_1_.posY - this.posY) / (double)lvt_2_1_;
                double lvt_7_1_ = (lvt_1_1_.posZ - this.posZ) / (double)lvt_2_1_;
                this.motionX += lvt_3_1_ * Math.abs(lvt_3_1_) * 0.4;
                this.motionY += lvt_5_1_ * Math.abs(lvt_5_1_) * 0.4;
                this.motionZ += lvt_7_1_ * Math.abs(lvt_7_1_) * 0.4;
            } else {
                this.tasks.enableControlFlag(1);
                float lvt_3_2_ = 2.0f;
                Vec3d lvt_4_1_ = new Vec3d(lvt_1_1_.posX - this.posX, lvt_1_1_.posY - this.posY, lvt_1_1_.posZ - this.posZ).normalize().scale(Math.max(lvt_2_1_ - 2.0f, 0.0f));
                this.getNavigator().tryMoveToXYZ(this.posX + lvt_4_1_.xCoord, this.posY + lvt_4_1_.yCoord, this.posZ + lvt_4_1_.zCoord, this.followLeashSpeed());
            }
        }
    }

    protected double followLeashSpeed() {
        return 1.0;
    }

    protected void onLeashDistance(float p_onLeashDistance_1_) {
    }
}

