/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MoverType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public abstract class EntityFlying
extends EntityLiving {
    public EntityFlying(World p_i1587_1_) {
        super(p_i1587_1_);
    }

    @Override
    public void fall(float p_fall_1_, float p_fall_2_) {
    }

    @Override
    protected void updateFallState(double p_updateFallState_1_, boolean p_updateFallState_3_, IBlockState p_updateFallState_4_, BlockPos p_updateFallState_5_) {
    }

    @Override
    public void moveEntityWithHeading(float p_moveEntityWithHeading_1_, float p_moveEntityWithHeading_2_) {
        if (this.isInWater()) {
            this.moveRelative(p_moveEntityWithHeading_1_, p_moveEntityWithHeading_2_, 0.02f);
            this.move(MoverType.SELF, this.motionX, this.motionY, this.motionZ);
            this.motionX *= (double)0.8f;
            this.motionY *= (double)0.8f;
            this.motionZ *= (double)0.8f;
        } else if (this.isInLava()) {
            this.moveRelative(p_moveEntityWithHeading_1_, p_moveEntityWithHeading_2_, 0.02f);
            this.move(MoverType.SELF, this.motionX, this.motionY, this.motionZ);
            this.motionX *= 0.5;
            this.motionY *= 0.5;
            this.motionZ *= 0.5;
        } else {
            float lvt_3_1_ = 0.91f;
            if (this.onGround) {
                lvt_3_1_ = this.world.getBlockState((BlockPos)new BlockPos((int)MathHelper.floor((double)this.posX), (int)(MathHelper.floor((double)this.getEntityBoundingBox().minY) - 1), (int)MathHelper.floor((double)this.posZ))).getBlock().slipperiness * 0.91f;
            }
            float lvt_4_1_ = 0.16277136f / (lvt_3_1_ * lvt_3_1_ * lvt_3_1_);
            this.moveRelative(p_moveEntityWithHeading_1_, p_moveEntityWithHeading_2_, this.onGround ? 0.1f * lvt_4_1_ : 0.02f);
            lvt_3_1_ = 0.91f;
            if (this.onGround) {
                lvt_3_1_ = this.world.getBlockState((BlockPos)new BlockPos((int)MathHelper.floor((double)this.posX), (int)(MathHelper.floor((double)this.getEntityBoundingBox().minY) - 1), (int)MathHelper.floor((double)this.posZ))).getBlock().slipperiness * 0.91f;
            }
            this.move(MoverType.SELF, this.motionX, this.motionY, this.motionZ);
            this.motionX *= (double)lvt_3_1_;
            this.motionY *= (double)lvt_3_1_;
            this.motionZ *= (double)lvt_3_1_;
        }
        this.prevLimbSwingAmount = this.limbSwingAmount;
        double lvt_3_2_ = this.posX - this.prevPosX;
        double lvt_5_1_ = this.posZ - this.prevPosZ;
        float lvt_7_1_ = MathHelper.sqrt(lvt_3_2_ * lvt_3_2_ + lvt_5_1_ * lvt_5_1_) * 4.0f;
        if (lvt_7_1_ > 1.0f) {
            lvt_7_1_ = 1.0f;
        }
        this.limbSwingAmount += (lvt_7_1_ - this.limbSwingAmount) * 0.4f;
        this.limbSwing += this.limbSwingAmount;
    }

    @Override
    public boolean isOnLadder() {
        return false;
    }
}

