/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.apache.commons.lang3.Validate;

public abstract class EntityHanging
extends Entity {
    private static final Predicate<Entity> IS_HANGING_ENTITY = new Predicate<Entity>(){

        public boolean apply(Entity p_apply_1_) {
            return p_apply_1_ instanceof EntityHanging;
        }
    };
    private int tickCounter1;
    protected BlockPos hangingPosition;
    @Nullable
    public EnumFacing facingDirection;

    public EntityHanging(World p_i1588_1_) {
        super(p_i1588_1_);
        this.setSize(0.5f, 0.5f);
    }

    public EntityHanging(World p_i45853_1_, BlockPos p_i45853_2_) {
        this(p_i45853_1_);
        this.hangingPosition = p_i45853_2_;
    }

    @Override
    protected void entityInit() {
    }

    protected void updateFacingWithBoundingBox(EnumFacing p_updateFacingWithBoundingBox_1_) {
        Validate.notNull((Object)p_updateFacingWithBoundingBox_1_);
        Validate.isTrue((boolean)p_updateFacingWithBoundingBox_1_.getAxis().isHorizontal());
        this.facingDirection = p_updateFacingWithBoundingBox_1_;
        this.prevRotationYaw = this.rotationYaw = (float)(this.facingDirection.getHorizontalIndex() * 90);
        this.updateBoundingBox();
    }

    protected void updateBoundingBox() {
        if (this.facingDirection != null) {
            double d0 = (double)this.hangingPosition.getX() + 0.5;
            double d1 = (double)this.hangingPosition.getY() + 0.5;
            double d2 = (double)this.hangingPosition.getZ() + 0.5;
            double d3 = 0.46875;
            double d4 = this.offs(this.getWidthPixels());
            double d5 = this.offs(this.getHeightPixels());
            d0 -= (double)this.facingDirection.getFrontOffsetX() * 0.46875;
            d2 -= (double)this.facingDirection.getFrontOffsetZ() * 0.46875;
            EnumFacing enumfacing = this.facingDirection.rotateYCCW();
            this.posX = d0 += d4 * (double)enumfacing.getFrontOffsetX();
            this.posY = d1 += d5;
            this.posZ = d2 += d4 * (double)enumfacing.getFrontOffsetZ();
            double d6 = this.getWidthPixels();
            double d7 = this.getHeightPixels();
            double d8 = this.getWidthPixels();
            if (this.facingDirection.getAxis() == EnumFacing.Axis.Z) {
                d8 = 1.0;
            } else {
                d6 = 1.0;
            }
            this.setEntityBoundingBox(new AxisAlignedBB(d0 - (d6 /= 32.0), d1 - (d7 /= 32.0), d2 - (d8 /= 32.0), d0 + d6, d1 + d7, d2 + d8));
        }
    }

    private double offs(int p_offs_1_) {
        return p_offs_1_ % 32 == 0 ? 0.5 : 0.0;
    }

    @Override
    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.tickCounter1++ == 100 && !this.world.isRemote) {
            this.tickCounter1 = 0;
            if (!this.isDead && !this.onValidSurface()) {
                this.setDead();
                this.onBroken(null);
            }
        }
    }

    public boolean onValidSurface() {
        if (!this.world.getCollisionBoxes(this, this.getEntityBoundingBox()).isEmpty()) {
            return false;
        }
        int i = Math.max(1, this.getWidthPixels() / 16);
        int j = Math.max(1, this.getHeightPixels() / 16);
        BlockPos blockpos = this.hangingPosition.offset(this.facingDirection.getOpposite());
        EnumFacing enumfacing = this.facingDirection.rotateYCCW();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k = 0; k < i; ++k) {
            for (int l = 0; l < j; ++l) {
                int i1 = (i - 1) / -2;
                int j1 = (j - 1) / -2;
                blockpos$mutableblockpos.setPos(blockpos).move(enumfacing, k + i1).move(EnumFacing.UP, l + j1);
                IBlockState iblockstate = this.world.getBlockState(blockpos$mutableblockpos);
                if (iblockstate.isSideSolid(this.world, blockpos$mutableblockpos, this.facingDirection) || iblockstate.getMaterial().isSolid() || BlockRedstoneDiode.isDiode(iblockstate)) continue;
                return false;
            }
        }
        return this.world.getEntitiesInAABBexcluding(this, this.getEntityBoundingBox(), IS_HANGING_ENTITY).isEmpty();
    }

    @Override
    public boolean canBeCollidedWith() {
        return true;
    }

    @Override
    public boolean hitByEntity(Entity p_hitByEntity_1_) {
        return p_hitByEntity_1_ instanceof EntityPlayer ? this.attackEntityFrom(DamageSource.causePlayerDamage((EntityPlayer)p_hitByEntity_1_), 0.0f) : false;
    }

    @Override
    public EnumFacing getHorizontalFacing() {
        return this.facingDirection;
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        if (this.isEntityInvulnerable(p_attackEntityFrom_1_)) {
            return false;
        }
        if (!this.isDead && !this.world.isRemote) {
            this.setDead();
            this.setBeenAttacked();
            this.onBroken(p_attackEntityFrom_1_.getEntity());
        }
        return true;
    }

    @Override
    public void move(MoverType p_move_1_, double p_move_2_, double p_move_4_, double p_move_6_) {
        if (!this.world.isRemote && !this.isDead && p_move_2_ * p_move_2_ + p_move_4_ * p_move_4_ + p_move_6_ * p_move_6_ > 0.0) {
            this.setDead();
            this.onBroken(null);
        }
    }

    @Override
    public void addVelocity(double p_addVelocity_1_, double p_addVelocity_3_, double p_addVelocity_5_) {
        if (!this.world.isRemote && !this.isDead && p_addVelocity_1_ * p_addVelocity_1_ + p_addVelocity_3_ * p_addVelocity_3_ + p_addVelocity_5_ * p_addVelocity_5_ > 0.0) {
            this.setDead();
            this.onBroken(null);
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        p_writeEntityToNBT_1_.setByte("Facing", (byte)this.facingDirection.getHorizontalIndex());
        BlockPos blockpos = this.getHangingPosition();
        p_writeEntityToNBT_1_.setInteger("TileX", blockpos.getX());
        p_writeEntityToNBT_1_.setInteger("TileY", blockpos.getY());
        p_writeEntityToNBT_1_.setInteger("TileZ", blockpos.getZ());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        this.hangingPosition = new BlockPos(p_readEntityFromNBT_1_.getInteger("TileX"), p_readEntityFromNBT_1_.getInteger("TileY"), p_readEntityFromNBT_1_.getInteger("TileZ"));
        this.updateFacingWithBoundingBox(EnumFacing.getHorizontal(p_readEntityFromNBT_1_.getByte("Facing")));
    }

    public abstract int getWidthPixels();

    public abstract int getHeightPixels();

    public abstract void onBroken(Entity var1);

    public abstract void playPlaceSound();

    @Override
    public EntityItem entityDropItem(ItemStack p_entityDropItem_1_, float p_entityDropItem_2_) {
        EntityItem entityitem = new EntityItem(this.world, this.posX + (double)((float)this.facingDirection.getFrontOffsetX() * 0.15f), this.posY + (double)p_entityDropItem_2_, this.posZ + (double)((float)this.facingDirection.getFrontOffsetZ() * 0.15f), p_entityDropItem_1_);
        entityitem.setDefaultPickupDelay();
        this.world.spawnEntity(entityitem);
        return entityitem;
    }

    @Override
    protected boolean shouldSetPosAfterLoading() {
        return false;
    }

    @Override
    public void setPosition(double p_setPosition_1_, double p_setPosition_3_, double p_setPosition_5_) {
        this.hangingPosition = new BlockPos(p_setPosition_1_, p_setPosition_3_, p_setPosition_5_);
        this.updateBoundingBox();
        this.isAirBorne = true;
    }

    public BlockPos getHangingPosition() {
        return this.hangingPosition;
    }

    @Override
    public float getRotatedYaw(Rotation p_getRotatedYaw_1_) {
        if (this.facingDirection != null && this.facingDirection.getAxis() != EnumFacing.Axis.Y) {
            switch (p_getRotatedYaw_1_) {
                case CLOCKWISE_180: {
                    this.facingDirection = this.facingDirection.getOpposite();
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    this.facingDirection = this.facingDirection.rotateYCCW();
                    break;
                }
                case CLOCKWISE_90: {
                    this.facingDirection = this.facingDirection.rotateY();
                }
            }
        }
        float f = MathHelper.wrapDegrees(this.rotationYaw);
        switch (p_getRotatedYaw_1_) {
            case CLOCKWISE_180: {
                return f + 180.0f;
            }
            case COUNTERCLOCKWISE_90: {
                return f + 90.0f;
            }
            case CLOCKWISE_90: {
                return f + 270.0f;
            }
        }
        return f;
    }

    @Override
    public float getMirroredYaw(Mirror p_getMirroredYaw_1_) {
        return this.getRotatedYaw(p_getMirroredYaw_1_.toRotation(this.facingDirection));
    }

    @Override
    public void onStruckByLightning(EntityLightningBolt p_onStruckByLightning_1_) {
    }
}

