/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFence;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLeashKnot
extends EntityHanging {
    public EntityLeashKnot(World p_i1592_1_) {
        super(p_i1592_1_);
    }

    public EntityLeashKnot(World p_i45851_1_, BlockPos p_i45851_2_) {
        super(p_i45851_1_, p_i45851_2_);
        this.setPosition((double)p_i45851_2_.getX() + 0.5, (double)p_i45851_2_.getY() + 0.5, (double)p_i45851_2_.getZ() + 0.5);
        float lvt_3_1_ = 0.125f;
        float lvt_4_1_ = 0.1875f;
        float lvt_5_1_ = 0.25f;
        this.setEntityBoundingBox(new AxisAlignedBB(this.posX - 0.1875, this.posY - 0.25 + 0.125, this.posZ - 0.1875, this.posX + 0.1875, this.posY + 0.25 + 0.125, this.posZ + 0.1875));
        this.forceSpawn = true;
    }

    @Override
    public void setPosition(double p_setPosition_1_, double p_setPosition_3_, double p_setPosition_5_) {
        super.setPosition((double)MathHelper.floor(p_setPosition_1_) + 0.5, (double)MathHelper.floor(p_setPosition_3_) + 0.5, (double)MathHelper.floor(p_setPosition_5_) + 0.5);
    }

    @Override
    protected void updateBoundingBox() {
        this.posX = (double)this.hangingPosition.getX() + 0.5;
        this.posY = (double)this.hangingPosition.getY() + 0.5;
        this.posZ = (double)this.hangingPosition.getZ() + 0.5;
    }

    @Override
    public void updateFacingWithBoundingBox(EnumFacing p_updateFacingWithBoundingBox_1_) {
    }

    @Override
    public int getWidthPixels() {
        return 9;
    }

    @Override
    public int getHeightPixels() {
        return 9;
    }

    @Override
    public float getEyeHeight() {
        return -0.0625f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double p_isInRangeToRenderDist_1_) {
        return p_isInRangeToRenderDist_1_ < 1024.0;
    }

    @Override
    public void onBroken(Entity p_onBroken_1_) {
        this.playSound(SoundEvents.ENTITY_LEASHKNOT_BREAK, 1.0f, 1.0f);
    }

    @Override
    public boolean writeToNBTOptional(NBTTagCompound p_writeToNBTOptional_1_) {
        return false;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
    }

    @Override
    public boolean processInitialInteract(EntityPlayer p_processInitialInteract_1_, EnumHand p_processInitialInteract_2_) {
        if (this.world.isRemote) {
            return true;
        }
        boolean lvt_3_1_ = false;
        double lvt_4_1_ = 7.0;
        List<EntityLiving> lvt_6_1_ = this.world.getEntitiesWithinAABB(EntityLiving.class, new AxisAlignedBB(this.posX - 7.0, this.posY - 7.0, this.posZ - 7.0, this.posX + 7.0, this.posY + 7.0, this.posZ + 7.0));
        for (EntityLiving lvt_8_1_ : lvt_6_1_) {
            if (!lvt_8_1_.getLeashed() || lvt_8_1_.getLeashedToEntity() != p_processInitialInteract_1_) continue;
            lvt_8_1_.setLeashedToEntity(this, true);
            lvt_3_1_ = true;
        }
        if (!lvt_3_1_) {
            this.setDead();
            if (p_processInitialInteract_1_.capabilities.isCreativeMode) {
                for (EntityLiving lvt_8_2_ : lvt_6_1_) {
                    if (!lvt_8_2_.getLeashed() || lvt_8_2_.getLeashedToEntity() != this) continue;
                    lvt_8_2_.clearLeashed(true, false);
                }
            }
        }
        return true;
    }

    @Override
    public boolean onValidSurface() {
        return this.world.getBlockState(this.hangingPosition).getBlock() instanceof BlockFence;
    }

    public static EntityLeashKnot createKnot(World p_createKnot_0_, BlockPos p_createKnot_1_) {
        EntityLeashKnot lvt_2_1_ = new EntityLeashKnot(p_createKnot_0_, p_createKnot_1_);
        p_createKnot_0_.spawnEntity(lvt_2_1_);
        lvt_2_1_.playPlaceSound();
        return lvt_2_1_;
    }

    @Nullable
    public static EntityLeashKnot getKnotForPosition(World p_getKnotForPosition_0_, BlockPos p_getKnotForPosition_1_) {
        int lvt_2_1_ = p_getKnotForPosition_1_.getX();
        int lvt_3_1_ = p_getKnotForPosition_1_.getY();
        int lvt_4_1_ = p_getKnotForPosition_1_.getZ();
        List<EntityLeashKnot> lvt_5_1_ = p_getKnotForPosition_0_.getEntitiesWithinAABB(EntityLeashKnot.class, new AxisAlignedBB((double)lvt_2_1_ - 1.0, (double)lvt_3_1_ - 1.0, (double)lvt_4_1_ - 1.0, (double)lvt_2_1_ + 1.0, (double)lvt_3_1_ + 1.0, (double)lvt_4_1_ + 1.0));
        for (EntityLeashKnot lvt_7_1_ : lvt_5_1_) {
            if (!lvt_7_1_.getHangingPosition().equals(p_getKnotForPosition_1_)) continue;
            return lvt_7_1_;
        }
        return null;
    }

    @Override
    public void playPlaceSound() {
        this.playSound(SoundEvents.ENTITY_LEASHKNOT_PLACE, 1.0f, 1.0f);
    }
}

