/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityBodyHelper;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLeashKnot;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityJumpHelper;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.EntitySenses;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntityAttach;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.stats.AchievementList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityLiving
extends EntityLivingBase {
    private static final DataParameter<Byte> AI_FLAGS = EntityDataManager.createKey(EntityLiving.class, DataSerializers.BYTE);
    public int livingSoundTime;
    protected int experienceValue;
    private final EntityLookHelper lookHelper;
    protected EntityMoveHelper moveHelper;
    protected EntityJumpHelper jumpHelper;
    private final EntityBodyHelper bodyHelper;
    protected PathNavigate navigator;
    public final EntityAITasks tasks;
    public final EntityAITasks targetTasks;
    private EntityLivingBase attackTarget;
    private final EntitySenses senses;
    private final NonNullList<ItemStack> inventoryHands = NonNullList.withSize(2, ItemStack.EMPTY);
    protected float[] inventoryHandsDropChances = new float[2];
    private final NonNullList<ItemStack> inventoryArmor = NonNullList.withSize(4, ItemStack.EMPTY);
    protected float[] inventoryArmorDropChances = new float[4];
    private boolean canPickUpLoot;
    private boolean persistenceRequired;
    private final Map<PathNodeType, Float> mapPathPriority = Maps.newEnumMap(PathNodeType.class);
    private ResourceLocation deathLootTable;
    private long deathLootTableSeed;
    private boolean isLeashed;
    private Entity leashedToEntity;
    private NBTTagCompound leashNBTTag;

    public EntityLiving(World p_i1595_1_) {
        super(p_i1595_1_);
        this.tasks = new EntityAITasks(p_i1595_1_ != null && p_i1595_1_.theProfiler != null ? p_i1595_1_.theProfiler : null);
        this.targetTasks = new EntityAITasks(p_i1595_1_ != null && p_i1595_1_.theProfiler != null ? p_i1595_1_.theProfiler : null);
        this.lookHelper = new EntityLookHelper(this);
        this.moveHelper = new EntityMoveHelper(this);
        this.jumpHelper = new EntityJumpHelper(this);
        this.bodyHelper = this.createBodyHelper();
        this.navigator = this.createNavigator(p_i1595_1_);
        this.senses = new EntitySenses(this);
        Arrays.fill(this.inventoryArmorDropChances, 0.085f);
        Arrays.fill(this.inventoryHandsDropChances, 0.085f);
        if (p_i1595_1_ != null && !p_i1595_1_.isRemote) {
            this.initEntityAI();
        }
    }

    protected void initEntityAI() {
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(16.0);
    }

    protected PathNavigate createNavigator(World p_createNavigator_1_) {
        return new PathNavigateGround(this, p_createNavigator_1_);
    }

    public float getPathPriority(PathNodeType p_getPathPriority_1_) {
        Float f = this.mapPathPriority.get((Object)p_getPathPriority_1_);
        return f == null ? p_getPathPriority_1_.getPriority() : f.floatValue();
    }

    public void setPathPriority(PathNodeType p_setPathPriority_1_, float p_setPathPriority_2_) {
        this.mapPathPriority.put(p_setPathPriority_1_, Float.valueOf(p_setPathPriority_2_));
    }

    protected EntityBodyHelper createBodyHelper() {
        return new EntityBodyHelper(this);
    }

    public EntityLookHelper getLookHelper() {
        return this.lookHelper;
    }

    public EntityMoveHelper getMoveHelper() {
        return this.moveHelper;
    }

    public EntityJumpHelper getJumpHelper() {
        return this.jumpHelper;
    }

    public PathNavigate getNavigator() {
        return this.navigator;
    }

    public EntitySenses getEntitySenses() {
        return this.senses;
    }

    @Nullable
    public EntityLivingBase getAttackTarget() {
        return this.attackTarget;
    }

    public void setAttackTarget(EntityLivingBase p_setAttackTarget_1_) {
        this.attackTarget = p_setAttackTarget_1_;
        ForgeHooks.onLivingSetAttackTarget(this, p_setAttackTarget_1_);
    }

    public boolean canAttackClass(Class<? extends EntityLivingBase> p_canAttackClass_1_) {
        return p_canAttackClass_1_ != EntityGhast.class;
    }

    public void eatGrassBonus() {
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(AI_FLAGS, (byte)0);
    }

    public int getTalkInterval() {
        return 80;
    }

    public void playLivingSound() {
        SoundEvent soundevent = this.getAmbientSound();
        if (soundevent != null) {
            this.playSound(soundevent, this.getSoundVolume(), this.getSoundPitch());
        }
    }

    @Override
    public void onEntityUpdate() {
        super.onEntityUpdate();
        this.world.theProfiler.startSection("mobBaseTick");
        if (this.isEntityAlive() && this.rand.nextInt(1000) < this.livingSoundTime++) {
            this.applyEntityAI();
            this.playLivingSound();
        }
        this.world.theProfiler.endSection();
    }

    @Override
    protected void playHurtSound(DamageSource p_playHurtSound_1_) {
        this.applyEntityAI();
        super.playHurtSound(p_playHurtSound_1_);
    }

    private void applyEntityAI() {
        this.livingSoundTime = -this.getTalkInterval();
    }

    @Override
    protected int getExperiencePoints(EntityPlayer p_getExperiencePoints_1_) {
        if (this.experienceValue > 0) {
            int i = this.experienceValue;
            for (int j = 0; j < this.inventoryArmor.size(); ++j) {
                if (this.inventoryArmor.get(j).isEmpty() || !(this.inventoryArmorDropChances[j] <= 1.0f)) continue;
                i += 1 + this.rand.nextInt(3);
            }
            for (int k = 0; k < this.inventoryHands.size(); ++k) {
                if (this.inventoryHands.get(k).isEmpty() || !(this.inventoryHandsDropChances[k] <= 1.0f)) continue;
                i += 1 + this.rand.nextInt(3);
            }
            return i;
        }
        return this.experienceValue;
    }

    public void spawnExplosionParticle() {
        if (this.world.isRemote) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.rand.nextGaussian() * 0.02;
                double d1 = this.rand.nextGaussian() * 0.02;
                double d2 = this.rand.nextGaussian() * 0.02;
                double d3 = 10.0;
                this.world.spawnParticle(EnumParticleTypes.EXPLOSION_NORMAL, this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width - d0 * 10.0, this.posY + (double)(this.rand.nextFloat() * this.height) - d1 * 10.0, this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width - d2 * 10.0, d0, d1, d2, new int[0]);
            }
        } else {
            this.world.setEntityState(this, (byte)20);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte p_handleStatusUpdate_1_) {
        if (p_handleStatusUpdate_1_ == 20) {
            this.spawnExplosionParticle();
        } else {
            super.handleStatusUpdate(p_handleStatusUpdate_1_);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.world.isRemote) {
            this.updateLeashedState();
            if (this.ticksExisted % 5 == 0) {
                boolean flag = !(this.getControllingPassenger() instanceof EntityLiving);
                boolean flag1 = !(this.getRidingEntity() instanceof EntityBoat);
                this.tasks.setControlFlag(1, flag);
                this.tasks.setControlFlag(4, flag && flag1);
                this.tasks.setControlFlag(2, flag);
            }
        }
    }

    @Override
    protected float updateDistance(float p_updateDistance_1_, float p_updateDistance_2_) {
        this.bodyHelper.updateRenderAngles();
        return p_updateDistance_2_;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return null;
    }

    @Nullable
    protected Item getDropItem() {
        return null;
    }

    @Override
    protected void dropFewItems(boolean p_dropFewItems_1_, int p_dropFewItems_2_) {
        Item item = this.getDropItem();
        if (item != null) {
            int i = this.rand.nextInt(3);
            if (p_dropFewItems_2_ > 0) {
                i += this.rand.nextInt(p_dropFewItems_2_ + 1);
            }
            for (int j = 0; j < i; ++j) {
                this.dropItem(item, 1);
            }
        }
    }

    public static void registerFixesMob(DataFixer p_registerFixesMob_0_, Class<?> p_registerFixesMob_1_) {
        p_registerFixesMob_0_.registerWalker(FixTypes.ENTITY, new ItemStackDataLists(p_registerFixesMob_1_, "ArmorItems", "HandItems"));
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_writeEntityToNBT_1_) {
        super.writeEntityToNBT(p_writeEntityToNBT_1_);
        p_writeEntityToNBT_1_.setBoolean("CanPickUpLoot", this.canPickUpLoot());
        p_writeEntityToNBT_1_.setBoolean("PersistenceRequired", this.persistenceRequired);
        NBTTagList nbttaglist = new NBTTagList();
        for (ItemStack itemStack : this.inventoryArmor) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            if (!itemStack.isEmpty()) {
                itemStack.writeToNBT(nBTTagCompound);
            }
            nbttaglist.appendTag(nBTTagCompound);
        }
        p_writeEntityToNBT_1_.setTag("ArmorItems", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (ItemStack itemStack : this.inventoryHands) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            if (!itemStack.isEmpty()) {
                itemStack.writeToNBT(nbttagcompound1);
            }
            nbttaglist1.appendTag(nbttagcompound1);
        }
        p_writeEntityToNBT_1_.setTag("HandItems", nbttaglist1);
        NBTTagList nBTTagList = new NBTTagList();
        for (float f : this.inventoryArmorDropChances) {
            nBTTagList.appendTag(new NBTTagFloat(f));
        }
        p_writeEntityToNBT_1_.setTag("ArmorDropChances", nBTTagList);
        NBTTagList nBTTagList2 = new NBTTagList();
        for (float f1 : this.inventoryHandsDropChances) {
            nBTTagList2.appendTag(new NBTTagFloat(f1));
        }
        p_writeEntityToNBT_1_.setTag("HandDropChances", nBTTagList2);
        p_writeEntityToNBT_1_.setBoolean("Leashed", this.isLeashed);
        if (this.leashedToEntity != null) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            if (this.leashedToEntity instanceof EntityLivingBase) {
                UUID uuid = this.leashedToEntity.getUniqueID();
                nbttagcompound2.setUniqueId("UUID", uuid);
            } else if (this.leashedToEntity instanceof EntityHanging) {
                BlockPos blockpos = ((EntityHanging)this.leashedToEntity).getHangingPosition();
                nbttagcompound2.setInteger("X", blockpos.getX());
                nbttagcompound2.setInteger("Y", blockpos.getY());
                nbttagcompound2.setInteger("Z", blockpos.getZ());
            }
            p_writeEntityToNBT_1_.setTag("Leash", nbttagcompound2);
        }
        p_writeEntityToNBT_1_.setBoolean("LeftHanded", this.isLeftHanded());
        if (this.deathLootTable != null) {
            p_writeEntityToNBT_1_.setString("DeathLootTable", this.deathLootTable.toString());
            if (this.deathLootTableSeed != 0L) {
                p_writeEntityToNBT_1_.setLong("DeathLootTableSeed", this.deathLootTableSeed);
            }
        }
        if (this.isAIDisabled()) {
            p_writeEntityToNBT_1_.setBoolean("NoAI", this.isAIDisabled());
        }
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_readEntityFromNBT_1_) {
        super.readEntityFromNBT(p_readEntityFromNBT_1_);
        if (p_readEntityFromNBT_1_.hasKey("CanPickUpLoot", 1)) {
            this.setCanPickUpLoot(p_readEntityFromNBT_1_.getBoolean("CanPickUpLoot"));
        }
        this.persistenceRequired = p_readEntityFromNBT_1_.getBoolean("PersistenceRequired");
        if (p_readEntityFromNBT_1_.hasKey("ArmorItems", 9)) {
            NBTTagList nbttaglist = p_readEntityFromNBT_1_.getTagList("ArmorItems", 10);
            for (int i = 0; i < this.inventoryArmor.size(); ++i) {
                this.inventoryArmor.set(i, new ItemStack(nbttaglist.getCompoundTagAt(i)));
            }
        }
        if (p_readEntityFromNBT_1_.hasKey("HandItems", 9)) {
            NBTTagList nbttaglist1 = p_readEntityFromNBT_1_.getTagList("HandItems", 10);
            for (int j = 0; j < this.inventoryHands.size(); ++j) {
                this.inventoryHands.set(j, new ItemStack(nbttaglist1.getCompoundTagAt(j)));
            }
        }
        if (p_readEntityFromNBT_1_.hasKey("ArmorDropChances", 9)) {
            NBTTagList nbttaglist2 = p_readEntityFromNBT_1_.getTagList("ArmorDropChances", 5);
            for (int k = 0; k < nbttaglist2.tagCount(); ++k) {
                this.inventoryArmorDropChances[k] = nbttaglist2.getFloatAt(k);
            }
        }
        if (p_readEntityFromNBT_1_.hasKey("HandDropChances", 9)) {
            NBTTagList nbttaglist3 = p_readEntityFromNBT_1_.getTagList("HandDropChances", 5);
            for (int l = 0; l < nbttaglist3.tagCount(); ++l) {
                this.inventoryHandsDropChances[l] = nbttaglist3.getFloatAt(l);
            }
        }
        this.isLeashed = p_readEntityFromNBT_1_.getBoolean("Leashed");
        if (this.isLeashed && p_readEntityFromNBT_1_.hasKey("Leash", 10)) {
            this.leashNBTTag = p_readEntityFromNBT_1_.getCompoundTag("Leash");
        }
        this.setLeftHanded(p_readEntityFromNBT_1_.getBoolean("LeftHanded"));
        if (p_readEntityFromNBT_1_.hasKey("DeathLootTable", 8)) {
            this.deathLootTable = new ResourceLocation(p_readEntityFromNBT_1_.getString("DeathLootTable"));
            this.deathLootTableSeed = p_readEntityFromNBT_1_.getLong("DeathLootTableSeed");
        }
        this.setNoAI(p_readEntityFromNBT_1_.getBoolean("NoAI"));
    }

    @Nullable
    protected ResourceLocation getLootTable() {
        return null;
    }

    @Override
    protected void dropLoot(boolean p_dropLoot_1_, int p_dropLoot_2_, DamageSource p_dropLoot_3_) {
        ResourceLocation resourcelocation = this.deathLootTable;
        if (resourcelocation == null) {
            resourcelocation = this.getLootTable();
        }
        if (resourcelocation != null) {
            LootTable loottable = this.world.getLootTableManager().getLootTableFromLocation(resourcelocation);
            this.deathLootTable = null;
            LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.world).withLootedEntity(this).withDamageSource(p_dropLoot_3_);
            if (p_dropLoot_1_ && this.attackingPlayer != null) {
                lootcontext$builder = lootcontext$builder.withPlayer(this.attackingPlayer).withLuck(this.attackingPlayer.getLuck());
            }
            for (ItemStack itemstack : loottable.generateLootForPools(this.deathLootTableSeed == 0L ? this.rand : new Random(this.deathLootTableSeed), lootcontext$builder.build())) {
                this.entityDropItem(itemstack, 0.0f);
            }
            this.dropEquipment(p_dropLoot_1_, p_dropLoot_2_);
        } else {
            super.dropLoot(p_dropLoot_1_, p_dropLoot_2_, p_dropLoot_3_);
        }
    }

    public void setMoveForward(float p_setMoveForward_1_) {
        this.moveForward = p_setMoveForward_1_;
    }

    public void setMoveStrafing(float p_setMoveStrafing_1_) {
        this.moveStrafing = p_setMoveStrafing_1_;
    }

    @Override
    public void setAIMoveSpeed(float p_setAIMoveSpeed_1_) {
        super.setAIMoveSpeed(p_setAIMoveSpeed_1_);
        this.setMoveForward(p_setAIMoveSpeed_1_);
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        this.world.theProfiler.startSection("looting");
        if (!this.world.isRemote && this.canPickUpLoot() && !this.dead && this.world.getGameRules().getBoolean("mobGriefing")) {
            for (EntityItem entityitem : this.world.getEntitiesWithinAABB(EntityItem.class, this.getEntityBoundingBox().expand(1.0, 0.0, 1.0))) {
                if (entityitem.isDead || entityitem.getEntityItem().isEmpty() || entityitem.cannotPickup()) continue;
                this.updateEquipmentIfNeeded(entityitem);
            }
        }
        this.world.theProfiler.endSection();
    }

    protected void updateEquipmentIfNeeded(EntityItem p_updateEquipmentIfNeeded_1_) {
        ItemStack itemstack = p_updateEquipmentIfNeeded_1_.getEntityItem();
        EntityEquipmentSlot entityequipmentslot = EntityLiving.getSlotForItemStack(itemstack);
        boolean flag = true;
        ItemStack itemstack1 = this.getItemStackFromSlot(entityequipmentslot);
        if (!itemstack1.isEmpty()) {
            if (entityequipmentslot.getSlotType() == EntityEquipmentSlot.Type.HAND) {
                if (itemstack.getItem() instanceof ItemSword && !(itemstack1.getItem() instanceof ItemSword)) {
                    flag = true;
                } else if (itemstack.getItem() instanceof ItemSword && itemstack1.getItem() instanceof ItemSword) {
                    ItemSword itemsword = (ItemSword)itemstack.getItem();
                    ItemSword itemsword1 = (ItemSword)itemstack1.getItem();
                    flag = itemsword.getDamageVsEntity() == itemsword1.getDamageVsEntity() ? itemstack.getMetadata() > itemstack1.getMetadata() || itemstack.hasTagCompound() && !itemstack1.hasTagCompound() : itemsword.getDamageVsEntity() > itemsword1.getDamageVsEntity();
                } else {
                    flag = itemstack.getItem() instanceof ItemBow && itemstack1.getItem() instanceof ItemBow ? itemstack.hasTagCompound() && !itemstack1.hasTagCompound() : false;
                }
            } else if (itemstack.getItem() instanceof ItemArmor && !(itemstack1.getItem() instanceof ItemArmor)) {
                flag = true;
            } else if (itemstack.getItem() instanceof ItemArmor && itemstack1.getItem() instanceof ItemArmor && !EnchantmentHelper.hasBindingCurse(itemstack1)) {
                ItemArmor itemarmor = (ItemArmor)itemstack.getItem();
                ItemArmor itemarmor1 = (ItemArmor)itemstack1.getItem();
                flag = itemarmor.damageReduceAmount == itemarmor1.damageReduceAmount ? itemstack.getMetadata() > itemstack1.getMetadata() || itemstack.hasTagCompound() && !itemstack1.hasTagCompound() : itemarmor.damageReduceAmount > itemarmor1.damageReduceAmount;
            } else {
                flag = false;
            }
        }
        if (flag && this.canEquipItem(itemstack)) {
            EntityPlayer entityplayer;
            double d0;
            switch (entityequipmentslot.getSlotType()) {
                case HAND: {
                    d0 = this.inventoryHandsDropChances[entityequipmentslot.getIndex()];
                    break;
                }
                case ARMOR: {
                    d0 = this.inventoryArmorDropChances[entityequipmentslot.getIndex()];
                    break;
                }
                default: {
                    d0 = 0.0;
                }
            }
            if (!itemstack1.isEmpty() && (double)(this.rand.nextFloat() - 0.1f) < d0) {
                this.entityDropItem(itemstack1, 0.0f);
            }
            if (itemstack.getItem() == Items.DIAMOND && p_updateEquipmentIfNeeded_1_.getThrower() != null && (entityplayer = this.world.getPlayerEntityByName(p_updateEquipmentIfNeeded_1_.getThrower())) != null) {
                entityplayer.addStat(AchievementList.DIAMONDS_TO_YOU);
            }
            this.setItemStackToSlot(entityequipmentslot, itemstack);
            switch (entityequipmentslot.getSlotType()) {
                case HAND: {
                    this.inventoryHandsDropChances[entityequipmentslot.getIndex()] = 2.0f;
                    break;
                }
                case ARMOR: {
                    this.inventoryArmorDropChances[entityequipmentslot.getIndex()] = 2.0f;
                }
            }
            this.persistenceRequired = true;
            this.onItemPickup(p_updateEquipmentIfNeeded_1_, itemstack.getCount());
            p_updateEquipmentIfNeeded_1_.setDead();
        }
    }

    protected boolean canEquipItem(ItemStack p_canEquipItem_1_) {
        return true;
    }

    protected boolean canDespawn() {
        return true;
    }

    protected void despawnEntity() {
        Event.Result result = null;
        if (this.persistenceRequired) {
            this.entityAge = 0;
        } else if ((this.entityAge & 0x1F) == 31 && (result = ForgeEventFactory.canEntityDespawn(this)) != Event.Result.DEFAULT) {
            if (result == Event.Result.DENY) {
                this.entityAge = 0;
            } else {
                this.setDead();
            }
        } else {
            EntityPlayer entity = this.world.getClosestPlayerToEntity(this, -1.0);
            if (entity != null) {
                double d0 = entity.posX - this.posX;
                double d1 = entity.posY - this.posY;
                double d2 = entity.posZ - this.posZ;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.canDespawn() && d3 > 16384.0) {
                    this.setDead();
                }
                if (this.entityAge > 600 && this.rand.nextInt(800) == 0 && d3 > 1024.0 && this.canDespawn()) {
                    this.setDead();
                } else if (d3 < 1024.0) {
                    this.entityAge = 0;
                }
            }
        }
    }

    @Override
    protected final void updateEntityActionState() {
        ++this.entityAge;
        this.world.theProfiler.startSection("checkDespawn");
        this.despawnEntity();
        this.world.theProfiler.endSection();
        this.world.theProfiler.startSection("sensing");
        this.senses.clearSensingCache();
        this.world.theProfiler.endSection();
        this.world.theProfiler.startSection("targetSelector");
        this.targetTasks.onUpdateTasks();
        this.world.theProfiler.endSection();
        this.world.theProfiler.startSection("goalSelector");
        this.tasks.onUpdateTasks();
        this.world.theProfiler.endSection();
        this.world.theProfiler.startSection("navigation");
        this.navigator.onUpdateNavigation();
        this.world.theProfiler.endSection();
        this.world.theProfiler.startSection("mob tick");
        this.updateAITasks();
        this.world.theProfiler.endSection();
        if (this.isRiding() && this.getRidingEntity() instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)this.getRidingEntity();
            entityliving.getNavigator().setPath(this.getNavigator().getPath(), 1.5);
            entityliving.getMoveHelper().read(this.getMoveHelper());
        }
        this.world.theProfiler.startSection("controls");
        this.world.theProfiler.startSection("move");
        this.moveHelper.onUpdateMoveHelper();
        this.world.theProfiler.endStartSection("look");
        this.lookHelper.onUpdateLook();
        this.world.theProfiler.endStartSection("jump");
        this.jumpHelper.doJump();
        this.world.theProfiler.endSection();
        this.world.theProfiler.endSection();
    }

    protected void updateAITasks() {
    }

    public int getVerticalFaceSpeed() {
        return 40;
    }

    public int getHorizontalFaceSpeed() {
        return 10;
    }

    public void faceEntity(Entity p_faceEntity_1_, float p_faceEntity_2_, float p_faceEntity_3_) {
        double d1;
        double d0 = p_faceEntity_1_.posX - this.posX;
        double d2 = p_faceEntity_1_.posZ - this.posZ;
        if (p_faceEntity_1_ instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)p_faceEntity_1_;
            d1 = entitylivingbase.posY + (double)entitylivingbase.getEyeHeight() - (this.posY + (double)this.getEyeHeight());
        } else {
            d1 = (p_faceEntity_1_.getEntityBoundingBox().minY + p_faceEntity_1_.getEntityBoundingBox().maxY) / 2.0 - (this.posY + (double)this.getEyeHeight());
        }
        double d3 = MathHelper.sqrt(d0 * d0 + d2 * d2);
        float f = (float)(MathHelper.atan2(d2, d0) * 57.29577951308232) - 90.0f;
        float f1 = (float)(-(MathHelper.atan2(d1, d3) * 57.29577951308232));
        this.rotationPitch = this.updateRotation(this.rotationPitch, f1, p_faceEntity_3_);
        this.rotationYaw = this.updateRotation(this.rotationYaw, f, p_faceEntity_2_);
    }

    private float updateRotation(float p_updateRotation_1_, float p_updateRotation_2_, float p_updateRotation_3_) {
        float f = MathHelper.wrapDegrees(p_updateRotation_2_ - p_updateRotation_1_);
        if (f > p_updateRotation_3_) {
            f = p_updateRotation_3_;
        }
        if (f < -p_updateRotation_3_) {
            f = -p_updateRotation_3_;
        }
        return p_updateRotation_1_ + f;
    }

    public boolean getCanSpawnHere() {
        IBlockState iblockstate = this.world.getBlockState(new BlockPos(this).down());
        return iblockstate.canEntitySpawn(this);
    }

    public boolean isNotColliding() {
        return !this.world.containsAnyLiquid(this.getEntityBoundingBox()) && this.world.getCollisionBoxes(this, this.getEntityBoundingBox()).isEmpty() && this.world.checkNoEntityCollision(this.getEntityBoundingBox(), this);
    }

    public float getRenderSizeModifier() {
        return 1.0f;
    }

    public int getMaxSpawnedInChunk() {
        return 4;
    }

    @Override
    public int getMaxFallHeight() {
        if (this.getAttackTarget() == null) {
            return 3;
        }
        int i = (int)(this.getHealth() - this.getMaxHealth() * 0.33f);
        if ((i -= (3 - this.world.getDifficulty().getDifficultyId()) * 4) < 0) {
            i = 0;
        }
        return i + 3;
    }

    @Override
    public Iterable<ItemStack> getHeldEquipment() {
        return this.inventoryHands;
    }

    @Override
    public Iterable<ItemStack> getArmorInventoryList() {
        return this.inventoryArmor;
    }

    @Override
    public ItemStack getItemStackFromSlot(EntityEquipmentSlot p_getItemStackFromSlot_1_) {
        switch (p_getItemStackFromSlot_1_.getSlotType()) {
            case HAND: {
                return this.inventoryHands.get(p_getItemStackFromSlot_1_.getIndex());
            }
            case ARMOR: {
                return this.inventoryArmor.get(p_getItemStackFromSlot_1_.getIndex());
            }
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void setItemStackToSlot(EntityEquipmentSlot p_setItemStackToSlot_1_, ItemStack p_setItemStackToSlot_2_) {
        switch (p_setItemStackToSlot_1_.getSlotType()) {
            case HAND: {
                this.inventoryHands.set(p_setItemStackToSlot_1_.getIndex(), p_setItemStackToSlot_2_);
                break;
            }
            case ARMOR: {
                this.inventoryArmor.set(p_setItemStackToSlot_1_.getIndex(), p_setItemStackToSlot_2_);
            }
        }
    }

    @Override
    protected void dropEquipment(boolean p_dropEquipment_1_, int p_dropEquipment_2_) {
        for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
            boolean flag;
            double d0;
            ItemStack itemstack = this.getItemStackFromSlot(entityequipmentslot);
            switch (entityequipmentslot.getSlotType()) {
                case HAND: {
                    d0 = this.inventoryHandsDropChances[entityequipmentslot.getIndex()];
                    break;
                }
                case ARMOR: {
                    d0 = this.inventoryArmorDropChances[entityequipmentslot.getIndex()];
                    break;
                }
                default: {
                    d0 = 0.0;
                }
            }
            boolean bl = flag = d0 > 1.0;
            if (itemstack.isEmpty() || EnchantmentHelper.hasVanishingCurse(itemstack) || !p_dropEquipment_1_ && !flag || !((double)(this.rand.nextFloat() - (float)p_dropEquipment_2_ * 0.01f) < d0)) continue;
            if (!flag && itemstack.isItemStackDamageable()) {
                itemstack.setItemDamage(itemstack.getMaxDamage() - this.rand.nextInt(1 + this.rand.nextInt(Math.max(itemstack.getMaxDamage() - 3, 1))));
            }
            this.entityDropItem(itemstack, 0.0f);
        }
    }

    protected void setEquipmentBasedOnDifficulty(DifficultyInstance p_setEquipmentBasedOnDifficulty_1_) {
        if (this.rand.nextFloat() < 0.15f * p_setEquipmentBasedOnDifficulty_1_.getClampedAdditionalDifficulty()) {
            float f;
            int i = this.rand.nextInt(2);
            float f2 = f = this.world.getDifficulty() == EnumDifficulty.HARD ? 0.1f : 0.25f;
            if (this.rand.nextFloat() < 0.095f) {
                ++i;
            }
            if (this.rand.nextFloat() < 0.095f) {
                ++i;
            }
            if (this.rand.nextFloat() < 0.095f) {
                ++i;
            }
            boolean flag = true;
            for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                Item item;
                if (entityequipmentslot.getSlotType() != EntityEquipmentSlot.Type.ARMOR) continue;
                ItemStack itemstack = this.getItemStackFromSlot(entityequipmentslot);
                if (!flag && this.rand.nextFloat() < f) break;
                flag = false;
                if (!itemstack.isEmpty() || (item = EntityLiving.getArmorByChance(entityequipmentslot, i)) == null) continue;
                this.setItemStackToSlot(entityequipmentslot, new ItemStack(item));
            }
        }
    }

    public static EntityEquipmentSlot getSlotForItemStack(ItemStack p_getSlotForItemStack_0_) {
        return p_getSlotForItemStack_0_.getItem() != Item.getItemFromBlock(Blocks.PUMPKIN) && p_getSlotForItemStack_0_.getItem() != Items.SKULL ? (p_getSlotForItemStack_0_.getItem() instanceof ItemArmor ? ((ItemArmor)p_getSlotForItemStack_0_.getItem()).armorType : (p_getSlotForItemStack_0_.getItem() == Items.ELYTRA ? EntityEquipmentSlot.CHEST : (p_getSlotForItemStack_0_.getItem() == Items.SHIELD ? EntityEquipmentSlot.OFFHAND : EntityEquipmentSlot.MAINHAND))) : EntityEquipmentSlot.HEAD;
    }

    @Nullable
    public static Item getArmorByChance(EntityEquipmentSlot p_getArmorByChance_0_, int p_getArmorByChance_1_) {
        switch (p_getArmorByChance_0_) {
            case HEAD: {
                if (p_getArmorByChance_1_ == 0) {
                    return Items.LEATHER_HELMET;
                }
                if (p_getArmorByChance_1_ == 1) {
                    return Items.GOLDEN_HELMET;
                }
                if (p_getArmorByChance_1_ == 2) {
                    return Items.CHAINMAIL_HELMET;
                }
                if (p_getArmorByChance_1_ == 3) {
                    return Items.IRON_HELMET;
                }
                if (p_getArmorByChance_1_ == 4) {
                    return Items.DIAMOND_HELMET;
                }
            }
            case CHEST: {
                if (p_getArmorByChance_1_ == 0) {
                    return Items.LEATHER_CHESTPLATE;
                }
                if (p_getArmorByChance_1_ == 1) {
                    return Items.GOLDEN_CHESTPLATE;
                }
                if (p_getArmorByChance_1_ == 2) {
                    return Items.CHAINMAIL_CHESTPLATE;
                }
                if (p_getArmorByChance_1_ == 3) {
                    return Items.IRON_CHESTPLATE;
                }
                if (p_getArmorByChance_1_ == 4) {
                    return Items.DIAMOND_CHESTPLATE;
                }
            }
            case LEGS: {
                if (p_getArmorByChance_1_ == 0) {
                    return Items.LEATHER_LEGGINGS;
                }
                if (p_getArmorByChance_1_ == 1) {
                    return Items.GOLDEN_LEGGINGS;
                }
                if (p_getArmorByChance_1_ == 2) {
                    return Items.CHAINMAIL_LEGGINGS;
                }
                if (p_getArmorByChance_1_ == 3) {
                    return Items.IRON_LEGGINGS;
                }
                if (p_getArmorByChance_1_ == 4) {
                    return Items.DIAMOND_LEGGINGS;
                }
            }
            case FEET: {
                if (p_getArmorByChance_1_ == 0) {
                    return Items.LEATHER_BOOTS;
                }
                if (p_getArmorByChance_1_ == 1) {
                    return Items.GOLDEN_BOOTS;
                }
                if (p_getArmorByChance_1_ == 2) {
                    return Items.CHAINMAIL_BOOTS;
                }
                if (p_getArmorByChance_1_ == 3) {
                    return Items.IRON_BOOTS;
                }
                if (p_getArmorByChance_1_ != 4) break;
                return Items.DIAMOND_BOOTS;
            }
        }
        return null;
    }

    protected void setEnchantmentBasedOnDifficulty(DifficultyInstance p_setEnchantmentBasedOnDifficulty_1_) {
        float f = p_setEnchantmentBasedOnDifficulty_1_.getClampedAdditionalDifficulty();
        if (!this.getHeldItemMainhand().isEmpty() && this.rand.nextFloat() < 0.25f * f) {
            this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, EnchantmentHelper.addRandomEnchantment(this.rand, this.getHeldItemMainhand(), (int)(5.0f + f * (float)this.rand.nextInt(18)), false));
        }
        for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
            ItemStack itemstack;
            if (entityequipmentslot.getSlotType() != EntityEquipmentSlot.Type.ARMOR || (itemstack = this.getItemStackFromSlot(entityequipmentslot)).isEmpty() || !(this.rand.nextFloat() < 0.5f * f)) continue;
            this.setItemStackToSlot(entityequipmentslot, EnchantmentHelper.addRandomEnchantment(this.rand, itemstack, (int)(5.0f + f * (float)this.rand.nextInt(18)), false));
        }
    }

    @Nullable
    public IEntityLivingData onInitialSpawn(DifficultyInstance p_onInitialSpawn_1_, IEntityLivingData p_onInitialSpawn_2_) {
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).applyModifier(new AttributeModifier("Random spawn bonus", this.rand.nextGaussian() * 0.05, 1));
        if (this.rand.nextFloat() < 0.05f) {
            this.setLeftHanded(true);
        } else {
            this.setLeftHanded(false);
        }
        return p_onInitialSpawn_2_;
    }

    public boolean canBeSteered() {
        return false;
    }

    public void enablePersistence() {
        this.persistenceRequired = true;
    }

    public void setDropChance(EntityEquipmentSlot p_setDropChance_1_, float p_setDropChance_2_) {
        switch (p_setDropChance_1_.getSlotType()) {
            case HAND: {
                this.inventoryHandsDropChances[p_setDropChance_1_.getIndex()] = p_setDropChance_2_;
                break;
            }
            case ARMOR: {
                this.inventoryArmorDropChances[p_setDropChance_1_.getIndex()] = p_setDropChance_2_;
            }
        }
    }

    public boolean canPickUpLoot() {
        return this.canPickUpLoot;
    }

    public void setCanPickUpLoot(boolean p_setCanPickUpLoot_1_) {
        this.canPickUpLoot = p_setCanPickUpLoot_1_;
    }

    public boolean isNoDespawnRequired() {
        return this.persistenceRequired;
    }

    @Override
    public final boolean processInitialInteract(EntityPlayer p_processInitialInteract_1_, EnumHand p_processInitialInteract_2_) {
        if (this.getLeashed() && this.getLeashedToEntity() == p_processInitialInteract_1_) {
            this.clearLeashed(true, !p_processInitialInteract_1_.capabilities.isCreativeMode);
            return true;
        }
        ItemStack itemstack = p_processInitialInteract_1_.getHeldItem(p_processInitialInteract_2_);
        if (itemstack.getItem() == Items.LEAD && this.canBeLeashedTo(p_processInitialInteract_1_)) {
            this.setLeashedToEntity(p_processInitialInteract_1_, true);
            itemstack.shrink(1);
            return true;
        }
        return this.processInteract(p_processInitialInteract_1_, p_processInitialInteract_2_) ? true : super.processInitialInteract(p_processInitialInteract_1_, p_processInitialInteract_2_);
    }

    protected boolean processInteract(EntityPlayer p_processInteract_1_, EnumHand p_processInteract_2_) {
        return false;
    }

    protected void updateLeashedState() {
        if (this.leashNBTTag != null) {
            this.recreateLeash();
        }
        if (this.isLeashed) {
            if (!this.isEntityAlive()) {
                this.clearLeashed(true, true);
            }
            if (this.leashedToEntity == null || this.leashedToEntity.isDead) {
                this.clearLeashed(true, true);
            }
        }
    }

    public void clearLeashed(boolean p_clearLeashed_1_, boolean p_clearLeashed_2_) {
        if (this.isLeashed) {
            this.isLeashed = false;
            this.leashedToEntity = null;
            if (!this.world.isRemote && p_clearLeashed_2_) {
                this.dropItem(Items.LEAD, 1);
            }
            if (!this.world.isRemote && p_clearLeashed_1_ && this.world instanceof WorldServer) {
                ((WorldServer)this.world).getEntityTracker().sendToTracking(this, new SPacketEntityAttach(this, null));
            }
        }
    }

    public boolean canBeLeashedTo(EntityPlayer p_canBeLeashedTo_1_) {
        return !this.getLeashed() && !(this instanceof IMob);
    }

    public boolean getLeashed() {
        return this.isLeashed;
    }

    public Entity getLeashedToEntity() {
        return this.leashedToEntity;
    }

    public void setLeashedToEntity(Entity p_setLeashedToEntity_1_, boolean p_setLeashedToEntity_2_) {
        this.isLeashed = true;
        this.leashedToEntity = p_setLeashedToEntity_1_;
        if (!this.world.isRemote && p_setLeashedToEntity_2_ && this.world instanceof WorldServer) {
            ((WorldServer)this.world).getEntityTracker().sendToTracking(this, new SPacketEntityAttach(this, this.leashedToEntity));
        }
        if (this.isRiding()) {
            this.dismountRidingEntity();
        }
    }

    @Override
    public boolean startRiding(Entity p_startRiding_1_, boolean p_startRiding_2_) {
        boolean flag = super.startRiding(p_startRiding_1_, p_startRiding_2_);
        if (flag && this.getLeashed()) {
            this.clearLeashed(true, true);
        }
        return flag;
    }

    private void recreateLeash() {
        if (this.isLeashed && this.leashNBTTag != null) {
            if (this.leashNBTTag.hasUniqueId("UUID")) {
                UUID uuid = this.leashNBTTag.getUniqueId("UUID");
                for (EntityLivingBase entitylivingbase : this.world.getEntitiesWithinAABB(EntityLivingBase.class, this.getEntityBoundingBox().expandXyz(10.0))) {
                    if (!entitylivingbase.getUniqueID().equals(uuid)) continue;
                    this.setLeashedToEntity(entitylivingbase, true);
                    break;
                }
            } else if (this.leashNBTTag.hasKey("X", 99) && this.leashNBTTag.hasKey("Y", 99) && this.leashNBTTag.hasKey("Z", 99)) {
                BlockPos blockpos = new BlockPos(this.leashNBTTag.getInteger("X"), this.leashNBTTag.getInteger("Y"), this.leashNBTTag.getInteger("Z"));
                EntityLeashKnot entityleashknot = EntityLeashKnot.getKnotForPosition(this.world, blockpos);
                if (entityleashknot == null) {
                    entityleashknot = EntityLeashKnot.createKnot(this.world, blockpos);
                }
                this.setLeashedToEntity(entityleashknot, true);
            } else {
                this.clearLeashed(false, true);
            }
        }
        this.leashNBTTag = null;
    }

    @Override
    public boolean replaceItemInInventory(int p_replaceItemInInventory_1_, ItemStack p_replaceItemInInventory_2_) {
        EntityEquipmentSlot entityequipmentslot;
        if (p_replaceItemInInventory_1_ == 98) {
            entityequipmentslot = EntityEquipmentSlot.MAINHAND;
        } else if (p_replaceItemInInventory_1_ == 99) {
            entityequipmentslot = EntityEquipmentSlot.OFFHAND;
        } else if (p_replaceItemInInventory_1_ == 100 + EntityEquipmentSlot.HEAD.getIndex()) {
            entityequipmentslot = EntityEquipmentSlot.HEAD;
        } else if (p_replaceItemInInventory_1_ == 100 + EntityEquipmentSlot.CHEST.getIndex()) {
            entityequipmentslot = EntityEquipmentSlot.CHEST;
        } else if (p_replaceItemInInventory_1_ == 100 + EntityEquipmentSlot.LEGS.getIndex()) {
            entityequipmentslot = EntityEquipmentSlot.LEGS;
        } else {
            if (p_replaceItemInInventory_1_ != 100 + EntityEquipmentSlot.FEET.getIndex()) {
                return false;
            }
            entityequipmentslot = EntityEquipmentSlot.FEET;
        }
        if (!p_replaceItemInInventory_2_.isEmpty() && !EntityLiving.isItemStackInSlot(entityequipmentslot, p_replaceItemInInventory_2_) && entityequipmentslot != EntityEquipmentSlot.HEAD) {
            return false;
        }
        this.setItemStackToSlot(entityequipmentslot, p_replaceItemInInventory_2_);
        return true;
    }

    @Override
    public boolean canPassengerSteer() {
        return this.canBeSteered() && super.canPassengerSteer();
    }

    public static boolean isItemStackInSlot(EntityEquipmentSlot p_isItemStackInSlot_0_, ItemStack p_isItemStackInSlot_1_) {
        EntityEquipmentSlot entityequipmentslot = EntityLiving.getSlotForItemStack(p_isItemStackInSlot_1_);
        return entityequipmentslot == p_isItemStackInSlot_0_ || entityequipmentslot == EntityEquipmentSlot.MAINHAND && p_isItemStackInSlot_0_ == EntityEquipmentSlot.OFFHAND || entityequipmentslot == EntityEquipmentSlot.OFFHAND && p_isItemStackInSlot_0_ == EntityEquipmentSlot.MAINHAND;
    }

    @Override
    public boolean isServerWorld() {
        return super.isServerWorld() && !this.isAIDisabled();
    }

    public void setNoAI(boolean p_setNoAI_1_) {
        byte b0 = this.dataManager.get(AI_FLAGS);
        this.dataManager.set(AI_FLAGS, p_setNoAI_1_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE));
    }

    public void setLeftHanded(boolean p_setLeftHanded_1_) {
        byte b0 = this.dataManager.get(AI_FLAGS);
        this.dataManager.set(AI_FLAGS, p_setLeftHanded_1_ ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD));
    }

    public boolean isAIDisabled() {
        return (this.dataManager.get(AI_FLAGS) & 1) != 0;
    }

    public boolean isLeftHanded() {
        return (this.dataManager.get(AI_FLAGS) & 2) != 0;
    }

    @Override
    public EnumHandSide getPrimaryHand() {
        return this.isLeftHanded() ? EnumHandSide.LEFT : EnumHandSide.RIGHT;
    }

    public static enum SpawnPlacementType {
        ON_GROUND,
        IN_AIR,
        IN_WATER;

    }
}

