/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityEnderEye;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityExpBottle;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.entity.projectile.EntityLlamaSpit;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityAttach;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityTracker {
    private static final Logger LOGGER = LogManager.getLogger();
    private final WorldServer world;
    private final Set<EntityTrackerEntry> entries = Sets.newHashSet();
    private final IntHashMap<EntityTrackerEntry> trackedEntityHashTable = new IntHashMap();
    private int maxTrackingDistanceThreshold;

    public EntityTracker(WorldServer p_i1516_1_) {
        this.world = p_i1516_1_;
        this.maxTrackingDistanceThreshold = p_i1516_1_.getMinecraftServer().getPlayerList().getEntityViewDistance();
    }

    public static long getPositionLong(double p_getPositionLong_0_) {
        return MathHelper.lfloor(p_getPositionLong_0_ * 4096.0);
    }

    @SideOnly(value=Side.CLIENT)
    public static void updateServerPosition(Entity p_updateServerPosition_0_, double p_updateServerPosition_1_, double p_updateServerPosition_3_, double p_updateServerPosition_5_) {
        p_updateServerPosition_0_.serverPosX = EntityTracker.getPositionLong(p_updateServerPosition_1_);
        p_updateServerPosition_0_.serverPosY = EntityTracker.getPositionLong(p_updateServerPosition_3_);
        p_updateServerPosition_0_.serverPosZ = EntityTracker.getPositionLong(p_updateServerPosition_5_);
    }

    public void track(Entity p_track_1_) {
        if (EntityRegistry.instance().tryTrackingEntity(this, p_track_1_)) {
            return;
        }
        if (p_track_1_ instanceof EntityPlayerMP) {
            this.track(p_track_1_, 512, 2);
            EntityPlayerMP entityplayermp = (EntityPlayerMP)p_track_1_;
            for (EntityTrackerEntry entitytrackerentry : this.entries) {
                if (entitytrackerentry.getTrackedEntity() == entityplayermp) continue;
                entitytrackerentry.updatePlayerEntity(entityplayermp);
            }
        } else if (p_track_1_ instanceof EntityFishHook) {
            this.track(p_track_1_, 64, 5, true);
        } else if (p_track_1_ instanceof EntityArrow) {
            this.track(p_track_1_, 64, 20, false);
        } else if (p_track_1_ instanceof EntitySmallFireball) {
            this.track(p_track_1_, 64, 10, false);
        } else if (p_track_1_ instanceof EntityFireball) {
            this.track(p_track_1_, 64, 10, true);
        } else if (p_track_1_ instanceof EntitySnowball) {
            this.track(p_track_1_, 64, 10, true);
        } else if (p_track_1_ instanceof EntityLlamaSpit) {
            this.track(p_track_1_, 64, 10, false);
        } else if (p_track_1_ instanceof EntityEnderPearl) {
            this.track(p_track_1_, 64, 10, true);
        } else if (p_track_1_ instanceof EntityEnderEye) {
            this.track(p_track_1_, 64, 4, true);
        } else if (p_track_1_ instanceof EntityEgg) {
            this.track(p_track_1_, 64, 10, true);
        } else if (p_track_1_ instanceof EntityPotion) {
            this.track(p_track_1_, 64, 10, true);
        } else if (p_track_1_ instanceof EntityExpBottle) {
            this.track(p_track_1_, 64, 10, true);
        } else if (p_track_1_ instanceof EntityFireworkRocket) {
            this.track(p_track_1_, 64, 10, true);
        } else if (p_track_1_ instanceof EntityItem) {
            this.track(p_track_1_, 64, 20, true);
        } else if (p_track_1_ instanceof EntityMinecart) {
            this.track(p_track_1_, 80, 3, true);
        } else if (p_track_1_ instanceof EntityBoat) {
            this.track(p_track_1_, 80, 3, true);
        } else if (p_track_1_ instanceof EntitySquid) {
            this.track(p_track_1_, 64, 3, true);
        } else if (p_track_1_ instanceof EntityWither) {
            this.track(p_track_1_, 80, 3, false);
        } else if (p_track_1_ instanceof EntityShulkerBullet) {
            this.track(p_track_1_, 80, 3, true);
        } else if (p_track_1_ instanceof EntityBat) {
            this.track(p_track_1_, 80, 3, false);
        } else if (p_track_1_ instanceof EntityDragon) {
            this.track(p_track_1_, 160, 3, true);
        } else if (p_track_1_ instanceof IAnimals) {
            this.track(p_track_1_, 80, 3, true);
        } else if (p_track_1_ instanceof EntityTNTPrimed) {
            this.track(p_track_1_, 160, 10, true);
        } else if (p_track_1_ instanceof EntityFallingBlock) {
            this.track(p_track_1_, 160, 20, true);
        } else if (p_track_1_ instanceof EntityHanging) {
            this.track(p_track_1_, 160, Integer.MAX_VALUE, false);
        } else if (p_track_1_ instanceof EntityArmorStand) {
            this.track(p_track_1_, 160, 3, true);
        } else if (p_track_1_ instanceof EntityXPOrb) {
            this.track(p_track_1_, 160, 20, true);
        } else if (p_track_1_ instanceof EntityAreaEffectCloud) {
            this.track(p_track_1_, 160, Integer.MAX_VALUE, true);
        } else if (p_track_1_ instanceof EntityEnderCrystal) {
            this.track(p_track_1_, 256, Integer.MAX_VALUE, false);
        } else if (p_track_1_ instanceof EntityEvokerFangs) {
            this.track(p_track_1_, 160, 2, false);
        }
    }

    public void track(Entity p_track_1_, int p_track_2_, int p_track_3_) {
        this.track(p_track_1_, p_track_2_, p_track_3_, false);
    }

    public void track(Entity p_track_1_, int p_track_2_, final int p_track_3_, boolean p_track_4_) {
        try {
            if (this.trackedEntityHashTable.containsItem(p_track_1_.getEntityId())) {
                throw new IllegalStateException("Entity is already tracked!");
            }
            EntityTrackerEntry entitytrackerentry = new EntityTrackerEntry(p_track_1_, p_track_2_, this.maxTrackingDistanceThreshold, p_track_3_, p_track_4_);
            this.entries.add(entitytrackerentry);
            this.trackedEntityHashTable.addKey(p_track_1_.getEntityId(), entitytrackerentry);
            entitytrackerentry.updatePlayerEntities(this.world.playerEntities);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Adding entity to track");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Entity To Track");
            crashreportcategory.addCrashSection("Tracking range", p_track_2_ + " blocks");
            crashreportcategory.setDetail("Update interval", new ICrashReportDetail<String>(){

                @Override
                public String call() throws Exception {
                    String s = "Once per " + p_track_3_ + " ticks";
                    if (p_track_3_ == Integer.MAX_VALUE) {
                        s = "Maximum (" + s + ")";
                    }
                    return s;
                }
            });
            p_track_1_.addEntityCrashInfo(crashreportcategory);
            this.trackedEntityHashTable.lookup(p_track_1_.getEntityId()).getTrackedEntity().addEntityCrashInfo(crashreport.makeCategory("Entity That Is Already Tracked"));
            try {
                throw new ReportedException(crashreport);
            }
            catch (ReportedException reportedexception) {
                LOGGER.error("\"Silently\" catching entity tracking error.", (Throwable)reportedexception);
            }
        }
    }

    public void untrack(Entity p_untrack_1_) {
        EntityTrackerEntry entitytrackerentry1;
        if (p_untrack_1_ instanceof EntityPlayerMP) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)p_untrack_1_;
            for (EntityTrackerEntry entitytrackerentry : this.entries) {
                entitytrackerentry.removeFromTrackedPlayers(entityplayermp);
            }
        }
        if ((entitytrackerentry1 = this.trackedEntityHashTable.removeObject(p_untrack_1_.getEntityId())) != null) {
            this.entries.remove(entitytrackerentry1);
            entitytrackerentry1.sendDestroyEntityPacketToTrackedPlayers();
        }
    }

    public void tick() {
        ArrayList list = Lists.newArrayList();
        for (EntityTrackerEntry entitytrackerentry : this.entries) {
            Entity entity;
            entitytrackerentry.updatePlayerList(this.world.playerEntities);
            if (!entitytrackerentry.playerEntitiesUpdated || !((entity = entitytrackerentry.getTrackedEntity()) instanceof EntityPlayerMP)) continue;
            list.add((EntityPlayerMP)entity);
        }
        for (int i = 0; i < list.size(); ++i) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)list.get(i);
            for (EntityTrackerEntry entitytrackerentry1 : this.entries) {
                if (entitytrackerentry1.getTrackedEntity() == entityplayermp) continue;
                entitytrackerentry1.updatePlayerEntity(entityplayermp);
            }
        }
    }

    public void updateVisibility(EntityPlayerMP p_updateVisibility_1_) {
        for (EntityTrackerEntry entitytrackerentry : this.entries) {
            if (entitytrackerentry.getTrackedEntity() == p_updateVisibility_1_) {
                entitytrackerentry.updatePlayerEntities(this.world.playerEntities);
                continue;
            }
            entitytrackerentry.updatePlayerEntity(p_updateVisibility_1_);
        }
    }

    public void sendToTracking(Entity p_sendToTracking_1_, Packet<?> p_sendToTracking_2_) {
        EntityTrackerEntry entitytrackerentry = this.trackedEntityHashTable.lookup(p_sendToTracking_1_.getEntityId());
        if (entitytrackerentry != null) {
            entitytrackerentry.sendPacketToTrackedPlayers(p_sendToTracking_2_);
        }
    }

    public Set<? extends EntityPlayer> getTrackingPlayers(Entity p_getTrackingPlayers_1_) {
        EntityTrackerEntry entry = this.trackedEntityHashTable.lookup(p_getTrackingPlayers_1_.getEntityId());
        if (entry == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(entry.trackingPlayers);
    }

    public void sendToTrackingAndSelf(Entity p_sendToTrackingAndSelf_1_, Packet<?> p_sendToTrackingAndSelf_2_) {
        EntityTrackerEntry entitytrackerentry = this.trackedEntityHashTable.lookup(p_sendToTrackingAndSelf_1_.getEntityId());
        if (entitytrackerentry != null) {
            entitytrackerentry.sendToTrackingAndSelf(p_sendToTrackingAndSelf_2_);
        }
    }

    public void removePlayerFromTrackers(EntityPlayerMP p_removePlayerFromTrackers_1_) {
        for (EntityTrackerEntry entitytrackerentry : this.entries) {
            entitytrackerentry.removeTrackedPlayerSymmetric(p_removePlayerFromTrackers_1_);
        }
    }

    public void sendLeashedEntitiesInChunk(EntityPlayerMP p_sendLeashedEntitiesInChunk_1_, Chunk p_sendLeashedEntitiesInChunk_2_) {
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        for (EntityTrackerEntry entitytrackerentry : this.entries) {
            Entity entity = entitytrackerentry.getTrackedEntity();
            if (entity == p_sendLeashedEntitiesInChunk_1_ || entity.chunkCoordX != p_sendLeashedEntitiesInChunk_2_.xPosition || entity.chunkCoordZ != p_sendLeashedEntitiesInChunk_2_.zPosition) continue;
            entitytrackerentry.updatePlayerEntity(p_sendLeashedEntitiesInChunk_1_);
            if (entity instanceof EntityLiving && ((EntityLiving)entity).getLeashedToEntity() != null) {
                list.add(entity);
            }
            if (entity.getPassengers().isEmpty()) continue;
            list1.add(entity);
        }
        if (!list.isEmpty()) {
            for (Entity entity1 : list) {
                p_sendLeashedEntitiesInChunk_1_.connection.sendPacket(new SPacketEntityAttach(entity1, ((EntityLiving)entity1).getLeashedToEntity()));
            }
        }
        if (!list1.isEmpty()) {
            for (Entity entity2 : list1) {
                p_sendLeashedEntitiesInChunk_1_.connection.sendPacket(new SPacketSetPassengers(entity2));
            }
        }
    }

    public void setViewDistance(int p_setViewDistance_1_) {
        this.maxTrackingDistanceThreshold = (p_setViewDistance_1_ - 1) * 16;
        for (EntityTrackerEntry entitytrackerentry : this.entries) {
            entitytrackerentry.setMaxRange(this.maxTrackingDistanceThreshold);
        }
    }
}

