/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SharedMonsterAttributes {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final IAttribute MAX_HEALTH = new RangedAttribute(null, "generic.maxHealth", 20.0, 0.0, 1024.0).setDescription("Max Health").setShouldWatch(true);
    public static final IAttribute FOLLOW_RANGE = new RangedAttribute(null, "generic.followRange", 32.0, 0.0, 2048.0).setDescription("Follow Range");
    public static final IAttribute KNOCKBACK_RESISTANCE = new RangedAttribute(null, "generic.knockbackResistance", 0.0, 0.0, 1.0).setDescription("Knockback Resistance");
    public static final IAttribute MOVEMENT_SPEED = new RangedAttribute(null, "generic.movementSpeed", 0.7f, 0.0, 1024.0).setDescription("Movement Speed").setShouldWatch(true);
    public static final IAttribute ATTACK_DAMAGE = new RangedAttribute(null, "generic.attackDamage", 2.0, 0.0, 2048.0);
    public static final IAttribute ATTACK_SPEED = new RangedAttribute(null, "generic.attackSpeed", 4.0, 0.0, 1024.0).setShouldWatch(true);
    public static final IAttribute ARMOR = new RangedAttribute(null, "generic.armor", 0.0, 0.0, 30.0).setShouldWatch(true);
    public static final IAttribute ARMOR_TOUGHNESS = new RangedAttribute(null, "generic.armorToughness", 0.0, 0.0, 20.0).setShouldWatch(true);
    public static final IAttribute LUCK = new RangedAttribute(null, "generic.luck", 0.0, -1024.0, 1024.0).setShouldWatch(true);

    public static NBTTagList writeBaseAttributeMapToNBT(AbstractAttributeMap p_writeBaseAttributeMapToNBT_0_) {
        NBTTagList lvt_1_1_ = new NBTTagList();
        for (IAttributeInstance lvt_3_1_ : p_writeBaseAttributeMapToNBT_0_.getAllAttributes()) {
            lvt_1_1_.appendTag(SharedMonsterAttributes.writeAttributeInstanceToNBT(lvt_3_1_));
        }
        return lvt_1_1_;
    }

    private static NBTTagCompound writeAttributeInstanceToNBT(IAttributeInstance p_writeAttributeInstanceToNBT_0_) {
        NBTTagCompound lvt_1_1_ = new NBTTagCompound();
        IAttribute lvt_2_1_ = p_writeAttributeInstanceToNBT_0_.getAttribute();
        lvt_1_1_.setString("Name", lvt_2_1_.getName());
        lvt_1_1_.setDouble("Base", p_writeAttributeInstanceToNBT_0_.getBaseValue());
        Collection<AttributeModifier> lvt_3_1_ = p_writeAttributeInstanceToNBT_0_.getModifiers();
        if (lvt_3_1_ != null && !lvt_3_1_.isEmpty()) {
            NBTTagList lvt_4_1_ = new NBTTagList();
            for (AttributeModifier lvt_6_1_ : lvt_3_1_) {
                if (!lvt_6_1_.isSaved()) continue;
                lvt_4_1_.appendTag(SharedMonsterAttributes.writeAttributeModifierToNBT(lvt_6_1_));
            }
            lvt_1_1_.setTag("Modifiers", lvt_4_1_);
        }
        return lvt_1_1_;
    }

    public static NBTTagCompound writeAttributeModifierToNBT(AttributeModifier p_writeAttributeModifierToNBT_0_) {
        NBTTagCompound lvt_1_1_ = new NBTTagCompound();
        lvt_1_1_.setString("Name", p_writeAttributeModifierToNBT_0_.getName());
        lvt_1_1_.setDouble("Amount", p_writeAttributeModifierToNBT_0_.getAmount());
        lvt_1_1_.setInteger("Operation", p_writeAttributeModifierToNBT_0_.getOperation());
        lvt_1_1_.setUniqueId("UUID", p_writeAttributeModifierToNBT_0_.getID());
        return lvt_1_1_;
    }

    public static void setAttributeModifiers(AbstractAttributeMap p_setAttributeModifiers_0_, NBTTagList p_setAttributeModifiers_1_) {
        for (int lvt_2_1_ = 0; lvt_2_1_ < p_setAttributeModifiers_1_.tagCount(); ++lvt_2_1_) {
            NBTTagCompound lvt_3_1_ = p_setAttributeModifiers_1_.getCompoundTagAt(lvt_2_1_);
            IAttributeInstance lvt_4_1_ = p_setAttributeModifiers_0_.getAttributeInstanceByName(lvt_3_1_.getString("Name"));
            if (lvt_4_1_ == null) {
                LOGGER.warn("Ignoring unknown attribute '{}'", new Object[]{lvt_3_1_.getString("Name")});
                continue;
            }
            SharedMonsterAttributes.applyModifiersToAttributeInstance(lvt_4_1_, lvt_3_1_);
        }
    }

    private static void applyModifiersToAttributeInstance(IAttributeInstance p_applyModifiersToAttributeInstance_0_, NBTTagCompound p_applyModifiersToAttributeInstance_1_) {
        p_applyModifiersToAttributeInstance_0_.setBaseValue(p_applyModifiersToAttributeInstance_1_.getDouble("Base"));
        if (p_applyModifiersToAttributeInstance_1_.hasKey("Modifiers", 9)) {
            NBTTagList lvt_2_1_ = p_applyModifiersToAttributeInstance_1_.getTagList("Modifiers", 10);
            for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_2_1_.tagCount(); ++lvt_3_1_) {
                AttributeModifier lvt_4_1_ = SharedMonsterAttributes.readAttributeModifierFromNBT(lvt_2_1_.getCompoundTagAt(lvt_3_1_));
                if (lvt_4_1_ == null) continue;
                AttributeModifier lvt_5_1_ = p_applyModifiersToAttributeInstance_0_.getModifier(lvt_4_1_.getID());
                if (lvt_5_1_ != null) {
                    p_applyModifiersToAttributeInstance_0_.removeModifier(lvt_5_1_);
                }
                p_applyModifiersToAttributeInstance_0_.applyModifier(lvt_4_1_);
            }
        }
    }

    @Nullable
    public static AttributeModifier readAttributeModifierFromNBT(NBTTagCompound p_readAttributeModifierFromNBT_0_) {
        UUID lvt_1_1_ = p_readAttributeModifierFromNBT_0_.getUniqueId("UUID");
        try {
            return new AttributeModifier(lvt_1_1_, p_readAttributeModifierFromNBT_0_.getString("Name"), p_readAttributeModifierFromNBT_0_.getDouble("Amount"), p_readAttributeModifierFromNBT_0_.getInteger("Operation"));
        }
        catch (Exception lvt_2_1_) {
            LOGGER.warn("Unable to create attribute: {}", new Object[]{lvt_2_1_.getMessage()});
            return null;
        }
    }
}

