/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.MathHelper;

public class EntityAIAttackRanged
extends EntityAIBase {
    private final EntityLiving entityHost;
    private final IRangedAttackMob rangedAttackEntityHost;
    private EntityLivingBase attackTarget;
    private int rangedAttackTime = -1;
    private final double entityMoveSpeed;
    private int seeTime;
    private final int attackIntervalMin;
    private final int maxRangedAttackTime;
    private final float attackRadius;
    private final float maxAttackDistance;

    public EntityAIAttackRanged(IRangedAttackMob p_i1649_1_, double p_i1649_2_, int p_i1649_4_, float p_i1649_5_) {
        this(p_i1649_1_, p_i1649_2_, p_i1649_4_, p_i1649_4_, p_i1649_5_);
    }

    public EntityAIAttackRanged(IRangedAttackMob p_i1650_1_, double p_i1650_2_, int p_i1650_4_, int p_i1650_5_, float p_i1650_6_) {
        if (!(p_i1650_1_ instanceof EntityLivingBase)) {
            throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
        }
        this.rangedAttackEntityHost = p_i1650_1_;
        this.entityHost = (EntityLiving)((Object)p_i1650_1_);
        this.entityMoveSpeed = p_i1650_2_;
        this.attackIntervalMin = p_i1650_4_;
        this.maxRangedAttackTime = p_i1650_5_;
        this.attackRadius = p_i1650_6_;
        this.maxAttackDistance = p_i1650_6_ * p_i1650_6_;
        this.setMutexBits(3);
    }

    @Override
    public boolean shouldExecute() {
        EntityLivingBase lvt_1_1_ = this.entityHost.getAttackTarget();
        if (lvt_1_1_ == null) {
            return false;
        }
        this.attackTarget = lvt_1_1_;
        return true;
    }

    @Override
    public boolean continueExecuting() {
        return this.shouldExecute() || !this.entityHost.getNavigator().noPath();
    }

    @Override
    public void resetTask() {
        this.attackTarget = null;
        this.seeTime = 0;
        this.rangedAttackTime = -1;
    }

    @Override
    public void updateTask() {
        double lvt_1_1_ = this.entityHost.getDistanceSq(this.attackTarget.posX, this.attackTarget.getEntityBoundingBox().minY, this.attackTarget.posZ);
        boolean lvt_3_1_ = this.entityHost.getEntitySenses().canSee(this.attackTarget);
        this.seeTime = lvt_3_1_ ? ++this.seeTime : 0;
        if (lvt_1_1_ > (double)this.maxAttackDistance || this.seeTime < 20) {
            this.entityHost.getNavigator().tryMoveToEntityLiving(this.attackTarget, this.entityMoveSpeed);
        } else {
            this.entityHost.getNavigator().clearPathEntity();
        }
        this.entityHost.getLookHelper().setLookPositionWithEntity(this.attackTarget, 30.0f, 30.0f);
        if (--this.rangedAttackTime == 0) {
            float lvt_4_1_;
            if (!lvt_3_1_) {
                return;
            }
            float lvt_5_1_ = lvt_4_1_ = MathHelper.sqrt(lvt_1_1_) / this.attackRadius;
            lvt_5_1_ = MathHelper.clamp(lvt_5_1_, 0.1f, 1.0f);
            this.rangedAttackEntityHost.attackEntityWithRangedAttack(this.attackTarget, lvt_5_1_);
            this.rangedAttackTime = MathHelper.floor(lvt_4_1_ * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin);
        } else if (this.rangedAttackTime < 0) {
            float lvt_4_2_ = MathHelper.sqrt(lvt_1_1_) / this.attackRadius;
            this.rangedAttackTime = MathHelper.floor(lvt_4_2_ * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin);
        }
    }
}

