/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBow;
import net.minecraft.util.EnumHand;

public class EntityAIAttackRangedBow
extends EntityAIBase {
    private final AbstractSkeleton entity;
    private final double moveSpeedAmp;
    private int attackCooldown;
    private final float maxAttackDistance;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public EntityAIAttackRangedBow(AbstractSkeleton p_i46805_1_, double p_i46805_2_, int p_i46805_4_, float p_i46805_5_) {
        this.entity = p_i46805_1_;
        this.moveSpeedAmp = p_i46805_2_;
        this.attackCooldown = p_i46805_4_;
        this.maxAttackDistance = p_i46805_5_ * p_i46805_5_;
        this.setMutexBits(3);
    }

    public void setAttackCooldown(int p_setAttackCooldown_1_) {
        this.attackCooldown = p_setAttackCooldown_1_;
    }

    @Override
    public boolean shouldExecute() {
        if (this.entity.getAttackTarget() == null) {
            return false;
        }
        return this.isBowInMainhand();
    }

    protected boolean isBowInMainhand() {
        return !this.entity.getHeldItemMainhand().isEmpty() && this.entity.getHeldItemMainhand().getItem() == Items.BOW;
    }

    @Override
    public boolean continueExecuting() {
        return (this.shouldExecute() || !this.entity.getNavigator().noPath()) && this.isBowInMainhand();
    }

    @Override
    public void startExecuting() {
        super.startExecuting();
        this.entity.setSwingingArms(true);
    }

    @Override
    public void resetTask() {
        super.resetTask();
        this.entity.setSwingingArms(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.entity.resetActiveHand();
    }

    @Override
    public void updateTask() {
        boolean lvt_5_1_;
        EntityLivingBase lvt_1_1_ = this.entity.getAttackTarget();
        if (lvt_1_1_ == null) {
            return;
        }
        double lvt_2_1_ = this.entity.getDistanceSq(lvt_1_1_.posX, lvt_1_1_.getEntityBoundingBox().minY, lvt_1_1_.posZ);
        boolean lvt_4_1_ = this.entity.getEntitySenses().canSee(lvt_1_1_);
        boolean bl = lvt_5_1_ = this.seeTime > 0;
        if (lvt_4_1_ != lvt_5_1_) {
            this.seeTime = 0;
        }
        this.seeTime = lvt_4_1_ ? ++this.seeTime : --this.seeTime;
        if (lvt_2_1_ > (double)this.maxAttackDistance || this.seeTime < 20) {
            this.entity.getNavigator().tryMoveToEntityLiving(lvt_1_1_, this.moveSpeedAmp);
            this.strafingTime = -1;
        } else {
            this.entity.getNavigator().clearPathEntity();
            ++this.strafingTime;
        }
        if (this.strafingTime >= 20) {
            if ((double)this.entity.getRNG().nextFloat() < 0.3) {
                boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
            }
            if ((double)this.entity.getRNG().nextFloat() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1) {
            if (lvt_2_1_ > (double)(this.maxAttackDistance * 0.75f)) {
                this.strafingBackwards = false;
            } else if (lvt_2_1_ < (double)(this.maxAttackDistance * 0.25f)) {
                this.strafingBackwards = true;
            }
            this.entity.getMoveHelper().strafe(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
            this.entity.faceEntity(lvt_1_1_, 30.0f, 30.0f);
        } else {
            this.entity.getLookHelper().setLookPositionWithEntity(lvt_1_1_, 30.0f, 30.0f);
        }
        if (this.entity.isHandActive()) {
            int lvt_6_1_;
            if (!lvt_4_1_ && this.seeTime < -60) {
                this.entity.resetActiveHand();
            } else if (lvt_4_1_ && (lvt_6_1_ = this.entity.getItemInUseMaxCount()) >= 20) {
                this.entity.resetActiveHand();
                this.entity.attackEntityWithRangedAttack(lvt_1_1_, ItemBow.getArrowVelocity(lvt_6_1_));
                this.attackTime = this.attackCooldown;
            }
        } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
            this.entity.setActiveHand(EnumHand.MAIN_HAND);
        }
    }
}

