/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class EntityAIBeg
extends EntityAIBase {
    private final EntityWolf theWolf;
    private EntityPlayer player;
    private final World world;
    private final float minPlayerDistance;
    private int timeoutCounter;

    public EntityAIBeg(EntityWolf p_i1617_1_, float p_i1617_2_) {
        this.theWolf = p_i1617_1_;
        this.world = p_i1617_1_.world;
        this.minPlayerDistance = p_i1617_2_;
        this.setMutexBits(2);
    }

    @Override
    public boolean shouldExecute() {
        this.player = this.world.getClosestPlayerToEntity(this.theWolf, this.minPlayerDistance);
        if (this.player == null) {
            return false;
        }
        return this.hasTemptationItemInHand(this.player);
    }

    @Override
    public boolean continueExecuting() {
        if (!this.player.isEntityAlive()) {
            return false;
        }
        if (this.theWolf.getDistanceSqToEntity(this.player) > (double)(this.minPlayerDistance * this.minPlayerDistance)) {
            return false;
        }
        return this.timeoutCounter > 0 && this.hasTemptationItemInHand(this.player);
    }

    @Override
    public void startExecuting() {
        this.theWolf.setBegging(true);
        this.timeoutCounter = 40 + this.theWolf.getRNG().nextInt(40);
    }

    @Override
    public void resetTask() {
        this.theWolf.setBegging(false);
        this.player = null;
    }

    @Override
    public void updateTask() {
        this.theWolf.getLookHelper().setLookPosition(this.player.posX, this.player.posY + (double)this.player.getEyeHeight(), this.player.posZ, 10.0f, this.theWolf.getVerticalFaceSpeed());
        --this.timeoutCounter;
    }

    private boolean hasTemptationItemInHand(EntityPlayer p_hasTemptationItemInHand_1_) {
        for (EnumHand lvt_5_1_ : EnumHand.values()) {
            ItemStack lvt_6_1_ = p_hasTemptationItemInHand_1_.getHeldItem(lvt_5_1_);
            if (this.theWolf.isTamed() && lvt_6_1_.getItem() == Items.BONE) {
                return true;
            }
            if (!this.theWolf.isBreedingItem(lvt_6_1_)) continue;
            return true;
        }
        return false;
    }
}

