/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIDoorInteract;
import net.minecraft.world.EnumDifficulty;

public class EntityAIBreakDoor
extends EntityAIDoorInteract {
    private int breakingTime;
    private int previousBreakProgress = -1;

    public EntityAIBreakDoor(EntityLiving p_i1618_1_) {
        super(p_i1618_1_);
    }

    @Override
    public boolean shouldExecute() {
        if (!super.shouldExecute()) {
            return false;
        }
        if (!this.theEntity.world.getGameRules().getBoolean("mobGriefing")) {
            return false;
        }
        return !BlockDoor.isOpen(this.theEntity.world, this.doorPosition);
    }

    @Override
    public void startExecuting() {
        super.startExecuting();
        this.breakingTime = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean continueExecuting() {
        double lvt_1_1_ = this.theEntity.getDistanceSq(this.doorPosition);
        if (this.breakingTime > 240) return false;
        if (BlockDoor.isOpen(this.theEntity.world, this.doorPosition)) return false;
        if (!(lvt_1_1_ < 4.0)) return false;
        return true;
    }

    @Override
    public void resetTask() {
        super.resetTask();
        this.theEntity.world.sendBlockBreakProgress(this.theEntity.getEntityId(), this.doorPosition, -1);
    }

    @Override
    public void updateTask() {
        super.updateTask();
        if (this.theEntity.getRNG().nextInt(20) == 0) {
            this.theEntity.world.playEvent(1019, this.doorPosition, 0);
        }
        ++this.breakingTime;
        int lvt_1_1_ = (int)((float)this.breakingTime / 240.0f * 10.0f);
        if (lvt_1_1_ != this.previousBreakProgress) {
            this.theEntity.world.sendBlockBreakProgress(this.theEntity.getEntityId(), this.doorPosition, lvt_1_1_);
            this.previousBreakProgress = lvt_1_1_;
        }
        if (this.breakingTime == 240 && this.theEntity.world.getDifficulty() == EnumDifficulty.HARD) {
            this.theEntity.world.setBlockToAir(this.doorPosition);
            this.theEntity.world.playEvent(1021, this.doorPosition, 0);
            this.theEntity.world.playEvent(2001, this.doorPosition, Block.getIdFromBlock(this.doorBlock));
        }
    }
}

