/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;

public abstract class EntityAIDoorInteract
extends EntityAIBase {
    protected EntityLiving theEntity;
    protected BlockPos doorPosition = BlockPos.ORIGIN;
    protected BlockDoor doorBlock;
    boolean hasStoppedDoorInteraction;
    float entityPositionX;
    float entityPositionZ;

    public EntityAIDoorInteract(EntityLiving p_i1621_1_) {
        this.theEntity = p_i1621_1_;
        if (!(p_i1621_1_.getNavigator() instanceof PathNavigateGround)) {
            throw new IllegalArgumentException("Unsupported mob type for DoorInteractGoal");
        }
    }

    @Override
    public boolean shouldExecute() {
        if (!this.theEntity.isCollidedHorizontally) {
            return false;
        }
        PathNavigateGround lvt_1_1_ = (PathNavigateGround)this.theEntity.getNavigator();
        Path lvt_2_1_ = lvt_1_1_.getPath();
        if (lvt_2_1_ == null || lvt_2_1_.isFinished() || !lvt_1_1_.getEnterDoors()) {
            return false;
        }
        for (int lvt_3_1_ = 0; lvt_3_1_ < Math.min(lvt_2_1_.getCurrentPathIndex() + 2, lvt_2_1_.getCurrentPathLength()); ++lvt_3_1_) {
            PathPoint lvt_4_1_ = lvt_2_1_.getPathPointFromIndex(lvt_3_1_);
            this.doorPosition = new BlockPos(lvt_4_1_.xCoord, lvt_4_1_.yCoord + 1, lvt_4_1_.zCoord);
            if (this.theEntity.getDistanceSq(this.doorPosition.getX(), this.theEntity.posY, this.doorPosition.getZ()) > 2.25) continue;
            this.doorBlock = this.getBlockDoor(this.doorPosition);
            if (this.doorBlock == null) continue;
            return true;
        }
        this.doorPosition = new BlockPos(this.theEntity).up();
        this.doorBlock = this.getBlockDoor(this.doorPosition);
        return this.doorBlock != null;
    }

    @Override
    public boolean continueExecuting() {
        return !this.hasStoppedDoorInteraction;
    }

    @Override
    public void startExecuting() {
        this.hasStoppedDoorInteraction = false;
        this.entityPositionX = (float)((double)((float)this.doorPosition.getX() + 0.5f) - this.theEntity.posX);
        this.entityPositionZ = (float)((double)((float)this.doorPosition.getZ() + 0.5f) - this.theEntity.posZ);
    }

    @Override
    public void updateTask() {
        float lvt_2_1_;
        float lvt_1_1_ = (float)((double)((float)this.doorPosition.getX() + 0.5f) - this.theEntity.posX);
        float lvt_3_1_ = this.entityPositionX * lvt_1_1_ + this.entityPositionZ * (lvt_2_1_ = (float)((double)((float)this.doorPosition.getZ() + 0.5f) - this.theEntity.posZ));
        if (lvt_3_1_ < 0.0f) {
            this.hasStoppedDoorInteraction = true;
        }
    }

    private BlockDoor getBlockDoor(BlockPos p_getBlockDoor_1_) {
        IBlockState lvt_2_1_ = this.theEntity.world.getBlockState(p_getBlockDoor_1_);
        Block lvt_3_1_ = lvt_2_1_.getBlock();
        if (lvt_3_1_ instanceof BlockDoor && lvt_2_1_.getMaterial() == Material.WOOD) {
            return (BlockDoor)lvt_3_1_;
        }
        return null;
    }
}

