/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityAIEatGrass
extends EntityAIBase {
    private static final Predicate<IBlockState> IS_TALL_GRASS = BlockStateMatcher.forBlock(Blocks.TALLGRASS).where(BlockTallGrass.TYPE, Predicates.equalTo((Object)BlockTallGrass.EnumType.GRASS));
    private final EntityLiving grassEaterEntity;
    private final World entityWorld;
    int eatingGrassTimer;

    public EntityAIEatGrass(EntityLiving p_i45314_1_) {
        this.grassEaterEntity = p_i45314_1_;
        this.entityWorld = p_i45314_1_.world;
        this.setMutexBits(7);
    }

    @Override
    public boolean shouldExecute() {
        if (this.grassEaterEntity.getRNG().nextInt(this.grassEaterEntity.isChild() ? 50 : 1000) != 0) {
            return false;
        }
        BlockPos lvt_1_1_ = new BlockPos(this.grassEaterEntity.posX, this.grassEaterEntity.posY, this.grassEaterEntity.posZ);
        if (IS_TALL_GRASS.apply((Object)this.entityWorld.getBlockState(lvt_1_1_))) {
            return true;
        }
        return this.entityWorld.getBlockState(lvt_1_1_.down()).getBlock() == Blocks.GRASS;
    }

    @Override
    public void startExecuting() {
        this.eatingGrassTimer = 40;
        this.entityWorld.setEntityState(this.grassEaterEntity, (byte)10);
        this.grassEaterEntity.getNavigator().clearPathEntity();
    }

    @Override
    public void resetTask() {
        this.eatingGrassTimer = 0;
    }

    @Override
    public boolean continueExecuting() {
        return this.eatingGrassTimer > 0;
    }

    public int getEatingGrassTimer() {
        return this.eatingGrassTimer;
    }

    @Override
    public void updateTask() {
        this.eatingGrassTimer = Math.max(0, this.eatingGrassTimer - 1);
        if (this.eatingGrassTimer != 4) {
            return;
        }
        BlockPos lvt_1_1_ = new BlockPos(this.grassEaterEntity.posX, this.grassEaterEntity.posY, this.grassEaterEntity.posZ);
        if (IS_TALL_GRASS.apply((Object)this.entityWorld.getBlockState(lvt_1_1_))) {
            if (this.entityWorld.getGameRules().getBoolean("mobGriefing")) {
                this.entityWorld.destroyBlock(lvt_1_1_, false);
            }
            this.grassEaterEntity.eatGrassBonus();
        } else {
            BlockPos lvt_2_1_ = lvt_1_1_.down();
            if (this.entityWorld.getBlockState(lvt_2_1_).getBlock() == Blocks.GRASS) {
                if (this.entityWorld.getGameRules().getBoolean("mobGriefing")) {
                    this.entityWorld.playEvent(2001, lvt_2_1_, Block.getIdFromBlock(Blocks.GRASS));
                    this.entityWorld.setBlockState(lvt_2_1_, Blocks.DIRT.getDefaultState(), 2);
                }
                this.grassEaterEntity.eatGrassBonus();
            }
        }
    }
}

