/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityAIFindEntityNearest
extends EntityAIBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final EntityLiving mob;
    private final Predicate<EntityLivingBase> predicate;
    private final EntityAINearestAttackableTarget.Sorter sorter;
    private EntityLivingBase target;
    private final Class<? extends EntityLivingBase> classToCheck;

    public EntityAIFindEntityNearest(EntityLiving p_i45884_1_, Class<? extends EntityLivingBase> p_i45884_2_) {
        this.mob = p_i45884_1_;
        this.classToCheck = p_i45884_2_;
        if (p_i45884_1_ instanceof EntityCreature) {
            LOGGER.warn("Use NearestAttackableTargetGoal.class for PathfinerMob mobs!");
        }
        this.predicate = new Predicate<EntityLivingBase>(){

            public boolean apply(EntityLivingBase p_apply_1_) {
                double lvt_2_1_ = EntityAIFindEntityNearest.this.getFollowRange();
                if (p_apply_1_.isSneaking()) {
                    lvt_2_1_ *= (double)0.8f;
                }
                if (p_apply_1_.isInvisible()) {
                    return false;
                }
                if ((double)p_apply_1_.getDistanceToEntity(EntityAIFindEntityNearest.this.mob) > lvt_2_1_) {
                    return false;
                }
                return EntityAITarget.isSuitableTarget(EntityAIFindEntityNearest.this.mob, p_apply_1_, false, true);
            }

            public /* synthetic */ boolean apply(Object p_apply_1_) {
                return this.apply((EntityLivingBase)p_apply_1_);
            }
        };
        this.sorter = new EntityAINearestAttackableTarget.Sorter(p_i45884_1_);
    }

    @Override
    public boolean shouldExecute() {
        double lvt_1_1_ = this.getFollowRange();
        List<EntityLivingBase> lvt_3_1_ = this.mob.world.getEntitiesWithinAABB(this.classToCheck, this.mob.getEntityBoundingBox().expand(lvt_1_1_, 4.0, lvt_1_1_), this.predicate);
        Collections.sort(lvt_3_1_, this.sorter);
        if (lvt_3_1_.isEmpty()) {
            return false;
        }
        this.target = lvt_3_1_.get(0);
        return true;
    }

    @Override
    public boolean continueExecuting() {
        EntityLivingBase lvt_1_1_ = this.mob.getAttackTarget();
        if (lvt_1_1_ == null) {
            return false;
        }
        if (!lvt_1_1_.isEntityAlive()) {
            return false;
        }
        double lvt_2_1_ = this.getFollowRange();
        if (this.mob.getDistanceSqToEntity(lvt_1_1_) > lvt_2_1_ * lvt_2_1_) {
            return false;
        }
        return !(lvt_1_1_ instanceof EntityPlayerMP) || !((EntityPlayerMP)lvt_1_1_).interactionManager.isCreative();
    }

    @Override
    public void startExecuting() {
        this.mob.setAttackTarget(this.target);
        super.startExecuting();
    }

    @Override
    public void resetTask() {
        this.mob.setAttackTarget(null);
        super.startExecuting();
    }

    protected double getFollowRange() {
        IAttributeInstance lvt_1_1_ = this.mob.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE);
        return lvt_1_1_ == null ? 16.0 : lvt_1_1_.getAttributeValue();
    }
}

