/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.Team;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityAIFindEntityNearestPlayer
extends EntityAIBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final EntityLiving entityLiving;
    private final Predicate<Entity> predicate;
    private final EntityAINearestAttackableTarget.Sorter sorter;
    private EntityLivingBase entityTarget;

    public EntityAIFindEntityNearestPlayer(EntityLiving p_i45882_1_) {
        this.entityLiving = p_i45882_1_;
        if (p_i45882_1_ instanceof EntityCreature) {
            LOGGER.warn("Use NearestAttackableTargetGoal.class for PathfinerMob mobs!");
        }
        this.predicate = new Predicate<Entity>(){

            public boolean apply(Entity p_apply_1_) {
                if (!(p_apply_1_ instanceof EntityPlayer)) {
                    return false;
                }
                if (((EntityPlayer)p_apply_1_).capabilities.disableDamage) {
                    return false;
                }
                double lvt_2_1_ = EntityAIFindEntityNearestPlayer.this.maxTargetRange();
                if (p_apply_1_.isSneaking()) {
                    lvt_2_1_ *= (double)0.8f;
                }
                if (p_apply_1_.isInvisible()) {
                    float lvt_4_1_ = ((EntityPlayer)p_apply_1_).getArmorVisibility();
                    if (lvt_4_1_ < 0.1f) {
                        lvt_4_1_ = 0.1f;
                    }
                    lvt_2_1_ *= (double)(0.7f * lvt_4_1_);
                }
                if ((double)p_apply_1_.getDistanceToEntity(EntityAIFindEntityNearestPlayer.this.entityLiving) > lvt_2_1_) {
                    return false;
                }
                return EntityAITarget.isSuitableTarget(EntityAIFindEntityNearestPlayer.this.entityLiving, (EntityLivingBase)p_apply_1_, false, true);
            }

            public /* synthetic */ boolean apply(Object p_apply_1_) {
                return this.apply((Entity)p_apply_1_);
            }
        };
        this.sorter = new EntityAINearestAttackableTarget.Sorter(p_i45882_1_);
    }

    @Override
    public boolean shouldExecute() {
        double lvt_1_1_ = this.maxTargetRange();
        List<Entity> lvt_3_1_ = this.entityLiving.world.getEntitiesWithinAABB(EntityPlayer.class, this.entityLiving.getEntityBoundingBox().expand(lvt_1_1_, 4.0, lvt_1_1_), this.predicate);
        Collections.sort(lvt_3_1_, this.sorter);
        if (lvt_3_1_.isEmpty()) {
            return false;
        }
        this.entityTarget = (EntityLivingBase)lvt_3_1_.get(0);
        return true;
    }

    @Override
    public boolean continueExecuting() {
        EntityLivingBase lvt_1_1_ = this.entityLiving.getAttackTarget();
        if (lvt_1_1_ == null) {
            return false;
        }
        if (!lvt_1_1_.isEntityAlive()) {
            return false;
        }
        if (lvt_1_1_ instanceof EntityPlayer && ((EntityPlayer)lvt_1_1_).capabilities.disableDamage) {
            return false;
        }
        Team lvt_2_1_ = this.entityLiving.getTeam();
        Team lvt_3_1_ = lvt_1_1_.getTeam();
        if (lvt_2_1_ != null && lvt_3_1_ == lvt_2_1_) {
            return false;
        }
        double lvt_4_1_ = this.maxTargetRange();
        if (this.entityLiving.getDistanceSqToEntity(lvt_1_1_) > lvt_4_1_ * lvt_4_1_) {
            return false;
        }
        return !(lvt_1_1_ instanceof EntityPlayerMP) || !((EntityPlayerMP)lvt_1_1_).interactionManager.isCreative();
    }

    @Override
    public void startExecuting() {
        this.entityLiving.setAttackTarget(this.entityTarget);
        super.startExecuting();
    }

    @Override
    public void resetTask() {
        this.entityLiving.setAttackTarget(null);
        super.startExecuting();
    }

    protected double maxTargetRange() {
        IAttributeInstance lvt_1_1_ = this.entityLiving.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE);
        return lvt_1_1_ == null ? 16.0 : lvt_1_1_.getAttributeValue();
    }
}

