/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityAIFollowOwner
extends EntityAIBase {
    private final EntityTameable thePet;
    private EntityLivingBase theOwner;
    World world;
    private final double followSpeed;
    private final PathNavigate petPathfinder;
    private int timeToRecalcPath;
    float maxDist;
    float minDist;
    private float oldWaterCost;

    public EntityAIFollowOwner(EntityTameable p_i1625_1_, double p_i1625_2_, float p_i1625_4_, float p_i1625_5_) {
        this.thePet = p_i1625_1_;
        this.world = p_i1625_1_.world;
        this.followSpeed = p_i1625_2_;
        this.petPathfinder = p_i1625_1_.getNavigator();
        this.minDist = p_i1625_4_;
        this.maxDist = p_i1625_5_;
        this.setMutexBits(3);
        if (!(p_i1625_1_.getNavigator() instanceof PathNavigateGround)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    @Override
    public boolean shouldExecute() {
        EntityLivingBase lvt_1_1_ = this.thePet.getOwner();
        if (lvt_1_1_ == null) {
            return false;
        }
        if (lvt_1_1_ instanceof EntityPlayer && ((EntityPlayer)lvt_1_1_).isSpectator()) {
            return false;
        }
        if (this.thePet.isSitting()) {
            return false;
        }
        if (this.thePet.getDistanceSqToEntity(lvt_1_1_) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.theOwner = lvt_1_1_;
        return true;
    }

    @Override
    public boolean continueExecuting() {
        return !this.petPathfinder.noPath() && this.thePet.getDistanceSqToEntity(this.theOwner) > (double)(this.maxDist * this.maxDist) && !this.thePet.isSitting();
    }

    @Override
    public void startExecuting() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.thePet.getPathPriority(PathNodeType.WATER);
        this.thePet.setPathPriority(PathNodeType.WATER, 0.0f);
    }

    @Override
    public void resetTask() {
        this.theOwner = null;
        this.petPathfinder.clearPathEntity();
        this.thePet.setPathPriority(PathNodeType.WATER, this.oldWaterCost);
    }

    private boolean isEmptyBlock(BlockPos p_isEmptyBlock_1_) {
        IBlockState lvt_2_1_ = this.world.getBlockState(p_isEmptyBlock_1_);
        if (lvt_2_1_.getMaterial() == Material.AIR) {
            return true;
        }
        return !lvt_2_1_.isFullCube();
    }

    @Override
    public void updateTask() {
        this.thePet.getLookHelper().setLookPositionWithEntity(this.theOwner, 10.0f, this.thePet.getVerticalFaceSpeed());
        if (this.thePet.isSitting()) {
            return;
        }
        if (--this.timeToRecalcPath > 0) {
            return;
        }
        this.timeToRecalcPath = 10;
        if (this.petPathfinder.tryMoveToEntityLiving(this.theOwner, this.followSpeed)) {
            return;
        }
        if (this.thePet.getLeashed()) {
            return;
        }
        if (this.thePet.getDistanceSqToEntity(this.theOwner) < 144.0) {
            return;
        }
        int lvt_1_1_ = MathHelper.floor(this.theOwner.posX) - 2;
        int lvt_2_1_ = MathHelper.floor(this.theOwner.posZ) - 2;
        int lvt_3_1_ = MathHelper.floor(this.theOwner.getEntityBoundingBox().minY);
        for (int lvt_4_1_ = 0; lvt_4_1_ <= 4; ++lvt_4_1_) {
            for (int lvt_5_1_ = 0; lvt_5_1_ <= 4; ++lvt_5_1_) {
                if (lvt_4_1_ >= 1 && lvt_5_1_ >= 1 && lvt_4_1_ <= 3 && lvt_5_1_ <= 3 || !this.world.getBlockState(new BlockPos(lvt_1_1_ + lvt_4_1_, lvt_3_1_ - 1, lvt_2_1_ + lvt_5_1_)).isFullyOpaque() || !this.isEmptyBlock(new BlockPos(lvt_1_1_ + lvt_4_1_, lvt_3_1_, lvt_2_1_ + lvt_5_1_)) || !this.isEmptyBlock(new BlockPos(lvt_1_1_ + lvt_4_1_, lvt_3_1_ + 1, lvt_2_1_ + lvt_5_1_))) continue;
                this.thePet.setLocationAndAngles((float)(lvt_1_1_ + lvt_4_1_) + 0.5f, lvt_3_1_, (float)(lvt_2_1_ + lvt_5_1_) + 0.5f, this.thePet.rotationYaw, this.thePet.rotationPitch);
                this.petPathfinder.clearPathEntity();
                return;
            }
        }
    }
}

