/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import java.util.List;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;

public class EntityAIFollowParent
extends EntityAIBase {
    EntityAnimal childAnimal;
    EntityAnimal parentAnimal;
    double moveSpeed;
    private int delayCounter;

    public EntityAIFollowParent(EntityAnimal p_i1626_1_, double p_i1626_2_) {
        this.childAnimal = p_i1626_1_;
        this.moveSpeed = p_i1626_2_;
    }

    @Override
    public boolean shouldExecute() {
        if (this.childAnimal.getGrowingAge() >= 0) {
            return false;
        }
        List<?> lvt_1_1_ = this.childAnimal.world.getEntitiesWithinAABB(this.childAnimal.getClass(), this.childAnimal.getEntityBoundingBox().expand(8.0, 4.0, 8.0));
        EntityAnimal lvt_2_1_ = null;
        double lvt_3_1_ = Double.MAX_VALUE;
        for (EntityAnimal lvt_6_1_ : lvt_1_1_) {
            double lvt_7_1_;
            if (lvt_6_1_.getGrowingAge() < 0 || (lvt_7_1_ = this.childAnimal.getDistanceSqToEntity(lvt_6_1_)) > lvt_3_1_) continue;
            lvt_3_1_ = lvt_7_1_;
            lvt_2_1_ = lvt_6_1_;
        }
        if (lvt_2_1_ == null) {
            return false;
        }
        if (lvt_3_1_ < 9.0) {
            return false;
        }
        this.parentAnimal = lvt_2_1_;
        return true;
    }

    @Override
    public boolean continueExecuting() {
        if (this.childAnimal.getGrowingAge() >= 0) {
            return false;
        }
        if (!this.parentAnimal.isEntityAlive()) {
            return false;
        }
        double lvt_1_1_ = this.childAnimal.getDistanceSqToEntity(this.parentAnimal);
        return !(lvt_1_1_ < 9.0) && !(lvt_1_1_ > 256.0);
    }

    @Override
    public void startExecuting() {
        this.delayCounter = 0;
    }

    @Override
    public void resetTask() {
        this.parentAnimal = null;
    }

    @Override
    public void updateTask() {
        if (--this.delayCounter > 0) {
            return;
        }
        this.delayCounter = 10;
        this.childAnimal.getNavigator().tryMoveToEntityLiving(this.parentAnimal, this.moveSpeed);
    }
}

