/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityAIHarvestFarmland
extends EntityAIMoveToBlock {
    private final EntityVillager theVillager;
    private boolean hasFarmItem;
    private boolean wantsToReapStuff;
    private int currentTask;

    public EntityAIHarvestFarmland(EntityVillager p_i45889_1_, double p_i45889_2_) {
        super(p_i45889_1_, p_i45889_2_, 16);
        this.theVillager = p_i45889_1_;
    }

    @Override
    public boolean shouldExecute() {
        if (this.runDelay <= 0) {
            if (!this.theVillager.world.getGameRules().getBoolean("mobGriefing")) {
                return false;
            }
            this.currentTask = -1;
            this.hasFarmItem = this.theVillager.isFarmItemInInventory();
            this.wantsToReapStuff = this.theVillager.wantsMoreFood();
        }
        return super.shouldExecute();
    }

    @Override
    public boolean continueExecuting() {
        return this.currentTask >= 0 && super.continueExecuting();
    }

    @Override
    public void updateTask() {
        super.updateTask();
        this.theVillager.getLookHelper().setLookPosition((double)this.destinationBlock.getX() + 0.5, this.destinationBlock.getY() + 1, (double)this.destinationBlock.getZ() + 0.5, 10.0f, this.theVillager.getVerticalFaceSpeed());
        if (this.getIsAboveDestination()) {
            World lvt_1_1_ = this.theVillager.world;
            BlockPos lvt_2_1_ = this.destinationBlock.up();
            IBlockState lvt_3_1_ = lvt_1_1_.getBlockState(lvt_2_1_);
            Block lvt_4_1_ = lvt_3_1_.getBlock();
            if (this.currentTask == 0 && lvt_4_1_ instanceof BlockCrops && ((BlockCrops)lvt_4_1_).isMaxAge(lvt_3_1_)) {
                lvt_1_1_.destroyBlock(lvt_2_1_, true);
            } else if (this.currentTask == 1 && lvt_3_1_.getMaterial() == Material.AIR) {
                InventoryBasic lvt_5_1_ = this.theVillager.getVillagerInventory();
                for (int lvt_6_1_ = 0; lvt_6_1_ < lvt_5_1_.getSizeInventory(); ++lvt_6_1_) {
                    ItemStack lvt_7_1_ = lvt_5_1_.getStackInSlot(lvt_6_1_);
                    boolean lvt_8_1_ = false;
                    if (!lvt_7_1_.isEmpty()) {
                        if (lvt_7_1_.getItem() == Items.WHEAT_SEEDS) {
                            lvt_1_1_.setBlockState(lvt_2_1_, Blocks.WHEAT.getDefaultState(), 3);
                            lvt_8_1_ = true;
                        } else if (lvt_7_1_.getItem() == Items.POTATO) {
                            lvt_1_1_.setBlockState(lvt_2_1_, Blocks.POTATOES.getDefaultState(), 3);
                            lvt_8_1_ = true;
                        } else if (lvt_7_1_.getItem() == Items.CARROT) {
                            lvt_1_1_.setBlockState(lvt_2_1_, Blocks.CARROTS.getDefaultState(), 3);
                            lvt_8_1_ = true;
                        } else if (lvt_7_1_.getItem() == Items.BEETROOT_SEEDS) {
                            lvt_1_1_.setBlockState(lvt_2_1_, Blocks.BEETROOTS.getDefaultState(), 3);
                            lvt_8_1_ = true;
                        }
                    }
                    if (!lvt_8_1_) continue;
                    lvt_7_1_.shrink(1);
                    if (!lvt_7_1_.isEmpty()) break;
                    lvt_5_1_.setInventorySlotContents(lvt_6_1_, ItemStack.EMPTY);
                    break;
                }
            }
            this.currentTask = -1;
            this.runDelay = 10;
        }
    }

    @Override
    protected boolean shouldMoveTo(World p_shouldMoveTo_1_, BlockPos p_shouldMoveTo_2_) {
        Block lvt_3_1_ = p_shouldMoveTo_1_.getBlockState(p_shouldMoveTo_2_).getBlock();
        if (lvt_3_1_ == Blocks.FARMLAND) {
            IBlockState lvt_4_1_ = p_shouldMoveTo_1_.getBlockState(p_shouldMoveTo_2_ = p_shouldMoveTo_2_.up());
            lvt_3_1_ = lvt_4_1_.getBlock();
            if (lvt_3_1_ instanceof BlockCrops && ((BlockCrops)lvt_3_1_).isMaxAge(lvt_4_1_) && this.wantsToReapStuff && (this.currentTask == 0 || this.currentTask < 0)) {
                this.currentTask = 0;
                return true;
            }
            if (lvt_4_1_.getMaterial() == Material.AIR && this.hasFarmItem && (this.currentTask == 1 || this.currentTask < 0)) {
                this.currentTask = 1;
                return true;
            }
        }
        return false;
    }
}

