/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import java.util.List;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.util.math.AxisAlignedBB;

public class EntityAIHurtByTarget
extends EntityAITarget {
    private final boolean entityCallsForHelp;
    private int revengeTimerOld;
    private final Class<?>[] targetClasses;

    public EntityAIHurtByTarget(EntityCreature p_i45885_1_, boolean p_i45885_2_, Class<?> ... p_i45885_3_) {
        super(p_i45885_1_, true);
        this.entityCallsForHelp = p_i45885_2_;
        this.targetClasses = p_i45885_3_;
        this.setMutexBits(1);
    }

    @Override
    public boolean shouldExecute() {
        int lvt_1_1_ = this.taskOwner.getRevengeTimer();
        EntityLivingBase lvt_2_1_ = this.taskOwner.getAITarget();
        return lvt_1_1_ != this.revengeTimerOld && lvt_2_1_ != null && this.isSuitableTarget(lvt_2_1_, false);
    }

    @Override
    public void startExecuting() {
        this.taskOwner.setAttackTarget(this.taskOwner.getAITarget());
        this.target = this.taskOwner.getAttackTarget();
        this.revengeTimerOld = this.taskOwner.getRevengeTimer();
        this.unseenMemoryTicks = 300;
        if (this.entityCallsForHelp) {
            this.alertOthers();
        }
        super.startExecuting();
    }

    protected void alertOthers() {
        double lvt_1_1_ = this.getTargetDistance();
        List<?> lvt_3_1_ = this.taskOwner.world.getEntitiesWithinAABB(this.taskOwner.getClass(), new AxisAlignedBB(this.taskOwner.posX, this.taskOwner.posY, this.taskOwner.posZ, this.taskOwner.posX + 1.0, this.taskOwner.posY + 1.0, this.taskOwner.posZ + 1.0).expand(lvt_1_1_, 10.0, lvt_1_1_));
        for (EntityCreature lvt_5_1_ : lvt_3_1_) {
            if (this.taskOwner == lvt_5_1_ || lvt_5_1_.getAttackTarget() != null || this.taskOwner instanceof EntityTameable && ((EntityTameable)this.taskOwner).getOwner() != ((EntityTameable)lvt_5_1_).getOwner() || lvt_5_1_.isOnSameTeam(this.taskOwner.getAITarget())) continue;
            boolean lvt_6_1_ = false;
            for (Class<?> lvt_10_1_ : this.targetClasses) {
                if (lvt_5_1_.getClass() != lvt_10_1_) continue;
                lvt_6_1_ = true;
                break;
            }
            if (lvt_6_1_) continue;
            this.setEntityAttackTarget(lvt_5_1_, this.taskOwner.getAITarget());
        }
    }

    protected void setEntityAttackTarget(EntityCreature p_setEntityAttackTarget_1_, EntityLivingBase p_setEntityAttackTarget_2_) {
        p_setEntityAttackTarget_1_.setAttackTarget(p_setEntityAttackTarget_2_);
    }
}

