/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.MathHelper;

public class EntityAILeapAtTarget
extends EntityAIBase {
    EntityLiving leaper;
    EntityLivingBase leapTarget;
    float leapMotionY;

    public EntityAILeapAtTarget(EntityLiving p_i1630_1_, float p_i1630_2_) {
        this.leaper = p_i1630_1_;
        this.leapMotionY = p_i1630_2_;
        this.setMutexBits(5);
    }

    @Override
    public boolean shouldExecute() {
        this.leapTarget = this.leaper.getAttackTarget();
        if (this.leapTarget == null) {
            return false;
        }
        double lvt_1_1_ = this.leaper.getDistanceSqToEntity(this.leapTarget);
        if (lvt_1_1_ < 4.0 || lvt_1_1_ > 16.0) {
            return false;
        }
        if (!this.leaper.onGround) {
            return false;
        }
        return this.leaper.getRNG().nextInt(5) == 0;
    }

    @Override
    public boolean continueExecuting() {
        return !this.leaper.onGround;
    }

    @Override
    public void startExecuting() {
        double lvt_1_1_ = this.leapTarget.posX - this.leaper.posX;
        double lvt_3_1_ = this.leapTarget.posZ - this.leaper.posZ;
        float lvt_5_1_ = MathHelper.sqrt(lvt_1_1_ * lvt_1_1_ + lvt_3_1_ * lvt_3_1_);
        if ((double)lvt_5_1_ >= 1.0E-4) {
            this.leaper.motionX += lvt_1_1_ / (double)lvt_5_1_ * 0.5 * (double)0.8f + this.leaper.motionX * (double)0.2f;
            this.leaper.motionZ += lvt_3_1_ / (double)lvt_5_1_ * 0.5 * (double)0.8f + this.leaper.motionZ * (double)0.2f;
        }
        this.leaper.motionY = this.leapMotionY;
    }
}

