/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.util.math.Vec3d;

public class EntityAILlamaFollowCaravan
extends EntityAIBase {
    public EntityLlama llama;
    private double speedModifier;
    private int distCheckCounter;

    public EntityAILlamaFollowCaravan(EntityLlama p_i47305_1_, double p_i47305_2_) {
        this.llama = p_i47305_1_;
        this.speedModifier = p_i47305_2_;
        this.setMutexBits(1);
    }

    @Override
    public boolean shouldExecute() {
        if (this.llama.getLeashed() || this.llama.inCaravan()) {
            return false;
        }
        List<?> lvt_1_1_ = this.llama.world.getEntitiesWithinAABB(this.llama.getClass(), this.llama.getEntityBoundingBox().expand(9.0, 4.0, 9.0));
        EntityLiving lvt_2_1_ = null;
        double lvt_3_1_ = Double.MAX_VALUE;
        for (EntityLlama lvt_6_1_ : lvt_1_1_) {
            double lvt_7_1_;
            if (!lvt_6_1_.inCaravan() || lvt_6_1_.hasCaravanTrail() || (lvt_7_1_ = this.llama.getDistanceSqToEntity(lvt_6_1_)) > lvt_3_1_) continue;
            lvt_3_1_ = lvt_7_1_;
            lvt_2_1_ = lvt_6_1_;
        }
        if (lvt_2_1_ == null) {
            for (EntityLlama lvt_6_2_ : lvt_1_1_) {
                double lvt_7_2_;
                if (!lvt_6_2_.getLeashed() || lvt_6_2_.hasCaravanTrail() || (lvt_7_2_ = this.llama.getDistanceSqToEntity(lvt_6_2_)) > lvt_3_1_) continue;
                lvt_3_1_ = lvt_7_2_;
                lvt_2_1_ = lvt_6_2_;
            }
        }
        if (lvt_2_1_ == null) {
            return false;
        }
        if (lvt_3_1_ < 4.0) {
            return false;
        }
        if (!lvt_2_1_.getLeashed() && !this.firstIsLeashed((EntityLlama)lvt_2_1_, 1)) {
            return false;
        }
        this.llama.joinCaravan((EntityLlama)lvt_2_1_);
        return true;
    }

    @Override
    public boolean continueExecuting() {
        if (!(this.llama.inCaravan() && this.llama.getCaravanHead().isEntityAlive() && this.firstIsLeashed(this.llama, 0))) {
            return false;
        }
        double lvt_1_1_ = this.llama.getDistanceSqToEntity(this.llama.getCaravanHead());
        if (lvt_1_1_ > 676.0) {
            if (this.speedModifier <= 3.0) {
                this.speedModifier *= 1.2;
                this.distCheckCounter = 40;
                return true;
            }
            if (this.distCheckCounter == 0) {
                return false;
            }
        }
        if (this.distCheckCounter > 0) {
            --this.distCheckCounter;
        }
        return true;
    }

    @Override
    public void resetTask() {
        this.llama.leaveCaravan();
        this.speedModifier = 2.1;
    }

    @Override
    public void updateTask() {
        if (!this.llama.inCaravan()) {
            return;
        }
        EntityLlama lvt_1_1_ = this.llama.getCaravanHead();
        double lvt_2_1_ = this.llama.getDistanceToEntity(lvt_1_1_);
        float lvt_4_1_ = 2.0f;
        Vec3d lvt_5_1_ = new Vec3d(lvt_1_1_.posX - this.llama.posX, lvt_1_1_.posY - this.llama.posY, lvt_1_1_.posZ - this.llama.posZ).normalize().scale(Math.max(lvt_2_1_ - 2.0, 0.0));
        this.llama.getNavigator().tryMoveToXYZ(this.llama.posX + lvt_5_1_.xCoord, this.llama.posY + lvt_5_1_.yCoord, this.llama.posZ + lvt_5_1_.zCoord, this.speedModifier);
    }

    private boolean firstIsLeashed(EntityLlama p_firstIsLeashed_1_, int p_firstIsLeashed_2_) {
        if (p_firstIsLeashed_2_ > 8) {
            return false;
        }
        if (p_firstIsLeashed_1_.inCaravan()) {
            if (p_firstIsLeashed_1_.getCaravanHead().getLeashed()) {
                return true;
            }
            return this.firstIsLeashed(p_firstIsLeashed_1_.getCaravanHead(), ++p_firstIsLeashed_2_);
        }
        return false;
    }
}

