/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.Village;
import net.minecraft.village.VillageDoorInfo;

public class EntityAIMoveIndoors
extends EntityAIBase {
    private final EntityCreature entityObj;
    private VillageDoorInfo doorInfo;
    private int insidePosX = -1;
    private int insidePosZ = -1;

    public EntityAIMoveIndoors(EntityCreature p_i1637_1_) {
        this.entityObj = p_i1637_1_;
        this.setMutexBits(1);
    }

    @Override
    public boolean shouldExecute() {
        BlockPos lvt_1_1_ = new BlockPos(this.entityObj);
        if (this.entityObj.world.isDaytime() && (!this.entityObj.world.isRaining() || this.entityObj.world.getBiome(lvt_1_1_).canRain()) || !this.entityObj.world.provider.hasSkyLight()) {
            return false;
        }
        if (this.entityObj.getRNG().nextInt(50) != 0) {
            return false;
        }
        if (this.insidePosX != -1 && this.entityObj.getDistanceSq(this.insidePosX, this.entityObj.posY, this.insidePosZ) < 4.0) {
            return false;
        }
        Village lvt_2_1_ = this.entityObj.world.getVillageCollection().getNearestVillage(lvt_1_1_, 14);
        if (lvt_2_1_ == null) {
            return false;
        }
        this.doorInfo = lvt_2_1_.getDoorInfo(lvt_1_1_);
        return this.doorInfo != null;
    }

    @Override
    public boolean continueExecuting() {
        return !this.entityObj.getNavigator().noPath();
    }

    @Override
    public void startExecuting() {
        this.insidePosX = -1;
        BlockPos lvt_1_1_ = this.doorInfo.getInsideBlockPos();
        int lvt_2_1_ = lvt_1_1_.getX();
        int lvt_3_1_ = lvt_1_1_.getY();
        int lvt_4_1_ = lvt_1_1_.getZ();
        if (this.entityObj.getDistanceSq(lvt_1_1_) > 256.0) {
            Vec3d lvt_5_1_ = RandomPositionGenerator.findRandomTargetBlockTowards(this.entityObj, 14, 3, new Vec3d((double)lvt_2_1_ + 0.5, lvt_3_1_, (double)lvt_4_1_ + 0.5));
            if (lvt_5_1_ != null) {
                this.entityObj.getNavigator().tryMoveToXYZ(lvt_5_1_.xCoord, lvt_5_1_.yCoord, lvt_5_1_.zCoord, 1.0);
            }
        } else {
            this.entityObj.getNavigator().tryMoveToXYZ((double)lvt_2_1_ + 0.5, lvt_3_1_, (double)lvt_4_1_ + 0.5, 1.0);
        }
    }

    @Override
    public void resetTask() {
        this.insidePosX = this.doorInfo.getInsideBlockPos().getX();
        this.insidePosZ = this.doorInfo.getInsideBlockPos().getZ();
        this.doorInfo = null;
    }
}

