/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.Village;
import net.minecraft.village.VillageDoorInfo;

public class EntityAIMoveThroughVillage
extends EntityAIBase {
    private final EntityCreature theEntity;
    private final double movementSpeed;
    private Path entityPathNavigate;
    private VillageDoorInfo doorInfo;
    private final boolean isNocturnal;
    private final List<VillageDoorInfo> doorList = Lists.newArrayList();

    public EntityAIMoveThroughVillage(EntityCreature p_i1638_1_, double p_i1638_2_, boolean p_i1638_4_) {
        this.theEntity = p_i1638_1_;
        this.movementSpeed = p_i1638_2_;
        this.isNocturnal = p_i1638_4_;
        this.setMutexBits(1);
        if (!(p_i1638_1_.getNavigator() instanceof PathNavigateGround)) {
            throw new IllegalArgumentException("Unsupported mob for MoveThroughVillageGoal");
        }
    }

    @Override
    public boolean shouldExecute() {
        this.resizeDoorList();
        if (this.isNocturnal && this.theEntity.world.isDaytime()) {
            return false;
        }
        Village lvt_1_1_ = this.theEntity.world.getVillageCollection().getNearestVillage(new BlockPos(this.theEntity), 0);
        if (lvt_1_1_ == null) {
            return false;
        }
        this.doorInfo = this.findNearestDoor(lvt_1_1_);
        if (this.doorInfo == null) {
            return false;
        }
        PathNavigateGround lvt_2_1_ = (PathNavigateGround)this.theEntity.getNavigator();
        boolean lvt_3_1_ = lvt_2_1_.getEnterDoors();
        lvt_2_1_.setBreakDoors(false);
        this.entityPathNavigate = lvt_2_1_.getPathToPos(this.doorInfo.getDoorBlockPos());
        lvt_2_1_.setBreakDoors(lvt_3_1_);
        if (this.entityPathNavigate != null) {
            return true;
        }
        Vec3d lvt_4_1_ = RandomPositionGenerator.findRandomTargetBlockTowards(this.theEntity, 10, 7, new Vec3d(this.doorInfo.getDoorBlockPos().getX(), this.doorInfo.getDoorBlockPos().getY(), this.doorInfo.getDoorBlockPos().getZ()));
        if (lvt_4_1_ == null) {
            return false;
        }
        lvt_2_1_.setBreakDoors(false);
        this.entityPathNavigate = this.theEntity.getNavigator().getPathToXYZ(lvt_4_1_.xCoord, lvt_4_1_.yCoord, lvt_4_1_.zCoord);
        lvt_2_1_.setBreakDoors(lvt_3_1_);
        return this.entityPathNavigate != null;
    }

    @Override
    public boolean continueExecuting() {
        if (this.theEntity.getNavigator().noPath()) {
            return false;
        }
        float lvt_1_1_ = this.theEntity.width + 4.0f;
        return this.theEntity.getDistanceSq(this.doorInfo.getDoorBlockPos()) > (double)(lvt_1_1_ * lvt_1_1_);
    }

    @Override
    public void startExecuting() {
        this.theEntity.getNavigator().setPath(this.entityPathNavigate, this.movementSpeed);
    }

    @Override
    public void resetTask() {
        if (this.theEntity.getNavigator().noPath() || this.theEntity.getDistanceSq(this.doorInfo.getDoorBlockPos()) < 16.0) {
            this.doorList.add(this.doorInfo);
        }
    }

    private VillageDoorInfo findNearestDoor(Village p_findNearestDoor_1_) {
        VillageDoorInfo lvt_2_1_ = null;
        int lvt_3_1_ = Integer.MAX_VALUE;
        List<VillageDoorInfo> lvt_4_1_ = p_findNearestDoor_1_.getVillageDoorInfoList();
        for (VillageDoorInfo lvt_6_1_ : lvt_4_1_) {
            int lvt_7_1_ = lvt_6_1_.getDistanceSquared(MathHelper.floor(this.theEntity.posX), MathHelper.floor(this.theEntity.posY), MathHelper.floor(this.theEntity.posZ));
            if (lvt_7_1_ >= lvt_3_1_ || this.doesDoorListContain(lvt_6_1_)) continue;
            lvt_2_1_ = lvt_6_1_;
            lvt_3_1_ = lvt_7_1_;
        }
        return lvt_2_1_;
    }

    private boolean doesDoorListContain(VillageDoorInfo p_doesDoorListContain_1_) {
        for (VillageDoorInfo lvt_3_1_ : this.doorList) {
            if (!p_doesDoorListContain_1_.getDoorBlockPos().equals(lvt_3_1_.getDoorBlockPos())) continue;
            return true;
        }
        return false;
    }

    private void resizeDoorList() {
        if (this.doorList.size() > 15) {
            this.doorList.remove(0);
        }
    }
}

